/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.CellViewer;
import com.mathworks.mwswing.CellViewerCustomizer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.JLabel;
import javax.swing.JList;

public class DefaultListCellViewerCustomizer
implements CellViewerCustomizer<Integer> {
    private final JList fList;

    public DefaultListCellViewerCustomizer(JList jList) {
        this.fList = jList;
    }

    @Override
    public Component getCellPainter(Integer n) {
        return this.fList.getCellRenderer().getListCellRendererComponent(this.fList, this.fList.getModel().getElementAt(n), n, this.fList.isSelectedIndex(n), false);
    }

    @Override
    public Dimension getCellViewerOffset(Integer n) {
        return new Dimension(0, 0);
    }

    @Override
    public boolean shouldShowCellViewer(Integer n) {
        Rectangle rectangle = this.fList.getVisibleRect();
        Rectangle rectangle2 = this.fList.getCellBounds(n, n);
        Component component = this.getCellPainter(n);
        Dimension dimension = component.getPreferredSize();
        int n2 = component instanceof JLabel ? ((JLabel)component).getHorizontalAlignment() : 2;
        return CellViewer.shouldShow(rectangle, rectangle2, dimension, n2);
    }

    @Override
    public boolean constrainViewerToCellHeight() {
        return true;
    }
}

