/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.UniqueTag;

public class ObjToIntMap
implements Serializable {
    static final long serialVersionUID = 3396438333234169727L;
    private static final Object NULL_VALUE = new Object();
    private transient Object[] OEAB;
    private transient int[] codeBug;
    private int power;
    private int keyCount;
    private transient int defaultReadObject;

    public ObjToIntMap() {
        this(4);
    }

    public ObjToIntMap(int n) {
        if (n < 0) {
            Context.codeBug();
        }
        int n2 = n * 4 / 3;
        int n3 = 2;
        while (1 << n3 < n2) {
            ++n3;
        }
        this.power = n3;
    }

    public boolean isEmpty() {
        return this.keyCount == 0;
    }

    public int size() {
        return this.keyCount;
    }

    public boolean has(Object object) {
        if (object == null) {
            object = UniqueTag.NULL_VALUE;
        }
        return 0 <= this.OEAB(object);
    }

    public int get(Object object, int n) {
        int n2;
        if (object == null) {
            object = UniqueTag.NULL_VALUE;
        }
        if (0 <= (n2 = this.OEAB(object))) {
            return this.codeBug[n2];
        }
        return n;
    }

    public int getExisting(Object object) {
        int n;
        if (object == null) {
            object = UniqueTag.NULL_VALUE;
        }
        if (0 <= (n = this.OEAB(object))) {
            return this.codeBug[n];
        }
        Context.codeBug();
        return 0;
    }

    public void put(Object object, int n) {
        if (object == null) {
            object = UniqueTag.NULL_VALUE;
        }
        int n2 = this.defaultWriteObject(object);
        this.codeBug[n2] = n;
    }

    public Object intern(Object object) {
        boolean bl = false;
        if (object == null) {
            bl = true;
            object = UniqueTag.NULL_VALUE;
        }
        int n = this.defaultWriteObject(object);
        this.codeBug[n] = 0;
        return bl ? null : this.OEAB[n];
    }

    public void remove(Object object) {
        int n;
        if (object == null) {
            object = UniqueTag.NULL_VALUE;
        }
        if (0 <= (n = this.OEAB(object))) {
            this.OEAB[n] = NULL_VALUE;
            --this.keyCount;
        }
    }

    public void clear() {
        int n = this.OEAB.length;
        while (n != 0) {
            this.OEAB[--n] = null;
        }
        this.keyCount = 0;
        this.defaultReadObject = 0;
    }

    public Iterator newIterator() {
        return new Iterator(this);
    }

    final void initIterator(Iterator iterator) {
        iterator.init(this.OEAB, this.codeBug, this.keyCount);
    }

    public Object[] getKeys() {
        Object[] objectArray = new Object[this.keyCount];
        this.getKeys(objectArray, 0);
        return objectArray;
    }

    public void getKeys(Object[] objectArray, int n) {
        int n2 = this.keyCount;
        int n3 = 0;
        while (n2 != 0) {
            Object object = this.OEAB[n3];
            if (object != null && object != NULL_VALUE) {
                if (object == UniqueTag.NULL_VALUE) {
                    object = null;
                }
                objectArray[n] = object;
                ++n;
                --n2;
            }
            ++n3;
        }
    }

    private static int NULL_VALUE(int n, int n2, int n3) {
        int n4 = 32 - 2 * n3;
        if (n4 >= 0) {
            return n >>> n4 & n2 | 1;
        }
        return n & n2 >>> -n4 | 1;
    }

    private int OEAB(Object object) {
        int n;
        int n2;
        int n3;
        Object object2;
        if (this.OEAB != null && (object2 = this.OEAB[n3 = (n2 = (n = object.hashCode()) * -1640531527) >>> 32 - this.power]) != null) {
            int n4 = 1 << this.power;
            if (object2 == object || this.codeBug[n4 + n3] == n && object2.equals(object)) {
                return n3;
            }
            int n5 = n4 - 1;
            int n6 = ObjToIntMap.NULL_VALUE(n2, n5, this.power);
            boolean bl = false;
            while ((object2 = this.OEAB[n3 = n3 + n6 & n5]) != null) {
                if (object2 != object && (this.codeBug[n4 + n3] != n || !object2.equals(object))) continue;
                return n3;
            }
        }
        return -1;
    }

    private int codeBug(Object object, int n) {
        int n2 = n * -1640531527;
        int n3 = n2 >>> 32 - this.power;
        int n4 = 1 << this.power;
        if (this.OEAB[n3] != null) {
            int n5 = n4 - 1;
            int n6 = ObjToIntMap.NULL_VALUE(n2, n5, this.power);
            int n7 = n3;
            while (this.OEAB[n3 = n3 + n6 & n5] != null) {
            }
        }
        this.OEAB[n3] = object;
        this.codeBug[n4 + n3] = n;
        ++this.defaultReadObject;
        ++this.keyCount;
        return n3;
    }

    private void defaultReadObject() {
        if (this.OEAB == null) {
            int n = 1 << this.power;
            this.OEAB = new Object[n];
            this.codeBug = new int[2 * n];
        } else {
            if (this.keyCount * 2 >= this.defaultReadObject) {
                ++this.power;
            }
            int n = 1 << this.power;
            Object[] objectArray = this.OEAB;
            int[] nArray = this.codeBug;
            int n2 = objectArray.length;
            this.OEAB = new Object[n];
            this.codeBug = new int[2 * n];
            int n3 = this.keyCount;
            this.keyCount = 0;
            this.defaultReadObject = 0;
            int n4 = 0;
            while (n3 != 0) {
                Object object = objectArray[n4];
                if (object != null && object != NULL_VALUE) {
                    int n5 = nArray[n2 + n4];
                    int n6 = this.codeBug(object, n5);
                    this.codeBug[n6] = nArray[n4];
                    --n3;
                }
                ++n4;
            }
        }
    }

    private int defaultWriteObject(Object object) {
        int n;
        Object object2;
        int n2 = object.hashCode();
        int n3 = -1;
        int n4 = -1;
        if (this.OEAB != null && (object2 = this.OEAB[n3 = (n = n2 * -1640531527) >>> 32 - this.power]) != null) {
            int n5 = 1 << this.power;
            if (object2 == object || this.codeBug[n5 + n3] == n2 && object2.equals(object)) {
                return n3;
            }
            if (object2 == NULL_VALUE) {
                n4 = n3;
            }
            int n6 = n5 - 1;
            int n7 = ObjToIntMap.NULL_VALUE(n, n6, this.power);
            boolean bl = false;
            while ((object2 = this.OEAB[n3 = n3 + n7 & n6]) != null) {
                if (object2 == object || this.codeBug[n5 + n3] == n2 && object2.equals(object)) {
                    return n3;
                }
                if (object2 != NULL_VALUE || n4 >= 0) continue;
                n4 = n3;
            }
        }
        if (n4 >= 0) {
            n3 = n4;
        } else {
            if (this.OEAB == null || this.defaultReadObject * 4 >= (1 << this.power) * 3) {
                this.defaultReadObject();
                return this.codeBug(object, n2);
            }
            ++this.defaultReadObject;
        }
        this.OEAB[n3] = object;
        this.codeBug[(1 << this.power) + n3] = n2;
        ++this.keyCount;
        return n3;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        int n = this.keyCount;
        int n2 = 0;
        while (n != 0) {
            Object object = this.OEAB[n2];
            if (object != null && object != NULL_VALUE) {
                --n;
                objectOutputStream.writeObject(object);
                objectOutputStream.writeInt(this.codeBug[n2]);
            }
            ++n2;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = this.keyCount;
        if (n != 0) {
            this.keyCount = 0;
            int n2 = 1 << this.power;
            this.OEAB = new Object[n2];
            this.codeBug = new int[2 * n2];
            int n3 = 0;
            while (n3 != n) {
                Object object = objectInputStream.readObject();
                int n4 = object.hashCode();
                int n5 = this.codeBug(object, n4);
                this.codeBug[n5] = objectInputStream.readInt();
                ++n3;
            }
        }
    }

    static Object access$000() {
        return NULL_VALUE;
    }

    public static class Iterator {
        ObjToIntMap master;
        private int NULL_VALUE;
        private int OEAB;
        private Object[] access$000;
        private int[] codeBug;

        Iterator(ObjToIntMap objToIntMap) {
            this.master = objToIntMap;
        }

        final void init(Object[] objectArray, int[] nArray, int n) {
            this.access$000 = objectArray;
            this.codeBug = nArray;
            this.NULL_VALUE = -1;
            this.OEAB = n;
        }

        public void start() {
            this.master.initIterator(this);
            this.next();
        }

        public boolean done() {
            return this.OEAB < 0;
        }

        public void next() {
            if (this.OEAB == -1) {
                Context.codeBug();
            }
            if (this.OEAB == 0) {
                this.OEAB = -1;
                this.NULL_VALUE = -1;
            } else {
                ++this.NULL_VALUE;
                while (true) {
                    Object object;
                    if ((object = this.access$000[this.NULL_VALUE]) != null && object != ObjToIntMap.access$000()) {
                        --this.OEAB;
                        break;
                    }
                    ++this.NULL_VALUE;
                }
            }
        }

        public Object getKey() {
            Object object = this.access$000[this.NULL_VALUE];
            if (object == UniqueTag.NULL_VALUE) {
                object = null;
            }
            return object;
        }

        public int getValue() {
            return this.codeBug[this.NULL_VALUE];
        }

        public void setValue(int n) {
            this.codeBug[this.NULL_VALUE] = n;
        }
    }
}

