/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.util;

import com.mathworks.jmi.AutoConvertStringToMatlabChar;
import com.mathworks.toolbox.instrument.device.DeviceClient;
import com.mathworks.toolbox.instrument.device.PropertyInfo;
import com.mathworks.toolbox.testmeas.util.TMException;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.util.Vector;

public class PropertyUtil
implements AutoConvertStringToMatlabChar {
    private PropertyUtil() {
    }

    public static final Object createPropSetArray(DeviceClient deviceClient, String string) throws TMException {
        PropertyInfo propertyInfo = deviceClient.getPropertyInfo(string);
        if (propertyInfo.readOnly.equals("always")) {
            TMStringUtil.error((String)("Attempt to modify read-only " + deviceClient.getDisplayName() + " property: '" + propertyInfo.name + "'."));
        }
        if (propertyInfo.type.equals("double") || propertyInfo.type.equals("any")) {
            return "";
        }
        return propertyInfo.constraintValue;
    }

    public static final String createPropSetDisplay(DeviceClient deviceClient, String[] stringArray) throws TMException {
        PropertyInfo propertyInfo = deviceClient.getPropertyInfo(stringArray[0]);
        if (propertyInfo.readOnly.equals("always")) {
            TMStringUtil.error((String)("Attempt to modify read-only " + deviceClient.getDisplayName() + " property: '" + propertyInfo.name + "'."));
        }
        if (propertyInfo.type.equals("callback")) {
            return "string -or- function handle -or- cell array";
        }
        String string = deviceClient.getSetList(propertyInfo.getName());
        if (string.equals("")) {
            return "A " + deviceClient.getDisplayName() + " object's '" + propertyInfo.name + "' property does not have a fixed set of property values.";
        }
        return string;
    }

    public static String createEnumSetList(DeviceClient deviceClient, PropertyInfo propertyInfo) {
        if (propertyInfo.isInterfaceSpecific()) {
            return deviceClient.getSetList(propertyInfo.getName());
        }
        try {
            Object[] objectArray = (Object[])propertyInfo.constraintValue;
            if (objectArray == null || objectArray.length == 0) {
                return "";
            }
            Object object = propertyInfo.defaultValue;
            String string = "[ ";
            for (int i = 0; i < objectArray.length; ++i) {
                string = objectArray[i].equals(object) ? string + "{" + objectArray[i] + "}" : string + objectArray[i];
                string = i == objectArray.length - 1 ? string + " ]" : string + " | ";
            }
            return string;
        }
        catch (ClassCastException classCastException) {
            return "";
        }
    }

    public static final String[] getSettable(DeviceClient deviceClient) throws TMException {
        Vector<String> vector = deviceClient.getAllProperties();
        int n = vector.size();
        int n2 = 0;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            PropertyInfo propertyInfo = deviceClient.getPropertyInfo(vector.elementAt(i));
            if (propertyInfo.hidden != 0 || propertyInfo.readOnly.equals("always")) continue;
            stringArray[n2++] = propertyInfo.name;
        }
        String[] stringArray2 = new String[n2];
        for (int i = 0; i < n2; ++i) {
            stringArray2[i] = stringArray[i];
        }
        return stringArray2;
    }

    public static final String[] getNonSettable(DeviceClient deviceClient) throws TMException {
        Vector<String> vector = deviceClient.getAllProperties();
        int n = vector.size();
        int n2 = 0;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            PropertyInfo propertyInfo = deviceClient.getPropertyInfo(vector.elementAt(i));
            if (propertyInfo.hidden != 0 || propertyInfo.readOnly.equals("never")) continue;
            stringArray[n2++] = propertyInfo.name;
        }
        String[] stringArray2 = new String[n2];
        for (int i = 0; i < n2; ++i) {
            stringArray2[i] = stringArray[i];
        }
        return stringArray2;
    }

    public static final String[] getPropertyNames(DeviceClient deviceClient) throws TMException {
        return TMStringUtil.vector2StringArray(deviceClient.getAllProperties());
    }

    public static final int[] isInterfaceSpecific(DeviceClient deviceClient) throws TMException {
        Vector<String> vector = deviceClient.getAllProperties();
        int n = vector.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = deviceClient.isBaseProperty(vector.elementAt(i)) ? 0 : 1;
        }
        return nArray;
    }

    public static final int getNumberOfValidProps(PropertyInfo[] propertyInfoArray) {
        int n;
        int n2 = n = propertyInfoArray.length;
        for (int i = 0; i < n; ++i) {
            if (propertyInfoArray[i].hidden != 1) continue;
            --n2;
        }
        return n2;
    }

    public static final Object[] propinfo(DeviceClient deviceClient, PropertyInfo[] propertyInfoArray) {
        int n = propertyInfoArray.length;
        Object[] objectArray = new Object[PropertyUtil.getNumberOfValidProps(propertyInfoArray)];
        Object[] objectArray2 = new Object[7];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (propertyInfoArray[i].hidden != 0) continue;
            objectArray2[0] = propertyInfoArray[i].name;
            objectArray2[1] = propertyInfoArray[i].type;
            objectArray2[2] = propertyInfoArray[i].constraint;
            objectArray2[3] = propertyInfoArray[i].constraintValue;
            objectArray2[4] = propertyInfoArray[i].defaultValue;
            objectArray2[5] = propertyInfoArray[i].readOnly;
            objectArray2[6] = new Integer(propertyInfoArray[i].interfaceSpecific);
            if (propertyInfoArray[i].type.equals("double&string")) {
                objectArray2[1] = "Instrument Value";
            }
            if (propertyInfoArray[i].constraint.equals("bounded&enum")) {
                objectArray2[2] = "Instrument Value";
            }
            Object object = objectArray2.clone();
            objectArray[n2++] = object;
        }
        return objectArray;
    }

    public static final Object[] propinfoWithoutName(DeviceClient deviceClient, PropertyInfo[] propertyInfoArray) {
        Object[] objectArray = new Object[6];
        Object[] objectArray2 = new Object[propertyInfoArray.length];
        for (int i = 0; i < propertyInfoArray.length; ++i) {
            Object object;
            objectArray[0] = propertyInfoArray[i].type;
            objectArray[1] = propertyInfoArray[i].constraint;
            objectArray[2] = propertyInfoArray[i].constraintValue;
            objectArray[3] = propertyInfoArray[i].defaultValue;
            objectArray[4] = propertyInfoArray[i].readOnly;
            objectArray[5] = new Integer(propertyInfoArray[i].interfaceSpecific);
            if (propertyInfoArray[i].type.equals("double&string")) {
                objectArray[0] = "Instrument Value";
            }
            if (propertyInfoArray[i].constraint.equals("bounded&enum")) {
                objectArray[1] = "Instrument Value";
            }
            objectArray2[i] = object = objectArray.clone();
        }
        return objectArray2;
    }
}

