/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.guiutil.panels;

import com.mathworks.toolbox.instrument.device.PropertyChangedListener;
import com.mathworks.toolbox.instrument.device.drivers.xml.Parser;
import com.mathworks.toolbox.instrument.device.drivers.xml.property.PropertyConstraint;
import com.mathworks.toolbox.instrument.device.guiutil.panels.DeviceDriverHelper;
import com.mathworks.toolbox.instrument.device.guiutil.panels.DevicePanel;
import com.mathworks.toolbox.instrument.device.guiutil.panels.PropertyPanelListener;
import com.mathworks.toolbox.instrument.device.icdevice.ICDevice;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PropertyPanel
extends DevicePanel
implements PropertyChangedListener,
ActionListener,
ListSelectionListener {
    private static final long serialVersionUID = 1L;
    private static final JPanel DEFAULT_RB_PANEL = new JPanel();
    private static final Dimension DEFAULT_DIM = new Dimension(149, 64);
    private static final String ACTION = "ACTION";
    private static final int HELP = 0;
    private static final int GET = 1;
    private static final int SET = 2;
    private static Vector<PropertyPanelListener> listeners = new Vector();
    private JPanel outerPanel;
    private JPanel radioButtonPanel;
    private ButtonGroup valueButtonGroup;
    private JList properties;
    private JLabel valueLabel;
    private JButton showHelp;
    private JButton get;
    private JButton set;
    protected JLabel objectLabel;
    protected JComboBox propertyObject;
    private Vector<PropertyConstraint> constraints = new Vector();
    private Vector<Object> constraintValues = new Vector();
    private Hashtable<PropertyConstraint, JRadioButton> buttonConstraints = new Hashtable();
    private DeviceDriverHelper helper = null;
    private boolean isEnabled = true;
    private ICDevice deviceObject = null;

    public PropertyPanel() {
        this.setLayout(new BorderLayout(0, 0));
        this.radioButtonPanel = DEFAULT_RB_PANEL;
        DEFAULT_RB_PANEL.setPreferredSize(DEFAULT_DIM);
        this.layoutPanel();
    }

    public void update(ICDevice iCDevice, Parser parser, DeviceDriverHelper deviceDriverHelper) {
        this.helper = deviceDriverHelper;
        if (this.helper == null) {
            this.helper = new DeviceDriverHelper(parser);
        }
        this.deviceObject = iCDevice;
        this.properties.setListData(this.helper.getPropertyListData());
        ICDevice.addPropertyChangedListener(this);
    }

    public void cleanup() {
    }

    private void layoutPanel() {
        this.valueButtonGroup = new ButtonGroup();
        this.outerPanel = this.add(this.createPropertyToConfigurePanel(), this.createObjectPanel(), 4);
        JPanel jPanel = this.add(this.outerPanel, this.radioButtonPanel, 4);
        this.add((Component)jPanel, "North");
        this.add((Component)this.createPropertyButtonPanel(), "South");
    }

    protected JPanel createPropertyToConfigurePanel() {
        this.properties = new JList();
        this.properties.setName("Property to configure Listbox");
        JScrollPane jScrollPane = new JScrollPane(this.properties);
        jScrollPane.setPreferredSize(new Dimension(70, 140));
        this.properties.addListSelectionListener(this);
        if (this.properties.getModel().getSize() > 0) {
            this.properties.setSelectedIndex(0);
        }
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    protected JPanel createObjectPanel() {
        this.objectLabel = new JLabel("Object:");
        this.objectLabel.setVerticalAlignment(1);
        this.propertyObject = new JComboBox();
        this.propertyObject.setName("Object Combobox");
        JPanel jPanel = new JPanel(new BorderLayout(2, 0));
        jPanel.add((Component)this.objectLabel, "West");
        jPanel.add((Component)this.propertyObject, "Center");
        return jPanel;
    }

    private JPanel createPropertyButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2, 0, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 0));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2, 4, 0));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        this.showHelp = new JButton("Show Help...");
        this.get = new JButton("Get");
        this.set = new JButton("Set");
        this.showHelp.setName("Show Help Button");
        this.get.setName("Get Button");
        this.set.setName("Set Button");
        this.showHelp.putClientProperty(ACTION, new Integer(0));
        this.get.putClientProperty(ACTION, new Integer(1));
        this.set.putClientProperty(ACTION, new Integer(2));
        this.showHelp.addActionListener(this);
        this.get.addActionListener(this);
        this.set.addActionListener(this);
        jPanel2.add(this.get);
        jPanel2.add(this.set);
        jPanel.add(this.showHelp);
        jPanel.add(jPanel2);
        return jPanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JComponent jComponent = (JComponent)actionEvent.getSource();
        int n = (Integer)jComponent.getClientProperty(ACTION);
        switch (n) {
            case 0: {
                this.helper.showPropertyHelp(this.properties.getSelectedIndex());
                break;
            }
            case 1: {
                String string = this.helper.getProperty(this.properties.getSelectedIndex());
                String string2 = (String)this.propertyObject.getSelectedItem();
                PropertyPanel.propertyGet(string, string2);
                break;
            }
            case 2: {
                String string = this.helper.getProperty(this.properties.getSelectedIndex());
                String string3 = (String)this.propertyObject.getSelectedItem();
                PropertyPanel.propertySet(string, string3);
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting() || this.propertyObject == null) {
            return;
        }
        int n = this.properties.getSelectedIndex();
        if (this.helper.isPropertyHeader(n)) {
            this.setPropertyComponentsEnabled(false);
            this.cleanupPanel();
            this.radioButtonPanel = DEFAULT_RB_PANEL;
            this.radioButtonPanel.setPreferredSize(DEFAULT_DIM);
            this.outerPanel.add((Component)this.radioButtonPanel, "South");
            this.repaint();
            return;
        }
        this.setPropertyComponentsEnabled(true);
        if (n < 0) {
            return;
        }
        String string = this.helper.getSelectedPropertyGroup(n);
        String string2 = this.helper.getProperty(n);
        if (this.deviceObject.getStatus() == 1) {
            this.setButtonEnabled(this.get, true);
            if (this.helper.isPropertyReadOnly(string, string2)) {
                this.setButtonEnabled(this.set, false);
            } else {
                this.setButtonEnabled(this.set, true);
            }
        } else {
            this.setButtonEnabled(this.set, false);
            this.setButtonEnabled(this.get, false);
        }
        this.updatePropertyInformation(string);
    }

    void setButtonEnabled(final JButton jButton, final boolean bl) {
        if (!SwingUtilities.isEventDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    jButton.setEnabled(bl);
                }
            });
        } else {
            jButton.setEnabled(bl);
        }
    }

    private void updatePropertyInformation(String string) {
        this.updateObject(string);
        this.cleanupPanel();
        this.radioButtonPanel = this.createRadioButtonPanel();
        this.radioButtonPanel.setPreferredSize(DEFAULT_DIM);
        this.outerPanel.add((Component)this.radioButtonPanel, "South");
        this.updateConstraintValues();
        this.repaint();
    }

    private void updateConstraintValues() {
        if (this.constraintValues == null || this.constraintValues.size() == 0) {
            return;
        }
        for (int i = 0; i < this.constraints.size(); ++i) {
            PropertyConstraint propertyConstraint = this.constraints.elementAt(i);
            try {
                propertyConstraint.setPanelValue(this.constraintValues.elementAt(i));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void updateObject(String string) {
        this.propertyObject.removeAllItems();
        if (string.equals("parent")) {
            this.propertyObject.addItem("Device object");
            return;
        }
        int n = this.helper.getGroupSize(string);
        for (int i = 0; i < n; ++i) {
            this.propertyObject.addItem(this.helper.getGroupCommandNameAt(string, i + 1));
        }
        this.propertyObject.addItem("All objects");
    }

    private JPanel createRadioButtonPanel() {
        int n = this.properties.getSelectedIndex();
        if (n < 0 || this.helper.isPropertyHeader(n)) {
            return DEFAULT_RB_PANEL;
        }
        String string = this.helper.getProperty(n);
        String string2 = this.helper.getSelectedPropertyGroup(n);
        if (this.helper.isPropertyReadOnly(string2, string)) {
            return DEFAULT_RB_PANEL;
        }
        PropertyConstraint[] propertyConstraintArray = this.helper.getPropertyConstraints(string2, string);
        JPanel jPanel = new JPanel(new GridLayout(propertyConstraintArray.length, 1, 0, 2));
        this.constraints.removeAllElements();
        for (int i = 0; i < propertyConstraintArray.length; ++i) {
            jPanel.add(this.createConstraintPanel(propertyConstraintArray[i]));
            this.constraints.add(propertyConstraintArray[i]);
        }
        if (this.constraints != null && this.constraints.size() > 0) {
            this.buttonConstraints.get(this.constraints.elementAt(0)).setSelected(true);
        }
        jPanel.setBorder(BorderFactory.createTitledBorder(""));
        JPanel jPanel2 = new JPanel(new BorderLayout(5, 0));
        this.valueLabel = new JLabel("Value:");
        this.valueLabel.setVerticalAlignment(1);
        jPanel2.add((Component)this.valueLabel, "West");
        jPanel2.add((Component)jPanel, "Center");
        return jPanel2;
    }

    private JPanel createConstraintPanel(PropertyConstraint propertyConstraint) {
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        JRadioButton jRadioButton = new JRadioButton();
        jRadioButton.setName("Constraint Radiobutton");
        this.valueButtonGroup.add(jRadioButton);
        this.buttonConstraints.put(propertyConstraint, jRadioButton);
        jPanel.add((Component)jRadioButton, "West");
        jPanel.add((Component)propertyConstraint.getPanel(), "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, "North");
        return jPanel2;
    }

    private void cleanupPanel() {
        this.outerPanel.remove(this.radioButtonPanel);
        for (int i = 0; i < this.constraints.size(); ++i) {
            JRadioButton jRadioButton = this.buttonConstraints.get(this.constraints.elementAt(i));
            this.valueButtonGroup.remove(jRadioButton);
            this.buttonConstraints.remove(this.constraints.elementAt(i));
        }
        this.constraints.removeAllElements();
        if (this.constraintValues != null) {
            this.constraintValues.removeAllElements();
        }
    }

    public void setPropertyComponentsEnabled(boolean bl) {
        if (this.isEnabled == bl) {
            return;
        }
        this.objectLabel.setEnabled(bl);
        this.propertyObject.setEnabled(bl);
        this.showHelp.setEnabled(bl);
        if (this.deviceObject.getStatus() == 1 && bl) {
            this.get.setEnabled(bl);
            this.set.setEnabled(bl);
        } else {
            this.get.setEnabled(false);
            this.set.setEnabled(false);
        }
        this.isEnabled = bl;
    }

    protected int getSelectedIndexInButtonGroup(ButtonGroup buttonGroup) {
        Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            JRadioButton jRadioButton = (JRadioButton)enumeration.nextElement();
            if (jRadioButton.isSelected()) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    protected void selectIndexInButtonGroup(ButtonGroup buttonGroup, int n) {
        Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            JRadioButton jRadioButton = (JRadioButton)enumeration.nextElement();
            if (n2 == n) {
                jRadioButton.setSelected(true);
                break;
            }
            ++n2;
        }
    }

    @Override
    public void propertyChanged(Object object, String string, Object object2) {
        if (!object.equals(this.deviceObject)) {
            return;
        }
        if (!string.equals("Status")) {
            return;
        }
        if (object2.equals("open")) {
            if (!this.helper.isPropertyHeader(this.properties.getSelectedIndex())) {
                this.setButtonEnabled(this.get, true);
                String string2 = this.helper.getSelectedPropertyGroup(this.properties.getSelectedIndex());
                String string3 = this.helper.getProperty(this.properties.getSelectedIndex());
                if (!this.helper.isPropertyReadOnly(string2, string3)) {
                    this.setButtonEnabled(this.set, true);
                } else {
                    this.setButtonEnabled(this.set, true);
                }
            }
        } else {
            this.setButtonEnabled(this.get, false);
            this.setButtonEnabled(this.set, false);
        }
    }

    public String getSetCode() {
        String string = this.helper.getProperty(this.properties.getSelectedIndex());
        String string2 = this.helper.getSelectedPropertyGroup(this.properties.getSelectedIndex());
        String string3 = this.getValueToSet();
        if (string2.equals("parent")) {
            return "set(deviceObj, '" + string + "', " + string3 + ");";
        }
        int n = this.propertyObject.getSelectedIndex();
        int n2 = this.propertyObject.getItemCount();
        if (n2 == n + 1) {
            return "set(deviceObj." + string2 + ", '" + string + "', " + string3 + ");";
        }
        return "set(deviceObj." + string2 + "(" + ++n + "), '" + string + "', " + string3 + ");";
    }

    public String getGetCode() {
        String string = this.helper.getProperty(this.properties.getSelectedIndex());
        String string2 = this.helper.getSelectedPropertyGroup(this.properties.getSelectedIndex());
        if (string2.equals("parent")) {
            return "get(deviceObj, '" + string + "');";
        }
        int n = this.propertyObject.getSelectedIndex();
        int n2 = this.propertyObject.getItemCount();
        if (n2 == n + 1) {
            return "get(deviceObj." + string2 + ", '" + string + "');";
        }
        return "get(deviceObj." + string2 + "(" + ++n + "), '" + string + "');";
    }

    public String getValueToSet() {
        return this.formatPropertyValue((String)this.getSpecifiedValue());
    }

    private Object getSpecifiedValue() {
        JRadioButton jRadioButton = this.getSelectedRadioButtonInButtonGroup(this.valueButtonGroup);
        Enumeration<PropertyConstraint> enumeration = this.buttonConstraints.keys();
        while (enumeration.hasMoreElements()) {
            PropertyConstraint propertyConstraint = enumeration.nextElement();
            if (!this.buttonConstraints.get(propertyConstraint).equals(jRadioButton)) continue;
            return propertyConstraint.getPanelValue();
        }
        return null;
    }

    private JRadioButton getSelectedRadioButtonInButtonGroup(ButtonGroup buttonGroup) {
        Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            JRadioButton jRadioButton = (JRadioButton)enumeration.nextElement();
            if (!jRadioButton.isSelected()) continue;
            return jRadioButton;
        }
        return null;
    }

    private String formatPropertyValue(String string) {
        if (TMStringUtil.isnumeric((String)string)) {
            return string;
        }
        if (TMStringUtil.isdouble((String)string)) {
            return string;
        }
        try {
            Double.parseDouble(string);
            if (string.endsWith("d") || string.endsWith("f")) {
                return string.substring(0, string.length() - 1);
            }
            return string;
        }
        catch (NumberFormatException numberFormatException) {
            if (!string.startsWith("'")) {
                string = "'" + string;
            }
            if (!string.endsWith("'")) {
                string = string + "'";
            }
            return string;
        }
    }

    public DeviceDriverHelper getDeviceDriverHelper() {
        return this.helper;
    }

    public void setProperty(int n) {
        this.properties.setSelectedIndex(n);
    }

    public int getProperty() {
        return this.properties.getSelectedIndex();
    }

    public void setObject(int n) {
        try {
            this.propertyObject.setSelectedIndex(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getObject() {
        return this.propertyObject.getSelectedIndex();
    }

    public int getSelectedValueIndex() {
        if (this.valueButtonGroup == null) {
            return -1;
        }
        return this.getSelectedIndexInButtonGroup(this.valueButtonGroup);
    }

    public void setSelectedValueIndex(int n) {
        if (n >= 0) {
            this.selectIndexInButtonGroup(this.valueButtonGroup, n);
        }
    }

    public Vector<Object> getConstraintValues() {
        int n = this.properties.getSelectedIndex();
        String string = this.helper.getProperty(n);
        String string2 = this.helper.getSelectedPropertyGroup(n);
        if (this.helper.isPropertyHeader(n) || this.helper.isPropertyReadOnly(string2, string)) {
            return null;
        }
        if (this.constraintValues == null) {
            this.constraintValues = new Vector();
        } else {
            this.constraintValues.removeAllElements();
        }
        PropertyConstraint[] propertyConstraintArray = this.helper.getPropertyConstraints(string2, string);
        for (int i = 0; i < propertyConstraintArray.length; ++i) {
            this.constraintValues.add(propertyConstraintArray[i].getPanelValue());
        }
        return this.constraintValues;
    }

    public void setConstraintValues(Vector<Object> vector) {
        this.constraintValues = vector;
        this.updateConstraintValues();
    }

    public static void addPropertyPanelListener(PropertyPanelListener propertyPanelListener) {
        if (!listeners.contains(propertyPanelListener)) {
            listeners.addElement(propertyPanelListener);
        }
    }

    public static void removePropertyPanelListener(PropertyPanelListener propertyPanelListener) {
        listeners.removeElement(propertyPanelListener);
        propertyPanelListener = null;
    }

    public static void propertyGet(String string, String string2) {
        for (int i = 0; i < listeners.size(); ++i) {
            listeners.elementAt(i).propertyGet(string, string2);
        }
    }

    public static void propertySet(String string, String string2) {
        for (int i = 0; i < listeners.size(); ++i) {
            listeners.elementAt(i).propertySet(string, string2);
        }
    }
}

