/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.drivers.xml.property;

import com.mathworks.toolbox.instrument.device.drivers.xml.property.PropertyConstraint;
import com.mathworks.toolbox.instrument.guiutil.ICNumberSpinner;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.JPanel;

public class DoubleBoundedProperty
extends PropertyConstraint {
    private double min = 0.0;
    private double max = 1.0;
    private Double[] constraintValues;
    private ICNumberSpinner valueSpinner = null;

    public DoubleBoundedProperty() {
    }

    public DoubleBoundedProperty(String string, String string2) {
        this.setRange(string, string2);
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public int getConstraint() {
        return 0;
    }

    @Override
    public Object getDefaultValue() {
        return String.valueOf(this.min);
    }

    @Override
    public void setRange(String string, String string2) {
        this.min = TMStringUtil.str2double((String)string);
        this.max = TMStringUtil.str2double((String)string2);
        this.constraintValues = new Double[2];
        this.constraintValues[0] = new Double(this.min);
        this.constraintValues[1] = new Double(this.max);
    }

    @Override
    public Object[] getConstraintValues() {
        return this.constraintValues;
    }

    @Override
    public boolean isValidValue(Object object) {
        if (object instanceof Double) {
            return this.isValidValue((Double)object);
        }
        if (object instanceof String && TMStringUtil.isdouble((String)((String)object))) {
            return this.isValidValue(Double.valueOf((String)object));
        }
        return false;
    }

    public boolean isValidValue(double d) {
        return d <= this.max && d >= this.min;
    }

    @Override
    public String getSetList() {
        return "[ " + this.min + " to " + this.max + " ]";
    }

    @Override
    public String getSetError() {
        return "a value between " + this.min + " and " + this.max;
    }

    @Override
    public JPanel getPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
        if (this.min > this.max) {
            TMStringUtil.error(null, (String)"TMTOOL Bounded Property Error", (String)"The minimum value specified in this driver is larger than the maximum value.\nPlease use MIDEDIT to examine the property selected and correct the range");
            this.valueSpinner = null;
            return jPanel;
        }
        this.valueSpinner = new ICNumberSpinner(this.min, this.min, this.max, Math.abs(this.min));
        jPanel.add((Component)((Object)this.valueSpinner));
        Dimension dimension = this.valueSpinner.getPreferredSize();
        if (dimension.width < 93) {
            dimension.width = 93;
        }
        this.valueSpinner.setPreferredSize(dimension);
        return jPanel;
    }

    @Override
    public Object getPanelValue() {
        return String.valueOf(this.valueSpinner.getValue());
    }

    @Override
    public void setPanelValue(Object object) {
        if (object instanceof String) {
            this.valueSpinner.setValue(new Double((String)object));
        }
        this.valueSpinner.setValue(object);
    }

    @Override
    public String getCellArrayOfValues(int n) {
        if (n == 0) {
            return "{}";
        }
        String string = "";
        double d = this.max - this.min;
        double d2 = Math.floor(d / (double)(n - 1));
        if (d2 == 0.0) {
            d2 = d / (double)n;
        }
        for (int i = 0; i < n - 1; ++i) {
            string = string + String.valueOf(this.min + (double)i * d2) + ", ";
        }
        string = string + String.valueOf(this.max);
        string = "{" + string + "}";
        return string;
    }
}

