/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.browser.objects;

import com.mathworks.toolbox.instrument.Gpib;
import com.mathworks.toolbox.instrument.browser.objects.BrowserObject;
import com.mathworks.toolbox.testmeas.util.TMException;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;

public class GPIBObject
extends BrowserObject {
    protected String vendor;
    protected String boardIndex;
    protected String primaryAddress;
    protected String secondaryAddress;
    protected String eoiMode = "on";
    protected Object eosCharCode = "LF";
    protected String eosMode = "none";

    public GPIBObject(String string, String string2, String string3, String string4, String string5, String string6) {
        super(string5, string6);
        this.vendor = string;
        this.boardIndex = string2;
        this.primaryAddress = string3;
        this.secondaryAddress = string4;
    }

    @Override
    public String[] getHeadingInfoColumnOne() {
        String[] stringArray = new String[]{"GPIB board vendor:", this.vendor, "GPIB board index:", this.boardIndex, "Primary address:", this.primaryAddress};
        return stringArray;
    }

    @Override
    public String getDescriptiveText() {
        return "primary address " + this.primaryAddress + " (" + this.vendor + " board " + this.boardIndex + ")";
    }

    @Override
    public String getType() {
        return "GPIB";
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getBoardIndex() {
        return this.boardIndex;
    }

    public String getPrimaryAddress() {
        return this.primaryAddress;
    }

    public String getSecondaryAddress() {
        return this.secondaryAddress;
    }

    public void setEOSCharCode(Object object) {
        this.eosCharCode = object;
        if (this.instrumentObject == null) {
            return;
        }
        try {
            ((Gpib)this.instrumentObject).setEOSCharCode(this.eosCharCode);
        }
        catch (TMException tMException) {
            TMStringUtil.error((String)"Error Setting EOSCharCode", (String)tMException.getMessage());
        }
    }

    public Object getEOSCharCode() {
        return this.eosCharCode;
    }

    public void setEOSMode(String string) {
        this.eosMode = string;
        if (this.instrumentObject == null) {
            return;
        }
        try {
            ((Gpib)this.instrumentObject).setEOSMode(this.getIndex(EOSMODE, this.eosMode));
        }
        catch (TMException tMException) {
            TMStringUtil.error((String)"Error Setting EOSMode", (String)tMException.getMessage());
        }
    }

    public String getEOSMode() {
        return this.eosMode;
    }

    public String getEOIMode() {
        return this.eoiMode;
    }

    public void setEOIMode(String string) {
        this.eoiMode = string;
        if (this.instrumentObject == null) {
            return;
        }
        try {
            ((Gpib)this.instrumentObject).setEOIMode(this.str2bool(this.eoiMode));
        }
        catch (TMException tMException) {
            TMStringUtil.error((String)"Error Setting EOIMode", (String)tMException.getMessage());
        }
    }
}

