/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.browser.ivicWrapper;

import com.mathworks.jmi.MatlabWorker;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJList;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.toolbox.instrument.browser.ICTBrowserDesktop;
import com.mathworks.toolbox.instrument.browser.ivicWrapper.IviInstrumentInfo;
import com.mathworks.toolbox.instrument.util.ICUtil;
import com.mathworks.widgets.desk.DTFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AddIviCInstrumentPage
extends JDialog
implements ListSelectionListener,
WindowListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private static final String ACTION = "ACTION";
    private static final int OK = 0;
    private static final int CANCEL = 1;
    private String IviCInstrumentType;
    private DefaultListModel driverListmodel;
    private MJList driverListBox;
    private DefaultListModel resourceListModel;
    private MJList resourcesListBox;
    private Vector<DriverInfo> IviCDrivers;
    private IviInstrumentInfo instrumentInfo;

    public AddIviCInstrumentPage(String string) {
        super((Frame)ICTBrowserDesktop.getInstance().getMainFrame(), "Add " + string + " instrument", true);
        this.setLayout(new BorderLayout(4, 4));
        this.layoutPanel();
        this.pack();
        this.setResizable(false);
        this.IviCInstrumentType = string;
        this.IviCDrivers = new Vector();
        DriverManager driverManager = new DriverManager();
        driverManager.start();
        ResourceManager resourceManager = new ResourceManager();
        resourceManager.start();
        DTFrame dTFrame = ICTBrowserDesktop.getInstance().getMainFrame();
        ICUtil.centerWindow((Window)dTFrame, this);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(this);
        this.setVisible(true);
    }

    public synchronized void enableGlassPane(boolean bl) {
        ICTBrowserDesktop.getInstance().enableGlassPane(bl);
    }

    private void layoutPanel() {
        this.add((Component)this.createDriverPanel(), "North");
        this.add((Component)this.createResourcePanel(), "Center");
        this.add((Component)this.createButtonPanel(), "South");
    }

    private JPanel createDriverPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(4, 0));
        this.driverListmodel = new DefaultListModel();
        this.driverListBox = new MJList((ListModel)this.driverListmodel);
        this.driverListBox.addListSelectionListener((ListSelectionListener)this);
        JScrollPane jScrollPane = new JScrollPane((Component)this.driverListBox);
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.setBorder(BorderFactory.createTitledBorder("Available Drivers"));
        return jPanel;
    }

    private JPanel createResourcePanel() {
        JPanel jPanel = new JPanel(new BorderLayout(4, 0));
        this.resourceListModel = new DefaultListModel();
        this.resourcesListBox = new MJList((ListModel)this.resourceListModel);
        this.resourcesListBox.addListSelectionListener((ListSelectionListener)this);
        JScrollPane jScrollPane = new JScrollPane((Component)this.resourcesListBox);
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.setBorder(BorderFactory.createTitledBorder("Instrument Resources"));
        return jPanel;
    }

    private MJPanel createButtonPanel() {
        MJPanel mJPanel = new MJPanel((LayoutManager)new FlowLayout(1, 0, 0));
        MJButton mJButton = new MJButton("OK");
        mJButton.putClientProperty((Object)ACTION, (Object)new Integer(0));
        mJButton.addActionListener((ActionListener)this);
        MJButton mJButton2 = new MJButton("Cancel");
        mJButton2.putClientProperty((Object)ACTION, (Object)new Integer(1));
        mJButton2.addActionListener((ActionListener)this);
        mJPanel.add((Component)mJButton);
        mJPanel.add((Component)mJButton2);
        mJPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
        return mJPanel;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JComponent jComponent = (JComponent)actionEvent.getSource();
        int n = Integer.parseInt(jComponent.getClientProperty(ACTION).toString());
        switch (n) {
            case 0: {
                if (this.resourcesListBox.getSelectedValue() == null) {
                    JOptionPane.showMessageDialog(null, "Pelase select instrument resource");
                    return;
                }
                if (this.driverListBox.getSelectedValue() == null) {
                    JOptionPane.showMessageDialog(null, "Please select instrument driver");
                    return;
                }
                String string = (String)this.driverListBox.getSelectedValue();
                String string2 = (String)this.resourcesListBox.getSelectedValue();
                String string3 = String.format("Instrument using driver %s with resource %s", string, string2);
                this.instrumentInfo = new IviInstrumentInfo(string3, string, string2);
                this.setVisible(false);
                break;
            }
            case 1: {
                this.instrumentInfo = null;
                this.setVisible(false);
            }
        }
    }

    public IviInstrumentInfo getInstrument() {
        return this.instrumentInfo;
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    private class ResourceManager
    extends MatlabWorker {
        private ResourceManager() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runOnAWTEventDispatchThread(Object object) {
            AddIviCInstrumentPage.this.resourceListModel.clear();
            if (object == null) {
                return;
            }
            String[] stringArray = (String[])object;
            try {
                for (int i = 0; i < stringArray.length; ++i) {
                    AddIviCInstrumentPage.this.resourceListModel.addElement(stringArray[i]);
                }
            }
            catch (Exception exception) {
            }
            finally {
                AddIviCInstrumentPage.this.enableGlassPane(false);
            }
        }

        public Object runOnMatlabThread() throws Exception {
            Object object = null;
            try {
                AddIviCInstrumentPage.this.enableGlassPane(true);
                object = ResourceManager.feval((String)"instrument.internal.udm.InstrumentUtility.getVisaResources", null, (int)1, (boolean)false);
            }
            catch (Exception exception) {
                AddIviCInstrumentPage.this.enableGlassPane(false);
                exception.printStackTrace();
            }
            return object;
        }
    }

    private class DriverManager
    extends MatlabWorker {
        private DriverManager() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runOnAWTEventDispatchThread(Object object) {
            AddIviCInstrumentPage.this.driverListmodel.clear();
            AddIviCInstrumentPage.this.IviCDrivers.removeAllElements();
            if (object == null) {
                return;
            }
            String[] stringArray = (String[])object;
            try {
                for (int i = 0; i < stringArray.length; i += 2) {
                    AddIviCInstrumentPage.this.IviCDrivers.add(new DriverInfo(stringArray[i], stringArray[i + 1]));
                    AddIviCInstrumentPage.this.driverListmodel.addElement(stringArray[i]);
                }
            }
            catch (Exception exception) {
            }
            finally {
                AddIviCInstrumentPage.this.enableGlassPane(false);
            }
        }

        public Object runOnMatlabThread() throws Exception {
            Object object = null;
            try {
                AddIviCInstrumentPage.this.enableGlassPane(true);
                object = DriverManager.feval((String)"instrument.internal.util.getIviDrivers", (Object[])new Object[]{"ivic", AddIviCInstrumentPage.this.IviCInstrumentType}, (int)1, (boolean)false);
            }
            catch (Exception exception) {
                AddIviCInstrumentPage.this.enableGlassPane(false);
                exception.printStackTrace();
            }
            return object;
        }
    }

    public class DriverInfo {
        private String fDriverName;
        private String fSupportedModels;

        public DriverInfo(String string, String string2) {
            this.fDriverName = string;
            this.fSupportedModels = string2;
        }

        public String getDriverName() {
            return this.fDriverName;
        }

        public String getSupportedModels() {
            return this.fSupportedModels;
        }
    }
}

