/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument;

import com.mathworks.toolbox.instrument.NetworkDataLink;
import com.mathworks.toolbox.testmeas.util.TMException;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.DatagramChannel;

public class EchoUDP
extends Thread {
    public static EchoUDP echoUDP = null;
    private static final int DEFAULT_PORT = 9090;
    private static final int MAX_READ_SIZE = 65535;
    private DatagramSocket socketUDP = null;
    private int portNumber = 9090;
    private boolean serverRunning = true;
    private ByteBuffer readBuffer = ByteBuffer.allocate(65535);
    private DatagramChannel channel = null;

    public EchoUDP() throws TMException {
        this(9090);
    }

    public EchoUDP(int n) throws TMException {
        try {
            this.portNumber = n;
            this.openSocket();
            this.start();
        }
        catch (Exception exception) {
            this.closeSocket();
            throw new TMException("An error occurred while creating echo server on port: " + this.portNumber + ".");
        }
    }

    public void openSocket() throws Exception {
        InetSocketAddress inetSocketAddress = new InetSocketAddress("localhost", this.portNumber);
        this.channel = DatagramChannel.open();
        this.socketUDP = this.channel.socket();
        this.socketUDP.bind(inetSocketAddress);
        this.socketUDP.setSoTimeout(0);
        this.socketUDP.setSendBufferSize(NetworkDataLink.OSBUFFERSIZE);
        this.socketUDP.setReceiveBufferSize(NetworkDataLink.OSBUFFERSIZE);
        this.socketUDP.connect(inetSocketAddress);
        echoUDP = this;
    }

    @Override
    public void run() {
        SocketAddress socketAddress = null;
        while (this.serverRunning) {
            if (this.socketUDP == null) {
                try {
                    this.openSocket();
                }
                catch (Exception exception) {
                    System.err.println("Packet error: " + exception.getMessage());
                    this.closeSocket();
                }
            }
            try {
                this.readBuffer.clear();
                socketAddress = this.channel.receive(this.readBuffer);
                if (!this.serverRunning || socketAddress == null) continue;
                this.readBuffer.flip();
                this.channel.send(this.readBuffer, socketAddress);
            }
            catch (AsynchronousCloseException asynchronousCloseException) {
            }
            catch (IOException iOException) {
                this.closeSocket();
                System.err.println("Packet error: " + iOException.getMessage());
            }
        }
    }

    private void closeSocket() {
        try {
            this.socketUDP.close();
            this.socketUDP = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void shutDownServer() throws TMException {
        this.serverRunning = false;
        echoUDP = null;
        this.closeSocket();
    }

    public static EchoUDP getEchoServer() {
        return echoUDP;
    }

    public int getPort() {
        return this.portNumber;
    }
}

