/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing.window;

import java.awt.Window;
import java.lang.ref.WeakReference;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public class MJFullWindowRegistry {
    private static Vector<WeakReference<Window>> sWindows = new Vector();

    public static synchronized void register(Window window) {
        if (MJFullWindowRegistry.findReference(window) == null) {
            sWindows.add(new WeakReference<Window>(window));
        }
    }

    public static synchronized void unregister(Window window) {
        WeakReference weakReference = MJFullWindowRegistry.findReference(window);
        if (weakReference != null) {
            sWindows.remove(weakReference);
        }
    }

    public static synchronized Enumeration<Window> windows() {
        Vector<Window> vector = new Vector<Window>();
        Iterator<WeakReference<Window>> iterator = sWindows.iterator();
        while (iterator.hasNext()) {
            Window window = (Window)iterator.next().get();
            if (window != null) {
                vector.add(window);
                continue;
            }
            iterator.remove();
        }
        return vector.elements();
    }

    private static WeakReference findReference(Window window) {
        Iterator<WeakReference<Window>> iterator = sWindows.iterator();
        while (iterator.hasNext()) {
            WeakReference<Window> weakReference = iterator.next();
            if (weakReference.get() == null) {
                iterator.remove();
                continue;
            }
            if (weakReference.get() != window) continue;
            return weakReference;
        }
        return null;
    }

    private MJFullWindowRegistry() {
    }
}

