/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing.text;

import com.mathworks.mwswing.ChildAction;
import com.mathworks.mwswing.CustomizablePopupMenu;
import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.PopupMenuCustomizer;
import com.mathworks.mwswing.binding.DefaultKeyBindings;
import com.mathworks.mwswing.binding.KeyBindingManager;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.apache.commons.lang.Validate;

public class TextContextMenu
extends MJPopupMenu
implements CustomizablePopupMenu {
    private final ExtendedAction fCutAction;
    private final ExtendedAction fCopyAction;
    private final ExtendedAction fPasteAction;
    private final ExtendedAction fSelectAllAction;
    private PopupMenuCustomizer fCustomizer;
    private static final TextContextMenu SHARED_INSTANCE = new TextContextMenu();
    public static final String contextMenuName = "FullContextMenu";
    private static final String cutActionName = "cut-to-clipboard";
    public static final String cutMenuName = "cut-to-clipboardMenuItem";
    private static final String copyActionName = "copy-to-clipboard";
    public static final String copyMenuName = "copy-to-clipboardMenuItem";
    private static final String pasteActionName = "paste-from-clipboard";
    public static final String pasteMenuName = "paste-from-clipboardMenuItem";
    private static final String selectAllActionName = "select-all";
    public static final String selectAllMenuName = "select-allMenuItem";

    public TextContextMenu() {
        this((PopupMenuCustomizer)null);
    }

    public TextContextMenu(PopupMenuCustomizer popupMenuCustomizer) {
        this(DefaultKeyBindings.getManager(), "DefaultContext", popupMenuCustomizer);
    }

    public TextContextMenu(KeyBindingManager keyBindingManager, String string) {
        this(keyBindingManager, string, null);
    }

    public TextContextMenu(KeyBindingManager keyBindingManager, String string, PopupMenuCustomizer popupMenuCustomizer) {
        if (keyBindingManager == null) {
            throw new IllegalArgumentException("KeyBindingManager supplied cannot be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("Context supplied cannot be null: " + string);
        }
        if (!keyBindingManager.containsContext(string)) {
            throw new IllegalArgumentException("Context supplied does not exist in keybinding manager: " + string);
        }
        this.setName(contextMenuName);
        this.fCutAction = this.createAction(new DefaultEditorKit.CutAction(), keyBindingManager, cutActionName, string);
        this.fCopyAction = this.createAction(new DefaultEditorKit.CopyAction(), keyBindingManager, copyActionName, string);
        this.fPasteAction = this.createAction(new DefaultEditorKit.PasteAction(), keyBindingManager, pasteActionName, string);
        this.fSelectAllAction = this.createAction(new SelectAllAction(), keyBindingManager, selectAllActionName, string);
        this.fCustomizer = popupMenuCustomizer;
    }

    @Override
    public void setCustomizer(PopupMenuCustomizer popupMenuCustomizer) {
        this.fCustomizer = popupMenuCustomizer;
    }

    private ExtendedAction createAction(TextAction textAction, KeyBindingManager keyBindingManager, String string, String string2) {
        if (!keyBindingManager.containsAction(string)) {
            throw new IllegalArgumentException("Action '" + string + "' is not registered");
        }
        ChildAction childAction = new ChildAction(textAction);
        this.initializeWithKeybindingManager(childAction, keyBindingManager, string, string2);
        return childAction;
    }

    protected void initializeWithKeybindingManager(MJAbstractAction mJAbstractAction, KeyBindingManager keyBindingManager, String string, String string2) {
        keyBindingManager.addKeyBindingAndActionInfo(string2, string, mJAbstractAction);
    }

    public static TextContextMenu getSharedInstance() {
        return SHARED_INSTANCE;
    }

    @Override
    public void show(Component component, int n, int n2) {
        Validate.isTrue((boolean)(component instanceof JTextComponent), (String)"Error: Trying to show TextContextMenu on other than a JTextComponent");
        this.populateMenu((JTextComponent)component);
        super.show(component, n, n2);
    }

    public final void populateMenu(JTextComponent jTextComponent) {
        this.removeAll();
        boolean bl = jTextComponent.getSelectionStart() != jTextComponent.getSelectionEnd();
        boolean bl2 = jTextComponent.isEditable() && jTextComponent.isEnabled();
        this.fCutAction.setEnabled(bl && bl2);
        this.fCopyAction.setEnabled(bl);
        Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this);
        this.fPasteAction.setEnabled(bl2 && transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor));
        this.add(this.fCutAction);
        this.add(this.fCopyAction);
        this.add(this.fPasteAction);
        this.add(this.fSelectAllAction);
        if (this.fCustomizer != null) {
            this.fCustomizer.customize(this);
        }
    }

    private static class SelectAllAction
    extends TextAction {
        private SelectAllAction() {
            super(TextContextMenu.selectAllActionName);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                jTextComponent.selectAll();
            }
        }
    }
}

