/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing.datatransfer;

import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.datatransfer.MJTransferable;
import com.mathworks.util.PlatformInfo;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

public class MJClipboard {
    private static Clipboard sSystemClipboard;
    private static Clipboard sXSelectionClipboard;
    private Clipboard fPrivateClipboard;
    private Clipboard fVeryPrivateClipboard;
    private static MJClipboard sThis;
    private static PrivateClipboardOwner sClipboardOwner;

    private MJClipboard() {
        sClipboardOwner = new PrivateClipboardOwner();
        sSystemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        sXSelectionClipboard = Toolkit.getDefaultToolkit().getSystemSelection();
        this.fPrivateClipboard = this.fVeryPrivateClipboard = new Clipboard("MJClipboard private Clipboard");
    }

    private static synchronized void initialize() {
        if (sThis == null) {
            sThis = new MJClipboard();
        }
    }

    public static synchronized MJClipboard getMJClipboard() {
        MJClipboard.initialize();
        return sThis;
    }

    public synchronized void setContents(String string, ClipboardOwner clipboardOwner) {
        this.setContents(string, null, clipboardOwner);
    }

    public synchronized void setContents(String string, Transferable transferable, ClipboardOwner clipboardOwner) {
        if (string == null) {
            return;
        }
        this.setContents(new StringSelection(string), transferable, clipboardOwner);
    }

    public synchronized void setContents(Transferable transferable, ClipboardOwner clipboardOwner) {
        this.setContents(transferable, null, clipboardOwner);
    }

    public synchronized void setContents(Transferable transferable, Transferable transferable2, ClipboardOwner clipboardOwner) {
        if (transferable == null) {
            return;
        }
        try {
            sSystemClipboard.setContents(transferable, sClipboardOwner);
            if (clipboardOwner != null) {
                sClipboardOwner.setExternalOwner(clipboardOwner);
            }
            if (this.fPrivateClipboard == null) {
                this.fPrivateClipboard = this.fVeryPrivateClipboard;
            }
            this.fPrivateClipboard.setContents(transferable2, clipboardOwner);
        }
        catch (IllegalStateException illegalStateException) {
            MJClipboard.showErrorMessage();
        }
    }

    public synchronized Transferable getContents(Object object) {
        Transferable transferable = null;
        Transferable transferable2 = null;
        try {
            transferable = sSystemClipboard.getContents(object);
            if (this.fPrivateClipboard != null) {
                transferable2 = this.fPrivateClipboard.getContents(object);
            }
        }
        catch (IllegalStateException illegalStateException) {
            MJClipboard.showErrorMessage();
        }
        Transferable[] transferableArray = new Transferable[]{transferable, transferable2};
        return MJTransferable.getCombinedTransferable(transferableArray);
    }

    public synchronized DataFlavor[] getAvailableDataFlavors() {
        DataFlavor[] dataFlavorArray = sSystemClipboard.getAvailableDataFlavors();
        if (this.fPrivateClipboard == null) {
            return dataFlavorArray;
        }
        DataFlavor[] dataFlavorArray2 = this.fPrivateClipboard.getAvailableDataFlavors();
        DataFlavor[] dataFlavorArray3 = new DataFlavor[dataFlavorArray.length + dataFlavorArray2.length];
        System.arraycopy(dataFlavorArray, 0, dataFlavorArray3, 0, dataFlavorArray.length);
        System.arraycopy(dataFlavorArray2, 0, dataFlavorArray3, dataFlavorArray.length, dataFlavorArray2.length);
        return dataFlavorArray3;
    }

    public synchronized boolean isDataFlavorAvailable(DataFlavor dataFlavor) {
        return sSystemClipboard.isDataFlavorAvailable(dataFlavor) || this.fPrivateClipboard.isDataFlavorAvailable(dataFlavor);
    }

    public synchronized Object getData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (sSystemClipboard.isDataFlavorAvailable(dataFlavor)) {
            return sSystemClipboard.getData(dataFlavor);
        }
        return this.fPrivateClipboard.getData(dataFlavor);
    }

    public synchronized Object getXSelectionData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (PlatformInfo.isXWindows()) {
            Object object = null;
            try {
                if (sXSelectionClipboard != null) {
                    object = sXSelectionClipboard.getData(dataFlavor);
                }
            }
            catch (IllegalStateException illegalStateException) {
                MJClipboard.showErrorMessage();
            }
            return object;
        }
        return null;
    }

    public synchronized void setXSelectionContents(String string) {
        if (PlatformInfo.isXWindows()) {
            StringSelection stringSelection = new StringSelection(string);
            sXSelectionClipboard.setContents(stringSelection, null);
        }
    }

    public synchronized Transferable getXSelectionContents(Object object) {
        if (PlatformInfo.isXWindows()) {
            Transferable transferable = null;
            try {
                if (sXSelectionClipboard != null) {
                    transferable = sXSelectionClipboard.getContents(object);
                }
            }
            catch (IllegalStateException illegalStateException) {
                MJClipboard.showErrorMessage();
            }
            return transferable;
        }
        return null;
    }

    private static void showErrorMessage() {
        MJOptionPane.showMessageDialog(null, MJUtilities.intlString("error.ClipboardUnavailable"), MJUtilities.intlString("error.ClipboardErrorTitle"), 0);
    }

    static {
        sThis = null;
        sClipboardOwner = null;
    }

    private class PrivateClipboardOwner
    implements ClipboardOwner {
        private ClipboardOwner fExternalOwner = null;

        private PrivateClipboardOwner() {
        }

        @Override
        public synchronized void lostOwnership(Clipboard clipboard, Transferable transferable) {
            MJClipboard.this.fPrivateClipboard = null;
            if (this.fExternalOwner != null) {
                this.fExternalOwner.lostOwnership(clipboard, transferable);
            }
        }

        synchronized void setExternalOwner(ClipboardOwner clipboardOwner) {
            this.fExternalOwner = clipboardOwner;
        }

        synchronized ClipboardOwner getExternalOwner() {
            return this.fExternalOwner;
        }
    }
}

