/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing.binding;

import com.mathworks.mwswing.binding.ActionData;
import com.mathworks.mwswing.binding.Context;
import com.mathworks.mwswing.binding.ContextActionData;
import com.mathworks.mwswing.binding.CustomKeyBindingSet;
import com.mathworks.mwswing.binding.DefaultKeyBindingSet;
import com.mathworks.mwswing.binding.KeyBindingManager;
import com.mathworks.mwswing.binding.KeyStrokeList;
import com.mathworks.mwswing.binding.KeyStrokeUtils;
import com.mathworks.mwswing.binding.ReadWriteException;
import com.mathworks.util.PlatformInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import javax.swing.KeyStroke;

public final class UseCase {
    public static final ActionData COPY;
    public static final ActionData EXIT_MATLAB;
    public static final ActionData EVAL_CELL;
    public static final ActionData EVAL_SELECTED_CODE;
    public static final ActionData DEBUG_BLOCK;
    public static final ActionData BOGUS_ACTION;
    public static final ActionData NAVIGATION_ACTION;
    public static final Context EDITOR_CONTEXT;
    public static final Context EML_CONTEXT;
    public static final Context COMMAND_WINDOW_CONTEXT;
    public static final CustomKeyBindingSet CUSTOM_KEY_SET;
    public static final KeyStrokeList ALT_W;
    private static final KeyStrokeList META_W;
    public static final KeyStrokeList[] ALT_W_BINDINGS;
    public static final KeyStrokeList CTRL_C;
    public static final KeyStrokeList SYSCTRL_Q;
    public static final KeyStrokeList SYSCTRL_ENTER;
    public static final KeyStrokeList SYSCTRL_E;
    public static final KeyStrokeList CTRL_INSERT;
    public static final KeyStrokeList CTRL_D;
    public static final KeyStrokeList CTRL_X;
    public static final KeyStrokeList SYSCTRL_J;
    public static final KeyStrokeList ALT_RIGHT;
    public static final KeyStrokeList ALT_KP_RIGHT;
    public static final KeyStrokeList META_RIGHT;
    public static final KeyStrokeList META_KP_RIGHT;
    public static final KeyStrokeList UP;
    public static final KeyStrokeList KP_UP;
    public static final KeyStrokeList DOWN;
    public static final KeyStrokeList KP_DOWN;
    private KeyBindingManager fManager;

    public UseCase(Class clazz) throws ReadWriteException {
        if (clazz == null) {
            this.fManager = new KeyBindingManager();
            this.fManager.addAction(COPY);
            this.fManager.addAction(EXIT_MATLAB);
            this.fManager.addAction(EVAL_CELL);
            this.fManager.addAction(EVAL_SELECTED_CODE);
            this.fManager.addAction(DEBUG_BLOCK);
            this.fManager.addAction(BOGUS_ACTION);
            this.fManager.addAction(NAVIGATION_ACTION);
            this.fManager.addContext(EDITOR_CONTEXT);
            this.fManager.addContext(COMMAND_WINDOW_CONTEXT);
            this.fManager.addContext(EML_CONTEXT);
            this.fManager.addCustomKeyBindingSet(CUSTOM_KEY_SET);
        } else {
            this.fManager = new KeyBindingManager();
            this.fManager.parseAndRegisterActions(clazz.getResourceAsStream("CommonActions.xml"));
            this.fManager.parseAndRegisterActions(clazz.getResourceAsStream("EMLEditorActions.xml"));
            this.fManager.parseAndRegisterContexts(clazz.getResourceAsStream("EditorContext.xml"));
            this.fManager.parseAndRegisterContexts(clazz.getResourceAsStream("CommandWindowContext.xml"));
            this.fManager.parseAndRegisterContexts(clazz.getResourceAsStream("EMLContext.xml"));
            this.fManager.parseAndRegisterCustomKeyBindingSet(CUSTOM_KEY_SET.getID(), CUSTOM_KEY_SET.getName(), clazz.getResourceAsStream("CustomWindowsSet.xml"));
        }
    }

    public KeyBindingManager getKeyBindingManager() {
        return this.fManager;
    }

    public static CustomKeyBindingSet createCustomSet(String string) {
        CustomKeyBindingSet customKeyBindingSet = new CustomKeyBindingSet(string, DefaultKeyBindingSet.WINDOWS, "CustomWindowsSet.xml");
        customKeyBindingSet.addGlobalBinding(COPY, CTRL_X);
        customKeyBindingSet.addGlobalBinding(DEBUG_BLOCK, CTRL_D);
        customKeyBindingSet.setCustomKeyBindings(EDITOR_CONTEXT, EXIT_MATLAB, true, new LinkedList<KeyStrokeList>());
        LinkedList<KeyStrokeList> linkedList = new LinkedList<KeyStrokeList>();
        linkedList.add(new KeyStrokeList(KeyStroke.getKeyStroke(84, 2)));
        customKeyBindingSet.setCustomKeyBindings(EDITOR_CONTEXT, BOGUS_ACTION, false, linkedList);
        customKeyBindingSet.setCustomKeyBindings(EML_CONTEXT, EVAL_CELL, true, new LinkedList<KeyStrokeList>());
        return customKeyBindingSet;
    }

    public static KeyStrokeList[] addToAltWBindings(KeyStrokeList ... keyStrokeListArray) {
        ArrayList<KeyStrokeList> arrayList = new ArrayList<KeyStrokeList>(Arrays.asList(ALT_W_BINDINGS));
        for (KeyStrokeList keyStrokeList : keyStrokeListArray) {
            arrayList.add(keyStrokeList);
        }
        return arrayList.toArray(new KeyStrokeList[0]);
    }

    static {
        KeyStrokeList[] keyStrokeListArray;
        ALT_W = new KeyStrokeList(KeyStroke.getKeyStroke(87, 8));
        META_W = new KeyStrokeList(KeyStroke.getKeyStroke(87, 4));
        if (PlatformInfo.isMacintosh()) {
            KeyStrokeList[] keyStrokeListArray2 = new KeyStrokeList[1];
            keyStrokeListArray = keyStrokeListArray2;
            keyStrokeListArray2[0] = ALT_W;
        } else {
            KeyStrokeList[] keyStrokeListArray3 = new KeyStrokeList[2];
            keyStrokeListArray3[0] = ALT_W;
            keyStrokeListArray = keyStrokeListArray3;
            keyStrokeListArray3[1] = META_W;
        }
        ALT_W_BINDINGS = keyStrokeListArray;
        CTRL_C = new KeyStrokeList(KeyStroke.getKeyStroke(67, 2));
        SYSCTRL_Q = new KeyStrokeList(KeyStroke.getKeyStroke(81, KeyStrokeUtils.MENU_SHORTCUT_KEY_MASK));
        SYSCTRL_ENTER = new KeyStrokeList(KeyStroke.getKeyStroke(10, KeyStrokeUtils.MENU_SHORTCUT_KEY_MASK));
        SYSCTRL_E = new KeyStrokeList(KeyStroke.getKeyStroke(69, KeyStrokeUtils.MENU_SHORTCUT_KEY_MASK));
        CTRL_INSERT = new KeyStrokeList(KeyStroke.getKeyStroke(155, 2));
        CTRL_D = new KeyStrokeList(KeyStroke.getKeyStroke(68, 2));
        CTRL_X = new KeyStrokeList(KeyStroke.getKeyStroke(88, 2));
        SYSCTRL_J = new KeyStrokeList(KeyStroke.getKeyStroke(74, KeyStrokeUtils.MENU_SHORTCUT_KEY_MASK));
        ALT_RIGHT = new KeyStrokeList(KeyStroke.getKeyStroke(39, 8));
        ALT_KP_RIGHT = new KeyStrokeList(KeyStroke.getKeyStroke(227, 8));
        META_RIGHT = new KeyStrokeList(KeyStroke.getKeyStroke(39, 4));
        META_KP_RIGHT = new KeyStrokeList(KeyStroke.getKeyStroke(39, 4));
        UP = new KeyStrokeList(KeyStroke.getKeyStroke(38, 0));
        KP_UP = new KeyStrokeList(KeyStroke.getKeyStroke(224, 0));
        DOWN = new KeyStrokeList(KeyStroke.getKeyStroke(40, 0));
        KP_DOWN = new KeyStrokeList(KeyStroke.getKeyStroke(225, 0));
        COPY = new ActionData("Copy", "&Copy", "Edit", "Puts text on the clipboard", null, "CommonIcon.COPY", null, "Copy Preference Label", false);
        COPY.addAlternateID("copy");
        COPY.addDefaultSetBinding(DefaultKeyBindingSet.WINDOWS, CTRL_C);
        COPY.addDefaultSetBinding(DefaultKeyBindingSet.EMACS, ALT_W);
        COPY.initializationFinished();
        EXIT_MATLAB = new ActionData("ExitMATLAB", "&Exit MATLAB", "File", "Closes MATLAB", null, null, null, null, false);
        EXIT_MATLAB.addUnspecifiedBinding(SYSCTRL_Q);
        EXIT_MATLAB.initializationFinished();
        EVAL_CELL = new ActionData("EvaluateCell", "Evaluate &Cell", "Cell", "Evaluates a block of code", "Evaluate cell", "CommonIcon.CUT", null, null, false);
        EVAL_CELL.addUnspecifiedBinding(SYSCTRL_ENTER);
        EVAL_CELL.initializationFinished();
        EVAL_SELECTED_CODE = new ActionData("EvalSelectedCode", "Evaluate &Selected Code", "Text", "Evaluates selected code in Command Window", null, null, null, null, false);
        EVAL_SELECTED_CODE.addUnspecifiedBinding(SYSCTRL_ENTER);
        EVAL_SELECTED_CODE.initializationFinished();
        DEBUG_BLOCK = new ActionData("DebugBlock", "Debug EML &Block", "Debug", "Debugs an Embedded MATLAB block", null, null, null, null, false);
        DEBUG_BLOCK.initializationFinished();
        BOGUS_ACTION = new ActionData("BogusAction", "Bogus Action", "Edit", "Bogus Action", null, null, null, null, true);
        BOGUS_ACTION.addUnspecifiedBinding(SYSCTRL_J);
        BOGUS_ACTION.addUnspecifiedBinding(SYSCTRL_Q);
        BOGUS_ACTION.initializationFinished();
        NAVIGATION_ACTION = new ActionData("SpecialStrokes", "Has shortcuts that must be duplicated to numpad and/or meta versions", "Edit", "Navigational stroke", null, null, null, null, true);
        NAVIGATION_ACTION.addUnspecifiedBinding(SYSCTRL_Q);
        NAVIGATION_ACTION.addUnspecifiedBinding(ALT_RIGHT);
        NAVIGATION_ACTION.addDefaultSetBinding(DefaultKeyBindingSet.EMACS, UP);
        NAVIGATION_ACTION.initializationFinished();
        ContextActionData contextActionData = new ContextActionData(COPY);
        contextActionData.initializationFinished();
        LinkedList<ContextActionData> linkedList = new LinkedList<ContextActionData>();
        linkedList.add(contextActionData);
        ContextActionData contextActionData2 = new ContextActionData(EXIT_MATLAB);
        contextActionData2.setUnspecifiedFollowsContext(Context.NONE);
        contextActionData2.initializationFinished();
        linkedList.add(contextActionData2);
        ContextActionData contextActionData3 = new ContextActionData(EVAL_CELL);
        contextActionData3.initializationFinished();
        linkedList.add(contextActionData3);
        ContextActionData contextActionData4 = new ContextActionData(BOGUS_ACTION);
        contextActionData4.initializationFinished();
        linkedList.add(contextActionData4);
        EDITOR_CONTEXT = new Context("Editor", "MATLAB Editor", linkedList);
        ContextActionData contextActionData5 = new ContextActionData(COPY);
        contextActionData5.setUnspecifiedFollowsContext(EDITOR_CONTEXT);
        contextActionData5.initializationFinished();
        linkedList.clear();
        linkedList.add(contextActionData5);
        ContextActionData contextActionData6 = new ContextActionData(EVAL_CELL);
        contextActionData6.setUnspecifiedFollowsContext(Context.NONE);
        contextActionData6.addUnspecifiedBindings(SYSCTRL_E);
        contextActionData6.initializationFinished();
        linkedList.add(contextActionData6);
        ContextActionData contextActionData7 = new ContextActionData(DEBUG_BLOCK);
        contextActionData7.initializationFinished();
        linkedList.add(contextActionData7);
        ContextActionData contextActionData8 = new ContextActionData(BOGUS_ACTION);
        contextActionData8.setUnspecifiedFollowsContext(EDITOR_CONTEXT);
        contextActionData8.initializationFinished();
        linkedList.add(contextActionData8);
        ContextActionData contextActionData9 = new ContextActionData(NAVIGATION_ACTION);
        contextActionData9.addUnspecifiedBindings(KP_DOWN);
        contextActionData9.initializationFinished();
        linkedList.add(contextActionData9);
        EML_CONTEXT = new Context("EMLEditor", "EML Editor", linkedList);
        ContextActionData contextActionData10 = new ContextActionData(COPY);
        contextActionData10.addKeyBinding(DefaultKeyBindingSet.WINDOWS, CTRL_INSERT);
        contextActionData10.addKeyBinding(DefaultKeyBindingSet.EMACS, CTRL_C);
        contextActionData10.initializationFinished();
        linkedList.clear();
        linkedList.add(contextActionData10);
        ContextActionData contextActionData11 = new ContextActionData(EXIT_MATLAB);
        contextActionData11.initializationFinished();
        linkedList.add(contextActionData11);
        ContextActionData contextActionData12 = new ContextActionData(EVAL_SELECTED_CODE);
        contextActionData12.initializationFinished();
        linkedList.add(contextActionData12);
        COMMAND_WINDOW_CONTEXT = new Context("CommandWindow", "Command Window", linkedList);
        CUSTOM_KEY_SET = UseCase.createCustomSet("ArbitraryID");
    }
}

