/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing.binding;

import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.ExtendedInputMap;
import com.mathworks.mwswing.MInputMap;
import com.mathworks.mwswing.binding.ActionData;
import com.mathworks.mwswing.binding.ActionDataID;
import com.mathworks.mwswing.binding.ActionDataReader;
import com.mathworks.mwswing.binding.Context;
import com.mathworks.mwswing.binding.ContextActionData;
import com.mathworks.mwswing.binding.ContextReader;
import com.mathworks.mwswing.binding.CustomKeyBindingSet;
import com.mathworks.mwswing.binding.CustomKeyBindingSetReader;
import com.mathworks.mwswing.binding.CustomKeyBindingSetUtils;
import com.mathworks.mwswing.binding.DefaultKeyBindingSet;
import com.mathworks.mwswing.binding.KeyBindingManagerListener;
import com.mathworks.mwswing.binding.KeyBindingManagerRegistry;
import com.mathworks.mwswing.binding.KeyBindingSet;
import com.mathworks.mwswing.binding.KeyStrokeList;
import com.mathworks.mwswing.binding.ReadWriteException;
import com.mathworks.util.Log;
import com.mathworks.util.PlatformInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;

public final class KeyBindingManager
implements KeyBindingManagerRegistry {
    private final Map<String, ActionData> fActionMap = new HashMap<String, ActionData>();
    private final Map<String, Context> fContextMap = new HashMap<String, Context>();
    private final Map<String, CustomKeyBindingSet> fCustomKeyBindingSetMap = new HashMap<String, CustomKeyBindingSet>();
    private Collection<DefaultKeyBindingSet> fDefaultSetsForPlatform = DefaultKeyBindingSet.getDefaultKeyBindingSets();
    private KeyBindingSet fCurrentSet = KeyBindingManager.getDefaultSetForPlatform();
    private final Map<String, ContextReader> fContextReaderMap = new HashMap<String, ContextReader>();
    private final Map<ContextActionData, Collection<WeakReference<KeyBindingManagerListener>>> fListeners = new HashMap<ContextActionData, Collection<WeakReference<KeyBindingManagerListener>>>();
    private int fNumberOfAddListenerCalls = 0;

    public static DefaultKeyBindingSet getDefaultSetForPlatform() {
        return PlatformInfo.isMacintosh() ? DefaultKeyBindingSet.MAC : (PlatformInfo.isWindows() ? DefaultKeyBindingSet.WINDOWS : DefaultKeyBindingSet.EMACS);
    }

    public void parseAndRegisterActions(InputStream inputStream) throws ReadWriteException {
        Collection<ActionData> collection = new ActionDataReader(inputStream, this).getActions();
        for (ActionData actionData : collection) {
            this.addAction(actionData);
        }
    }

    public synchronized void parseAndRegisterContexts(InputStream inputStream) throws ReadWriteException {
        ContextReader contextReader = new ContextReader(inputStream, this);
        Context context = contextReader.getContext();
        this.addContext(context);
        this.fContextReaderMap.put(context.getID(), contextReader);
    }

    public void parseAndRegisterCustomKeyBindingSet(String string, String string2, InputStream inputStream) throws ReadWriteException {
        this.addCustomKeyBindingSet(new CustomKeyBindingSetReader(string2, string, inputStream, this).getKeyBindingSet());
    }

    public void parseAndRegisterCustomKeyBindingSet(File file) throws ReadWriteException, FileNotFoundException {
        this.addCustomKeyBindingSet(CustomKeyBindingSetUtils.readFromFile(file, this));
    }

    public void parseAndRegisterModifiedDefaultSet(File file) throws ReadWriteException, FileNotFoundException {
        CustomKeyBindingSet customKeyBindingSet = CustomKeyBindingSetUtils.readFromFile(file, this);
        assert (customKeyBindingSet.isModifiedDefault()) : "Modified default set does not have modified flag set to true: " + file.getAbsolutePath();
        this.addCustomKeyBindingSet(customKeyBindingSet);
    }

    public void setDefaultKeyBindingSetsForPlatform(Collection<DefaultKeyBindingSet> collection) {
        assert (this.getDefaultKeyBindingSets().containsAll(collection)) : "The default sets specified must be a subset of all available default sets";
        this.fDefaultSetsForPlatform = Collections.unmodifiableCollection(collection);
    }

    public synchronized void addCustomKeyBindingSet(CustomKeyBindingSet customKeyBindingSet) {
        if (this.fCustomKeyBindingSetMap.containsKey(customKeyBindingSet.getID())) {
            KeyBindingManager.throwError("Custom key set " + customKeyBindingSet + " is already registered.");
        }
        this.fCustomKeyBindingSetMap.put(customKeyBindingSet.getID(), customKeyBindingSet);
    }

    public synchronized void removeCustomKeyBindingSet(String string) {
        this.fCustomKeyBindingSetMap.remove(string);
    }

    public synchronized void updateCustomKeyBindingSet(CustomKeyBindingSet customKeyBindingSet) {
        String string = customKeyBindingSet.getID();
        if (!this.containsCustomKeyBindingSet(string)) {
            throw new IllegalArgumentException("There is no currently registered set with ID " + string);
        }
        KeyBindingSet keyBindingSet = this.getKeyBindingSet(string);
        this.removeCustomKeyBindingSet(string);
        this.addCustomKeyBindingSet(customKeyBindingSet);
        if (this.getCurrentKeyBindingSet() == keyBindingSet) {
            this.setCurrentKeyBindingSet(string);
        }
    }

    public synchronized boolean containsCustomKeyBindingSet(String string) {
        return this.fCustomKeyBindingSetMap.containsKey(string);
    }

    public synchronized void addAction(ActionData actionData) {
        if (this.fActionMap.containsKey(actionData.getID())) {
            KeyBindingManager.throwError("ActionData " + actionData + " is already registered.");
        }
        this.fActionMap.put(actionData.getID(), actionData);
    }

    public synchronized void addContext(Context context) {
        if (this.fContextMap.containsKey(context.getID())) {
            KeyBindingManager.throwError("Context " + context + " is already registered.");
        }
        this.fContextMap.put(context.getID(), context);
    }

    @Override
    public synchronized Context getContext(String string) {
        if (string.equals(Context.GLOBAL.getID())) {
            return Context.GLOBAL;
        }
        if (string.equals(Context.NONE.getID())) {
            return Context.NONE;
        }
        Context context = this.fContextMap.get(string);
        if (context == null) {
            KeyBindingManager.throwError("Context " + string + " is not a supported Context.");
        }
        return context;
    }

    @Override
    public synchronized boolean containsContext(String string) {
        return string != null && (string.equals(Context.GLOBAL.getID()) || string.equals(Context.NONE.getID()) || this.fContextMap.containsKey(string));
    }

    public synchronized Collection<ActionData> getActions() {
        return Collections.unmodifiableList(new LinkedList<ActionData>(this.fActionMap.values()));
    }

    public synchronized Collection<ActionData> getNonHiddenActions() {
        LinkedList<ActionData> linkedList = new LinkedList<ActionData>();
        for (ActionData actionData : this.fActionMap.values()) {
            if (actionData.isHidden()) continue;
            linkedList.add(actionData);
        }
        return Collections.unmodifiableList(linkedList);
    }

    @Override
    public synchronized ActionData getActionData(String string) {
        ActionData actionData = this.fActionMap.get(string);
        if (actionData == null) {
            KeyBindingManager.throwError("ActionData " + string + " is not a registered ActionData.");
        }
        return actionData;
    }

    @Override
    public synchronized boolean containsAction(String string) {
        return string != null && this.fActionMap.containsKey(string);
    }

    public Collection<Context> getContextsWithAction(ActionDataID actionDataID) {
        Collection<Context> collection = this.getContexts();
        LinkedList<Context> linkedList = new LinkedList<Context>();
        for (Context context : collection) {
            if (!context.isSupportedAction(actionDataID)) continue;
            linkedList.add(context);
        }
        return Collections.unmodifiableList(linkedList);
    }

    public synchronized Collection<Context> getContexts() {
        return Collections.unmodifiableList(new LinkedList<Context>(this.fContextMap.values()));
    }

    public synchronized Collection<KeyBindingSet> getCustomKeyBindingSets() {
        return Collections.unmodifiableList(new LinkedList<CustomKeyBindingSet>(this.fCustomKeyBindingSetMap.values()));
    }

    public Collection<DefaultKeyBindingSet> getDefaultKeyBindingSets() {
        return DefaultKeyBindingSet.getDefaultKeyBindingSets();
    }

    public Collection<DefaultKeyBindingSet> getDefaultKeyBindingSetsForPlatform() {
        return this.fDefaultSetsForPlatform;
    }

    public Collection<KeyBindingSet> getAllSetsForPlatform() {
        LinkedList<KeyBindingSet> linkedList = new LinkedList<KeyBindingSet>();
        linkedList.addAll(this.getDefaultKeyBindingSetsForPlatform());
        linkedList.addAll(this.getCustomKeyBindingSets());
        return Collections.unmodifiableCollection(linkedList);
    }

    @Override
    public synchronized KeyBindingSet getKeyBindingSet(String string) {
        return this.fCustomKeyBindingSetMap.containsKey(string) ? (KeyBindingSet)this.fCustomKeyBindingSetMap.get(string) : this.getDefaultKeyBindingSet(string);
    }

    private synchronized boolean setCustomKeyBindingSet(String string) {
        if (this.fCustomKeyBindingSetMap.containsKey(string)) {
            this.setCurrentKeyBindingSet(string);
            return true;
        }
        return false;
    }

    public synchronized void setCurrentKeyBindingSet(String string) {
        KeyBindingSet keyBindingSet = this.fCurrentSet;
        this.fCurrentSet = this.getKeyBindingSet(string);
        Collection<ActionData> collection = this.getActions();
        for (ActionData actionData : collection) {
            Collection<Context> collection2 = this.getContextsWithAction(actionData);
            for (Context context : collection2) {
                List<KeyStrokeList> list;
                List<KeyStrokeList> list2;
                Collection<WeakReference<KeyBindingManagerListener>> collection3 = this.getRegisteredListeners(actionData, context);
                if (collection3 == null || ((Object)(list2 = this.fCurrentSet.getKeyBindings(context, actionData))).equals(list = keyBindingSet == null ? null : keyBindingSet.getKeyBindings(context, actionData))) continue;
                KeyBindingManager.fireEvent(collection3, actionData, context, list, list2);
                this.checkUnchangedAssignmentsAndFireEventsIfNecessary(list, list2, actionData, context, keyBindingSet);
            }
        }
    }

    private void checkUnchangedAssignmentsAndFireEventsIfNecessary(List<KeyStrokeList> list, List<KeyStrokeList> list2, ActionData actionData, Context context, KeyBindingSet keyBindingSet) {
        if (list != null) {
            ArrayList<KeyStrokeList> arrayList = new ArrayList<KeyStrokeList>(list);
            arrayList.removeAll(list2);
            if (arrayList.size() > 0) {
                Collection<ContextActionData> collection = context.getSupportedActions();
                for (ContextActionData contextActionData : collection) {
                    Collection<WeakReference<KeyBindingManagerListener>> collection2;
                    ActionData actionData2 = contextActionData.getAction();
                    if (actionData2.equals(actionData) || (collection2 = this.fListeners.get(contextActionData)) == null) continue;
                    assert (keyBindingSet != null) : "If we had non-null old keybindings, then oldSet must be non-null";
                    List<KeyStrokeList> list3 = keyBindingSet.getKeyBindings(context, actionData2);
                    if (!KeyBindingManager.containsAny(arrayList, list3) || !((Object)list3).equals(this.fCurrentSet.getKeyBindings(context, actionData2))) continue;
                    KeyBindingManager.fireEvent(collection2, actionData2, context, list3, list3);
                }
            }
        }
    }

    private static boolean containsAny(List<KeyStrokeList> list, List<KeyStrokeList> list2) {
        for (KeyStrokeList keyStrokeList : list) {
            if (!list2.contains(keyStrokeList)) continue;
            return true;
        }
        return false;
    }

    private static void fireEvent(Collection<WeakReference<KeyBindingManagerListener>> collection, ActionData actionData, Context context, List<KeyStrokeList> list, List<KeyStrokeList> list2) {
        LinkedList<WeakReference<KeyBindingManagerListener>> linkedList = new LinkedList<WeakReference<KeyBindingManagerListener>>(collection);
        for (WeakReference weakReference : linkedList) {
            KeyBindingManagerListener keyBindingManagerListener = (KeyBindingManagerListener)weakReference.get();
            if (keyBindingManagerListener == null) continue;
            keyBindingManagerListener.keyBindingChanged(actionData.getID(), context.getID(), list, list2);
        }
    }

    public synchronized KeyBindingSet getCurrentKeyBindingSet() {
        return this.fCurrentSet;
    }

    @Override
    public DefaultKeyBindingSet getDefaultKeyBindingSet(String string) {
        for (DefaultKeyBindingSet defaultKeyBindingSet : this.getDefaultKeyBindingSets()) {
            if (!defaultKeyBindingSet.getID().equals(string)) continue;
            return defaultKeyBindingSet;
        }
        if (string.equals(DefaultKeyBindingSet.EMPTY.getID())) {
            return DefaultKeyBindingSet.EMPTY;
        }
        KeyBindingManager.throwError("Set " + string + " is not a registered KeyBinding Set.");
        return null;
    }

    public synchronized void addListener(String string, String string2, KeyBindingManagerListener keyBindingManagerListener) {
        Context context = this.getContext(string2);
        ActionData actionData = this.getActionData(string);
        ContextActionData contextActionData = context.getContextAction(actionData);
        Collection<WeakReference<KeyBindingManagerListener>> collection = this.getRegisteredListeners(actionData, context);
        if (collection == null) {
            collection = new LinkedList<WeakReference<KeyBindingManagerListener>>();
            this.fListeners.put(contextActionData, collection);
        }
        collection.add(new WeakReference<KeyBindingManagerListener>(keyBindingManagerListener));
        keyBindingManagerListener.keyBindingChanged(actionData.getID(), context.getID(), null, this.fCurrentSet.getKeyBindings(context, actionData));
        if (++this.fNumberOfAddListenerCalls % 1000 == 0) {
            this.expungeNullKeyBindingManagerListener();
        }
    }

    public Collection<WeakReference<KeyBindingManagerListener>> getRegisteredListeners(ActionData actionData, Context context) {
        ContextActionData contextActionData = context.getContextAction(actionData);
        return this.fListeners.get(contextActionData);
    }

    private void expungeNullKeyBindingManagerListener() {
        for (ContextActionData contextActionData : this.fListeners.keySet()) {
            Iterator<WeakReference<KeyBindingManagerListener>> iterator = this.fListeners.get(contextActionData).iterator();
            while (iterator.hasNext()) {
                if (iterator.next().get() != null) continue;
                iterator.remove();
            }
        }
    }

    public synchronized void removeListener(String string, String string2, KeyBindingManagerListener keyBindingManagerListener) {
        Collection<WeakReference<KeyBindingManagerListener>> collection = this.getRegisteredListeners(this.getActionData(string), this.getContext(string2));
        KeyBindingManager.removeListener(keyBindingManagerListener, collection);
    }

    public synchronized void removeListenerFromAllActions(KeyBindingManagerListener keyBindingManagerListener) {
        Set<Map.Entry<ContextActionData, Collection<WeakReference<KeyBindingManagerListener>>>> set = this.fListeners.entrySet();
        for (Map.Entry<ContextActionData, Collection<WeakReference<KeyBindingManagerListener>>> entry : set) {
            KeyBindingManager.removeListener(keyBindingManagerListener, entry.getValue());
        }
    }

    private static void removeListener(KeyBindingManagerListener keyBindingManagerListener, Collection<WeakReference<KeyBindingManagerListener>> collection) {
        if (collection != null) {
            Iterator<WeakReference<KeyBindingManagerListener>> iterator = collection.iterator();
            while (iterator.hasNext()) {
                KeyBindingManagerListener keyBindingManagerListener2 = (KeyBindingManagerListener)iterator.next().get();
                if (keyBindingManagerListener2 != keyBindingManagerListener) continue;
                iterator.remove();
                break;
            }
        }
    }

    synchronized void clearAll() {
        this.fActionMap.clear();
        this.fContextMap.clear();
        this.fCustomKeyBindingSetMap.clear();
    }

    public synchronized Collection<String> getActionsWithTag(String string, String string2) {
        ContextReader contextReader = this.fContextReaderMap.get(string);
        if (contextReader == null) {
            KeyBindingManager.throwError("Context '" + string + "' has not been registered with its xml file.");
        }
        return contextReader.getActionsWithTag(string2);
    }

    private static void throwError(String string) throws IllegalStateException {
        Log.printLn((String)string);
        throw new IllegalStateException(string);
    }

    public void addToActionMap(ExtendedAction extendedAction, ActionMap actionMap) {
        if (!this.containsAction(extendedAction.getActionID())) {
            throw new IllegalArgumentException("Action '" + extendedAction.getName() + "' is not registered.");
        }
        actionMap.put(extendedAction.getActionID(), extendedAction);
        for (String string : this.getActionData(extendedAction.getActionID()).getAlternateIDs()) {
            actionMap.put(string, extendedAction);
        }
    }

    public void removeFromActionMap(ExtendedAction extendedAction, ActionMap actionMap) {
        if (!this.containsAction(extendedAction.getActionID())) {
            throw new IllegalArgumentException("Action '" + extendedAction.getName() + "' is not registered.");
        }
        actionMap.remove(extendedAction.getActionID());
        for (String string : this.getActionData(extendedAction.getActionID()).getAlternateIDs()) {
            actionMap.remove(string);
        }
    }

    public void addKeyBindings(JComponent jComponent, int n, ExtendedAction extendedAction) {
        ExtendedInputMap extendedInputMap;
        InputMap inputMap = jComponent.getInputMap(n);
        if (inputMap instanceof ExtendedInputMap) {
            extendedInputMap = (ExtendedInputMap)((Object)inputMap);
        } else {
            MInputMap mInputMap = new MInputMap();
            mInputMap.setParent(inputMap);
            jComponent.setInputMap(n, mInputMap);
            extendedInputMap = mInputMap;
        }
        this.addToActionMap(extendedAction, jComponent.getActionMap());
        this.addKeyBindings(extendedAction, extendedInputMap);
    }

    public void addKeyBindings(ExtendedAction extendedAction, ExtendedInputMap extendedInputMap) {
        if (!this.containsActionAndContext(extendedAction)) {
            throw new IllegalArgumentException("Action '" + extendedAction.getName() + "' is not registered.");
        }
        this.addKeyBindings(extendedAction.getContextID(), extendedAction.getActionID(), extendedInputMap);
    }

    public void addKeyBindings(String string, String string2, ExtendedInputMap extendedInputMap) {
        this.addListener(string2, string, extendedInputMap);
    }

    public void addKeyBindingsWithTag(String string, String string2, ExtendedInputMap extendedInputMap) {
        Collection<String> collection = this.getActionsWithTag(string, string2);
        for (String string3 : collection) {
            this.addKeyBindings(string, string3, extendedInputMap);
        }
    }

    public void clearKeyBindings(String string, String string2, ExtendedInputMap extendedInputMap) {
        this.removeListener(string2, string, extendedInputMap);
        List<KeyStrokeList> list = this.getCurrentKeyBindingSet().getKeyBindings(this.getContext(string), this.getActionData(string2));
        extendedInputMap.keyBindingChanged(string2, string, list, null);
    }

    public void clearAllKeyBindings(ExtendedInputMap extendedInputMap) {
        this.removeListenerFromAllActions(extendedInputMap);
        extendedInputMap.clearSequences();
        extendedInputMap.clear();
    }

    public void addKeyBindingAndActionInfo(String string, String string2, ExtendedAction extendedAction) {
        this.addActionInfoOnly(string, string2, extendedAction);
        this.addListener(string2, string, extendedAction);
    }

    public void addActionInfoOnly(String string, String string2, ExtendedAction extendedAction) {
        ActionData actionData = this.getActionData(string2);
        extendedAction.addActionInfo(string, string2, actionData.getLabel(), actionData.getTooltip(), actionData.getIcon());
    }

    public void clearKeyBinding(ExtendedAction extendedAction) {
        String string = extendedAction.getActionID();
        assert (string != null) : "No action ID has been set on this action";
        String string2 = extendedAction.getContextID();
        assert (string2 != null) : "No context has been set on this action";
        this.removeListener(string, string2, extendedAction);
        extendedAction.setAccelerator(null);
        extendedAction.setAcceleratorSequence(null);
    }

    public synchronized boolean containsActionAndContext(Action action) {
        return action instanceof ExtendedAction && this.containsAction(((ExtendedAction)action).getActionID()) && this.containsContext(((ExtendedAction)action).getContextID());
    }

    public synchronized boolean isActionSupportedByContext(String string, String string2) {
        return this.containsContext(string) && this.containsAction(string2) && this.getContext(string).isSupportedAction(this.getActionData(string2));
    }

    public synchronized List<Conflict> getAllKeyBindingConflicts(KeyBindingSet keyBindingSet, KeyStrokeList keyStrokeList) {
        ArrayList<Conflict> arrayList = new ArrayList<Conflict>();
        for (ActionData actionData : this.getNonHiddenActions()) {
            for (Context context : this.getContextsWithAction(actionData)) {
                List<KeyStrokeList> list = keyBindingSet.getKeyBindings(context, actionData);
                for (KeyStrokeList keyStrokeList2 : list) {
                    if (!KeyBindingManager.bindingsStartWithSameEntries(keyStrokeList2, keyStrokeList)) continue;
                    arrayList.add(new Conflict(keyStrokeList2, actionData, context));
                }
            }
        }
        return arrayList;
    }

    private static boolean bindingsStartWithSameEntries(KeyStrokeList keyStrokeList, KeyStrokeList keyStrokeList2) {
        KeyStrokeList keyStrokeList3 = keyStrokeList.getKeyStrokes().size() > keyStrokeList2.getKeyStrokes().size() ? keyStrokeList : keyStrokeList2;
        KeyStrokeList keyStrokeList4 = keyStrokeList3 == keyStrokeList ? keyStrokeList2 : keyStrokeList;
        return Collections.indexOfSubList(keyStrokeList3.getKeyStrokes(), keyStrokeList4.getKeyStrokes()) == 0;
    }

    public static class Conflict {
        private final KeyStrokeList fBinding;
        private final ActionData fAction;
        private final Context fContext;

        private Conflict(KeyStrokeList keyStrokeList, ActionData actionData, Context context) {
            this.fBinding = keyStrokeList;
            this.fAction = actionData;
            this.fContext = context;
        }

        public KeyStrokeList getBinding() {
            return this.fBinding;
        }

        public ActionData getAction() {
            return this.fAction;
        }

        public Context getContext() {
            return this.fContext;
        }
    }
}

