/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing.binding;

import com.mathworks.mwswing.ExtendedInputMap;
import com.mathworks.mwswing.binding.KeyBindingManagerListener;
import com.mathworks.mwswing.binding.KeyStrokeList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.swing.InputMap;
import javax.swing.KeyStroke;

public class InputMapActionListener
implements KeyBindingManagerListener {
    private final ExtendedInputMap fInputMap;
    private HashMap<List<KeyStroke>, Object> fSequenceMap = new HashMap();
    private HashMap<KeyStroke, List<List<KeyStroke>>> fStartsWithMap = new HashMap();

    public InputMapActionListener(ExtendedInputMap extendedInputMap) {
        assert (extendedInputMap != null) : "input map cannot be null";
        this.fInputMap = extendedInputMap;
    }

    public void put(KeyStroke[] keyStrokeArray, Object object) {
        if (keyStrokeArray == null || keyStrokeArray.length == 0) {
            return;
        }
        if (keyStrokeArray.length == 1) {
            this.fInputMap.put(keyStrokeArray[0], object);
            return;
        }
        List<KeyStroke> list = Arrays.asList(keyStrokeArray);
        if (object == null) {
            this.remove(list);
        } else {
            this.put(list, object);
        }
    }

    public void remove(KeyStroke[] keyStrokeArray) {
        if (keyStrokeArray.length == 1) {
            this.fInputMap.remove(keyStrokeArray[0]);
        } else {
            this.remove(Arrays.asList(keyStrokeArray));
        }
    }

    public Object get(KeyStroke[] keyStrokeArray) {
        InputMap inputMap;
        if (keyStrokeArray.length == 1) {
            return this.fInputMap.get(keyStrokeArray[0]);
        }
        Object object = this.fSequenceMap.get(Arrays.asList(keyStrokeArray));
        if (object == null && (inputMap = this.fInputMap.getParent()) instanceof ExtendedInputMap) {
            object = ((ExtendedInputMap)((Object)inputMap)).get(keyStrokeArray);
        }
        return object;
    }

    public List<KeyStroke[]> getSequencesStartingWith(KeyStroke keyStroke) {
        return this.getSequencesStartingWith(keyStroke, null);
    }

    public List<KeyStroke[]> getSequencesStartingWith(KeyStroke keyStroke, List<KeyStroke[]> list) {
        InputMap inputMap;
        List<List<KeyStroke>> list2;
        if (list == null) {
            list = new ArrayList<KeyStroke[]>();
        }
        if ((list2 = this.fStartsWithMap.get(keyStroke)) != null) {
            int n = list2.size();
            for (int i = 0; i < n; ++i) {
                List<KeyStroke> list3 = list2.get(i);
                list.add((KeyStroke[])list3.toArray());
            }
        }
        if ((inputMap = this.fInputMap.getParent()) instanceof ExtendedInputMap) {
            ((ExtendedInputMap)((Object)inputMap)).getSequencesStartingWith(keyStroke, list);
        }
        return list;
    }

    public void clearSequences() {
        this.fSequenceMap.clear();
        this.fStartsWithMap.clear();
    }

    public int sequenceCount() {
        return this.fSequenceMap.size();
    }

    private void put(List<KeyStroke> list, Object object) {
        this.fSequenceMap.put(list, object);
        KeyStroke keyStroke = list.iterator().next();
        List<List<KeyStroke>> list2 = this.fStartsWithMap.get(keyStroke);
        if (list2 == null) {
            list2 = new ArrayList<List<KeyStroke>>();
            this.fStartsWithMap.put(keyStroke, list2);
            list2.add(list);
        } else if (!list2.contains(list)) {
            list2.add(list);
        }
    }

    public void remove(List<KeyStroke> list) {
        this.fSequenceMap.remove(list);
        KeyStroke keyStroke = list.iterator().next();
        List<List<KeyStroke>> list2 = this.fStartsWithMap.get(keyStroke);
        if (list2 != null && list2.contains(list)) {
            list2.remove(list);
            if (list2.size() == 0) {
                this.fStartsWithMap.remove(keyStroke);
            }
        }
    }

    @Override
    public void keyBindingChanged(String string, String string2, List<KeyStrokeList> list, List<KeyStrokeList> list2) {
        Object object;
        List<KeyStroke> list3;
        if (list != null) {
            for (KeyStrokeList keyStrokeList : list) {
                list3 = keyStrokeList.getKeyStrokes();
                if (list3 == null || list3.isEmpty()) continue;
                if (keyStrokeList.isMultiStroke()) {
                    assert (list3.size() >= 2);
                    if (!string.equals(this.fInputMap.getSequenceMapObject(list3))) continue;
                    this.fInputMap.remove(list3);
                    continue;
                }
                assert (list3.size() == 1);
                object = list3.iterator().next();
                if (!string.equals(this.fInputMap.get((KeyStroke)object))) continue;
                this.fInputMap.remove((KeyStroke)object);
            }
        }
        if (list2 != null) {
            for (KeyStrokeList keyStrokeList : list2) {
                if (!keyStrokeList.isMultiStroke() && keyStrokeList.getKeyStrokes().size() > 0) {
                    assert (keyStrokeList.getKeyStrokes().size() == 1);
                    this.fInputMap.put(keyStrokeList.getKeyStrokes().iterator().next(), (Object)string);
                    continue;
                }
                if (!keyStrokeList.isMultiStroke()) continue;
                list3 = keyStrokeList.getKeyStrokes();
                object = new KeyStroke[list3.size()];
                list3.toArray((T[])object);
                this.put(Arrays.asList(object), (Object)string);
            }
        }
    }

    public Object getSequenceMapObject(List<KeyStroke> list) {
        return this.fSequenceMap.get(list);
    }
}

