/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.jgoodies.looks.LookUtils;
import com.mathworks.common.icons.DialogIcon;
import com.mathworks.mwswing.BareSwingDetector;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.plaf.PlafUtils;
import com.mathworks.util.LanguageUtils;
import com.mathworks.util.PlatformInfo;
import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ComponentInputMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.commons.lang.ArrayUtils;

public class MJOptionPane
extends JOptionPane {
    public static final String YES_STRING = MJOptionPane.getButtonString("dialog.MJOptionPane.Yes");
    public static final String NO_STRING = MJOptionPane.getButtonString("dialog.MJOptionPane.No");
    public static final String CANCEL_STRING = MJOptionPane.getButtonString("dialog.MJOptionPane.Cancel");
    public static final String SAVE_STRING = MJOptionPane.getButtonString("dialog.MJOptionPane.Save");
    public static final String DONT_SAVE_STRING = MJOptionPane.getButtonString("dialog.MJOptionPane.DontSave");
    public static final String DEFAULT_DIALOG_NAME = "MJOptionPaneDialog";
    private InputMap fHotKeyInputMap;
    private static final Set<AWTKeyStroke> FORWARD_ARROW_KEYS;
    private static final Set<AWTKeyStroke> BACKWARD_ARROW_KEYS;

    private static String getButtonString(String string) {
        String string2 = MJUtilities.intlString(string);
        if (PlatformInfo.isMacintosh()) {
            string2 = MJUtilities.exciseAmpersand(string2);
        }
        return string2;
    }

    public MJOptionPane() {
    }

    public MJOptionPane(Object object) {
        super(object);
    }

    public MJOptionPane(Object object, int n) {
        this(object, n, 1);
    }

    public MJOptionPane(Object object, int n, int n2) {
        this(object, n, n2, null);
    }

    public MJOptionPane(Object object, int n, int n2, Icon icon) {
        this(object, n, n2, icon, null);
    }

    public MJOptionPane(Object object, int n, int n2, Icon icon, Object[] objectArray) {
        this(object, n, n2, icon, objectArray, null);
    }

    public MJOptionPane(Object object, int n, int n2, Icon icon, Object[] objectArray, Object object2) {
        super(object, n, n2, icon, objectArray, object2);
    }

    @Override
    public void updateUI() {
        BareSwingDetector.exempt();
        super.updateUI();
        BareSwingDetector.reinstate();
    }

    @Override
    public JDialog createDialog(Component component, String string) {
        Window window = MJOptionPane.getWindowForComponent(component);
        final MJDialog mJDialog = window instanceof Frame ? new MJDialog((Frame)window, string, true) : new MJDialog((Dialog)window, string, true);
        mJDialog.setName(DEFAULT_DIALOG_NAME);
        Container container = mJDialog.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this, "Center");
        mJDialog.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = mJDialog.getSize();
        boolean bl = false;
        if (dimension2.width > dimension.width) {
            dimension2.width = dimension.width;
            bl = true;
        }
        if (dimension2.height > dimension.height) {
            dimension2.height = dimension.height;
            bl = true;
        }
        if (bl) {
            mJDialog.setSize(dimension2);
        }
        mJDialog.setLocationRelativeTo(component);
        this.setupFocusListenerForArrowHandling(mJDialog);
        mJDialog.addWindowListener(new WindowAdapter(){
            private boolean iGotFocus = false;

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                MJOptionPane.this.setValue(null);
            }

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                if (!this.iGotFocus) {
                    MJOptionPane.this.selectInitialValue();
                    this.iGotFocus = true;
                }
            }
        });
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (mJDialog.isVisible() && propertyChangeEvent.getSource() == MJOptionPane.this && (propertyChangeEvent.getPropertyName().equals("value") || propertyChangeEvent.getPropertyName().equals("inputValue"))) {
                    mJDialog.setVisible(false);
                    mJDialog.dispose();
                }
            }
        });
        return mJDialog;
    }

    private void setupFocusListenerForArrowHandling(final JDialog jDialog) {
        final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                MJOptionPane.checkFocusTraversalKeys(propertyChangeEvent.getNewValue(), jDialog);
            }
        };
        final KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        keyboardFocusManager.addPropertyChangeListener("focusOwner", propertyChangeListener);
        WindowAdapter windowAdapter = new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                keyboardFocusManager.removePropertyChangeListener("focusOwner", propertyChangeListener);
                jDialog.removeWindowListener(this);
            }
        };
        jDialog.addWindowListener(windowAdapter);
    }

    private static void checkFocusTraversalKeys(Object object, JDialog jDialog) {
        if (object instanceof JComponent) {
            JComponent jComponent = (JComponent)object;
            InputMap inputMap = MJUtilities.createCompositeInputMap(jComponent.getInputMap(), jComponent.getInputMap(1));
            Set<AWTKeyStroke> set = jDialog.getFocusTraversalKeys(0);
            Set<AWTKeyStroke> set2 = jDialog.getFocusTraversalKeys(1);
            HashSet<AWTKeyStroke> hashSet = new HashSet<AWTKeyStroke>(set);
            HashSet<AWTKeyStroke> hashSet2 = new HashSet<AWTKeyStroke>(set2);
            if (inputMap.get(KeyStroke.getKeyStroke(38, 0)) == null && inputMap.get(KeyStroke.getKeyStroke(40, 0)) == null && inputMap.get(KeyStroke.getKeyStroke(37, 0)) == null && inputMap.get(KeyStroke.getKeyStroke(39, 0)) == null) {
                hashSet.addAll(FORWARD_ARROW_KEYS);
                hashSet2.addAll(BACKWARD_ARROW_KEYS);
            } else {
                hashSet.removeAll(FORWARD_ARROW_KEYS);
                hashSet2.removeAll(BACKWARD_ARROW_KEYS);
            }
            jDialog.setFocusTraversalKeys(0, hashSet);
            jDialog.setFocusTraversalKeys(1, hashSet2);
        }
    }

    public static String showInputDialog(Object object) {
        return MJOptionPane.showInputDialog(null, object);
    }

    public static String showInputDialog(Component component, Object object) {
        return MJOptionPane.showInputDialog(component, object, MJUtilities.intlString("dialog.MJOptionPane.InputTitle"), 3);
    }

    public static String showInputDialog(Component component, Object object, String string, int n) {
        return (String)MJOptionPane.showInputDialog(component, object, string, n, null, null, null);
    }

    public static Object showInputDialog(Component component, Object object, String string, int n, Icon icon, Object[] objectArray, Object object2) {
        BareSwingDetector.exempt();
        MJOptionPane mJOptionPane = new MJOptionPane(object, n, 2, icon, null, null);
        mJOptionPane.setWantsInput(true);
        mJOptionPane.setSelectionValues(objectArray);
        mJOptionPane.setInitialSelectionValue(object2);
        mJOptionPane.setComponentOrientation((component == null ? MJOptionPane.getRootFrame() : component).getComponentOrientation());
        JDialog jDialog = mJOptionPane.createDialog(component, string);
        mJOptionPane.selectInitialValue();
        BareSwingDetector.reinstate();
        jDialog.setVisible(true);
        jDialog.dispose();
        Object object3 = mJOptionPane.getInputValue();
        if (object3 == UNINITIALIZED_VALUE) {
            return null;
        }
        return object3;
    }

    public static void showMessageDialog(Component component, Object object) {
        MJOptionPane.showMessageDialog(component, object, MJUtilities.intlString("dialog.MJOptionPane.MessageTitle"), 1);
    }

    public static void showMessageDialog(Component component, Object object, String string, int n) {
        MJOptionPane.showMessageDialog(component, object, string, n, null);
    }

    public static void showMessageDialog(Component component, Object object, String string, int n, Icon icon) {
        MJOptionPane.showOptionDialog(component, object, string, -1, n, icon, null, null);
    }

    public static int showConfirmDialog(Component component, Object object) {
        return MJOptionPane.showConfirmDialog(component, object, MJUtilities.intlString("dialog.MJOptionPane.ConfirmTitle"), 1);
    }

    public static int showConfirmDialog(Component component, Object object, String string, int n) {
        return MJOptionPane.showConfirmDialog(component, object, string, n, 3);
    }

    public static int showConfirmDialog(Component component, Object object, String string, int n, int n2) {
        return MJOptionPane.showConfirmDialog(component, object, string, n, n2, null);
    }

    public static int showConfirmDialog(Component component, Object object, String string, int n, int n2, Icon icon) {
        return MJOptionPane.showOptionDialog(component, object, string, n, n2, icon, null, null);
    }

    public static int showOptionDialog(Component component, Object object, String string, int n, int n2, Icon icon, Object[] objectArray, Object object2) {
        boolean bl;
        BareSwingDetector.exempt();
        if (objectArray != null && PlatformInfo.isMacintosh()) {
            for (int i = 0; i != objectArray.length; ++i) {
                if (!(objectArray[i] instanceof String)) continue;
                objectArray[i] = MJUtilities.exciseAmpersand((String)objectArray[i]);
            }
        }
        Object[] objectArray2 = MJOptionPane.configureButtons(objectArray);
        int n3 = objectArray == null ? -1 : ArrayUtils.indexOf((Object[])objectArray, (Object)object2);
        Object object3 = n3 == -1 ? object2 : objectArray2[n3];
        MJOptionPane mJOptionPane = new MJOptionPane(object, n2, n, icon, objectArray2, object3);
        mJOptionPane.setParentOptionPane(objectArray2);
        mJOptionPane.setInitialValue(object3);
        mJOptionPane.setComponentOrientation((component == null ? MJOptionPane.getRootFrame() : component).getComponentOrientation());
        JDialog jDialog = mJOptionPane.createDialog(component, string);
        boolean bl2 = bl = !(object instanceof Component);
        if (!bl && object instanceof EnhancedKeyHandling) {
            bl = ((EnhancedKeyHandling)object).allowMnemonicHandling();
        }
        if (bl) {
            mJOptionPane.addDefaultHotKeys(objectArray);
        }
        mJOptionPane.selectInitialValue();
        BareSwingDetector.reinstate();
        jDialog.setVisible(true);
        jDialog.dispose();
        Object object4 = mJOptionPane.getValue();
        if (object4 == null) {
            return -1;
        }
        if (objectArray == null) {
            if (object4 instanceof Integer) {
                return (Integer)object4;
            }
            return -1;
        }
        int n4 = ArrayUtils.indexOf((Object[])objectArray, (Object)object4);
        return n4 == -1 ? -1 : n4;
    }

    static Window getWindowForComponent(Component component) {
        if (component == null) {
            return MJOptionPane.getRootFrame();
        }
        if (component instanceof Frame || component instanceof Dialog) {
            return (Window)component;
        }
        return MJOptionPane.getWindowForComponent(component.getParent());
    }

    private static Object[] configureButtons(Object[] objectArray) {
        Object[] objectArray2 = null;
        if (objectArray != null) {
            objectArray2 = new Object[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] instanceof String || objectArray[i] instanceof Option) {
                    String string = objectArray[i] instanceof Option ? ((Option)objectArray[i]).getText() : (String)objectArray[i];
                    MJButton mJButton = new MJButton(new ButtonAction(string, objectArray[i]));
                    int n = UIManager.getInt("OptionPane.buttonMinimumWidth");
                    if (n > mJButton.getPreferredSize().width) {
                        mJButton.setPreferredSize(new Dimension(n, mJButton.getPreferredSize().height));
                    }
                    mJButton.setToolTipText(null);
                    objectArray2[i] = mJButton;
                    continue;
                }
                objectArray2[i] = objectArray[i];
            }
        }
        return objectArray2;
    }

    private void setParentOptionPane(Object[] objectArray) {
        if (objectArray != null) {
            for (int i = 0; i != objectArray.length; ++i) {
                if (!(objectArray[i] instanceof JButton) || !(((AbstractButton)objectArray[i]).getAction() instanceof ButtonAction)) continue;
                ((ButtonAction)((AbstractButton)objectArray[i]).getAction()).setOptionPane(this);
            }
        }
    }

    private void addHotKey(char c, Object object) {
        Window window = SwingUtilities.windowForComponent(this);
        if (window instanceof RootPaneContainer) {
            Serializable serializable;
            JRootPane jRootPane = ((RootPaneContainer)((Object)window)).getRootPane();
            if (this.fHotKeyInputMap == null) {
                serializable = jRootPane.getInputMap(2);
                this.fHotKeyInputMap = new ComponentInputMap(jRootPane);
                this.fHotKeyInputMap.setParent((InputMap)serializable);
                jRootPane.setInputMap(2, this.fHotKeyInputMap);
            }
            serializable = new HotKeyAction(object);
            this.fHotKeyInputMap.put(KeyStroke.getKeyStroke(Character.toLowerCase(c)), serializable);
            this.fHotKeyInputMap.put(KeyStroke.getKeyStroke(Character.toUpperCase(c)), serializable);
            jRootPane.getActionMap().put(serializable, (Action)((Object)serializable));
        }
    }

    private void addDefaultHotKeys(Object[] objectArray) {
        if (!PlatformInfo.isMacintosh()) {
            if (objectArray == null) {
                switch (this.getOptionType()) {
                    case 0: {
                        this.addHotKey('Y', 0);
                        this.addHotKey('N', 1);
                        break;
                    }
                    case 2: {
                        this.addHotKey('O', 0);
                        this.addHotKey('C', 2);
                        break;
                    }
                    case 1: {
                        this.addHotKey('Y', 0);
                        this.addHotKey('N', 1);
                        this.addHotKey('C', 2);
                        break;
                    }
                    default: {
                        this.addHotKey('O', 0);
                        break;
                    }
                }
            } else {
                for (int i = 0; i != objectArray.length; ++i) {
                    this.addHotKey(objectArray[i]);
                }
            }
        }
    }

    private void addHotKey(Object object) {
        int n;
        if (object instanceof String) {
            String string = (String)object;
            int n2 = MJUtilities.indexOfMnemonic(string);
            if (n2 != -1) {
                char c = ((CharSequence)object).charAt(n2);
                this.addHotKey(c, object);
            } else if (string.equals(CANCEL_STRING)) {
                this.addHotKey('C', object);
            }
        } else if (object instanceof AbstractButton && (n = ((AbstractButton)object).getMnemonic()) != -1 && n != 0) {
            this.addHotKey((char)n, object);
        }
    }

    static {
        UIManager.put("OptionPane.informationIcon", DialogIcon.INFO_32x32.getIcon());
        UIManager.put("OptionPane.questionIcon", DialogIcon.QUESTION_32x32.getIcon());
        UIManager.put("OptionPane.warningIcon", DialogIcon.WARNING_32x32.getIcon());
        UIManager.put("OptionPane.errorIcon", DialogIcon.ERROR_32x32.getIcon());
        if (LanguageUtils.isJapanese()) {
            UIManager.getDefaults().put("OptionPane.cancelButtonText", "\u30ad\u30e3\u30f3\u30bb\u30eb");
        }
        if (PlafUtils.isPlasticLookAndFeel()) {
            UIManager.put("OptionPane.buttonMinimumWidth", LookUtils.IS_LOW_RESOLUTION ? 75 : 100);
        }
        FORWARD_ARROW_KEYS = new HashSet<AWTKeyStroke>();
        BACKWARD_ARROW_KEYS = new HashSet<AWTKeyStroke>();
        FORWARD_ARROW_KEYS.add(AWTKeyStroke.getAWTKeyStroke(39, 0));
        FORWARD_ARROW_KEYS.add(AWTKeyStroke.getAWTKeyStroke(40, 0));
        BACKWARD_ARROW_KEYS.add(AWTKeyStroke.getAWTKeyStroke(37, 0));
        BACKWARD_ARROW_KEYS.add(AWTKeyStroke.getAWTKeyStroke(38, 0));
    }

    public static interface Option {
        public String getText();
    }

    public static interface EnhancedKeyHandling {
        public boolean allowMnemonicHandling();

        public boolean allowArrowKeyTraversal();
    }

    private static class ButtonAction
    extends MJAbstractAction {
        private final Object fValue;
        private MJOptionPane fOptionPane;

        private ButtonAction(String string, Object object) {
            super(string);
            this.fValue = object;
        }

        void setOptionPane(MJOptionPane mJOptionPane) {
            this.fOptionPane = mJOptionPane;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.fOptionPane != null) {
                this.fOptionPane.setValue(this.fValue);
            }
        }
    }

    private class HotKeyAction
    extends AbstractAction {
        private final Object fValue;

        HotKeyAction(Object object) {
            this.fValue = object;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MJOptionPane.this.setValue(this.fValue);
        }
    }
}

