/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.MJUtilities;
import java.awt.Component;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;

final class CheckThreadViolationRepaintManager
extends RepaintManager {
    private static final String MESSAGE = "A Swing component is being accessed on a thread ({0}) other than\nthe Event Dispatch Thread. Please update this code to use the correct thread\n(e.g., via java.awt.EventQueue.invokeLater() or 'javaObjectEDT', 'javaMethodEDT'\nfrom MATLAB).";
    private boolean fCheckWhenNotVisible;
    private WeakReference<Component> fLastComponent;
    private static final Set<String> THREAD_SAFE_METHODS = new HashSet<String>(Arrays.asList("repaint", "revalidate", "replaceSelection", "remove", "append", "insert", "insertString", "replaceRange", "setText", "insertIcon", "insertLogicalStyle", "setCharacterAttributes", "setParagraphAttributes"));
    private static final Set<String> IGNORED_SWING_CLASSES = new HashSet<String>(Arrays.asList("javax.swing.text.html.ImageView$ImageHandler", "javax.swing.colorchooser.SyntheticImageGenerator", "ice.storm.LoadThread", "sun.awt.image.ImageFetcher", "com.sun.java.accessibility.AccessBridge", "com.wildcrest.j2printerworks.J2TreePrinter", "org.openscience.jmol.app.ScriptWindow$ExecuteCommandThread"));

    static String createViolationMessage() {
        String string = Thread.currentThread().getName();
        return MessageFormat.format(MESSAGE, string);
    }

    CheckThreadViolationRepaintManager(boolean bl) {
        this.fCheckWhenNotVisible = bl;
    }

    @Override
    public synchronized void addInvalidComponent(JComponent jComponent) {
        this.checkThreadViolations(jComponent);
        super.addInvalidComponent(jComponent);
    }

    @Override
    public void addDirtyRegion(JComponent jComponent, int n, int n2, int n3, int n4) {
        this.checkThreadViolations(jComponent);
        super.addDirtyRegion(jComponent, n, n2, n3, n4);
    }

    private void checkThreadViolations(JComponent jComponent) {
        if (MJUtilities.threadingChecksEnabled() && !SwingUtilities.isEventDispatchThread() && (this.fCheckWhenNotVisible || jComponent.isShowing())) {
            StackTraceElement[] stackTraceElementArray;
            boolean bl = false;
            boolean bl2 = false;
            for (StackTraceElement stackTraceElement : stackTraceElementArray = new Exception().getStackTrace()) {
                if (IGNORED_SWING_CLASSES.contains(stackTraceElement.getClassName())) {
                    return;
                }
                if (bl && stackTraceElement.getClassName().startsWith("javax.swing.")) {
                    bl2 = true;
                }
                if (!THREAD_SAFE_METHODS.contains(stackTraceElement.getMethodName())) continue;
                bl = true;
                bl2 = false;
            }
            if (bl && !bl2) {
                return;
            }
            if (this.fLastComponent != null && jComponent == this.fLastComponent.get()) {
                return;
            }
            this.fLastComponent = new WeakReference<JComponent>(jComponent);
            System.err.println(CheckThreadViolationRepaintManager.createViolationMessage());
            System.err.println("Component: " + jComponent);
            if (!MJUtilities.threadSafetyWarningStackTraceSuppressed()) {
                for (int i = 3; i < stackTraceElementArray.length; ++i) {
                    System.err.println("    at " + stackTraceElementArray[i]);
                }
            }
        }
    }
}

