/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.beans.editors;

import com.mathworks.util.Log;

class DoubleBuffer {
    public static final int INCREMENT_MODE = 0;
    public static final int MODULO_INCREMENT_MODE = 1;
    public static final int DOUBLE_MODE = 2;
    public static final int DOUBLING_MODE = 3;
    public static final int QUAD_MODE = 4;
    private double[] fBuf;
    private int fLength;
    private int fIncrement;
    private int fGrowthFactor;
    private int fGrowthMode;
    private static final double NULL_VALUE = 0.0;
    private static final double[] EMPTY_ARRAY = new double[0];
    private final double[] fSingletonArray = new double[1];

    public DoubleBuffer() {
        this(16, 256);
    }

    public DoubleBuffer(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("InitialCapacity (" + n + ") must be > 0");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("Increment (" + n2 + ") must be > 0");
        }
        this.fBuf = new double[n];
        this.fIncrement = n2;
        this.fLength = 0;
    }

    public int length() {
        return this.fLength;
    }

    public void setSize(int n) {
        this.setSize(n, true);
    }

    public void setSize(int n, boolean bl) {
        if (n < 0) {
            throw new IllegalArgumentException("newSize (" + n + ") must be >= 0");
        }
        if (n > this.fLength) {
            this.ensureCapacity(n);
        } else if (bl) {
            for (int i = n; i < this.fBuf.length; ++i) {
                this.fBuf[i] = 0.0;
            }
        }
        this.fLength = n;
    }

    public void ensureCapacity(int n) {
        if (n > this.fBuf.length) {
            int n2;
            if (this.fGrowthFactor > n) {
                n2 = this.fGrowthFactor;
            } else {
                switch (this.fGrowthMode) {
                    case 0: {
                        n2 = this.fBuf.length + this.fIncrement;
                        break;
                    }
                    case 1: {
                        n2 = (n + this.fIncrement - 1) / this.fIncrement * this.fIncrement;
                        break;
                    }
                    case 2: {
                        n2 = this.fBuf.length << 1;
                        if (n2 <= this.fIncrement) break;
                        n2 = (n + this.fIncrement - 1) / this.fIncrement * this.fIncrement;
                        break;
                    }
                    case 3: {
                        for (n2 = this.fBuf.length << 1; n > n2; n2 <<= 1) {
                        }
                        break;
                    }
                    case 4: {
                        n2 = this.fBuf.length << 2;
                        if (n2 <= this.fIncrement) break;
                        n2 = (n + this.fIncrement - 1) / this.fIncrement * this.fIncrement;
                        break;
                    }
                    default: {
                        n2 = 0;
                    }
                }
            }
            if (n > n2) {
                n2 = n + this.fIncrement;
            }
            double[] dArray = this.fBuf;
            this.fBuf = new double[n2];
            System.arraycopy(dArray, 0, this.fBuf, 0, dArray.length);
        }
    }

    public void reduceCapacity(int n) {
        if (n > this.fBuf.length) {
            this.ensureCapacity(n);
        } else {
            double[] dArray = this.fBuf;
            this.fBuf = new double[n];
            System.arraycopy(dArray, 0, this.fBuf, 0, n);
            if (this.fLength > n) {
                this.fLength = n;
            }
        }
    }

    public void setCapacityIncrement(int n) {
        if (n > 0) {
            this.fIncrement = n;
        }
    }

    public void setGrowthFactor(int n) {
        if (n >= 0) {
            this.fGrowthFactor = n;
        }
    }

    public void setGrowthMode(int n) {
        if (n >= 0 && n <= 4) {
            this.fGrowthMode = n;
        }
    }

    public void append(double d) {
        this.insert(this.fLength, d);
    }

    public void append(double[] dArray) {
        this.insert(this.fLength, dArray);
    }

    public synchronized void insert(int n, double d) {
        this.fSingletonArray[0] = d;
        this.replace(n, n, this.fSingletonArray);
        this.fSingletonArray[0] = 0.0;
    }

    public void insert(int n, double[] dArray) {
        this.replace(n, n, dArray);
    }

    public void insertSpace(int n, int n2) {
        this.ensureCapacity(this.fLength + n2);
        System.arraycopy(this.fBuf, n, this.fBuf, n + n2, this.fLength - n);
        for (int i = 0; i < n2; ++i) {
            this.fBuf[n + i] = 0.0;
        }
        this.fLength += n2;
    }

    public void delete(int n, int n2) {
        this.replace(n, n2, EMPTY_ARRAY);
    }

    public void replace(int n, int n2, double d) {
        this.fSingletonArray[0] = d;
        this.replace(n, n2, this.fSingletonArray);
        this.fSingletonArray[0] = 0.0;
    }

    public void replace(int n, int n2, double[] dArray) {
        this.checkRange(n, n2);
        if (dArray == null) {
            throw new IllegalArgumentException();
        }
        int n3 = dArray.length - (n2 - n);
        this.ensureCapacity(this.fLength + n3);
        System.arraycopy(this.fBuf, n2, this.fBuf, n2 + n3, this.fLength - n2);
        System.arraycopy(dArray, 0, this.fBuf, n, dArray.length);
        if (n3 < 0) {
            for (int i = this.fLength + n3; i < this.fLength; ++i) {
                this.fBuf[i] = 0.0;
            }
        }
        this.fLength += n3;
    }

    public double getAt(int n) {
        this.checkIndex(n);
        return this.fBuf[n];
    }

    public void setAt(int n, double d) {
        this.checkIndex(n);
        this.fBuf[n] = d;
    }

    public void copy(int n, int n2, int n3) {
        this.checkRange(n, n + n3);
        this.ensureCapacity(n2 + n3);
        System.arraycopy(this.fBuf, n, this.fBuf, n2, n3);
    }

    public void copyInto(int n, int n2, double[] dArray, int n3) {
        this.checkRange(n, n2);
        System.arraycopy(this.fBuf, n, dArray, n3, n2 - n);
    }

    public double[] getRawBuf() {
        return this.fBuf;
    }

    private void checkRange(int n, int n2) {
        if (Log.LOGGING) {
            if (n > n2) {
                throw new IllegalArgumentException();
            }
            if (n != this.fLength) {
                this.checkHelper(n);
            }
            if (n2 != this.fLength) {
                this.checkHelper(n2);
            }
        }
    }

    private void checkIndex(int n) {
        if (Log.LOGGING) {
            this.checkHelper(n);
        }
    }

    private void checkHelper(int n) {
        if (n < 0 || n >= this.fLength) {
            throw new IllegalArgumentException("Invalid index (" + n + ") should be in the range [0," + this.fLength + "]");
        }
    }
}

