/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.javabuilder.internal;

import com.mathworks.toolbox.javabuilder.internal.MWMCRVersion;
import com.mathworks.toolbox.javabuilder.internal.PlatformInfo;
import java.io.File;

public class MCRConfiguration {
    private static final String SLASH = System.getProperty("file.separator");

    public static boolean isInstalledMCR() {
        return IsInstalledMCR.VALUE;
    }

    public static File getModuleDir() {
        return ModuleDir.VALUE;
    }

    public static File getMCRRoot() {
        return MCRRoot.VALUE;
    }

    public static File getToolboxPrefix() {
        return ToolboxPrefix.VALUE;
    }

    public static File getToolboxMATLABDir() {
        return ToolboxMATLABDir.VALUE;
    }

    public static File getToolboxDeployDir() {
        return ToolboxDeplayDir.VALUE;
    }

    public static String getProxyLibraryDir() {
        return ProxyLibraryDir.VALUE;
    }

    public static String getProxyLibraryName() {
        return ProxyLibraryName.VALUE;
    }

    public static boolean useSystemLoadLibrary() {
        String string = System.getProperty("mathworks.LibraryLoadMethod");
        if (null == string) {
            return PlatformInfo.isWindows();
        }
        return "system".equals(string.toLowerCase());
    }

    private static class ProxyLibraryName {
        static final String VALUE = ProxyLibraryName.get();

        private ProxyLibraryName() {
        }

        private static String get() {
            String string;
            int[] nArray = MWMCRVersion.getMCRVersionNums();
            int n = nArray[0];
            int n2 = nArray[1];
            int n3 = nArray[2];
            String string2 = n3 == 0 ? "" : "_" + Integer.toString(n3);
            String string3 = string = n3 == 0 ? "" : "." + Integer.toString(n3);
            if (PlatformInfo.isWindows()) {
                return "mclmcrrt" + n + "_" + n2 + string2 + ".dll";
            }
            if (PlatformInfo.isMacintosh()) {
                return "libmwmclmcrrt." + n + "." + n2 + string + ".dylib";
            }
            return "libmwmclmcrrt.so." + n + "." + n2 + string;
        }
    }

    private static class ProxyLibraryDir {
        static final String VALUE = ProxyLibraryDir.get();

        private ProxyLibraryDir() {
        }

        private static String get() {
            String string = MCRConfiguration.getProxyLibraryName();
            String string2 = PlatformInfo.isWindows() ? "PATH" : (PlatformInfo.isMacintosh() ? "DYLD_LIBRARY_PATH" : "LD_LIBRARY_PATH");
            for (String string3 : System.getenv(string2).split(File.pathSeparator)) {
                if (!new File(new File(string3), string).exists() || PlatformInfo.isWindows() && !string3.contains(PlatformInfo.getArch())) continue;
                return string3;
            }
            int[] nArray = MWMCRVersion.getMCRVersionNums();
            String string4 = nArray[0] + "." + nArray[1];
            throw new UnsatisfiedLinkError("Failed to find the library " + string + ", required by MATLAB Builder JA, on java.library.path.\n " + "This library is typically installed along with MATLAB or the MCR, its absence " + "may indicate an issue with that installation or the current path configuration.\n" + "The MCR version that this component is trying to use is: " + string4 + ".\n");
        }
    }

    private static class ToolboxDeplayDir {
        static final File VALUE = new File(MCRConfiguration.getToolboxPrefix(), "compiler");

        private ToolboxDeplayDir() {
        }
    }

    private static class ToolboxMATLABDir {
        static final File VALUE = new File(MCRConfiguration.getToolboxPrefix(), "matlab");

        private ToolboxMATLABDir() {
        }
    }

    private static class ToolboxPrefix {
        static final File VALUE = MCRConfiguration.isInstalledMCR() ? new File(MCRConfiguration.getMCRRoot(), "toolbox") : new File(new File(new File(MCRConfiguration.getMCRRoot(), "toolbox"), "compiler"), "mcr");

        private ToolboxPrefix() {
        }
    }

    private static class MCRRoot {
        static final File VALUE = MCRRoot.get();

        private MCRRoot() {
        }

        private static File get() {
            String string = MCRConfiguration.getProxyLibraryDir();
            int n = Math.max(string.lastIndexOf(SLASH + "runtime" + SLASH), string.lastIndexOf(SLASH + "bin" + SLASH));
            return new File(string.substring(0, n));
        }
    }

    private static class ModuleDir {
        static final File VALUE = new File(new File(MCRConfiguration.getMCRRoot(), "bin"), PlatformInfo.getArch());

        private ModuleDir() {
        }
    }

    private static class IsInstalledMCR {
        static final boolean VALUE = IsInstalledMCR.get();

        private IsInstalledMCR() {
        }

        private static boolean get() {
            String string = MCRConfiguration.getProxyLibraryDir();
            File file = new File(string).getParentFile().getParentFile();
            File file2 = new File(file.getAbsolutePath() + SLASH + "toolbox" + SLASH + "compiler" + SLASH + "mcr" + SLASH + "matlab");
            return !file2.exists();
        }
    }
}

