/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri.http;

import com.sun.jini.jeri.internal.http.ConnectionTimer;
import com.sun.jini.jeri.internal.http.HttpServerConnection;
import com.sun.jini.jeri.internal.http.HttpServerManager;
import com.sun.jini.jeri.internal.http.HttpSettings;
import com.sun.jini.jeri.internal.runtime.Util;
import com.sun.jini.logging.Levels;
import com.sun.jini.thread.Executor;
import com.sun.jini.thread.GetThreadPoolAction;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.io.UnsupportedConstraintException;
import net.jini.jeri.Endpoint;
import net.jini.jeri.RequestDispatcher;
import net.jini.jeri.ServerEndpoint;
import net.jini.jeri.http.Constraints;
import net.jini.jeri.http.HttpEndpoint;
import net.jini.security.Security;
import net.jini.security.SecurityContext;

public final class HttpServerEndpoint
implements ServerEndpoint {
    private static final Executor systemThreadPool = (Executor)Security.doPrivileged(new GetThreadPoolAction(false));
    private static final HttpServerManager serverManager;
    private static final ConnectionTimer connTimer;
    private static final Logger logger;
    private final String host;
    private final int port;
    private final SocketFactory sf;
    private final ServerSocketFactory ssf;

    public static HttpServerEndpoint getInstance(int n) {
        return HttpServerEndpoint.getInstance(null, n, null, null);
    }

    public static HttpServerEndpoint getInstance(String string, int n) {
        return HttpServerEndpoint.getInstance(string, n, null, null);
    }

    public static HttpServerEndpoint getInstance(String string, int n, SocketFactory socketFactory, ServerSocketFactory serverSocketFactory) {
        return new HttpServerEndpoint(string, n, socketFactory, serverSocketFactory);
    }

    private HttpServerEndpoint(String string, int n, SocketFactory socketFactory, ServerSocketFactory serverSocketFactory) {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("port number out of range: " + n);
        }
        this.host = string;
        this.port = n;
        this.sf = socketFactory;
        this.ssf = serverSocketFactory;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public SocketFactory getSocketFactory() {
        return this.sf;
    }

    public ServerSocketFactory getServerSocketFactory() {
        return this.ssf;
    }

    public InvocationConstraints checkConstraints(InvocationConstraints invocationConstraints) throws UnsupportedConstraintException {
        return Constraints.check(invocationConstraints, true);
    }

    public Endpoint enumerateListenEndpoints(ServerEndpoint.ListenContext listenContext) throws IOException {
        Object object;
        Object object2;
        if (listenContext == null) {
            throw new NullPointerException();
        }
        String string = this.host;
        if (string == null) {
            try {
                object2 = (InetAddress)Security.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws UnknownHostException {
                        return InetAddress.getLocalHost();
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (UnknownHostException)privilegedActionException.getCause();
            }
            object = System.getSecurityManager();
            if (object != null) {
                try {
                    ((SecurityManager)object).checkConnect(((InetAddress)object2).getHostName(), -1);
                }
                catch (SecurityException securityException) {
                    throw new SecurityException("access to resolve local host denied");
                }
            }
            string = ((InetAddress)object2).getHostAddress();
        }
        if (!((object = listenContext.addListenEndpoint((ServerEndpoint.ListenEndpoint)(object2 = new LE()))) instanceof LE.Cookie)) {
            throw new IllegalArgumentException();
        }
        LE.Cookie cookie = (LE.Cookie)object;
        if (!((LE)object2).equals(cookie.getLE())) {
            throw new IllegalArgumentException();
        }
        return HttpEndpoint.getInstance(string, cookie.getPort(), this.sf);
    }

    public int hashCode() {
        return this.port ^ (this.host != null ? this.host.hashCode() : 0) ^ (this.sf != null ? this.sf.hashCode() : 0) ^ (this.ssf != null ? this.ssf.hashCode() : 0);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof HttpServerEndpoint)) {
            return false;
        }
        HttpServerEndpoint httpServerEndpoint = (HttpServerEndpoint)object;
        return Util.equals(this.host, httpServerEndpoint.host) && this.port == httpServerEndpoint.port && Util.sameClassAndEquals(this.sf, httpServerEndpoint.sf) && Util.sameClassAndEquals(this.ssf, httpServerEndpoint.ssf);
    }

    public String toString() {
        return "HttpServerEndpoint[" + (this.host != null ? this.host + ":" : "") + this.port + (this.ssf != null ? "," + this.ssf : "") + (this.sf != null ? "," + this.sf : "") + "]";
    }

    static {
        HttpSettings httpSettings = HttpEndpoint.getHttpSettings();
        serverManager = new HttpServerManager(httpSettings.getResponseAckTimeout(15000L));
        connTimer = new ConnectionTimer(httpSettings.getServerConnectionTimeout(httpSettings.getConnectionTimeout(15000L) + 10000L));
        logger = Logger.getLogger("net.jini.jeri.http.server");
    }

    private static class LH
    implements ServerEndpoint.ListenHandle {
        private final RequestDispatcher requestDispatcher;
        private final ServerSocket serverSocket;
        private final SecurityContext context;
        private final ServerEndpoint.ListenCookie cookie;
        private long acceptFailureTime = 0L;
        private int acceptFailureCount;
        private final Object lock = new Object();
        private boolean closed = false;
        private final Set conns = new HashSet();

        LH(RequestDispatcher requestDispatcher, ServerSocket serverSocket, SecurityContext securityContext, ServerEndpoint.ListenCookie listenCookie) {
            this.requestDispatcher = requestDispatcher;
            this.serverSocket = serverSocket;
            this.context = securityContext;
            this.cookie = listenCookie;
        }

        void startAccepting() {
            systemThreadPool.execute(new Runnable(){

                public void run() {
                    LH.this.executeAcceptLoop();
                }
            }, this.toString() + " accept loop");
        }

        private void executeAcceptLoop() {
            AccessController.doPrivileged(this.context.wrap(new PrivilegedAction(){

                public Object run() {
                    LH.this.executeAcceptLoop0();
                    return null;
                }
            }), this.context.getAccessControlContext());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void executeAcceptLoop0() {
            while (true) {
                Socket socket = null;
                try {
                    block25: {
                        LogRecord logRecord;
                        block24: {
                            socket = this.serverSocket.accept();
                            if (logger.isLoggable(Level.FINE)) {
                                logger.log(Level.FINE, "accepted socket {0} from server socket {1}", new Object[]{socket, this.serverSocket});
                            }
                            try {
                                socket.setTcpNoDelay(true);
                            }
                            catch (SocketException socketException) {
                                if (!logger.isLoggable(Levels.HANDLED)) break block24;
                                logRecord = new LogRecord(Levels.HANDLED, "exception setting TCP_NODELAY on socket {0}");
                                logRecord.setLoggerName(logger.getName());
                                logRecord.setSourceClassName(this.getClass().getName());
                                logRecord.setSourceMethodName("executeAcceptLoop");
                                logRecord.setParameters(new Object[]{socket});
                                logRecord.setThrown(socketException);
                                logger.log(logRecord);
                            }
                        }
                        try {
                            socket.setKeepAlive(true);
                        }
                        catch (SocketException socketException) {
                            if (!logger.isLoggable(Levels.HANDLED)) break block25;
                            logRecord = new LogRecord(Levels.HANDLED, "exception setting SO_KEEPALIVE on socket {0}");
                            logRecord.setLoggerName(logger.getName());
                            logRecord.setSourceClassName(this.getClass().getName());
                            logRecord.setSourceMethodName("executeAcceptLoop");
                            logRecord.setParameters(new Object[]{socket});
                            logRecord.setThrown(socketException);
                            logger.log(logRecord);
                        }
                    }
                    new Connection(socket);
                    continue;
                }
                catch (Throwable throwable) {
                    boolean bl;
                    Object object = this;
                    synchronized (object) {
                        bl = this.closed;
                    }
                    if (!bl && logger.isLoggable(Level.INFO)) {
                        object = new LogRecord(Level.INFO, "accept loop for {0} throws");
                        ((LogRecord)object).setLoggerName(logger.getName());
                        ((LogRecord)object).setSourceClassName(this.getClass().getName());
                        ((LogRecord)object).setSourceMethodName("executeAcceptLoop");
                        ((LogRecord)object).setParameters(new Object[]{this.serverSocket});
                        ((LogRecord)object).setThrown(throwable);
                        logger.log((LogRecord)object);
                    }
                    if (socket != null) {
                        try {
                            socket.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (bl) return;
                    if (!(throwable instanceof SecurityException)) {
                        try {
                            Object object2 = this.lock;
                            synchronized (object2) {
                                object = this.closed ? null : this.conns.toArray();
                            }
                            if (object != null) {
                                for (int i = 0; i < ((Object)object).length; ++i) {
                                    ((Connection)object[i]).shutdown(false);
                                }
                            }
                        }
                        catch (OutOfMemoryError outOfMemoryError) {
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (!(throwable instanceof IOException) && !(throwable instanceof SecurityException) && !(throwable instanceof RuntimeException) && !(throwable instanceof OutOfMemoryError) && !(throwable instanceof NoClassDefFoundError)) throw (Error)throwable;
                    if (!this.continueAfterAcceptFailure(throwable)) return;
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Iterator iterator = this.lock;
            synchronized (iterator) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
            }
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "closed server socket {0}", new Object[]{this.serverSocket});
            }
            iterator = this.conns.iterator();
            while (iterator.hasNext()) {
                ((Connection)iterator.next()).shutdown(true);
            }
        }

        public ServerEndpoint.ListenCookie getCookie() {
            return this.cookie;
        }

        public String toString() {
            return "HttpServerEndpoint.LH[" + this.serverSocket + "]";
        }

        private boolean continueAfterAcceptFailure(Throwable throwable) {
            long l = System.currentTimeMillis();
            if (this.acceptFailureTime == 0L || l - this.acceptFailureTime > 5000L) {
                this.acceptFailureTime = l;
                this.acceptFailureCount = 0;
            } else {
                ++this.acceptFailureCount;
                if (this.acceptFailureCount >= 10) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            return true;
        }

        private class Connection
        extends HttpServerConnection {
            private final Socket socket;
            private final Object connLock;
            private boolean connClosed;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            Connection(Socket socket) throws IOException {
                super(socket, LH.this.requestDispatcher, serverManager);
                this.connLock = new Object();
                this.socket = socket;
                boolean bl = false;
                Object object = LH.this.lock;
                synchronized (object) {
                    if (LH.this.closed) {
                        bl = true;
                    } else {
                        LH.this.conns.add(this);
                    }
                }
                if (bl) {
                    this.shutdown(true);
                } else {
                    this.start();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean shutdown(boolean bl) {
                Object object = this.connLock;
                synchronized (object) {
                    if (this.connClosed) {
                        return true;
                    }
                    this.connClosed = super.shutdown(bl);
                    if (!this.connClosed) {
                        return false;
                    }
                }
                connTimer.cancelTimeout(this);
                object = LH.this.lock;
                synchronized (object) {
                    if (!LH.this.closed) {
                        LH.this.conns.remove(this);
                    }
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "shut down connection on socket {0}", new Object[]{this.socket});
                }
                return true;
            }

            protected void checkPermissions() {
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    securityManager.checkAccept(this.socket.getInetAddress().getHostAddress(), this.socket.getPort());
                }
            }

            protected InvocationConstraints checkConstraints(InvocationConstraints invocationConstraints) throws UnsupportedConstraintException {
                return Constraints.check(invocationConstraints, true);
            }

            protected void populateContext(Collection collection) {
                Util.populateContext(collection, this.socket.getInetAddress());
            }

            protected void idle() {
                connTimer.scheduleTimeout(this, false);
            }

            protected void busy() {
                connTimer.cancelTimeout(this);
            }
        }
    }

    private class LE
    implements ServerEndpoint.ListenEndpoint {
        LE() {
        }

        public void checkPermissions() {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkListen(HttpServerEndpoint.this.port);
            }
        }

        public ServerEndpoint.ListenHandle listen(RequestDispatcher requestDispatcher) throws IOException {
            if (requestDispatcher == null) {
                throw new NullPointerException();
            }
            ServerSocket serverSocket = HttpServerEndpoint.this.ssf != null ? HttpServerEndpoint.this.ssf.createServerSocket(HttpServerEndpoint.this.port) : new ServerSocket(HttpServerEndpoint.this.port);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "created server socket {0}" + (HttpServerEndpoint.this.ssf != null ? " using factory {1}" : ""), new Object[]{serverSocket, HttpServerEndpoint.this.ssf});
            }
            Cookie cookie = new Cookie(serverSocket.getLocalPort());
            LH lH = new LH(requestDispatcher, serverSocket, Security.getContext(), cookie);
            lH.startAccepting();
            return lH;
        }

        private int getPort() {
            return HttpServerEndpoint.this.port;
        }

        private ServerSocketFactory getSSF() {
            return HttpServerEndpoint.this.ssf;
        }

        public int hashCode() {
            return HttpServerEndpoint.this.port ^ (HttpServerEndpoint.this.ssf != null ? HttpServerEndpoint.this.ssf.hashCode() : 0);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof LE)) {
                return false;
            }
            LE lE = (LE)object;
            return HttpServerEndpoint.this.port == lE.getPort() && Util.sameClassAndEquals(HttpServerEndpoint.this.ssf, lE.getSSF());
        }

        public String toString() {
            return "HttpServerEndpoint.LE[" + HttpServerEndpoint.this.port + (HttpServerEndpoint.this.ssf != null ? "," + HttpServerEndpoint.this.ssf : "") + "]";
        }

        private class Cookie
        implements ServerEndpoint.ListenCookie {
            private final int port;

            Cookie(int n) {
                this.port = n;
            }

            LE getLE() {
                return LE.this;
            }

            int getPort() {
                return this.port;
            }

            public String toString() {
                return "HttpServerEndpoint.LE.Cookie[" + this.port + "]";
            }
        }
    }
}

