/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.discovery;

import com.sun.jini.discovery.DiscoveryProtocolVersion;
import com.sun.jini.discovery.MulticastMaxPacketSize;
import com.sun.jini.discovery.MulticastTimeToLive;
import com.sun.jini.discovery.UnicastSocketTimeout;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.jini.core.constraint.ConstraintAlternatives;
import net.jini.core.constraint.InvocationConstraint;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.io.UnsupportedConstraintException;

public class DiscoveryConstraints {
    public static final Method multicastRequestMethod;
    public static final Method multicastAnnouncementMethod;
    public static final Method unicastDiscoveryMethod;
    private static final Set supportedProtocols;
    private final InvocationConstraints unfulfilled;
    private final Set protocolVersions;
    private final int preferredProtocolVersion;
    private final MulticastMaxPacketSize maxPacketSize;
    private final MulticastTimeToLive timeToLive;
    private final UnicastSocketTimeout socketTimeout;
    static /* synthetic */ Class class$com$sun$jini$discovery$MulticastMaxPacketSize;

    public static void multicastRequest() {
    }

    public static void multicastAnnouncement() {
    }

    public static void unicastDiscovery() {
    }

    public static DiscoveryConstraints process(InvocationConstraints invocationConstraints) throws UnsupportedConstraintException {
        return new DiscoveryConstraints(invocationConstraints);
    }

    private DiscoveryConstraints(InvocationConstraints invocationConstraints) throws UnsupportedConstraintException {
        this.unfulfilled = new InvocationConstraints(DiscoveryConstraints.getUnfulfilled(invocationConstraints.requirements()), DiscoveryConstraints.getUnfulfilled(invocationConstraints.preferences()));
        ConstraintReducer constraintReducer = new ConstraintReducer(DiscoveryProtocolVersion.class);
        this.protocolVersions = constraintReducer.reduce(new InvocationConstraints(invocationConstraints.requirements(), null));
        if (!this.protocolVersions.isEmpty() && DiscoveryConstraints.intersect(this.protocolVersions, supportedProtocols).isEmpty()) {
            throw new UnsupportedConstraintException("no supported protocols: " + this.protocolVersions);
        }
        this.preferredProtocolVersion = DiscoveryConstraints.chooseProtocolVersion(this.protocolVersions, constraintReducer.reduce(invocationConstraints), this.unfulfilled);
        Set set = new MulticastMaxPacketSizeReducer().reduce(invocationConstraints);
        this.maxPacketSize = set.isEmpty() ? null : (MulticastMaxPacketSize)DiscoveryConstraints.getElement(set);
        set = new ConstraintReducer(MulticastTimeToLive.class).reduce(invocationConstraints);
        this.timeToLive = set.isEmpty() ? null : (MulticastTimeToLive)DiscoveryConstraints.getElement(set);
        set = new ConstraintReducer(UnicastSocketTimeout.class).reduce(invocationConstraints);
        this.socketTimeout = set.isEmpty() ? null : (UnicastSocketTimeout)DiscoveryConstraints.getElement(set);
    }

    public int chooseProtocolVersion() {
        return this.preferredProtocolVersion;
    }

    public void checkProtocolVersion(int n) throws UnsupportedConstraintException {
        if (!this.protocolVersions.isEmpty() && !this.protocolVersions.contains(DiscoveryProtocolVersion.getInstance(n))) {
            throw new UnsupportedConstraintException("disallowed protocol: " + n);
        }
    }

    public int getMulticastMaxPacketSize(int n) {
        return this.maxPacketSize != null ? this.maxPacketSize.getSize() : n;
    }

    public int getMulticastTimeToLive(int n) {
        return this.timeToLive != null ? this.timeToLive.getTimeToLive() : n;
    }

    public int getUnicastSocketTimeout(int n) {
        return this.socketTimeout != null ? this.socketTimeout.getTimeout() : n;
    }

    public InvocationConstraints getUnfulfilledConstraints() {
        return this.unfulfilled;
    }

    private static Set getUnfulfilled(Set set) {
        HashSet<InvocationConstraint> hashSet = new HashSet<InvocationConstraint>(set.size());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            InvocationConstraint invocationConstraint = (InvocationConstraint)iterator.next();
            if (invocationConstraint instanceof ConstraintAlternatives) {
                Set set2 = ((ConstraintAlternatives)invocationConstraint).elements();
                Set set3 = DiscoveryConstraints.getUnfulfilled(set2);
                if (set3.size() != set2.size()) continue;
                hashSet.add(invocationConstraint);
                continue;
            }
            if (invocationConstraint instanceof DiscoveryProtocolVersion || invocationConstraint instanceof MulticastMaxPacketSize || invocationConstraint instanceof MulticastTimeToLive || invocationConstraint instanceof UnicastSocketTimeout) continue;
            hashSet.add(invocationConstraint);
        }
        return hashSet;
    }

    private static int chooseProtocolVersion(Set set, Set set2, InvocationConstraints invocationConstraints) {
        DiscoveryProtocolVersion discoveryProtocolVersion = invocationConstraints.isEmpty() ? DiscoveryProtocolVersion.ONE : DiscoveryProtocolVersion.TWO;
        Set[] setArray = new Set[]{set2, set};
        for (int i = 0; i < setArray.length; ++i) {
            Set set3 = setArray[i];
            if (set3.contains(discoveryProtocolVersion)) {
                return discoveryProtocolVersion.getVersion();
            }
            if ((set3 = DiscoveryConstraints.intersect(set3, supportedProtocols)).isEmpty()) continue;
            return ((DiscoveryProtocolVersion)DiscoveryConstraints.getElement(set3)).getVersion();
        }
        return discoveryProtocolVersion.getVersion();
    }

    private static Set intersect(Set set, Set set2) {
        HashSet hashSet = Collections.EMPTY_SET;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!set2.contains(e)) continue;
            if (hashSet.isEmpty()) {
                hashSet = new HashSet();
            }
            hashSet.add(e);
        }
        return hashSet;
    }

    private static Object getElement(Set set) {
        return set.iterator().next();
    }

    static {
        try {
            multicastRequestMethod = DiscoveryConstraints.class.getMethod("multicastRequest", null);
            multicastAnnouncementMethod = DiscoveryConstraints.class.getMethod("multicastAnnouncement", null);
            unicastDiscoveryMethod = DiscoveryConstraints.class.getMethod("unicastDiscovery", null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)noSuchMethodException);
        }
        supportedProtocols = new HashSet(2);
        supportedProtocols.add(DiscoveryProtocolVersion.ONE);
        supportedProtocols.add(DiscoveryProtocolVersion.TWO);
    }

    private static class MulticastMaxPacketSizeReducer
    extends ConstraintReducer {
        MulticastMaxPacketSizeReducer() {
            super(class$com$sun$jini$discovery$MulticastMaxPacketSize == null ? (class$com$sun$jini$discovery$MulticastMaxPacketSize = DiscoveryConstraints.class$("com.sun.jini.discovery.MulticastMaxPacketSize")) : class$com$sun$jini$discovery$MulticastMaxPacketSize);
        }

        Set reduce0(Set set, Set set2) {
            int n = 0;
            Iterator iterator = set2.iterator();
            while (iterator.hasNext()) {
                n = Math.max(n, ((MulticastMaxPacketSize)iterator.next()).getSize());
            }
            if (set != null) {
                n = Math.min(n, ((MulticastMaxPacketSize)DiscoveryConstraints.getElement(set)).getSize());
            }
            return Collections.singleton(new MulticastMaxPacketSize(n));
        }
    }

    private static class ConstraintReducer {
        private final Class targetClass;

        ConstraintReducer(Class clazz) {
            this.targetClass = clazz;
        }

        Set reduce(InvocationConstraints invocationConstraints) throws UnsupportedConstraintException {
            Set set = this.reduce(null, invocationConstraints.requirements(), true);
            return (set = this.reduce(set, invocationConstraints.preferences(), false)) != null ? set : Collections.EMPTY_SET;
        }

        Set reduce0(Set set, Set set2) {
            return set != null ? DiscoveryConstraints.intersect(set, set2) : set2;
        }

        private Set reduce(Set set, Set set2, boolean bl) throws UnsupportedConstraintException {
            Iterator iterator = set2.iterator();
            while (iterator.hasNext()) {
                InvocationConstraint invocationConstraint = (InvocationConstraint)iterator.next();
                Set set3 = Collections.EMPTY_SET;
                if (this.targetClass.isInstance(invocationConstraint)) {
                    set3 = Collections.singleton(invocationConstraint);
                } else if (invocationConstraint instanceof ConstraintAlternatives) {
                    set3 = this.getTargetInstances(((ConstraintAlternatives)invocationConstraint).elements());
                }
                if (set3.isEmpty()) continue;
                Set set4 = this.reduce0(set, set3);
                if (!set4.isEmpty()) {
                    set = set4;
                    continue;
                }
                if (!bl) continue;
                throw new UnsupportedConstraintException("constraints conflict: " + set2);
            }
            return set;
        }

        private Set getTargetInstances(Set set) {
            HashSet hashSet = Collections.EMPTY_SET;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!this.targetClass.isInstance(e)) continue;
                if (hashSet.isEmpty()) {
                    hashSet = new HashSet();
                }
                hashSet.add(e);
            }
            return hashSet;
        }
    }
}

