/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instutil.services;

import com.mathworks.instutil.services.AwsActivationServiceThread;
import com.mathworks.instutil.services.ServiceThreadState;
import com.mathworks.instutil.services.ServiceThreadView;
import com.mathworks.internal.mwaws.client.v5.ArrayOfMWAEntitlement;
import com.mathworks.internal.mwaws.client.v5.ArrayOfMWMessage;
import com.mathworks.internal.mwaws.client.v5.MWAEntitlement;
import com.mathworks.internal.mwaws.client.v5.MWAGetEntitlementsResponse;
import com.mathworks.internal.mwaws.client.v5.MWAResponse;
import com.mathworks.internal.mwaws.client.v5.MWMessage;
import com.mathworks.mlwebservices.ActivationService;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

class EntitlementListRetrievalThread
extends AwsActivationServiceThread<MWAEntitlement[]> {
    private MWAEntitlement[] entitlements;
    private final String token;
    private final Lock lock = new ReentrantLock();

    EntitlementListRetrievalThread(ServiceThreadView serviceThreadView, ActivationService activationService, String string) {
        super(serviceThreadView, activationService, "dialog.title", "dialog.license");
        this.token = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block21: {
            ActivationService activationService = this.getActivationService();
            String string = this.getClientString();
            try {
                MWMessage[] mWMessageArray;
                MWAGetEntitlementsResponse mWAGetEntitlementsResponse = activationService.getEntitlements(this.token, string);
                ServiceThreadState serviceThreadState = this.processResponse((MWAResponse)mWAGetEntitlementsResponse);
                this.setStatus(serviceThreadState);
                if (this.getStatus() == ServiceThreadState.SUCCESS) {
                    this.lock.lock();
                    try {
                        ArrayOfMWAEntitlement arrayOfMWAEntitlement = mWAGetEntitlementsResponse.getEntitlements();
                        if (arrayOfMWAEntitlement != null) {
                            this.entitlements = arrayOfMWAEntitlement.getEntitlement();
                        }
                        break block21;
                    }
                    finally {
                        this.lock.unlock();
                    }
                }
                ArrayOfMWMessage arrayOfMWMessage = mWAGetEntitlementsResponse.getMessages();
                if (arrayOfMWMessage != null && (mWMessageArray = arrayOfMWMessage.getMessage()) != null) {
                    for (MWMessage mWMessage : mWMessageArray) {
                        if (mWMessage.getCode() != 676) continue;
                        this.setStatus(ServiceThreadState.SUCCESS);
                    }
                }
            }
            catch (Throwable throwable) {
                this.handleThrowable(throwable);
            }
            finally {
                if (this.isCancelled()) {
                    this.lock.lock();
                    try {
                        this.entitlements = null;
                    }
                    finally {
                        this.lock.unlock();
                    }
                } else {
                    this.finish();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MWAEntitlement[] getResult() {
        MWAEntitlement[] mWAEntitlementArray;
        this.lock.lock();
        try {
            mWAEntitlementArray = this.entitlements;
        }
        finally {
            this.lock.unlock();
        }
        return mWAEntitlementArray;
    }
}

