/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.instrcreate;

import com.mathworks.mlwidgets.inspector.PropertyView;
import com.mathworks.services.ObjectRegistry;
import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.toolbox.instrument.InstrumentObjectListener;
import com.mathworks.toolbox.instrument.objectbrowser.InstrumentObjectBrowserClient;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class PropertyPanel
extends JPanel
implements InstrumentObjectListener {
    private static final long serialVersionUID = 1L;
    private ObjectRegistry registry = new ObjectRegistry();
    private PropertyView view;
    private Instrument selectedObject;

    public PropertyPanel(Instrument instrument) {
        this.setLayout(new BorderLayout(0, 0));
        this.layoutPanel();
        Vector<Instrument> vector = Instrument.getNonLockedObjects();
        if (vector != null && vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                this.instrumentObjectAdded(vector.elementAt(i), "", "");
            }
            this.selectedObjectUpdated(vector.elementAt(vector.size() - 1), null);
            this.update();
        }
        Instrument.addInstrumentObjectListener(this);
        this.update();
    }

    public void cleanup() {
        Instrument.removeInstrumentObjectListener(this);
    }

    public void setup() {
        Instrument instrument;
        int n;
        Instrument.addInstrumentObjectListener(this);
        Vector vector = this.registry.getTopLevelObjects();
        Vector<Instrument> vector2 = Instrument.getNonLockedObjects();
        for (n = 0; n < vector2.size(); ++n) {
            instrument = vector2.elementAt(n);
            if (vector.contains(instrument)) continue;
            this.instrumentObjectAdded(instrument, instrument.getType(), instrument.getName());
        }
        for (n = 0; n < vector.size(); ++n) {
            instrument = (Instrument)vector.elementAt(n);
            if (instrument.isvalid() && instrument.getObjectVisibility()) continue;
            this.instrumentObjectDeleted(instrument, instrument.getType(), instrument.getName());
        }
    }

    private void layoutPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(6, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 6, 10, 6));
        this.add((Component)jPanel, "Center");
        this.view = new PropertyView(this.registry);
        jPanel.add((Component)this.view, "Center");
    }

    public void selectedObjectUpdated(Instrument instrument, InstrumentObjectBrowserClient instrumentObjectBrowserClient) {
        Object[] objectArray = new Object[1];
        if (instrument != null) {
            this.selectedObject = instrument;
            objectArray[0] = this.selectedObject;
            this.registry.setSelected(objectArray, true);
        } else {
            objectArray[0] = this.selectedObject;
            this.registry.setSelected(objectArray, false);
            this.repaint();
            this.validate();
        }
    }

    public void objectVisibilityUpdated(Instrument instrument, InstrumentObjectBrowserClient instrumentObjectBrowserClient) {
        this.registry.register((Object)instrument, null);
    }

    @Override
    public void instrumentObjectAdded(Instrument instrument, String string, String string2) {
        this.registry.register((Object)instrument, null);
    }

    @Override
    public void instrumentObjectDeleted(Instrument instrument, String string, String string2) {
        this.registry.unregister((Object)instrument);
        if (this.registry.isSelected((Object)instrument)) {
            Object[] objectArray = new Object[]{instrument};
            this.registry.setSelected(objectArray, false);
        }
        this.repaint();
        this.validate();
    }

    protected void update() {
        this.view.triggerRefresh();
    }
}

