/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.guiutil.midtest;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabEvent;
import com.mathworks.jmi.MatlabListener;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.toolbox.instrument.device.drivers.xml.Parser;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.CodeGenerator;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.MIDGlassPane;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.MIDTestExecuter;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.MIDTestExporter;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.MIDTestTool;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.MIDTestToolFileReader;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.MIDTestToolFileWriter;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.SaveTestWithDriverDialog;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.TestOptionsDialog;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.panel.FunctionInfo;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.panel.FunctionSweepInfo;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.panel.PropertyInfo;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.panel.PropertySweepInfo;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.panel.SetupPanel;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.panel.StepInfo;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.panel.StepPanel;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverFileReader;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverFileWriter;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverFunction;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverModel;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.MIDTool;
import com.mathworks.toolbox.instrument.guiutil.ICSaveDialog;
import com.mathworks.toolbox.instrument.guiutil.ToolboxHelpRunnable;
import com.mathworks.toolbox.testmeas.browser.BaseBrowserClient;
import com.mathworks.toolbox.testmeas.browser.BrowserClient;
import com.mathworks.toolbox.testmeas.browser.BrowserConfigFileReader;
import com.mathworks.toolbox.testmeas.browser.BrowserConfigFileWriter;
import com.mathworks.toolbox.testmeas.browser.BrowserTreeNode;
import com.mathworks.toolbox.testmeas.browser.TreeViewEditorListener;
import com.mathworks.toolbox.testmeas.guiutil.AboutWindow;
import com.mathworks.toolbox.testmeas.guiutil.TMFileDialog;
import com.mathworks.toolbox.testmeas.util.TMException;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MIDTestToolClient
extends BaseBrowserClient
implements MatlabListener,
BrowserClient,
ActionListener,
WindowListener,
TreeViewEditorListener,
Runnable {
    public static ImageIcon startImage = new ImageIcon(MIDTestTool.class.getResource("/com/mathworks/toolbox/instrument/device/guiutil/midtest/resources/start.gif"));
    public static ImageIcon stopImage = new ImageIcon(MIDTestTool.class.getResource("/com/mathworks/toolbox/instrument/device/guiutil/midtest/resources/stop.gif"));
    public static ImageIcon propImage = new ImageIcon(MIDTestTool.class.getResource("/com/mathworks/toolbox/instrument/device/guiutil/midtest/resources/properties.gif"));
    public static ImageIcon fcnImage = new ImageIcon(MIDTestTool.class.getResource("/com/mathworks/toolbox/instrument/device/guiutil/midtest/resources/functions.gif"));
    public static ImageIcon sweepImage = new ImageIcon(MIDTestTool.class.getResource("/com/mathworks/toolbox/instrument/device/guiutil/midtest/resources/propertysweep.gif"));
    public static ImageIcon optionsImage = new ImageIcon(MIDTestTool.class.getResource("/com/mathworks/toolbox/instrument/device/guiutil/midtest/resources/preferences.gif"));
    public static ImageIcon upImage = new ImageIcon(MIDTestTool.class.getResource("/com/mathworks/toolbox/instrument/device/guiutil/midtest/resources/move_up.gif"));
    public static ImageIcon downImage = new ImageIcon(MIDTestTool.class.getResource("/com/mathworks/toolbox/instrument/device/guiutil/midtest/resources/move_down.gif"));
    public static ImageIcon deleteImage = new ImageIcon(MIDTestTool.class.getResource("/com/mathworks/toolbox/instrument/device/guiutil/midtest/resources/delete.gif"));
    public static final String ACTION = "ACTION";
    public static final int ICHELP = 0;
    public static final int ICABOUT = 1;
    public static final int CLOSE = 2;
    public static final int RUN_THIS_STEP = 3;
    public static final int RUN_FROM_HERE = 4;
    public static final int TEST_OPTIONS = 5;
    public static final int START_TEST = 6;
    public static final int STOP_TEST = 7;
    public static final int EDIT_DRIVER = 8;
    public static final int DELETE_NODE = 9;
    public static final int RENAME_NODE = 10;
    public static final int DUPLICATE_NODE = 11;
    public static final int SAVE = 12;
    public static final int SAVE_AS = 13;
    public static final int OPEN = 14;
    public static final int NEW = 15;
    public static final int OPEN_FILENAME = 16;
    public static final int SAVE_AS_MCODE = 17;
    public static final int EXPORT = 18;
    public static final int PRINT_RESULTS = 19;
    public static final int SAVE_RESULTS = 20;
    public static final int SAVE_WITH_DRIVER = 21;
    public static final int UP = 22;
    public static final int DOWN = 23;
    public static final int DELETE = 24;
    public static final int RUN_THIS_STEP_RC = 25;
    public static final int RUN_FROM_HERE_RC = 26;
    public static CodeGenerator codeGenerator = null;
    public static final int RUN_ALL = 0;
    public static final int RUN_CURRENT = 1;
    public static final int CONTINUE = 0;
    public static final int RESET = 1;
    public static final int STOP = 2;
    public static final int STOP_RESET = 3;
    public static final int PROPERTY_SWEEP = 0;
    public static final int PROPERTY_SET = 1;
    public static final int PROPERTY_GET = 2;
    public static final int FUNCTION = 3;
    public static final int FUNCTION_SWEEP = 4;
    public static final int ROOT = 5;
    public static final String[] STEP_NAMES = new String[]{"Properties Sweep", "Set Property", "Get Property", "Function", "Function Sweep"};
    public static final String[] SAVE_NAMES = new String[]{"PropertySweep", "SetProperty", "GetProperty", "Function", "FunctionSweep"};
    public static final ImageIcon[] STEP_ICONS = new ImageIcon[]{sweepImage, propImage, propImage, fcnImage, sweepImage};
    public static final String[] HELP_NAMES = new String[]{"_sweep.html", "_setproperty.html", "_getproperty.html", "_function.html", "_starting.html"};
    protected String driverName = "";
    protected long driverLastModified = 0L;
    protected Parser parser = null;
    private BrowserTreeNode rootNode;
    private BrowserTreeNode selectedNode = this.rootNode = new BrowserTreeNode("Unnamed test", (BrowserClient)this);
    private BrowserTreeNode rightClickNode = null;
    private MIDTestTool midTester;
    private int runMode = 0;
    private int failAction = 0;
    private String noErrorMessage = "+0,\"No error\"";
    private String numDoubleValues = "4";
    private JMenuItem saveMenuItem;
    private JMenuItem saveAsMCodeItem;
    private JMenuItem saveResultsWithDriverItem;
    private JMenuItem editMenuItem;
    private JMenuItem startMenuItem;
    private JMenuItem stopMenuItem;
    private JMenuItem exportMenuItem;
    private JMenuItem saveResultsMenuItem;
    private JMenuItem printResultsMenuItem;
    private MJButton startToolbarButton;
    private MJButton stopToolbarButton;
    private MJButton optionsToolbarButton;
    private MJButton upToolbarButton;
    private MJButton downToolbarButton;
    private MJButton deleteToolbarButton;
    private StepPanel stepPanel;
    private SetupPanel setupPanel;
    private JMenuItem runThisStepOnly = new JMenuItem("Run this step only");
    private JMenuItem runFromHere = new JMenuItem("Run test starting from this step");
    private JMenuItem renameNode = new JMenuItem("Rename");
    private JMenuItem duplicateNode = new JMenuItem("Duplicate");
    private JMenuItem deleteNode = new JMenuItem("Delete");
    private String fileNameWithPath = "";
    private String fileName = "";
    private Vector<String> recentFileNames = new Vector();
    private int numOfFileNamesToKeep = 4;
    private int numOfMenusInserted = 0;
    private Vector<JMenuItem> recentFileNameMenus = new Vector();
    private boolean needToSave = false;
    private static boolean needToClose = false;
    private static boolean isRunning = false;
    private MIDTestExecuter testExecuter = new MIDTestExecuter(this);
    private Vector<Object> testResultInfo = new Vector();
    private Vector<Object> variables = new Vector();
    private MIDGlassPane glassPane = null;
    private SaveTestWithDriverDialog saveTestWithDriverDialog = null;
    private boolean errorParsingDriver = false;
    private ToolboxHelpRunnable toolboxHelpRunnable = null;
    private CleanupRunnable cleanupRunnable = null;
    private int propSetCount = 0;

    public void init() {
        this.setupPanel = new SetupPanel(this, this.rootNode);
        this.rootNode.setPanel((JPanel)this.setupPanel);
        this.rootNode.setType(5);
        this.rootNode.setEditable(true);
        this.rootNode.setHelpDirectoryAndPage("instrument", "midtest_csh\\_starting.html");
        this.stepPanel = new StepPanel(this);
        this.initRightClickMenuItems();
        for (int i = 0; i < this.numOfFileNamesToKeep; ++i) {
            JMenuItem jMenuItem = new JMenuItem();
            jMenuItem.putClientProperty(ACTION, new Integer(16));
            this.recentFileNameMenus.addElement(jMenuItem);
        }
        Matlab.addListener((MatlabListener)this);
    }

    public void cleanup() {
        this.getBrowserFrame().removeWindowListener((WindowListener)this);
    }

    public BrowserTreeNode getRootNode() {
        return null;
    }

    public BrowserTreeNode[] getLevelOneNodes() {
        return null;
    }

    public void setMIDTester(MIDTestTool mIDTestTool) {
        this.midTester = mIDTestTool;
    }

    public BrowserTreeNode getSelectedNode() {
        return this.selectedNode;
    }

    public JPanel getPanel(BrowserTreeNode browserTreeNode, BrowserTreeNode browserTreeNode2, BrowserTreeNode[] browserTreeNodeArray) {
        if (browserTreeNode2 != null && browserTreeNode2.equals(browserTreeNode)) {
            browserTreeNode.updatePanel(false);
            this.midTester.showSettingsTab();
            return null;
        }
        if (browserTreeNode2 != null && browserTreeNode2.getType() != 5 && browserTreeNode.getType() != 5) {
            browserTreeNode.updatePanel(false);
        } else {
            browserTreeNode.updatePanel(true);
        }
        if (browserTreeNode2 != null && browserTreeNode2.getPanel() instanceof StepPanel) {
            ((StepPanel)browserTreeNode2.getPanel()).cleanup(browserTreeNode2);
        }
        if (browserTreeNode.getPanel() instanceof StepPanel) {
            ((StepPanel)browserTreeNode.getPanel()).update(browserTreeNode);
        }
        this.selectedNode = browserTreeNode;
        try {
            this.nodeSelected(browserTreeNode);
            this.midTester.setBrowserDecorationText(this.getBrowserDecorationLabel(browserTreeNode), browserTreeNode.getIcon());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return browserTreeNode.getPanel();
    }

    public void reClickOnNode(BrowserTreeNode browserTreeNode) {
        this.getPanel(browserTreeNode, browserTreeNode, null);
    }

    public void nodeSelected(BrowserTreeNode browserTreeNode) {
        this.midTester.showSettingsTab();
        this.postStatusBarUpdateEvent("");
        if (browserTreeNode.getType() == 5) {
            this.upToolbarButton.setEnabled(false);
            this.downToolbarButton.setEnabled(false);
            this.deleteToolbarButton.setEnabled(false);
            return;
        }
        this.upToolbarButton.setEnabled(true);
        this.downToolbarButton.setEnabled(true);
        this.deleteToolbarButton.setEnabled(true);
        int[] nArray = this.midTester.getTreeSelectionRows();
        if (nArray == null) {
            return;
        }
        int n = nArray[0];
        if (n == 1) {
            this.upToolbarButton.setEnabled(false);
        }
        if (n == this.midTester.getTreeRowCount() - 1) {
            this.downToolbarButton.setEnabled(false);
        }
    }

    public String getBrowserDecorationLabel(BrowserTreeNode browserTreeNode) {
        if (browserTreeNode.getType() == 5) {
            return browserTreeNode.getName();
        }
        return browserTreeNode.getName() + " (" + STEP_NAMES[browserTreeNode.getType()] + " Test Step)";
    }

    protected BrowserTreeNode addStep(int n) {
        return this.addStep(n, true, this.rootNode.getChildCount() + 1);
    }

    protected BrowserTreeNode addStep(int n, int n2) {
        return this.addStep(n, true, n2);
    }

    protected BrowserTreeNode addStep(int n, boolean bl) {
        return this.addStep(n, bl, this.rootNode.getChildCount() + 1);
    }

    protected BrowserTreeNode addStep(int n, boolean bl, int n2) {
        String string = STEP_NAMES[n];
        if (string.equals("Set Property") && this.propSetCount == 0) {
            this.postStatusBarUpdateEvent("Driver has no properties that can be set");
            return null;
        }
        this.postStatusBarUpdateEvent("");
        BrowserTreeNode browserTreeNode = new BrowserTreeNode(string, (BrowserClient)this);
        browserTreeNode.setType(n);
        browserTreeNode.setIcon(STEP_ICONS[n]);
        browserTreeNode.setPanel((JPanel)this.stepPanel);
        browserTreeNode.setUserData((Object)this.createUserData(n));
        browserTreeNode.setEditable(true);
        browserTreeNode.setHelpDirectoryAndPage("instrument", "midtest_csh\\" + HELP_NAMES[n]);
        this.postNodeAddedEvent(this.rootNode, browserTreeNode, bl, n2);
        this.stepPanel.cleanupLowerPanel(browserTreeNode);
        this.needToSave = true;
        return browserTreeNode;
    }

    protected void duplicateStep(BrowserTreeNode browserTreeNode) {
        BrowserTreeNode browserTreeNode2 = this.addStep(browserTreeNode.getType(), false);
        this.stepPanel.duplicateNode(browserTreeNode2, browserTreeNode);
        this.postNodeSelectedEvent(browserTreeNode);
    }

    protected void moveStep(BrowserTreeNode browserTreeNode, int n) {
        this.postNodeRemovedEvent(this.rootNode, browserTreeNode);
        this.postNodeAddedEvent(this.rootNode, browserTreeNode, true, n);
    }

    protected StepInfo createUserData(int n) {
        switch (n) {
            case 0: {
                return new PropertySweepInfo();
            }
            case 1: {
                return new PropertyInfo(STEP_NAMES[1]);
            }
            case 2: {
                return new PropertyInfo(STEP_NAMES[2]);
            }
            case 3: {
                return new FunctionInfo();
            }
            case 4: {
                return new FunctionSweepInfo();
            }
        }
        return null;
    }

    protected void moveStepUp(BrowserTreeNode browserTreeNode, int n) {
        this.postNodeRemovedEvent(this.rootNode, browserTreeNode);
        this.postNodeAddedEvent(this.rootNode, browserTreeNode, true, n - 1);
        this.needToSave = true;
    }

    protected void moveStepDown(BrowserTreeNode browserTreeNode, int n) {
        this.postNodeRemovedEvent(this.rootNode, browserTreeNode);
        this.postNodeAddedEvent(this.rootNode, browserTreeNode, true, n + 1);
        this.needToSave = true;
    }

    protected void removeStep(BrowserTreeNode browserTreeNode) {
        BrowserTreeNode browserTreeNode2 = (BrowserTreeNode)this.rootNode.getChildBefore((TreeNode)browserTreeNode);
        this.postNodeRemovedEvent(this.rootNode, browserTreeNode);
        if (browserTreeNode2 != null) {
            this.postNodeSelectedEvent(browserTreeNode2);
        } else {
            this.postNodeSelectedEvent(this.rootNode);
        }
        this.needToSave = true;
    }

    public void updateNodeName(BrowserTreeNode browserTreeNode, String string) {
        browserTreeNode.setName(string);
        this.postNodeUpdatedEvent(browserTreeNode);
        this.midTester.setBrowserDecorationText(this.getBrowserDecorationLabel(browserTreeNode), browserTreeNode.getIcon());
    }

    public String getToolTipString(BrowserTreeNode browserTreeNode) {
        return null;
    }

    public void createEmptyTest(String string) {
        this.setupPanel.updateNameField(string);
        this.updateNodeName(this.rootNode, string);
        this.setupPanel.resetDirtyFlag();
    }

    public boolean defineRightClickMenuItems(BrowserTreeNode browserTreeNode, JPopupMenu jPopupMenu) {
        this.rightClickNode = browserTreeNode;
        switch (browserTreeNode.getType()) {
            case 5: {
                jPopupMenu.add(this.renameNode);
                return true;
            }
        }
        jPopupMenu.add(this.runThisStepOnly);
        jPopupMenu.add(this.runFromHere);
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.renameNode);
        jPopupMenu.add(this.duplicateNode);
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.deleteNode);
        return true;
    }

    private void initRightClickMenuItems() {
        this.runThisStepOnly.addActionListener(this);
        this.runThisStepOnly.putClientProperty(ACTION, new Integer(25));
        this.runFromHere.addActionListener(this);
        this.runFromHere.putClientProperty(ACTION, new Integer(26));
        this.renameNode.addActionListener(this);
        this.renameNode.putClientProperty(ACTION, new Integer(10));
        this.duplicateNode.addActionListener(this);
        this.duplicateNode.putClientProperty(ACTION, new Integer(11));
        this.deleteNode.addActionListener(this);
        this.deleteNode.putClientProperty(ACTION, new Integer(9));
    }

    public ImageIcon getNodeIcon(BrowserTreeNode browserTreeNode) {
        return browserTreeNode.getIcon();
    }

    public void menuSelected(String string, JMenu jMenu, BrowserTreeNode browserTreeNode) {
        if (!string.equals("File")) {
            return;
        }
        if (this.driverName == null || this.driverName.equals("")) {
            this.editMenuItem.setEnabled(false);
        } else {
            this.editMenuItem.setEnabled(true);
        }
        this.saveMenuItem.setEnabled(this.needToSave());
        this.exportMenuItem.setEnabled(this.midTester.hasOutputText());
        this.saveResultsMenuItem.setEnabled(this.midTester.hasOutputText());
        this.printResultsMenuItem.setEnabled(this.midTester.hasOutputText());
        this.saveAsMCodeItem.setEnabled(this.setupPanel.okToRunTest());
        this.saveResultsWithDriverItem.setEnabled(this.setupPanel.okToRunTest());
        if (this.recentFileNames.size() == 0) {
            return;
        }
        this.updateFileNameMenus(jMenu);
    }

    private void updateFileNameMenus(JMenu jMenu) {
        Serializable serializable;
        int n;
        for (n = this.recentFileNames.size() - 1; n >= 0; --n) {
            serializable = new File(this.recentFileNames.elementAt(n));
            if (((File)serializable).exists()) continue;
            this.recentFileNames.removeElementAt(n);
        }
        if (this.numOfMenusInserted == 0 && this.recentFileNames.size() > 0) {
            jMenu.insertSeparator(jMenu.getItemCount() - 1);
        }
        if (this.numOfMenusInserted < this.recentFileNames.size()) {
            for (n = this.numOfMenusInserted; n < this.recentFileNames.size(); ++n) {
                serializable = this.recentFileNameMenus.elementAt(n);
                ((AbstractButton)serializable).addActionListener(this);
                jMenu.add((Component)serializable, jMenu.getItemCount() - 2);
            }
        }
        if (this.numOfMenusInserted > this.recentFileNames.size()) {
            n = this.numOfMenusInserted - this.recentFileNames.size();
            for (int i = 0; i < n; ++i) {
                jMenu.remove(jMenu.getItemCount() - 2);
            }
            if (this.recentFileNames.size() == 0) {
                jMenu.remove(jMenu.getItemCount() - 1);
            }
        }
        for (n = 0; n < this.recentFileNames.size(); ++n) {
            JMenuItem jMenuItem = this.recentFileNameMenus.elementAt(n);
            String string = this.recentFileNames.elementAt(n);
            jMenuItem.putClientProperty("FILENAME", string);
            jMenuItem.setText(n + 1 + ": " + this.getFileNameMenuName(string));
        }
        this.numOfMenusInserted = this.recentFileNames.size();
    }

    private String getFileNameMenuName(String string) {
        if (string.length() < 25) {
            return string;
        }
        return string.substring(0, 3) + "..." + string.substring(string.length() - 19);
    }

    public JMenu[] getMenus() {
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        JMenuItem jMenuItem = new JMenuItem("New");
        JMenuItem jMenuItem2 = new JMenuItem("Open...");
        this.saveMenuItem = new JMenuItem("Save");
        JMenuItem jMenuItem3 = new JMenuItem("Save As...");
        this.saveAsMCodeItem = new JMenuItem("Save Test as MATLAB-Code...");
        this.saveResultsWithDriverItem = new JMenuItem("Save Test as Driver Function...");
        this.editMenuItem = new JMenuItem("Edit MATLAB Instrument Driver...");
        JMenuItem jMenuItem4 = new JMenuItem("Test Preferences...");
        this.exportMenuItem = new JMenuItem("Export Test Results...");
        this.saveResultsMenuItem = new JMenuItem("Save Test Results...");
        this.printResultsMenuItem = new JMenuItem("Print Test Results...");
        JMenuItem jMenuItem5 = new JMenuItem("Close");
        jMenu.add(jMenuItem);
        jMenu.add(jMenuItem2);
        jMenu.addSeparator();
        jMenu.add(this.saveMenuItem);
        jMenu.add(jMenuItem3);
        jMenu.add(this.saveAsMCodeItem);
        jMenu.add(this.saveResultsWithDriverItem);
        jMenu.addSeparator();
        jMenu.add(this.editMenuItem);
        jMenu.addSeparator();
        jMenu.add(jMenuItem4);
        jMenu.addSeparator();
        jMenu.add(this.exportMenuItem);
        jMenu.add(this.saveResultsMenuItem);
        jMenu.add(this.printResultsMenuItem);
        jMenu.addSeparator();
        jMenu.add(jMenuItem5);
        this.editMenuItem.setEnabled(false);
        this.exportMenuItem.setEnabled(false);
        this.saveResultsMenuItem.setEnabled(false);
        this.printResultsMenuItem.setEnabled(false);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        jMenuItem.putClientProperty(ACTION, new Integer(15));
        jMenuItem.addActionListener(this);
        jMenuItem2.putClientProperty(ACTION, new Integer(14));
        jMenuItem2.addActionListener(this);
        this.saveMenuItem.putClientProperty(ACTION, new Integer(12));
        this.saveMenuItem.addActionListener(this);
        jMenuItem3.putClientProperty(ACTION, new Integer(13));
        jMenuItem3.addActionListener(this);
        this.saveAsMCodeItem.putClientProperty(ACTION, new Integer(17));
        this.saveAsMCodeItem.addActionListener(this);
        this.saveResultsWithDriverItem.putClientProperty(ACTION, new Integer(21));
        this.saveResultsWithDriverItem.addActionListener(this);
        this.editMenuItem.putClientProperty(ACTION, new Integer(8));
        this.editMenuItem.addActionListener(this);
        jMenuItem4.putClientProperty(ACTION, new Integer(5));
        jMenuItem4.addActionListener(this);
        this.exportMenuItem.putClientProperty(ACTION, new Integer(18));
        this.exportMenuItem.addActionListener(this);
        this.printResultsMenuItem.putClientProperty(ACTION, new Integer(19));
        this.printResultsMenuItem.addActionListener(this);
        this.saveResultsMenuItem.putClientProperty(ACTION, new Integer(20));
        this.saveResultsMenuItem.addActionListener(this);
        jMenuItem5.putClientProperty(ACTION, new Integer(2));
        jMenuItem5.addActionListener(this);
        JMenu jMenu2 = new JMenu("Run");
        jMenu2.setMnemonic(82);
        this.startMenuItem = new JMenuItem("Start");
        this.stopMenuItem = new JMenuItem("Stop");
        jMenu2.add(this.startMenuItem);
        jMenu2.add(this.stopMenuItem);
        this.stopMenuItem.setEnabled(false);
        this.startMenuItem.putClientProperty(ACTION, new Integer(6));
        this.startMenuItem.addActionListener(this);
        this.stopMenuItem.putClientProperty(ACTION, new Integer(7));
        this.stopMenuItem.addActionListener(this);
        JMenu jMenu3 = new JMenu("Help");
        jMenu3.setMnemonic(72);
        JMenuItem jMenuItem6 = new JMenuItem("Instrument Control Toolbox");
        JMenuItem jMenuItem7 = new JMenuItem("About Instrument Control Toolbox");
        jMenu3.add(jMenuItem6);
        jMenu3.addSeparator();
        jMenu3.add(jMenuItem7);
        jMenuItem6.putClientProperty(ACTION, new Integer(0));
        jMenuItem6.addActionListener(this);
        jMenuItem7.putClientProperty(ACTION, new Integer(1));
        jMenuItem7.addActionListener(this);
        JMenu[] jMenuArray = new JMenu[]{jMenu, jMenu2, jMenu3};
        return jMenuArray;
    }

    public JMenuItem getHelpMenuItem() {
        JMenuItem jMenuItem = new JMenuItem("Instrument Control Toolbox");
        return jMenuItem;
    }

    public JMenuItem getAboutMenuItem() {
        JMenuItem jMenuItem = new JMenuItem("About Instrument Control");
        return jMenuItem;
    }

    public void addToolbarButtons(MJToolBar mJToolBar) {
        mJToolBar.setBorder(null);
        this.startToolbarButton = this.createToolbarButton(startImage, "Start");
        this.stopToolbarButton = this.createToolbarButton(stopImage, "Stop");
        this.optionsToolbarButton = this.createToolbarButton(optionsImage, "Configure Test Preferences");
        this.upToolbarButton = this.createToolbarButton(upImage, "Up");
        this.downToolbarButton = this.createToolbarButton(downImage, "Down");
        this.deleteToolbarButton = this.createToolbarButton(deleteImage, "Delete");
        this.stopToolbarButton.setEnabled(false);
        this.upToolbarButton.setEnabled(false);
        this.downToolbarButton.setEnabled(false);
        this.deleteToolbarButton.setEnabled(false);
        this.startToolbarButton.putClientProperty((Object)ACTION, (Object)new Integer(6));
        this.startToolbarButton.addActionListener((ActionListener)this);
        this.stopToolbarButton.putClientProperty((Object)ACTION, (Object)new Integer(7));
        this.stopToolbarButton.addActionListener((ActionListener)this);
        this.optionsToolbarButton.putClientProperty((Object)ACTION, (Object)new Integer(5));
        this.optionsToolbarButton.addActionListener((ActionListener)this);
        this.upToolbarButton.putClientProperty((Object)ACTION, (Object)new Integer(22));
        this.upToolbarButton.addActionListener((ActionListener)this);
        this.downToolbarButton.putClientProperty((Object)ACTION, (Object)new Integer(23));
        this.downToolbarButton.addActionListener((ActionListener)this);
        this.deleteToolbarButton.putClientProperty((Object)ACTION, (Object)new Integer(24));
        this.deleteToolbarButton.addActionListener((ActionListener)this);
        mJToolBar.add((Component)this.startToolbarButton);
        mJToolBar.add((Component)this.stopToolbarButton);
        mJToolBar.addSeparator();
        mJToolBar.add((Component)this.optionsToolbarButton);
        mJToolBar.addSeparator();
        mJToolBar.add((Component)this.upToolbarButton);
        mJToolBar.add((Component)this.downToolbarButton);
        mJToolBar.add((Component)this.deleteToolbarButton);
    }

    public String getToolboxVersion() {
        String string = Instrument.jarVersion();
        return string.substring(8);
    }

    public String getToolboxName() {
        return "Instrument Control Toolbox";
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JComponent jComponent = (JComponent)actionEvent.getSource();
        int n = (Integer)jComponent.getClientProperty(ACTION);
        switch (n) {
            case 0: {
                if (this.toolboxHelpRunnable == null) {
                    this.toolboxHelpRunnable = new ToolboxHelpRunnable();
                }
                Matlab.whenMatlabReady((Runnable)this.toolboxHelpRunnable);
                break;
            }
            case 1: {
                new AboutWindow(1, this.getBrowserFrame());
                break;
            }
            case 22: {
                TreePath treePath = this.midTester.getSelectedTreePath();
                this.moveStepUp((BrowserTreeNode)treePath.getLastPathComponent(), this.midTester.getSelectedTreePathIndex());
                break;
            }
            case 23: {
                TreePath treePath = this.midTester.getSelectedTreePath();
                this.moveStepDown((BrowserTreeNode)treePath.getLastPathComponent(), this.midTester.getSelectedTreePathIndex());
                break;
            }
            case 24: {
                TreePath treePath = this.midTester.getSelectedTreePath();
                this.removeStep((BrowserTreeNode)treePath.getLastPathComponent());
                break;
            }
            case 8: {
                MIDTool.openDocument(this.driverName);
                break;
            }
            case 9: {
                this.removeStep(this.rightClickNode);
                this.rightClickNode = null;
                break;
            }
            case 10: {
                this.midTester.editNode(this.rightClickNode);
                this.rightClickNode = null;
                break;
            }
            case 11: {
                this.duplicateStep(this.rightClickNode);
                this.rightClickNode = null;
                break;
            }
            case 5: {
                TestOptionsDialog testOptionsDialog = new TestOptionsDialog(this, this.runMode, this.failAction, this.noErrorMessage, this.numDoubleValues);
                testOptionsDialog.showAsDialog(this.getBrowserFrame());
                break;
            }
            case 3: {
                int n2 = this.rootNode.getIndex((TreeNode)this.selectedNode);
                this.start(n2, n2);
                break;
            }
            case 4: {
                this.start(this.rootNode.getIndex((TreeNode)this.selectedNode), this.rootNode.getChildCount() - 1);
                break;
            }
            case 25: {
                int n3 = this.rootNode.getIndex((TreeNode)this.rightClickNode);
                this.start(n3, n3);
                this.rightClickNode = null;
                break;
            }
            case 26: {
                this.start(this.rootNode.getIndex((TreeNode)this.rightClickNode), this.rootNode.getChildCount() - 1);
                this.rightClickNode = null;
                break;
            }
            case 6: {
                this.start();
                break;
            }
            case 7: {
                this.stop();
                break;
            }
            case 18: {
                new MIDTestExporter(this.testResultInfo, this.variables).showAsDialog(this.getBrowserFrame());
                break;
            }
            case 19: {
                this.midTester.printOutput();
                break;
            }
            case 20: {
                this.midTester.saveOutput();
                break;
            }
            case 15: {
                this.newTest();
                break;
            }
            case 12: {
                this.save();
                break;
            }
            case 13: {
                this.saveas();
                break;
            }
            case 17: {
                this.generateMCode();
                break;
            }
            case 21: {
                this.saveDriverMethodCode();
                break;
            }
            case 14: {
                this.load();
                break;
            }
            case 16: {
                this.newTest();
                this.showGlassPane(true);
                this.fileNameWithPath = (String)jComponent.getClientProperty("FILENAME");
                this.fileName = new File(this.fileNameWithPath).getName();
                this.loadTest();
                if (this.setupPanel.needToCreateObject()) break;
                this.showGlassPane(false);
                break;
            }
            case 2: {
                this.closeWindow();
            }
        }
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
        if (this.driverName == null || this.driverName.equals("")) {
            return;
        }
        if (!this.hasDriverUpdated()) {
            return;
        }
        EventQueue.invokeLater(this);
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
        if (this.selectedNode != this.rootNode) {
            this.stepPanel.cleanupLowerPanel(this.selectedNode);
        }
    }

    @Override
    public void run() {
        int n = TMStringUtil.confirm((MJFrame)this.getBrowserFrame(), (String)"Update MATLAB Instrument Driver Testing Tool", (String)"The driver has been modified. Would you like to reload the driver?");
        if (n == 1) {
            return;
        }
        this.parser.dispose();
        this.parser = null;
        this.setDriverName(this.driverName);
        for (int i = 0; i < this.rootNode.getChildCount(); ++i) {
            BrowserTreeNode browserTreeNode = (BrowserTreeNode)this.rootNode.getChildAt(i);
            ((StepInfo)browserTreeNode.getUserData()).setNeedsToUpdate(true);
        }
        if (this.selectedNode == this.rootNode) {
            return;
        }
        this.stepPanel.updateAfterDriverReload(this.selectedNode);
    }

    protected void updateTestOptions(int n, int n2, String string, String string2) {
        if (!(this.needToSave || this.runMode == n && this.failAction == n2 && this.noErrorMessage.equals(string) && this.numDoubleValues.equals(string2))) {
            this.needToSave = true;
        }
        this.runMode = n;
        this.failAction = n2;
        this.noErrorMessage = string;
        this.numDoubleValues = string2;
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.closeWindow();
    }

    private void closeWindow() {
        if (!this.startMenuItem.isEnabled()) {
            needToClose = true;
            this.stop();
            return;
        }
        if (this.needToSave()) {
            int n = this.askUserIfWantToSave();
            switch (n) {
                case 0: {
                    this.save();
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    return;
                }
            }
        }
        if (this.parser != null) {
            this.parser.dispose();
        }
        this.midTester.closeWindow();
        this.setupPanel.cleanup();
        this.stepPanel.cleanup();
        codeGenerator = null;
        Matlab.removeListener((MatlabListener)this);
        if (this.cleanupRunnable == null) {
            this.cleanupRunnable = new CleanupRunnable();
        }
        Matlab.whenMatlabReady((Runnable)this.cleanupRunnable);
    }

    public void checkClose() {
        if (needToClose) {
            this.closeWindow();
        }
    }

    public void matlabEvent(MatlabEvent matlabEvent) {
        if (matlabEvent.getEventType() != 1) {
            return;
        }
        if (!this.needToSave()) {
            return;
        }
        int n = TMStringUtil.confirm((MJFrame)this.getBrowserFrame(), (String)"Save Test File", (String)"Save changes to the test?");
        if (n == 0) {
            this.save();
        }
    }

    public int newTest() {
        int n = 0;
        if (this.needToSave()) {
            n = this.askUserIfWantToSave();
            switch (n) {
                case 0: {
                    this.save();
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    return n;
                }
            }
        }
        while (this.rootNode.getChildCount() > 0) {
            this.postNodeRemovedEvent(this.rootNode, (BrowserTreeNode)this.rootNode.getChildAt(0));
        }
        this.postNodeSelectedEvent(this.rootNode);
        this.setupPanel.reset();
        this.midTester.reset();
        this.midTester.clearOutput();
        this.fileNameWithPath = "";
        this.fileName = "";
        this.needToSave = false;
        this.driverName = "";
        this.driverLastModified = 0L;
        return n;
    }

    public void save() {
        if (this.fileNameWithPath.equals("")) {
            if (!ICSaveDialog.save(".xml", "Save MATLAB Instrument Driver Test File", "MATLAB Instrument Driver Test File (*.xml)", this.getBrowserFrame())) {
                return;
            }
            this.fileNameWithPath = ICSaveDialog.getFileNameWithPath();
            this.fileName = ICSaveDialog.getFileName();
        } else {
            ICSaveDialog.reset();
            if (!ICSaveDialog.checkFilePermissions(this.fileNameWithPath, ".xml", "Save MATLAB Instrument Driver Test File", "MATLAB Instrument Driver Test File (*.xml)", this.getBrowserFrame())) {
                return;
            }
            if (!ICSaveDialog.getFileNameWithPath().equals("")) {
                this.fileNameWithPath = ICSaveDialog.getFileNameWithPath();
                this.fileName = ICSaveDialog.getFileName();
            }
        }
        this.saveTest();
    }

    public void saveas() {
        if (this.setupPanel.getDriverName() == null || this.setupPanel.getDriverName().length() == 0) {
            MJOptionPane.showMessageDialog((Component)this.setupPanel, (Object)"You must specify a driver to save the test.", (String)"Invalid Driver", (int)0);
            return;
        }
        if (!ICSaveDialog.save(".xml", "Save MATLAB Instrument Driver Test File", "MATLAB Instrument Driver Test File (*.xml)", this.getBrowserFrame())) {
            return;
        }
        this.fileNameWithPath = ICSaveDialog.getFileNameWithPath();
        this.fileName = ICSaveDialog.getFileName();
        this.saveTest();
    }

    private void saveTest() {
        this.updateMostRecentFileNamesList();
        MIDTestToolFileWriter mIDTestToolFileWriter = null;
        if (!this.fileNameWithPath.equals("")) {
            mIDTestToolFileWriter = new MIDTestToolFileWriter(this.fileNameWithPath);
        }
        Element element = mIDTestToolFileWriter.addNode("TestOptions");
        mIDTestToolFileWriter.addNode(element, "RunMode", String.valueOf(this.runMode));
        mIDTestToolFileWriter.addNode(element, "FailAction", String.valueOf(this.failAction));
        mIDTestToolFileWriter.addNode(element, "NoErrorMessage", this.noErrorMessage);
        mIDTestToolFileWriter.addNode(element, "NumDoubleValues", this.numDoubleValues);
        element = mIDTestToolFileWriter.addNode("OutputPanel");
        mIDTestToolFileWriter.addNode(element, "Verbosity", this.midTester.getOutputVerbosity());
        element = mIDTestToolFileWriter.addNode("Root");
        this.setupPanel.save(mIDTestToolFileWriter, element);
        if (this.selectedNode != this.rootNode) {
            this.stepPanel.cleanupLowerPanel(this.selectedNode);
        }
        Element element2 = mIDTestToolFileWriter.addNode("Steps");
        for (int i = 0; i < this.rootNode.getChildCount(); ++i) {
            BrowserTreeNode browserTreeNode = (BrowserTreeNode)this.rootNode.getChildAt(i);
            element = mIDTestToolFileWriter.addNode(element2, SAVE_NAMES[browserTreeNode.getType()]);
            this.stepPanel.save(mIDTestToolFileWriter, element, browserTreeNode);
        }
        mIDTestToolFileWriter.saveToFile();
        this.resetDirtyFlag();
    }

    public void load() {
        String string = this.fileNameWithPath;
        int n = this.launchLoadDialog();
        if (n == 1) {
            return;
        }
        this.showGlassPane(true);
        String string2 = this.fileNameWithPath;
        this.fileNameWithPath = string;
        this.fileName = new File(this.fileNameWithPath).getName();
        this.newTest();
        this.fileNameWithPath = string2;
        this.fileName = new File(this.fileNameWithPath).getName();
        this.loadTest();
        if (!this.setupPanel.needToCreateObject()) {
            this.showGlassPane(false);
        }
    }

    public void loadTest(String string) {
        try {
            this.showGlassPane(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.newTest();
        this.fileNameWithPath = string;
        this.fileName = new File(this.fileNameWithPath).getName();
        this.loadTest();
        try {
            if (!this.setupPanel.needToCreateObject()) {
                this.showGlassPane(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void loadTest() {
        try {
            Object object;
            String string;
            int n;
            this.stepPanel.updateAfterDriverReload();
            this.updateMostRecentFileNamesList();
            MIDTestToolFileReader mIDTestToolFileReader = null;
            if (this.fileNameWithPath.equals("")) {
                throw new Exception("Empty Filename");
            }
            mIDTestToolFileReader = new MIDTestToolFileReader(this.fileNameWithPath);
            Node node = mIDTestToolFileReader.getNode("TestOptions");
            NodeList nodeList = node.getChildNodes();
            for (n = 0; n < nodeList.getLength(); ++n) {
                string = nodeList.item(n).getNodeName();
                object = nodeList.item(n).getChildNodes();
                if (object.getLength() == 0) continue;
                if (string.equals("RunMode")) {
                    this.runMode = new Integer(object.item(0).getNodeValue());
                    continue;
                }
                if (string.equals("FailAction")) {
                    this.failAction = new Integer(object.item(0).getNodeValue());
                    continue;
                }
                if (string.equals("NoErrorMessage")) {
                    this.noErrorMessage = object.item(0).getNodeValue();
                    continue;
                }
                if (!string.equals("NumDoubleValues")) continue;
                this.numDoubleValues = object.item(0).getNodeValue();
            }
            node = mIDTestToolFileReader.getNode("OutputPanel");
            nodeList = node.getChildNodes();
            for (n = 0; n < nodeList.getLength(); ++n) {
                string = nodeList.item(n).getNodeName();
                object = nodeList.item(n).getChildNodes();
                if (object.getLength() == 0 || !string.equals("Verbosity")) continue;
                this.midTester.setOutputVerbosity(object.item(0).getNodeValue());
            }
            node = mIDTestToolFileReader.getNode("Root");
            this.errorParsingDriver = false;
            this.setupPanel.load(mIDTestToolFileReader, node);
            if (this.errorParsingDriver) {
                this.postNodeSelectedEvent(this.rootNode);
                this.midTester.expandAll(this.rootNode);
                this.midTester.resetDirtyFlag();
                this.midTester.setBrowserDecorationText(this.rootNode.getName(), null);
                this.needToSave = false;
                return;
            }
            node = mIDTestToolFileReader.getNode("Steps");
            if (node == null) {
                return;
            }
            nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                object = nodeList.item(i).getNodeName();
                NodeList nodeList2 = nodeList.item(i).getChildNodes();
                if (nodeList2.getLength() == 0) continue;
                if (((String)object).equals(SAVE_NAMES[0])) {
                    BrowserTreeNode browserTreeNode = this.addStep(0, false);
                    this.stepPanel.load(nodeList.item(i), browserTreeNode);
                    continue;
                }
                if (((String)object).equals(SAVE_NAMES[1])) {
                    BrowserTreeNode browserTreeNode = this.addStep(1, false);
                    this.stepPanel.load(nodeList.item(i), browserTreeNode);
                    continue;
                }
                if (((String)object).equals(SAVE_NAMES[2])) {
                    BrowserTreeNode browserTreeNode = this.addStep(2, false);
                    this.stepPanel.load(nodeList.item(i), browserTreeNode);
                    continue;
                }
                if (((String)object).equals(SAVE_NAMES[3])) {
                    BrowserTreeNode browserTreeNode = this.addStep(3, false);
                    this.stepPanel.load(nodeList.item(i), browserTreeNode);
                    continue;
                }
                if (!((String)object).equals(SAVE_NAMES[4])) continue;
                BrowserTreeNode browserTreeNode = this.addStep(4, false);
                this.stepPanel.load(nodeList.item(i), browserTreeNode);
            }
            this.postNodeSelectedEvent(this.rootNode);
            this.midTester.expandAll(this.rootNode);
            this.midTester.resetDirtyFlag();
            this.midTester.setBrowserDecorationText(this.rootNode.getName(), null);
            this.needToSave = false;
        }
        catch (Exception exception) {
            TMStringUtil.error((MJFrame)this.getBrowserFrame(), (String)"Load Error", (String)"An error occurred while loading the test. The test may be invalid.");
        }
    }

    private boolean needToSave() {
        if (this.selectedNode != this.rootNode) {
            this.stepPanel.cleanupLowerPanel(this.selectedNode);
        }
        if (this.needToSave) {
            return true;
        }
        if (this.midTester.isDirty()) {
            return true;
        }
        if (this.setupPanel.isNodeDirty()) {
            return true;
        }
        for (int i = 0; i < this.rootNode.getChildCount(); ++i) {
            BrowserTreeNode browserTreeNode = (BrowserTreeNode)this.rootNode.getChildAt(i);
            StepInfo stepInfo = (StepInfo)browserTreeNode.getUserData();
            if (!stepInfo.getIsNodeDirty()) continue;
            return true;
        }
        return false;
    }

    private void resetDirtyFlag() {
        this.midTester.resetDirtyFlag();
        this.setupPanel.resetDirtyFlag();
        for (int i = 0; i < this.rootNode.getChildCount(); ++i) {
            BrowserTreeNode browserTreeNode = (BrowserTreeNode)this.rootNode.getChildAt(i);
            StepInfo stepInfo = (StepInfo)browserTreeNode.getUserData();
            stepInfo.setIsNodeDirty(false);
        }
        this.needToSave = false;
    }

    public void save(BrowserConfigFileWriter browserConfigFileWriter, Element element) {
        Element element2 = browserConfigFileWriter.addNode(element, "TestOptions");
        element2.setAttribute("RunMode", String.valueOf(this.runMode));
        element2.setAttribute("FailAction", String.valueOf(this.failAction));
        element2.setAttribute("NoErrorMessage", this.noErrorMessage);
        element2.setAttribute("NumDoubleValues", this.numDoubleValues);
        element2 = browserConfigFileWriter.addNode(element, "TestFiles");
        for (int i = 0; i < this.recentFileNames.size(); ++i) {
            element2.setAttribute("File" + i, this.recentFileNames.elementAt(i));
        }
    }

    public void load(BrowserConfigFileReader browserConfigFileReader, Node node) {
        if (node == null) {
            return;
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element;
            String string = nodeList.item(i).getNodeName();
            if (string.equals("TestOptions")) {
                element = (Element)nodeList.item(i);
                this.runMode = new Integer(element.getAttribute("RunMode"));
                this.failAction = new Integer(element.getAttribute("FailAction"));
                this.noErrorMessage = element.getAttribute("NoErrorMessage");
                this.numDoubleValues = element.getAttribute("NumDoubleValues");
                continue;
            }
            if (!string.equals("TestFiles")) continue;
            element = (Element)nodeList.item(i);
            for (int j = 0; j < this.numOfFileNamesToKeep; ++j) {
                String string2 = element.getAttribute("File" + j);
                if (string2 == null || string2.equals("")) continue;
                this.recentFileNames.addElement(string2);
            }
        }
    }

    private int launchLoadDialog() {
        return this.launchDialog(1, "Load MATLAB Instrument Driver Test File");
    }

    private int launchDialog(int n, String string) {
        try {
            TMFileDialog tMFileDialog = new TMFileDialog(string, "xml", "MATLAB Instrument Driver Test File (*.xml)");
            tMFileDialog.setCurrentDirectory(new File(Instrument.getPreferenceFile().read("SaveDirectory")));
            int n2 = tMFileDialog.showDialog(n, this.getBrowserFrame());
            if (n2 == 0) {
                this.fileNameWithPath = tMFileDialog.getSelectedFile().getAbsolutePath();
                this.fileName = new File(this.fileNameWithPath).getName();
                Instrument.getPreferenceFile().update("SaveDirectory", tMFileDialog.getSelectedFile().getParentFile().getPath());
            }
            return n2;
        }
        catch (Exception exception) {
            return 1;
        }
    }

    private void updateMostRecentFileNamesList() {
        int n = this.recentFileNames.indexOf(this.fileNameWithPath);
        switch (n) {
            case -1: {
                this.recentFileNames.insertElementAt(this.fileNameWithPath, 0);
                if (this.recentFileNames.size() <= this.numOfFileNamesToKeep) break;
                this.recentFileNames.removeElementAt(this.numOfFileNamesToKeep);
                break;
            }
            case 0: {
                break;
            }
            default: {
                this.recentFileNames.removeElement(this.fileNameWithPath);
                this.recentFileNames.insertElementAt(this.fileNameWithPath, 0);
            }
        }
    }

    private int askUserIfWantToSave() {
        String string = "Save changes to " + this.fileName + "?";
        if (this.fileName.equals("")) {
            string = "Save changes to the test?";
        }
        return TMStringUtil.confirmWithCancel((MJFrame)this.getBrowserFrame(), (String)"Save Confirmation", (String)string);
    }

    private void parseDriver() throws Exception {
        this.parser = new Parser(this.driverName);
        this.parser.parse();
    }

    private int countSetProperty() {
        String[] stringArray = TMStringUtil.vector2StringArray(this.parser.getPropertyGroups());
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            Vector<String> vector = this.parser.getProperties(stringArray[i]);
            if (vector == null || vector.size() <= 0) continue;
            for (int j = 0; j < vector.size(); ++j) {
                if (this.parser.getPropertyInformation(vector.elementAt(j), stringArray[i]).getReadOnly().equals("always")) continue;
                ++n;
            }
        }
        Vector<String> vector = this.parser.getProperties("parent");
        if (vector != null && vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                if (this.parser.getPropertyInformation(vector.elementAt(i), "parent").getReadOnly().equals("always")) continue;
                ++n;
            }
        }
        return n;
    }

    public Parser getParser() {
        return this.parser;
    }

    public long getDriverDate() {
        return this.driverLastModified;
    }

    public String setDriverName(String string) {
        this.driverName = string;
        this.postStatusBarUpdateEvent("Reading driver");
        try {
            this.parseDriver();
        }
        catch (Exception exception) {
            this.postStatusBarUpdateEvent("");
            this.errorParsingDriver = true;
            TMStringUtil.error((MJFrame)this.getBrowserFrame(), (String)"Invalid Driver", (String)"An error occurred while parsing the selected driver.");
            return null;
        }
        this.propSetCount = this.countSetProperty();
        File file = new File(this.driverName);
        this.driverLastModified = file.lastModified();
        this.stepPanel.updateAfterDriverReload();
        this.midTester.enableStepPanel(true);
        this.postStatusBarUpdateEvent("");
        return this.parser.getDriverType();
    }

    public boolean hasDriverUpdated() {
        File file = new File(this.driverName);
        long l = file.lastModified();
        if (l == this.driverLastModified) {
            return false;
        }
        this.driverLastModified = l;
        return true;
    }

    public void nodeEditingStopped(ChangeEvent changeEvent, BrowserTreeNode browserTreeNode) {
        this.nodeEditingCanceled(changeEvent, browserTreeNode);
    }

    public void nodeEditingCanceled(ChangeEvent changeEvent, BrowserTreeNode browserTreeNode) {
        String string;
        String string2;
        StepInfo stepInfo;
        if (browserTreeNode == this.rootNode) {
            this.setupPanel.updateNameField(browserTreeNode.getName());
            this.midTester.setBrowserDecorationText(browserTreeNode.getName(), null);
            this.rightClickNode = null;
            return;
        }
        if (this.rightClickNode == null) {
            stepInfo = (StepInfo)this.selectedNode.getUserData();
            string2 = this.selectedNode.getName();
            string = this.getBrowserDecorationLabel(this.selectedNode);
        } else {
            stepInfo = (StepInfo)this.rightClickNode.getUserData();
            string2 = this.rightClickNode.getName();
            string = this.getBrowserDecorationLabel(this.rightClickNode);
        }
        stepInfo.setName(string2);
        if (this.rightClickNode == this.selectedNode || this.rightClickNode == null) {
            this.stepPanel.updateNameField(string2);
        }
        this.rightClickNode = null;
        this.midTester.setBrowserDecorationText(string, browserTreeNode.getIcon());
    }

    public void showGlassPane(boolean bl) {
        if (this.getBrowserFrame() == null) {
            return;
        }
        if (this.glassPane == null) {
            Component[] componentArray = new Component[]{this.stopToolbarButton, this.midTester.getHtmlComponent()};
            this.glassPane = new MIDGlassPane(this.getBrowserFrame(), componentArray);
            this.getBrowserFrame().setGlassPane((Component)this.glassPane);
        }
        this.glassPane.setVisible(bl);
    }

    public void start() {
        if (this.runMode == 0) {
            this.start(0, this.rootNode.getChildCount() - 1);
            return;
        }
        if (this.selectedNode.equals(this.rootNode)) {
            TMStringUtil.error((MJFrame)this.getBrowserFrame(), (String)"Start Error", (String)("The Run Mode is 'Run current step only'. " + TMStringUtil.LINESEP + "The current step cannot be the root node. Select another node." + TMStringUtil.LINESEP + "To change the Run Mode, go to the File -> Test Preferences menu item."));
            return;
        }
        int n = this.rootNode.getIndex((TreeNode)this.selectedNode);
        this.start(n, n);
    }

    public void start(int n, int n2) {
        if (!this.setupPanel.okToRunTest()) {
            TMStringUtil.error((MJFrame)this.getBrowserFrame(), (String)"Start Error", (String)"The driver and interface must be specified before running the test.");
            return;
        }
        this.showGlassPane(true);
        if (this.selectedNode != this.rootNode) {
            this.stepPanel.cleanup(this.selectedNode);
        }
        this.postStatusBarUpdateEvent("Running test");
        this.setIsTestRunning(true);
        this.testResultInfo.removeAllElements();
        this.variables.removeAllElements();
        this.midTester.clearOutput();
        this.midTester.showOutputWindow();
        try {
            this.testExecuter.assignCode(this.generateMCodeForTestRun(n, n2));
        }
        catch (Exception exception) {
            MJOptionPane.showMessageDialog((Component)this.setupPanel, (Object)"An error occurred while generating test code.", (String)"Invalid Test or Interface", (int)0);
            return;
        }
        Matlab.whenMatlabReady((Runnable)this.testExecuter);
    }

    public void stop() {
        this.setIsTestRunning(false);
    }

    private void setIsTestRunning(boolean bl) {
        isRunning = bl;
        if (bl) {
            this.flipStartStop(bl);
        } else {
            this.stopToolbarButton.setEnabled(bl);
            this.stopMenuItem.setEnabled(bl);
        }
    }

    public void flipStartStop(boolean bl) {
        this.startToolbarButton.setEnabled(!bl);
        this.startMenuItem.setEnabled(!bl);
        this.stopToolbarButton.setEnabled(bl);
        this.stopMenuItem.setEnabled(bl);
    }

    public static boolean isTestRunning() {
        return isRunning;
    }

    public String generateMCodeForTestRun(int n, int n2) {
        if (codeGenerator == null) {
            codeGenerator = new CodeGenerator(this);
        }
        return codeGenerator.generateMCodeForTestRun(n, n2);
    }

    public void generateMCode() {
        if (codeGenerator == null) {
            codeGenerator = new CodeGenerator(this);
        }
        codeGenerator.generateMCode();
    }

    public void assignVariableInformation(Object object) {
        this.testResultInfo.addElement(object);
    }

    public void assignVariable(Object object) {
        this.variables.addElement(object);
    }

    public void saveDriverMethodCode() {
        if (this.saveTestWithDriverDialog == null) {
            this.saveTestWithDriverDialog = new SaveTestWithDriverDialog();
        }
        this.saveTestWithDriverDialog.update(this.parser.getMethods("parent"));
        this.saveTestWithDriverDialog.showAsDialog(this.getBrowserFrame());
        if (this.saveTestWithDriverDialog.isCancelled()) {
            return;
        }
        if (codeGenerator == null) {
            codeGenerator = new CodeGenerator(this);
        }
        String string = this.saveTestWithDriverDialog.getMethodName();
        DriverFileReader driverFileReader = new DriverFileReader(this.parser);
        DriverModel driverModel = driverFileReader.parserToModel();
        DriverFunction driverFunction = new DriverFunction(string, "parent");
        driverFunction.setCodeType(1);
        driverFunction.setMCodeToEvaluate(codeGenerator.generateDriverMethodCode(string));
        driverModel.add(driverFunction);
        DriverFileWriter driverFileWriter = new DriverFileWriter(driverModel);
        ICSaveDialog.reset();
        if (!ICSaveDialog.checkFilePermissions(this.driverName, ".mdd", "Save MATLAB Instrument Driver", "MATLAB Instrument Driver (*.mdd)", this.getBrowserFrame())) {
            return;
        }
        if (!ICSaveDialog.getFileNameWithPath().equals("")) {
            this.driverName = ICSaveDialog.getFileNameWithPath();
            this.driverLastModified = 0L;
        }
        try {
            driverFileWriter.writeXML(this.driverName);
        }
        catch (TMException tMException) {
            // empty catch block
        }
    }

    protected SetupPanel getSetupPanel() {
        return this.setupPanel;
    }

    protected StepPanel getStepPanel() {
        return this.stepPanel;
    }

    protected int getFailAction() {
        return this.failAction;
    }

    protected String getNoErrorMessage() {
        return this.noErrorMessage;
    }

    public BrowserTreeNode getRoot() {
        this.rootNode.setIcon(null);
        return this.rootNode;
    }

    public boolean reportWarnings() {
        return this.midTester.reportWarnings();
    }

    public int getNumberOfDoublesToTest() {
        return new Integer(this.numDoubleValues);
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    public class CleanupRunnable
    implements Runnable {
        private Object[] args = new Object[]{"privateMIDTestToolHelper", "cleanup"};

        @Override
        public void run() {
            try {
                Matlab.mtFeval((String)"instrgate", (Object[])this.args, (int)0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

