/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.drivers.vxipnp.sub;

import com.mathworks.toolbox.instrument.device.drivers.vxipnp.sub.AttributeIdentifier;
import com.mathworks.toolbox.instrument.device.drivers.vxipnp.sub.AttributeParser;
import com.mathworks.toolbox.instrument.device.drivers.vxipnp.sub.SubFileParser;
import com.mathworks.toolbox.instrument.device.drivers.vxipnp.sub.ValueSet;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverDataType;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverGroup;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverModel;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverProperty;
import com.mathworks.toolbox.instrument.device.icdevice.ICDevice;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class DefaultAttributeParser
implements AttributeParser {
    private String getAttributeAccessorGroupName = "";
    private String setAttributeAccessorGroupName = "";

    @Override
    public void parseAttributes(SubFileParser subFileParser, DriverModel driverModel) {
        Hashtable<String, AttributeIdentifier> hashtable = subFileParser.getAttributeIdentifiers();
        this.getAttributeAccessorGroupName(driverModel);
        Enumeration<String> enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object object;
            String string = enumeration.nextElement();
            AttributeIdentifier attributeIdentifier = hashtable.get(string);
            String string2 = attributeIdentifier.getFlattenedClassName();
            DriverGroup driverGroup = driverModel.getGroup(string2);
            if (driverGroup == null) {
                object = this.generateMATLABSafeGroupName(string2);
                driverGroup = driverModel.createGroup((String)object);
            }
            object = this.createProperty(attributeIdentifier, driverGroup, subFileParser);
            driverModel.add((DriverProperty)object);
        }
    }

    protected String generateMATLABSafeGroupName(String string) {
        String[] stringArray = ICDevice.BASE_PROPS;
        String string2 = "";
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equalsIgnoreCase(stringArray[i])) continue;
            string2 = "Instrument" + string;
            return string2;
        }
        string2 = string.replaceAll("\\W+", "");
        return string2;
    }

    protected String generateSetCode(AttributeIdentifier attributeIdentifier) {
        String string = "deviceobj = get(obj, 'Parent');\nattributeaccessors = get(deviceobj, '" + this.setAttributeAccessorGroupName + "');\n" + "RepCapIdentifier  = get(deviceobj, 'RepCapIdentifier');\n" + "RepCapIdentifier = [double(RepCapIdentifier) 0];\n";
        String string2 = attributeIdentifier.getDataType();
        string = string2.equals("ViString") ? string + "invoke (attributeaccessors, 'setattributevistring',RepCapIdentifier, " + attributeIdentifier.getAttributeID() + " , propertyValue);" : (string2.equals("ViInt32") ? string + "invoke (attributeaccessors, 'setattributeviint32',RepCapIdentifier, " + attributeIdentifier.getAttributeID() + " ,propertyValue);" : (string2.equals("ViReal64") ? string + "invoke (attributeaccessors, 'setattributevireal64',RepCapIdentifier, " + attributeIdentifier.getAttributeID() + " , propertyValue);" : (string2.equals("ViSession") ? string + "invoke (attributeaccessors, 'setattributevisession',RepCapIdentifier, " + attributeIdentifier.getAttributeID() + " ,propertyValue);" : (string2.equals("ViBoolean") ? string + "invoke (attributeaccessors, 'setattributeviboolean',RepCapIdentifier, " + attributeIdentifier.getAttributeID() + ", propertyValue);" : string + "unknown type"))));
        return string;
    }

    protected String generateGetCode(AttributeIdentifier attributeIdentifier) {
        String string = "deviceobj = get(obj, 'Parent');\nattributeaccessors = get(deviceobj, '" + this.getAttributeAccessorGroupName + "');\n" + "RepCapIdentifier  = get(deviceobj, 'RepCapIdentifier');\n" + "RepCapIdentifier = [double(RepCapIdentifier) 0];\n";
        String string2 = attributeIdentifier.getDataType();
        string = string2.equals("ViString") ? string + "propertyValue = invoke (attributeaccessors, 'getattributevistring',RepCapIdentifier, " + attributeIdentifier.getAttributeID() + ", 512);" : (string2.equals("ViInt32") ? string + "propertyValue = invoke (attributeaccessors, 'getattributeviint32',RepCapIdentifier, " + attributeIdentifier.getAttributeID() + ");" : (string2.equals("ViReal64") ? string + "propertyValue = invoke (attributeaccessors, 'getattributevireal64',RepCapIdentifier, " + attributeIdentifier.getAttributeID() + ");" : (string2.endsWith("ViSession") ? string + "propertyValue = invoke (attributeaccessors, 'getattributevisession',RepCapIdentifier, " + attributeIdentifier.getAttributeID() + ");" : (string2.equals("ViBoolean") ? string + "propertyValue = invoke (attributeaccessors, 'getattributeviboolean',RepCapIdentifier, " + attributeIdentifier.getAttributeID() + ");" : string + "unknown type"))));
        return string;
    }

    protected DriverProperty createProperty(AttributeIdentifier attributeIdentifier, DriverGroup driverGroup, SubFileParser subFileParser) {
        Object object;
        String string = attributeIdentifier.getName();
        if (string.indexOf("+") >= 0) {
            string = string.replaceAll("\\+", "PLUS");
        }
        if (string.indexOf("-") >= 0) {
            string = string.replaceAll("\\-", "MINUS");
        }
        if ((string = string.trim().replaceAll("\\W+", "_")).startsWith("_")) {
            string = string.substring(1);
        }
        if (string.endsWith("_")) {
            string = string.substring(0, string.length() - 1);
        }
        if (string.length() == 0) {
            string = attributeIdentifier.getMacroName();
        }
        string = string.substring(0, 1).toUpperCase() + string.substring(1);
        string = this.genvarname(string);
        Object[] objectArray = new String[]{"HwIndex", "HwName", "Name", "Parent", "Type"};
        if (Arrays.binarySearch(objectArray, string) > 0) {
            string = "Group_" + string;
        }
        DriverProperty driverProperty = new DriverProperty(string, driverGroup);
        driverProperty.setCodeType(1);
        driverProperty.setDescription(attributeIdentifier.getHelp());
        DriverDataType driverDataType = new DriverDataType();
        if (this.isString(attributeIdentifier.getDataType())) {
            driverDataType.setDataType(1);
        }
        if (attributeIdentifier.valueSetName.length() > 0) {
            driverDataType.setConstraintType(1);
            object = subFileParser.valueSets.get(attributeIdentifier.valueSetName);
            Enumeration<String> enumeration = ((ValueSet)object).values.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = enumeration.nextElement();
                switch (((ValueSet)object).getDataType()) {
                    case 0: {
                        Integer n = (Integer)((ValueSet)object).values.get(string2);
                        Double d = new Double(n.intValue());
                        driverDataType.addDoubleEnum(d);
                        break;
                    }
                    case 1: {
                        Double d = (Double)((ValueSet)object).values.get(string2);
                        driverDataType.addDoubleEnum(d);
                        break;
                    }
                    case 2: {
                        driverDataType.setDataType(1);
                        driverDataType.addStringEnumKey(string2);
                        String string3 = (String)((Object)((ValueSet)object).values.get(string2));
                        driverDataType.addStringEnumVal(string3);
                    }
                }
            }
        }
        driverProperty.addPropertyType(driverDataType);
        if (!attributeIdentifier.isSettable()) {
            driverProperty.setReadOnly("always");
        } else {
            object = driverProperty.getSetCodeToEvaluate();
            driverProperty.setSetCodeToEvaluate((String)object + this.generateSetCode(attributeIdentifier));
        }
        object = driverProperty.getGetCodeToEvaluate();
        driverProperty.setGetCodeToEvaluate((String)object + this.generateGetCode(attributeIdentifier));
        return driverProperty;
    }

    public String genvarname(String string) {
        if (string == null) {
            return "x";
        }
        String string2 = string.trim().replaceAll("\\W+", "");
        if (string2.length() > 0) {
            char c = string2.charAt(0);
            if (Character.isDigit(c)) {
                string2 = "x" + string2;
            }
            return string2;
        }
        return "x";
    }

    private boolean isString(String string) {
        return string.equalsIgnoreCase("viconststring") || string.equalsIgnoreCase("vistring");
    }

    private void getAttributeAccessorGroupName(DriverModel driverModel) {
        DriverGroup[] driverGroupArray = driverModel.getGroups();
        Vector<Object> vector = new Vector();
        for (int i = 0; i < driverGroupArray.length; ++i) {
            vector = driverModel.getFunctionNames(driverGroupArray[i]);
            if (vector.contains("getattributevistring")) {
                this.getAttributeAccessorGroupName = driverGroupArray[i].getName();
            }
            if (vector.contains("setattributevistring")) {
                this.setAttributeAccessorGroupName = driverGroupArray[i].getName();
            }
            if (this.getAttributeAccessorGroupName.length() > 0 && this.setAttributeAccessorGroupName.length() > 0) break;
        }
    }
}

