/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.drivers.vxipnp.fp;

import com.mathworks.toolbox.instrument.device.drivers.vxipnp.fp.Argument;
import com.mathworks.toolbox.instrument.device.icdevice.ICDevice;

public class FunctionPanel {
    public static int sDefaultCharArrayArgumentSize = 512;
    public static boolean sCheckForErrorsIsOn = true;
    protected static int FUNCTION = 0;
    protected static int GET_PROPERTY = 1;
    protected static int SET_PROPERTY = 2;
    private String fName;
    private String fClassName;
    private Argument[] fArgumentList;
    private String fDriverPrefix;
    private String fHelpText = "";
    private static Argument DEFAULT_ARGUMENT = new Argument("unknown", 1, "ViInt8");

    public FunctionPanel(String string, String string2, String string3) {
        this.fName = string;
        this.fClassName = string2;
        this.fDriverPrefix = string3;
        this.fArgumentList = new Argument[0];
    }

    public String getName() {
        return this.fName;
    }

    public String getClassName() {
        return this.fClassName;
    }

    public void setClassName(String string) {
        this.fClassName = string;
    }

    public String getMATLABSafeClassName() {
        String string = this.getClassName().replaceAll("\\W+", "");
        if (!Character.isLetter(string.charAt(0))) {
            string = "Group" + string;
        }
        String[] stringArray = ICDevice.BASE_PROPS;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase(string)) continue;
            string = "Driver" + string;
            break;
        }
        if ((string.endsWith("functions") || string.endsWith("Functions")) && string.length() > 9) {
            string = string.substring(0, string.length() - 9);
        }
        if ((string.endsWith("function") || string.endsWith("Function")) && string.length() > 8) {
            string = string.substring(0, string.length() - 8);
        }
        return string;
    }

    public String getHelpText() {
        return this.fHelpText;
    }

    public void setHelpText(String string) {
        this.fHelpText = string;
    }

    public void setArgument(Argument argument) {
        int n;
        if (argument.getType() == 6) {
            return;
        }
        if (this.fArgumentList.length == 0) {
            this.fArgumentList = new Argument[argument.getPosition() + 1];
            if (this.fArgumentList.length > 1) {
                for (int i = 0; i < this.fArgumentList.length; ++i) {
                    this.fArgumentList[i] = DEFAULT_ARGUMENT;
                }
            }
            this.fArgumentList[argument.getPosition()] = argument;
            return;
        }
        if (argument.getPosition() < this.fArgumentList.length) {
            this.fArgumentList[argument.getPosition()] = argument;
            return;
        }
        Argument[] argumentArray = new Argument[argument.getPosition() + 1];
        for (n = 0; n < argumentArray.length; ++n) {
            argumentArray[n] = DEFAULT_ARGUMENT;
        }
        for (n = 0; n < this.fArgumentList.length; ++n) {
            argumentArray[n] = this.fArgumentList[n];
        }
        argumentArray[argument.getPosition()] = argument;
        this.fArgumentList = argumentArray;
    }

    public Argument[] getArguments() {
        return this.fArgumentList;
    }

    public Argument getGetArgument() {
        return this.fArgumentList[1];
    }

    public Argument getSetArgument() {
        return this.fArgumentList[1];
    }

    public boolean isValidAsGetFunction() {
        if (this.getCalllibInputCount() != 2) {
            return false;
        }
        if (this.getCalllibOutputCount() != 2) {
            return false;
        }
        Argument argument = this.fArgumentList[1];
        return argument.isOutput() && !argument.isString() && !argument.isArray();
    }

    public boolean isValidAsSetFunction() {
        if (this.getCalllibInputCount() != 2) {
            return false;
        }
        Argument argument = this.fArgumentList[1];
        return !argument.isOutput() && !argument.isArray();
    }

    public int getCalllibInputCount() {
        return this.fArgumentList.length;
    }

    public int getCalllibOutputCount() {
        int n = 1;
        for (int i = 0; i < this.fArgumentList.length; ++i) {
            if (!this.fArgumentList[i].isReference()) continue;
            ++n;
        }
        return n;
    }

    public boolean hasOutputs() {
        for (int i = 0; i < this.fArgumentList.length; ++i) {
            if (!this.fArgumentList[i].isOutput()) continue;
            return true;
        }
        return false;
    }

    public String getMCode() {
        return this.getMCode(this.getName());
    }

    public String getMCode(String string) {
        int n;
        String string2 = "function ";
        boolean bl = false;
        if (this.hasOutputs()) {
            string2 = string2 + "[";
            for (n = 0; n < this.fArgumentList.length; ++n) {
                if (!this.fArgumentList[n].isOutput()) continue;
                if (bl) {
                    string2 = string2 + ", ";
                }
                string2 = string2 + this.fArgumentList[n].getName();
                bl = true;
            }
            string2 = string2 + "] = ";
        }
        string2 = string2 + string + "(obj";
        if (this.fArgumentList.length > 0) {
            if (!this.fArgumentList[0].isOutput() && !this.fArgumentList[0].isSession() || this.fArgumentList[0].isArray() && !this.fArgumentList[0].isString()) {
                string2 = string2 + ", " + this.fArgumentList[0].getName();
            }
            for (n = 1; n < this.fArgumentList.length; ++n) {
                if (this.fArgumentList[n].isOutput() && (!this.fArgumentList[n].isArray() || this.fArgumentList[n].isString())) continue;
                string2 = string2 + ", " + this.fArgumentList[n].getName();
            }
        }
        string2 = string2 + ")\n\n";
        string2 = string2 + this.writeSessionLibnameCode();
        for (n = 0; n < this.fArgumentList.length; ++n) {
            if (this.fArgumentList[n].isOutput()) {
                string2 = this.fArgumentList[n].isStruct() ? string2 + this.fArgumentList[n].getName() + " = libstruct('" + this.fArgumentList[n].getMATLABStructPointerType() + "', " : string2 + this.fArgumentList[n].getName() + " = libpointer('" + this.fArgumentList[n].getMATLABPointerType() + "', ";
                if (this.fArgumentList[n].isString()) {
                    string2 = string2 + "repmat(10, 1, " + sDefaultCharArrayArgumentSize + "));\n";
                    continue;
                }
                if (this.fArgumentList[n].isArray()) {
                    string2 = string2 + this.fArgumentList[n].getName() + ");\n";
                    continue;
                }
                string2 = string2 + "0);\n";
                continue;
            }
            if (!this.fArgumentList[n].isString()) continue;
            string2 = string2 + this.fArgumentList[n].getName() + " = [double(" + this.fArgumentList[n].getName() + ") 0];\n";
        }
        string2 = string2 + "\nstatus = calllib(libname, '" + this.fDriverPrefix + "_" + this.getName() + "'";
        if (this.fArgumentList.length > 0) {
            string2 = this.fArgumentList[0].isSession() ? string2 + ", session" : string2 + ", " + this.fArgumentList[0].getName();
        }
        for (n = 1; n < this.fArgumentList.length; ++n) {
            string2 = string2 + ", " + this.fArgumentList[n].getName();
        }
        string2 = string2 + ");\n\n";
        for (n = 0; n < this.fArgumentList.length; ++n) {
            if (!this.fArgumentList[n].isOutput()) continue;
            string2 = string2 + this.fArgumentList[n].getName() + " = ";
            string2 = this.fArgumentList[n].isString() ? string2 + "strtrim(char(" + this.fArgumentList[n].getName() + ".Value));\n" : (this.fArgumentList[n].isStruct() ? string2 + this.fArgumentList[n].getName() + ";\n" : string2 + "double(" + this.fArgumentList[n].getName() + ".Value);\n");
        }
        string2 = string2 + this.writeErrorCheckCode(FUNCTION);
        return string2;
    }

    public String getPropertyGetMCode() {
        String string = "function propertyValue = getProperty(obj, propertyName)\n\n";
        string = string + this.writeSessionLibnameCode();
        string = string + "\n[status, propertyValue] = calllib(libname, '" + this.fDriverPrefix + "_" + this.getName() + "', session, 0);\n\n";
        string = string + this.writeErrorCheckCode(GET_PROPERTY);
        string = string + "propertyValue = double(propertyValue);";
        return string;
    }

    public String getPropertySetMCode() {
        String string = "function setProperty(obj, propertyName, propertyValue)\n\n";
        string = string + this.writeSessionLibnameCode();
        string = string + "\nstatus = calllib(libname, '" + this.fDriverPrefix + "_" + this.getName() + "', session, propertyValue);\n\n";
        string = string + this.writeErrorCheckCode(SET_PROPERTY);
        return string;
    }

    protected String writeSessionLibnameCode() {
        String string;
        if (this.fClassName.equalsIgnoreCase("parent")) {
            string = "libname = get(obj, 'DriverName');\n";
            string = string + "session = get(obj, 'Interface');\n";
        } else {
            string = "libname = get(get(obj, 'Parent'), 'DriverName');\n";
            string = string + "session = get(get(obj, 'Parent'), 'Interface');\n";
        }
        return string;
    }

    protected String writeErrorCheckCode(int n) {
        if (!sCheckForErrorsIsOn) {
            return "";
        }
        if (this.fDriverPrefix.equalsIgnoreCase("niscope") || this.fDriverPrefix.equalsIgnoreCase("nifgen")) {
            String string = "\nif (status < 0)";
            string = string + "\n\tprivateErrorHandling(  libname, '" + this.fDriverPrefix + "', session, status" + ");\n";
            string = string + "end\n";
            return string;
        }
        String string = "\nif (status < 0)\n";
        string = string + "\terrorMessage = libpointer('int8Ptr', repmat(10, 1, 512));\n";
        string = string + "\tstatus = calllib(libname, '" + this.fDriverPrefix + "_error_message', session, status, errorMessage);\n";
        string = string + "\n\tif (status < 0)\n";
        string = string + "\t\terror('Failed to interpret error message');\n";
        string = string + "\tend\n\n";
        string = string + "\terrorMessage = strtrim(char(errorMessage.Value));\n";
        string = n == SET_PROPERTY ? string + "\terror('The instrument returned an error while setting the property value.\\n%s', errorMessage)\n" : (n == GET_PROPERTY ? string + "\terror('The instrument returned an error while getting the property value.\\n%s', errorMessage)\n" : string + "\terror('The instrument returned an error while executing the function.\\n%s', errorMessage)\n");
        string = string + "end\n";
        return string;
    }
}

