/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.drivers;

import com.mathworks.jmi.types.MLArrayRef;
import com.mathworks.toolbox.instrument.device.drivers.ExternalDriver;
import com.mathworks.toolbox.instrument.device.drivers.xml.Parser;
import com.mathworks.toolbox.testmeas.util.TMException;

public class GenericDriver
extends ExternalDriver {
    protected String errorID = "";
    protected String errorMessage = "";
    protected boolean isOpen = false;

    public GenericDriver(Parser parser, String string) throws TMException {
        super(parser, string);
        this.driverNameWithPath = this.xmlParser.getDriverName();
        this.driverName = this.parseDriverName(this.driverNameWithPath);
    }

    @Override
    protected void validateDriverType() throws TMException {
        if (this.xmlParser.getDriverTypeId() != 4) {
            throw new TMException("The driver must be a MATLAB generic instrument driver.");
        }
    }

    @Override
    public Object[] defineConstructorArgs() {
        if (this.resourceName.length() == 0) {
            Object[] objectArray = new Object[]{this.driverName};
            return objectArray;
        }
        Object[] objectArray = new Object[]{this.driverName, this.resourceName};
        return objectArray;
    }

    @Override
    public String defineConstructor() {
        if (this.resourceName.length() == 0) {
            return "icdevice('" + this.driverName + "');";
        }
        return "icdevice('" + this.driverName + "', '" + this.resourceName + "');";
    }

    @Override
    public String defineConstructorDescription() {
        if (this.resourceName.length() == 0) {
            return "Driver - " + this.driverName;
        }
        return "Driver - " + this.driverName + ", " + "ResourceName - " + this.resourceName;
    }

    @Override
    public int defineDriverType() {
        return 4;
    }

    @Override
    public int getStatusBasedOnInterface() {
        if (this.isOpen) {
            return 1;
        }
        return 0;
    }

    @Override
    public void setInstrumentModel(String string) throws TMException {
        this.instrumentModel = string;
    }

    @Override
    public void open() throws TMException {
        this.isOpen = true;
    }

    @Override
    public void close() throws TMException {
        this.isOpen = false;
    }

    @Override
    public void dispose() throws TMException {
        this.deviceMLObject.dispose();
    }

    public void SetErrorMessage(String string) {
        this.errorMessage = string;
    }

    @Override
    public String getError() throws TMException {
        String string = "";
        string = this.errorMessage;
        return string;
    }

    @Override
    public void hwreset() throws TMException {
        throw new TMException("devicereset is not a supported function for generic driver.");
    }

    @Override
    public String selftest() throws TMException {
        throw new TMException("selftest is not a supported function for generic driver.");
    }

    public MLArrayRef getInterfaceObject() {
        return null;
    }

    @Override
    public String getInterfaceConstructor() {
        return "";
    }
}

