/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.browser.ivicWrapper;

import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTabbedPane;
import com.mathworks.toolbox.instrument.browser.InstrumentControlBrowser;
import com.mathworks.toolbox.instrument.browser.deviceobj.DeviceObjectResultsExporter;
import com.mathworks.toolbox.instrument.browser.driver.DriverPage;
import com.mathworks.toolbox.instrument.browser.ivicWrapper.IVICInstrumentMCode;
import com.mathworks.toolbox.instrument.browser.ivicWrapper.IviCInstrumentObject;
import com.mathworks.toolbox.instrument.browser.ivicWrapper.IviCInstrumentObjectListener;
import com.mathworks.toolbox.instrument.browser.ivicWrapper.IviCInstrumentObjectStore;
import com.mathworks.toolbox.instrument.device.drivers.xml.XmlTreeElement;
import com.mathworks.toolbox.instrument.guiutil.ICSaveDialog;
import com.mathworks.toolbox.instrument.util.ICUtil;
import com.mathworks.toolbox.testmeas.browser.BrowserTreeNode;
import com.mathworks.widgets.SyntaxTextPane;
import com.mathworks.widgets.SyntaxTextPaneBase;
import com.mathworks.widgets.text.mcode.MLanguage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class IviCInstrumentObjectPage
extends DriverPage
implements ActionListener,
TreeSelectionListener,
IviCInstrumentObjectListener,
ItemListener,
ChangeListener {
    private static final long serialVersionUID = 1L;
    private InstrumentControlBrowser browser = null;
    private MJButton fExecuteButton;
    private MJButton fGetPropertyButton;
    private MJButton fSetPropertyButton;
    private MJButton fSaveButton;
    private MJButton fConnectButton;
    private MJButton fDisconnectButton;
    private MJButton fExportButton;
    private MJLabel fResourceLabel;
    private MJLabel fTypeLabel;
    private JEditorPane fResponsePane;
    private JScrollPane fDriverTreePane;
    private FunctionPanel fFunctionpanel;
    private PropertyPanel fPropertypanel;
    private JEditorPane fDriverHelpPane;
    private JPanel fMethodAndPropertyContainer;
    private MJTabbedPane tabPanel;
    private final int GROUP = 1;
    private final int PROPERTY = 2;
    private final int METHOD = 3;
    private String currentSelection;
    private static final String ACTION = "ACTION";
    private static final int SAVE = 1;
    private static final int EXECUTE = 2;
    private static final int CONNECT = 3;
    private static final int DISCONNECT = 4;
    private static final int GETPROPERTY = 5;
    private static final int SETPROPERTY = 6;
    private static final int EXPORT = 7;
    private static final int SESSIONLOGTAB = 1;
    private IviCInstrumentObject currentIvicInstrumentObj = null;
    private TreePath selectedTreePath;
    private SyntaxTextPane MCodeTextArea;
    private JComponent MCodeTextAreaPane;

    public IviCInstrumentObjectPage(InstrumentControlBrowser instrumentControlBrowser) {
        this.browser = instrumentControlBrowser;
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.layoutPanel();
    }

    public InstrumentControlBrowser getInstrumentControlBrowser() {
        return this.browser;
    }

    public MJPanel createHeadingPanel() {
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout(13, 0));
        mJPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 4, 0));
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new GridLayout(3, 1, 0, 4));
        mJPanel2.add((Component)new MJLabel(sResources.getString("IviCInstrumentObjectPage.InstrumentType")));
        mJPanel2.add((Component)new MJLabel(sResources.getString("IviCInstrumentObjectPage.Driver")));
        mJPanel2.add((Component)new MJLabel(sResources.getString("IviCInstrumentObjectPage.Resource")));
        MJPanel mJPanel3 = new MJPanel((LayoutManager)new GridLayout(3, 1, 0, 4));
        this.fTypeLabel = new MJLabel();
        this.fResourceLabel = new MJLabel();
        this.driverLabel = new MJLabel();
        mJPanel3.add((Component)this.fTypeLabel);
        mJPanel3.add((Component)this.driverLabel);
        mJPanel3.add((Component)this.fResourceLabel);
        MJPanel mJPanel4 = new MJPanel((LayoutManager)new BorderLayout(4, 0));
        MJCheckBox mJCheckBox = new MJCheckBox(sResources.getString("IviCInstrumentObjectPage.Simulate"));
        mJPanel4.add((Component)mJCheckBox, (Object)"North");
        MJPanel mJPanel5 = new MJPanel((LayoutManager)new GridLayout(1, 2, 4, 0));
        this.fConnectButton = new MJButton(sResources.getString("IviCInstrumentObjectPage.Connect"));
        this.fConnectButton.putClientProperty((Object)ACTION, (Object)new Integer(3));
        this.fConnectButton.addActionListener((ActionListener)this);
        this.fDisconnectButton = new MJButton(sResources.getString("IviCInstrumentObjectPage.Disconnect"));
        this.fDisconnectButton.putClientProperty((Object)ACTION, (Object)new Integer(4));
        this.fDisconnectButton.addActionListener((ActionListener)this);
        mJPanel5.add((Component)this.fConnectButton);
        mJPanel5.add((Component)this.fDisconnectButton);
        mJPanel4.add((Component)mJPanel5, (Object)"Center");
        mJPanel.add((Component)mJPanel2, (Object)"West");
        mJPanel.add((Component)mJPanel3, (Object)"Center");
        mJPanel.add((Component)mJPanel4, (Object)"East");
        mJPanel.setBorder((Border)BorderFactory.createTitledBorder("Summary"));
        return mJPanel;
    }

    private void layoutPanel() {
        this.add((Component)this.createHeadingPanel(), "North");
        this.tabPanel = new MJTabbedPane();
        this.tabPanel.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        this.tabPanel.addChangeListener((ChangeListener)this);
        this.fDriverTreePane = this.createDriverTreeView();
        this.fDriverTreePane.setMinimumSize(this.fDriverTreePane.getPreferredSize());
        JSplitPane jSplitPane = new JSplitPane(1, this.fDriverTreePane, this.createHelpPanel());
        jSplitPane.setDividerLocation(400);
        this.fMethodAndPropertyContainer = new JPanel();
        this.fFunctionpanel = new FunctionPanel(this);
        this.fPropertypanel = new PropertyPanel(this);
        ICUtil.addComponent(this.fMethodAndPropertyContainer, this.fFunctionpanel, 0, 0, 1.0, 0.0, 1, 1, 2, new Insets(4, 4, 4, 4), 17);
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        jPanel.add((Component)this.fMethodAndPropertyContainer, "West");
        JSplitPane jSplitPane2 = new JSplitPane(0, jPanel, this.createResponsePanel());
        JPanel jPanel2 = new JPanel(new BorderLayout(4, 0));
        jPanel2.add((Component)jSplitPane, "Center");
        JSplitPane jSplitPane3 = new JSplitPane(0, jPanel2, jSplitPane2);
        this.tabPanel.add("Functions", (Component)jSplitPane3);
        this.tabPanel.add("Session Log", (Component)this.createSessionLogPanel());
        this.add((Component)this.tabPanel, "Center");
    }

    private JPanel createHelpPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(0, 10));
        this.fDriverHelpPane = new JEditorPane();
        this.fDriverHelpPane.setEditorKit(this.fDriverHelpPane.getEditorKitForContentType("text/html"));
        this.fDriverHelpPane.setText("<html></html>");
        this.fDriverHelpPane.setBorder(BorderFactory.createLoweredBevelBorder());
        JScrollPane jScrollPane = new JScrollPane(this.fDriverHelpPane);
        jScrollPane.setPreferredSize(new Dimension(100, 100));
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private MJPanel createSessionLogPanel() {
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout(0, 0));
        mJPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.MCodeTextArea = new SyntaxTextPane();
        this.MCodeTextArea.setContentType(MLanguage.M_MIME_TYPE);
        this.MCodeTextArea.setEditable(false);
        this.MCodeTextArea.setShowLineNumbers(true, true);
        this.MCodeTextArea.setName("MCode TextArea");
        this.MCodeTextAreaPane = SyntaxTextPane.getDisplayComponent((SyntaxTextPaneBase)this.MCodeTextArea);
        mJPanel.add((Component)this.MCodeTextAreaPane, (Object)"Center");
        this.MCodeTextAreaPane.setPreferredSize(new Dimension(100, 100));
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new FlowLayout(0, 0, 0));
        mJPanel2.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        this.fSaveButton = new MJButton(sResources.getString("IviCInstrumentObjectPage.SaveSession"));
        this.fSaveButton.putClientProperty((Object)ACTION, (Object)new Integer(1));
        this.fSaveButton.addActionListener((ActionListener)this);
        mJPanel2.add((Component)this.fSaveButton);
        mJPanel.add((Component)mJPanel2, (Object)"South");
        return mJPanel;
    }

    private JPanel createResponsePanel() {
        JPanel jPanel = new JPanel(new BorderLayout(0, 10));
        jPanel.setBorder(BorderFactory.createTitledBorder("Response"));
        this.fResponsePane = new JEditorPane();
        this.fResponsePane.setEditorKit(this.fResponsePane.getEditorKitForContentType("text/html"));
        this.fResponsePane.setText("<html></html>");
        this.fResponsePane.setBorder(BorderFactory.createLoweredBevelBorder());
        this.fResponsePane.setName("Output window");
        JScrollPane jScrollPane = new JScrollPane(this.fResponsePane);
        jPanel.add((Component)jScrollPane, "Center");
        this.fExportButton = new MJButton(sResources.getString("IviCInstrumentObjectPage.Export"));
        this.fExportButton.setName("Export Button");
        this.fExportButton.setEnabled(false);
        this.fExportButton.putClientProperty((Object)ACTION, (Object)new Integer(7));
        this.fExportButton.addActionListener((ActionListener)this);
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 0, 0));
        jPanel2.add((Component)this.fExportButton);
        jPanel.add((Component)jPanel2, "South");
        jPanel.setMinimumSize(jPanel.getPreferredSize());
        return jPanel;
    }

    private JScrollPane createDriverTreeView() {
        JScrollPane jScrollPane = new JScrollPane();
        return jScrollPane;
    }

    private void updateSessionLog() {
        int n = this.MCodeTextArea.getCaretPosition();
        String string = this.currentIvicInstrumentObj.getMcode();
        if (string == null) {
            this.MCodeTextArea.setText("");
            return;
        }
        if (string.length() > 0) {
            this.fSaveButton.setEnabled(true);
        } else {
            this.fSaveButton.setEnabled(false);
        }
        this.MCodeTextArea.setText(string);
        if (n < 0 || n > string.length()) {
            n = 0;
        }
        this.MCodeTextArea.setCaretPosition(n);
    }

    @Override
    public void update(BrowserTreeNode browserTreeNode) {
        String string = browserTreeNode.getName();
        this.currentIvicInstrumentObj = IviCInstrumentObjectStore.getIviCInstrumentObject(string);
        this.driverLabel.setText(this.currentIvicInstrumentObj.getDriverName());
        this.fResourceLabel.setText(this.currentIvicInstrumentObj.getResource());
        this.fTypeLabel.setText(this.currentIvicInstrumentObj.fInstrumentType);
        if (this.currentIvicInstrumentObj.isConnected()) {
            this.fConnectButton.setEnabled(false);
            this.fDisconnectButton.setEnabled(true);
        } else {
            this.fConnectButton.setEnabled(true);
            this.fDisconnectButton.setEnabled(false);
        }
        this.showDriverStructure();
        this.updateOperationPanel();
        this.updateSessionLog();
    }

    private void updateOperationPanel() {
        boolean bl = this.currentIvicInstrumentObj.isConnected();
        if (bl) {
            this.fConnectButton.setEnabled(false);
            this.fDisconnectButton.setEnabled(true);
        } else {
            this.fConnectButton.setEnabled(true);
            this.fDisconnectButton.setEnabled(false);
        }
        this.selectedTreePath = this.currentIvicInstrumentObj.fIvicInstrumentObjTree.getSelectionPath();
        if (this.selectedTreePath == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.selectedTreePath.getLastPathComponent();
        Element element = (Element)((XmlTreeElement)defaultMutableTreeNode.getUserObject()).getXmlNode();
        TreePath treePath = this.currentIvicInstrumentObj.fIvicInstrumentObjTree.getSelectionPath();
        Object[] objectArray = treePath.getPath();
        if (objectArray.length == 1) {
            return;
        }
        this.currentSelection = "";
        for (int i = 1; i < objectArray.length; ++i) {
            this.currentSelection = this.currentSelection + "." + objectArray[i].toString();
        }
        this.currentSelection = this.currentSelection.substring(1);
        switch (this.getNodeType(element)) {
            case 1: {
                break;
            }
            case 3: {
                this.updatemethodAndPropertyContainer(this.fPropertypanel, this.fFunctionpanel);
                this.fFunctionpanel.updateUI(element, this.currentSelection);
                break;
            }
            case 2: {
                this.updatemethodAndPropertyContainer(this.fFunctionpanel, this.fPropertypanel);
                this.fPropertypanel.updateUI(element);
            }
        }
    }

    private void updatemethodAndPropertyContainer(JPanel jPanel, JPanel jPanel2) {
        this.fMethodAndPropertyContainer.remove(jPanel);
        ICUtil.addComponent(this.fMethodAndPropertyContainer, jPanel2, 1, 1, 1.0, 0.0, 1, 1, 2, new Insets(4, 0, 0, 0), 17);
        this.repaint();
    }

    private void showDriverStructure() {
        if (this.currentIvicInstrumentObj != null && this.currentIvicInstrumentObj.fIvicInstrumentObjTree != null) {
            this.fDriverTreePane.setViewportView(this.currentIvicInstrumentObj.fIvicInstrumentObjTree);
            return;
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JComponent jComponent = (JComponent)actionEvent.getSource();
        int n = (Integer)jComponent.getClientProperty(ACTION);
        this.fExportButton.setEnabled(false);
        switch (n) {
            case 2: {
                this.fResponsePane.setText(null);
                this.currentIvicInstrumentObj.executeMethod(this.fFunctionpanel.getOutArgs(), this.currentSelection, this.fFunctionpanel.getInArgs());
                break;
            }
            case 5: {
                this.fResponsePane.setText(null);
                this.currentIvicInstrumentObj.getDriverProp(this.currentSelection);
                break;
            }
            case 6: {
                this.fResponsePane.setText(null);
                this.currentIvicInstrumentObj.setDriverProp(this.currentSelection, this.fPropertypanel.getInArgs());
                break;
            }
            case 3: {
                this.currentIvicInstrumentObj.connect();
                break;
            }
            case 4: {
                this.currentIvicInstrumentObj.disconnect();
                break;
            }
            case 7: {
                IVICInstrumentMCode iVICInstrumentMCode = this.currentIvicInstrumentObj.getLastInvokeMCode();
                if (iVICInstrumentMCode == null) {
                    return;
                }
                this.fExportButton.setEnabled(true);
                MJFrame mJFrame = (MJFrame)SwingUtilities.windowForComponent((Component)((Object)this));
                new DeviceObjectResultsExporter(iVICInstrumentMCode).showAsDialog(mJFrame);
                break;
            }
            case 1: {
                this.saveMCode();
            }
        }
    }

    public void saveMCode() {
        if (!ICSaveDialog.save(".m", "Save Session Log", "MATLAB Files (*.m)", new MJFrame())) {
            return;
        }
        String string = ICSaveDialog.getFileName();
        String string2 = ICSaveDialog.getFileNameWithPath();
        try {
            File file = new File(string2);
            file.delete();
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            randomAccessFile.writeBytes(this.currentIvicInstrumentObj.getMcode() + "\n");
            randomAccessFile.close();
        }
        catch (IOException iOException) {
            System.out.println("Exception: " + iOException.getMessage());
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.fResponsePane.setText(null);
        this.selectedTreePath = treeSelectionEvent.getNewLeadSelectionPath();
        if (this.selectedTreePath == null) {
            return;
        }
        this.updateOperationPanel();
    }

    private int getNodeType(Element element) {
        String string = element.getAttribute("type");
        if (string.length() == 0) {
            return 0;
        }
        return Integer.parseInt(string);
    }

    @Override
    public void updateIviCInstrumentObjectStatus(String string) {
        this.browser.postBlockEventsEvent(false);
        if (string.equals("ConnectionStatus")) {
            this.updateOperationPanel();
        } else if (string.equals("EnableExport")) {
            this.fExportButton.setEnabled(true);
        } else {
            this.fResponsePane.setText(string);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.currentIvicInstrumentObj.fSimulate = itemEvent.getStateChange() == 1;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        switch (this.tabPanel.getSelectedIndex()) {
            case 1: {
                this.updateSessionLog();
            }
        }
    }

    private class PropertyPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JLabel objectLabel;
        private JLabel propertyDefinition;
        private JLabel inputArgLabel;
        private JTextField inputArgTextField;
        private IviCInstrumentObjectPage parent;

        public PropertyPanel(IviCInstrumentObjectPage iviCInstrumentObjectPage2) {
            this.parent = iviCInstrumentObjectPage2;
            this.setLayout(new BorderLayout(0, 0));
            this.layoutPanel();
        }

        public String getInArgs() {
            return this.inputArgTextField.getText().trim();
        }

        public void updateUI(Element element) {
            this.inputArgTextField.setText("");
            boolean bl = IviCInstrumentObjectPage.this.currentIvicInstrumentObj.isConnected();
            IviCInstrumentObjectPage.this.fGetPropertyButton.setEnabled(bl);
            this.propertyDefinition.setText(IviCInstrumentObjectPage.this.currentSelection);
            boolean bl2 = !this.isReadOnlyProperty(element);
            this.inputArgTextField.setEnabled(bl && bl2);
            IviCInstrumentObjectPage.this.fSetPropertyButton.setEnabled(bl && bl2);
            String string = "";
            NodeList nodeList = element.getChildNodes();
            if (nodeList != null) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    String string2 = nodeList.item(i).getNodeName();
                    if (!string2.equals("description")) continue;
                    string = nodeList.item(i).getTextContent();
                }
                this.parent.fDriverHelpPane.setText(string);
            }
        }

        private void layoutPanel() {
            JPanel jPanel = new JPanel(new BorderLayout(4, 0));
            this.objectLabel = new JLabel(sResources.getString("IviCInstrumentObjectPage.Property"));
            this.inputArgLabel = new JLabel(sResources.getString("IviCInstrumentObjectPage.PropertyValue"));
            this.objectLabel.setVerticalAlignment(1);
            this.inputArgLabel.setVerticalAlignment(1);
            JPanel jPanel2 = new JPanel(new GridLayout(3, 1, 0, 2));
            jPanel2.add(this.objectLabel);
            jPanel2.add(this.inputArgLabel);
            this.propertyDefinition = new JLabel();
            this.inputArgTextField = new JTextField(20);
            JPanel jPanel3 = new JPanel(new GridLayout(3, 1, 0, 2));
            jPanel3.add(this.propertyDefinition);
            jPanel3.add(this.inputArgTextField);
            jPanel.add((Component)jPanel2, "West");
            jPanel.add((Component)jPanel3, "Center");
            JPanel jPanel4 = new JPanel(new FlowLayout(0, 4, 0));
            IviCInstrumentObjectPage.this.fGetPropertyButton = new MJButton(sResources.getString("IviCInstrumentObjectPage.GetProperty"));
            IviCInstrumentObjectPage.this.fGetPropertyButton.putClientProperty((Object)IviCInstrumentObjectPage.ACTION, (Object)new Integer(5));
            IviCInstrumentObjectPage.this.fGetPropertyButton.addActionListener((ActionListener)this.parent);
            IviCInstrumentObjectPage.this.fSetPropertyButton = new MJButton(sResources.getString("IviCInstrumentObjectPage.SetProperty"));
            IviCInstrumentObjectPage.this.fSetPropertyButton.putClientProperty((Object)IviCInstrumentObjectPage.ACTION, (Object)new Integer(6));
            IviCInstrumentObjectPage.this.fSetPropertyButton.addActionListener((ActionListener)this.parent);
            jPanel4.add((Component)IviCInstrumentObjectPage.this.fGetPropertyButton);
            jPanel4.add((Component)IviCInstrumentObjectPage.this.fSetPropertyButton);
            this.add((Component)jPanel, "North");
            this.add((Component)jPanel4, "Center");
        }

        private boolean isReadOnlyProperty(Element element) {
            String string = element.getAttribute("access");
            return string.equalsIgnoreCase("R");
        }
    }

    private class FunctionPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JLabel objectLabel;
        private JLabel functionDefinition;
        private JLabel inputArgLabel;
        private JTextField inputArgTextField;
        private JLabel outputArgLabel;
        private JTextField outputArgTextField;
        private IviCInstrumentObjectPage parent;

        public FunctionPanel(IviCInstrumentObjectPage iviCInstrumentObjectPage2) {
            this.parent = iviCInstrumentObjectPage2;
            this.setLayout(new BorderLayout(0, 0));
            this.layoutPanel();
        }

        public String getOutArgs() {
            return this.outputArgTextField.getText().trim();
        }

        public String getInArgs() {
            return this.inputArgTextField.getText().trim();
        }

        private void layoutPanel() {
            JPanel jPanel = new JPanel(new BorderLayout(4, 0));
            this.objectLabel = new JLabel(sResources.getString("IviCInstrumentObjectPage.Method"));
            this.inputArgLabel = new JLabel(sResources.getString("IviCInstrumentObjectPage.InputArgs"));
            this.outputArgLabel = new JLabel(sResources.getString("IviCInstrumentObjectPage.OutputArgs"));
            this.objectLabel.setVerticalAlignment(1);
            this.inputArgLabel.setVerticalAlignment(1);
            this.outputArgLabel.setVerticalAlignment(1);
            JPanel jPanel2 = new JPanel(new GridLayout(3, 1, 0, 2));
            jPanel2.add(this.objectLabel);
            jPanel2.add(this.inputArgLabel);
            jPanel2.add(this.outputArgLabel);
            this.functionDefinition = new JLabel();
            this.inputArgTextField = new JTextField(40);
            this.inputArgTextField.setEnabled(false);
            this.outputArgTextField = new JTextField(40);
            this.outputArgTextField.setEnabled(false);
            JPanel jPanel3 = new JPanel(new GridLayout(3, 1, 0, 2));
            jPanel3.add(this.functionDefinition);
            jPanel3.add(this.inputArgTextField);
            jPanel3.add(this.outputArgTextField);
            jPanel.add((Component)jPanel2, "West");
            jPanel.add((Component)jPanel3, "Center");
            JPanel jPanel4 = new JPanel(new FlowLayout(0, 0, 0));
            IviCInstrumentObjectPage.this.fExecuteButton = new MJButton(sResources.getString("IviCInstrumentObjectPage.Execute"));
            IviCInstrumentObjectPage.this.fExecuteButton.putClientProperty((Object)IviCInstrumentObjectPage.ACTION, (Object)new Integer(2));
            IviCInstrumentObjectPage.this.fExecuteButton.addActionListener((ActionListener)this.parent);
            jPanel4.add((Component)IviCInstrumentObjectPage.this.fExecuteButton);
            this.add((Component)jPanel, "North");
            this.add((Component)jPanel4, "Center");
        }

        public void updateUI(Element element, String string) {
            String string2;
            this.inputArgTextField.setText("");
            String string3 = "";
            String string4 = "";
            String string5 = "";
            NodeList nodeList = element.getChildNodes();
            if (nodeList != null) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    String string6 = nodeList.item(i).getNodeName();
                    if (string6.equals("description")) {
                        string3 = nodeList.item(i).getTextContent();
                        continue;
                    }
                    if (string6.equals("inputArgs")) {
                        string4 = nodeList.item(i).getTextContent();
                        continue;
                    }
                    if (!string6.equals("outputArgs")) continue;
                    string5 = nodeList.item(i).getTextContent();
                }
            }
            if (string5.length() > 0) {
                string2 = string5 + "= " + string;
                this.outputArgTextField.setEnabled(IviCInstrumentObjectPage.this.currentIvicInstrumentObj.isConnected());
            } else {
                string2 = string;
            }
            if (string4.length() > 0) {
                string2 = string2 + "( " + string4 + " )";
                this.inputArgTextField.setEnabled(IviCInstrumentObjectPage.this.currentIvicInstrumentObj.isConnected());
            } else {
                string2 = string2 + "()";
            }
            this.outputArgTextField.setText(string5);
            this.functionDefinition.setText(string2);
            IviCInstrumentObjectPage.this.fExecuteButton.setEnabled(IviCInstrumentObjectPage.this.currentIvicInstrumentObj.isConnected());
            this.parent.fDriverHelpPane.setText(string3);
        }
    }
}

