/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.browser.hardware;

import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.toolbox.instrument.browser.InstrumentControlBrowser;
import com.mathworks.toolbox.instrument.browser.InstrumentControlBrowserPage;
import com.mathworks.toolbox.instrument.browser.hardware.BoardPage;
import com.mathworks.toolbox.instrument.browser.interfaceobj.CommunicationInfo;
import com.mathworks.toolbox.instrument.browser.interfaceobj.CommunicationPage;
import com.mathworks.toolbox.instrument.browser.objects.BrowserObject;
import com.mathworks.toolbox.instrument.browser.objects.GPIBVXIObject;
import com.mathworks.toolbox.instrument.browser.objects.VXIObject;
import com.mathworks.toolbox.testmeas.browser.BrowserClient;
import com.mathworks.toolbox.testmeas.browser.BrowserTreeNode;
import javax.swing.JPanel;
import org.w3c.dom.Element;

public class VXIChassisPage
extends BoardPage {
    private static final long serialVersionUID = 1L;

    public VXIChassisPage(InstrumentControlBrowser instrumentControlBrowser, String string, String string2, String string3, String string4) {
        super(instrumentControlBrowser, string, string2, string3, string4);
        this.init();
    }

    @Override
    protected void init() {
        this.statusMessage = "Scanning for VXI instruments";
        this.headings = new String[2];
        this.headings[0] = "Logical Address";
        this.headings[1] = "Identification";
        super.init();
    }

    @Override
    public void load(String string, String string2, String string3, Element element) {
        String string4 = element.getAttribute("LogicalAddress");
        String string5 = element.getAttribute("Identification");
        Object[] objectArray = new Object[]{string4, string5};
        this.tableModel.append(objectArray);
        this.data = this.tableModel.getData();
        String string6 = "LA-" + string4;
        BrowserTreeNode browserTreeNode = this.createNode(string6, string, string3, string4, string5, string2);
        this.lastNodes.addElement(browserTreeNode);
    }

    @Override
    protected void constructDataArray(Object object, String string) {
        String[] stringArray = (String[])object;
        int n = 0;
        this.data = new Object[stringArray.length / 2][this.headings.length];
        String string2 = (String)this.matlabArgs[2];
        String string3 = (String)this.matlabArgs[3];
        if (this.data.length == 0) {
            this.data = new Object[1][this.headings.length];
            this.data[0][0] = "";
            this.data[0][1] = NO_INSTRUMENT_STRING;
            String string4 = "PAD-";
            BrowserTreeNode browserTreeNode = this.createNode(string4, string2, string3, "", NO_INSTRUMENT_STRING, string);
            this.currentNodes.add(browserTreeNode);
        } else {
            for (int i = 0; i < this.data.length; ++i) {
                this.data[i][0] = stringArray[n++];
                this.data[i][1] = stringArray[n++];
                String string5 = "LA-" + this.data[i][0];
                BrowserTreeNode browserTreeNode = this.createNode(string5, string2, string3, (String)this.data[i][0], (String)this.data[i][1], string);
                this.currentNodes.add(browserTreeNode);
            }
        }
        this.cleanupNodes();
    }

    private BrowserTreeNode createNode(String string, String string2, String string3, String string4, String string5, String string6) {
        String string7 = this.defineNodeIDString(string5);
        BrowserTreeNode browserTreeNode = this.browser.getNode(this.path, string);
        if (string5.equals(NO_INSTRUMENT_STRING)) {
            if (browserTreeNode == null) {
                browserTreeNode = new BrowserTreeNode(string + string7, (BrowserClient)this.browser);
                browserTreeNode.setType(16);
                if (this.path[2].equals("VXI")) {
                    browserTreeNode.setHelpDirectoryAndPage("instrument", "tmtool_csh\\vxi_instrument.html");
                    browserTreeNode.setHelpMapAndAnchorTag(MLHelpServices.getDocRoot() + "/toolbox/instrument/instrument.map", "vxi_config");
                } else {
                    browserTreeNode.setHelpDirectoryAndPage("instrument", "tmtool_csh\\gpib_vxi_instrument.html");
                    browserTreeNode.setHelpMapAndAnchorTag(MLHelpServices.getDocRoot() + "/toolbox/instrument/instrument.map", "gpib_vxi_comm");
                }
                browserTreeNode.setPanel((JPanel)((Object)new InstrumentControlBrowserPage()));
                browserTreeNode.setUserData((Object)new Integer(NO_INSTRUMENT_NODE_COUNT++));
                this.browser.addNode(string, this.path, browserTreeNode);
            }
        } else if (browserTreeNode == null) {
            browserTreeNode = new BrowserTreeNode(string + string7, (BrowserClient)this.browser);
            BrowserObject browserObject = this.createBrowserObject(string2, string3, string4, string5, string6);
            browserTreeNode.setType(4);
            CommunicationPage communicationPage = CommunicationPage.getInstance(this.browser);
            CommunicationInfo communicationInfo = new CommunicationInfo(browserObject);
            this.browser.addToCommunicationInfoStore(communicationInfo);
            browserObject.setPanel(communicationPage);
            browserTreeNode.setPanel((JPanel)((Object)communicationPage));
            browserTreeNode.setUserData((Object)communicationInfo);
            this.browser.addNode(string, this.path, browserTreeNode);
            if (this.path[2].equals("VXI")) {
                browserTreeNode.setHelpDirectoryAndPage("instrument", "tmtool_csh\\vxi_instrument.html");
                browserTreeNode.setHelpMapAndAnchorTag(MLHelpServices.getDocRoot() + "/toolbox/instrument/instrument.map", "vxi_config");
            } else {
                browserTreeNode.setHelpDirectoryAndPage("instrument", "tmtool_csh\\gpib_vxi_instrument.html");
                browserTreeNode.setHelpMapAndAnchorTag(MLHelpServices.getDocRoot() + "/toolbox/instrument/instrument.map", "gpib_vxi_comm");
            }
        } else {
            CommunicationInfo communicationInfo = (CommunicationInfo)browserTreeNode.getUserData();
            BrowserObject browserObject = communicationInfo.getBrowserObject();
            browserObject.setIdentification(string5);
            browserObject.setScanDate(string6);
            browserTreeNode.setName(string + string7);
        }
        return browserTreeNode;
    }

    private BrowserObject createBrowserObject(String string, String string2, String string3, String string4, String string5) {
        if (this.path[2].equals("VXI")) {
            return new VXIObject(string, string2, string3, string4, string5);
        }
        return new GPIBVXIObject(string, string2, string3, string4, string5);
    }
}

