/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.browser.hardware;

import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.toolbox.instrument.browser.InstrumentControlBrowser;
import com.mathworks.toolbox.instrument.browser.hardware.ProtocolPage;
import com.mathworks.toolbox.instrument.browser.hardware.VXIChassisPage;
import com.mathworks.toolbox.testmeas.browser.BrowserClient;
import com.mathworks.toolbox.testmeas.browser.BrowserTreeNode;
import javax.swing.JPanel;
import org.w3c.dom.Element;

public class GPIBVXIPage
extends ProtocolPage {
    private static final long serialVersionUID = 1L;

    public GPIBVXIPage(InstrumentControlBrowser instrumentControlBrowser) {
        super(instrumentControlBrowser);
        this.init();
    }

    @Override
    protected void init() {
        this.headings[1] = "Chassis Index";
        this.path[2] = "GPIB-VXI";
        this.matlabArgs[1] = "identifyGPIBVXI";
        this.panelTitle = "Installed GPIB-VXI Chassis";
        this.statusMessage = "Scanning for GPIB-VXI chassis";
        super.init();
    }

    @Override
    protected void constructDataArray(Object object, String string) {
        String[] stringArray = (String[])object;
        int n = 0;
        this.data = new Object[stringArray.length / 2][this.headings.length];
        if (this.data.length == 0) {
            this.data = new Object[1][this.headings.length];
            this.data[0][0] = "No chassis were found";
            this.data[0][1] = "";
            this.cleanupNodes();
            return;
        }
        for (int i = 0; i < this.data.length; ++i) {
            String string2 = stringArray[n++];
            this.data[i][0] = this.createVendorStr(string2);
            this.data[i][1] = stringArray[n++];
            String string3 = "Chassis-" + this.data[i][1];
            BrowserTreeNode browserTreeNode = this.createNode(string3, string2, (String)this.data[i][1]);
            this.currentNodes.add(browserTreeNode);
        }
        this.cleanupNodes();
    }

    private BrowserTreeNode createNode(String string, String string2, String string3) {
        BrowserTreeNode browserTreeNode = this.browser.getNode(this.path, string);
        if (browserTreeNode == null) {
            browserTreeNode = new BrowserTreeNode(string, (BrowserClient)this.browser);
            browserTreeNode.setTag("Scan for GPIB-VXI instruments");
            browserTreeNode.setType(3);
            VXIChassisPage vXIChassisPage = new VXIChassisPage(this.browser, string, string2, string3, "GPIB-VXI");
            browserTreeNode.setPanel((JPanel)((Object)vXIChassisPage));
            this.pages.addElement(vXIChassisPage);
            this.browser.addNode(string, this.path, browserTreeNode);
        } else {
            VXIChassisPage vXIChassisPage = (VXIChassisPage)((Object)browserTreeNode.getPanel());
            this.pages.addElement(vXIChassisPage);
        }
        browserTreeNode.setHelpDirectoryAndPage("instrument", "tmtool_csh\\gpib_vxi_chassis.html");
        browserTreeNode.setHelpMapAndAnchorTag(MLHelpServices.getDocRoot() + "/toolbox/instrument/instrument.map", "gpib_vxi_chassis");
        return browserTreeNode;
    }

    @Override
    protected void createNodeOnLoad(String string, String string2) {
        String string3 = this.extractVendorAbbrv(string);
        String string4 = "Chassis-" + string2;
        BrowserTreeNode browserTreeNode = this.createNode(string4, string3, string2);
        this.lastNodes.addElement(browserTreeNode);
    }

    @Override
    protected void createInstrumentNodeOnLoad(String string, String string2, String string3, Element element) {
        String string4 = "Chassis-" + string2;
        BrowserTreeNode browserTreeNode = this.browser.getNode(this.path, string4);
        ((VXIChassisPage)((Object)browserTreeNode.getPanel())).load(string, string3, string2, element);
    }
}

