/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument;

import com.mathworks.toolbox.instrument.ASCIITableConverter;
import com.mathworks.toolbox.instrument.BinarySwapBytes;
import com.mathworks.toolbox.instrument.InstrumentAsync;
import com.mathworks.toolbox.instrument.VISA;
import com.mathworks.toolbox.testmeas.util.TMException;

public abstract class Vxi
extends InstrumentAsync {
    protected static final int NONE = 0;
    protected static final int READ = 1;
    protected static final String[] EOSMODES = new String[]{"none", "read", "write", "read&write"};
    protected static final int FIFO = 0;
    protected static final int BLOCK = 1;
    protected static final String[] MEMINC = new String[]{"FIFO", "block"};
    protected static final int A16 = 0;
    protected static final int A16_A24 = 1;
    protected static final int A16_A32 = 2;
    protected static final int EOIMODE = 200;
    protected static final int EOSMODE = 201;
    protected static final int INTERRUPTACTION = 202;
    protected static final int TIMEOUT = 203;
    protected static final int TRIGGERACTION = 204;
    protected static final int TRIGGERLINE = 205;
    protected static final int MEMORY_BASE = 206;
    protected static final int MEMORY_SIZE = 207;
    protected static final int MEMORY_SPACE = 208;
    protected static final int SLOT = 209;
    protected static final int BOARDINDEX = 210;
    protected static final int PRIMARY_ADDRESS = 211;
    protected static final int SECONDARY_ADDRESS = 212;
    protected static final int MEMORY_INCREMENT = 213;
    protected static final int ADAPTOR_DLL_NAME = 0;
    protected static final int ADAPTOR_DLL_VERSION = 1;
    protected static final int ADAPTOR_NAME = 2;
    protected static final int VENDOR_DRIVER_NAME = 3;
    protected static final int VENDOR_DRIVER_DESCRIPTION = 4;
    protected static final int VENDOR_DRIVER_VERSION = 5;
    protected static final String[] HWINFO_FIELDS = new String[]{"adaptordllname", "adaptordllversion", "adaptorname", "vendordllname", "vendordriverdescription", "vendordriverversion"};
    protected static final String[] ADDRESS_SPACE_DESC = new String[]{"A16", "A24", "A32"};
    protected static final int SUCCESS = 0;
    protected String alias = "";
    protected int chassisIndex = 0;
    protected int compareBits = 8;
    protected boolean eoiMode = true;
    protected int eosCharCode = 10;
    protected int eosMode = 0;
    protected int logicalAddress = 0;
    protected String mappedMemoryBase = "0H";
    protected int mappedMemorySize = 0;
    protected String memoryBase = "0H";
    protected int memoryIncrement = 1;
    protected int memorySize = 0;
    protected int memorySpace = 0;
    protected String rsrcName = "";
    protected int slot = 0;
    protected VISA visaobj;
    protected String visaName;
    protected boolean useAlias;
    protected byte[] eosCharByteArray = new byte[1];
    protected Object eosCharCodeObject = "LF";
    protected long address = 0L;
    protected int mappedMemorySpace = 0;
    protected Object[] info = new Object[6];
    protected int readId = 0;
    protected int writeId = 0;
    protected int oldTransferStatus = 0;
    protected boolean objectPolls = false;
    protected static final Object[] comVals = new Object[]{new Double(8.0)};
    protected static final String[] dModeVals = new String[]{"eosCharCode", "byte"};
    protected static final Object[] eosCVals = new Object[]{new Double(0.0), new Double(255.0)};
    protected static final String[] EOSMVals = new String[]{"none", "read", "write", "read&write"};
    protected static final String[] MIncVals = new String[]{"block", "FIFO"};
    protected static final String[] MSpVals = new String[]{"A16", "A16/A24", "A16/A32"};
    protected static final String[] TranSVals = new String[]{"idle", "read", "write"};
    protected static final Object[] AsciiVals = new Object[]{eosCVals};

    public void setAlias(String string) throws TMException {
        Vxi.displayError(this.createReadOnlyPropertyError("Alias"));
    }

    public String getAlias() {
        return this.alias;
    }

    public void setChassisIndex(int n) throws TMException {
        if (this.useAlias) {
            Vxi.displayError("ChassisIndex cannot be set for a VISA object that has an alias.");
        }
        if (this.status == 1) {
            Vxi.displayError("ChassisIndex cannot be set while OBJ is open.");
        }
        this.chassisIndex = n;
        this.updateNameProperties();
        this.postPropertyChangedEvent("ChassisIndex", new Integer(this.chassisIndex));
    }

    public final int getChassisIndex() {
        return this.chassisIndex;
    }

    public final void setCompareBits(int n) throws TMException {
        if (n != 8) {
            Vxi.displayError("CompareBits could not be set to the specified value.");
        }
        this.compareBits = n;
        this.postPropertyChangedEvent("CompareBits", new Integer(this.compareBits));
    }

    public final int getCompareBits() {
        return this.compareBits;
    }

    public final void setEOIMode(boolean bl) throws TMException {
        if (this.status == 0) {
            this.eoiMode = bl;
            this.postPropertyChangedEvent("EOIMode", this.bool2OnOff(this.eoiMode));
            return;
        }
        try {
            this.setHardwareEOIMode(bl);
            this.eoiMode = bl;
            this.postPropertyChangedEvent("EOIMode", this.bool2OnOff(this.eoiMode));
        }
        catch (Exception exception) {
            Vxi.displayError(exception.getMessage());
        }
    }

    public final boolean getEOIMode() {
        return this.eoiMode;
    }

    public final void setEOSCharCode(Object object) throws TMException {
        int n = ASCIITableConverter.convertEOSObjectToInt(object);
        if (this.status == 0) {
            this.eosCharCode = n;
            this.eosCharByteArray[0] = (byte)n;
            this.eosCharCodeObject = object;
            return;
        }
        try {
            this.setHardwareEOSChar(n);
            this.eosCharCode = n;
            this.eosCharByteArray[0] = (byte)this.eosCharCode;
            this.eosCharCodeObject = object;
        }
        catch (Exception exception) {
            Vxi.displayError(exception.getMessage());
        }
    }

    public final Object getEOSCharCode() {
        return this.eosCharCodeObject;
    }

    public final void setEOSMode(int n) throws TMException {
        if (this.status == 0) {
            this.eosMode = n;
            this.postPropertyChangedEvent("EOSMode", EOSMODES[this.eosMode]);
            return;
        }
        try {
            this.setHardwareEOSMode(n);
            this.eosMode = n;
            this.postPropertyChangedEvent("EOSMode", EOSMODES[this.eosMode]);
        }
        catch (Exception exception) {
            Vxi.displayError(exception.getMessage());
        }
    }

    public final int getEOSMode() {
        return this.eosMode;
    }

    public void setLogicalAddress(int n) throws TMException {
        if (this.useAlias) {
            Vxi.displayError("LogicalAddress cannot be set for a VISA object that has an alias.");
        }
        if (this.status == 1) {
            Vxi.displayError("LogicalAddress cannot be set while OBJ is open.");
        }
        this.logicalAddress = n;
        this.updateNameProperties();
        this.postPropertyChangedEvent("LogicalAddress", new Integer(this.logicalAddress));
    }

    public int getLogicalAddress() {
        return this.logicalAddress;
    }

    public void setMappedMemoryBase(String string) throws TMException {
        Vxi.displayError(this.createReadOnlyPropertyError("MappedMemoryBase"));
    }

    public String getMappedMemoryBase() {
        return this.mappedMemoryBase;
    }

    public void setMappedMemorySize(int n) throws TMException {
        Vxi.displayError(this.createReadOnlyPropertyError("MappedMemorySize"));
    }

    public int getMappedMemorySize() {
        return this.mappedMemorySize;
    }

    public void setMemoryBase(String string) throws TMException {
        Vxi.displayError(this.createReadOnlyPropertyError("MemoryBase"));
    }

    public String getMemoryBase() {
        return this.memoryBase;
    }

    public void setMemoryIncrement(int n) throws TMException {
        if (this.status == 0) {
            this.memoryIncrement = n;
            this.postPropertyChangedEvent("MemoryIncrement", MEMINC[this.memoryIncrement]);
            return;
        }
        try {
            this.setHardwareMemoryIncrement(n);
            this.memoryIncrement = n;
            this.postPropertyChangedEvent("MemoryIncrement", MEMINC[this.memoryIncrement]);
        }
        catch (Exception exception) {
            Vxi.displayError(exception.getMessage());
        }
    }

    public int getMemoryIncrement() {
        return this.memoryIncrement;
    }

    public void setMemorySize(int n) throws TMException {
        Vxi.displayError(this.createReadOnlyPropertyError("MemorySize"));
    }

    public int getMemorySize() {
        return this.memorySize;
    }

    public void setMemorySpace(int n) throws TMException {
        Vxi.displayError(this.createReadOnlyPropertyError("MemorySpace"));
    }

    public int getMemorySpace() {
        return this.memorySpace;
    }

    public void setRsrcName(String string) throws TMException {
        Vxi.displayError(this.createReadOnlyPropertyError("RsrcName"));
    }

    public String getRsrcName() {
        return this.rsrcName;
    }

    public void setSlot(int n) throws TMException {
        Vxi.displayError(this.createReadOnlyPropertyError("Slot"));
    }

    public int getSlot() {
        return this.slot;
    }

    protected void setHardwareEOIMode(boolean bl) throws TMException {
        this.visaobj.setProperty(this.handle, 200, this.bool2int(bl));
    }

    protected void setHardwareEOSChar(int n) throws TMException {
        this.visaobj.setHardwareEOSChar(this.handle, 201, n, this.eosMode);
    }

    protected void setHardwareEOSMode(int n) throws TMException {
        this.visaobj.setHardwareEOSMode(this.handle, 201, n, this.eosCharCode);
    }

    protected void getHardwareMemoryBase() throws TMException {
        int n = this.visaobj.getProperty(this.handle, 206);
        this.memoryBase = Integer.toHexString(n) + "H";
    }

    protected void setHardwareMemoryIncrement(int n) throws TMException {
        this.visaobj.setProperty(this.handle, 213, n);
    }

    protected void getHardwareMemorySize() throws TMException {
        this.memorySize = this.visaobj.getProperty(this.handle, 207);
    }

    protected void getHardwareMemorySpace() throws TMException {
        int n = this.visaobj.getProperty(this.handle, 208);
        this.memorySpace = n - 1;
    }

    protected void getHardwareSlot() throws TMException {
        this.slot = this.visaobj.getProperty(this.handle, 209);
    }

    @Override
    protected void setHardwareTimeout(double d) throws TMException {
        this.visaobj.setHardwareTimeout(this.handle, d, 203);
    }

    @Override
    protected double getHardwareTimeout() {
        int n = this.visaobj.Get(this.handle, 203);
        return (double)n / 1000.0;
    }

    @Override
    public String[] getBrowserInfo() {
        String[] stringArray = new String[]{"VISA vendor:", (String)this.info[2], "Chassis index:", String.valueOf(this.chassisIndex), "Logical address:", String.valueOf(this.logicalAddress)};
        return stringArray;
    }

    @Override
    public String getBrowserString() {
        return "chassis " + this.chassisIndex + ", logical address " + this.logicalAddress;
    }

    protected void getPropertyValuesUponConnecting() throws TMException {
        this.getHardwareMemoryBase();
        this.getHardwareMemorySize();
        this.getHardwareMemorySpace();
        this.getHardwareSlot();
    }

    @Override
    protected void hardwareStopAsync() {
        this.oldTransferStatus = this.transferStatus;
        switch (this.transferStatus) {
            case 1: {
                this.visaobj.StopAsync(this.handle, this.readId);
                break;
            }
            case 2: {
                this.visaobj.StopAsync(this.handle, this.writeId);
            }
        }
    }

    @Override
    public final Object[] constructorargs() {
        String string = (String)this.info[0];
        int n = string.lastIndexOf(FILESEP);
        Object[] objectArray = new Object[]{string.substring(0, n), string.substring(n + 1), this.rsrcName, this.alias};
        return objectArray;
    }

    @Override
    public final String getConstructor() {
        return "visa('" + this.info[2] + "', '" + this.rsrcName + "');";
    }

    @Override
    public String getConstructorDescription() {
        return "Vendor - " + this.info[2] + ", Resource Name - " + this.rsrcName;
    }

    @Override
    public String getInstrfindArgs() {
        return "('Type', '" + this.type + "', 'RsrcName', '" + this.rsrcName + "', 'Tag', '" + this.tag + "');";
    }

    @Override
    protected void hardwareFlushInput() {
    }

    @Override
    protected void hardwareFlushOutput() throws TMException {
        this.oldTransferStatus = this.transferStatus;
        switch (this.transferStatus) {
            case 2: {
                this.visaobj.StopAsync(this.handle, this.writeId);
            }
        }
    }

    @Override
    public boolean supportsAsynchronousOperations() {
        return this.objectPolls;
    }

    @Override
    protected void verifyWriteOperation(int n) throws TMException {
        this.visaobj.verifyWriteOperation(n, (String)this.info[2], this.type, this.transferStatus);
    }

    @Override
    protected void verifyReadOperation() throws TMException {
        this.visaobj.verifyReadOperation((String)this.info[2], this.type, this.transferStatus);
        this.transferStatus = 1;
    }

    @Override
    public int getAsyncActionType(int n, int n2) {
        if (n == 0) {
            n = this.transferStatus == 2 ? 2 : (this.transferStatus == 1 ? 0 : (this.oldTransferStatus == 2 ? 2 : (this.oldTransferStatus == 1 ? 0 : -1)));
        }
        return n;
    }

    @Override
    protected String getAsciiMessage(Object[] objectArray) {
        return this.getAsciiMessage(objectArray, this.eosMode, this.eosCharCode);
    }

    @Override
    protected String getAsciiMessage(String string) {
        return this.getAsciiMessage(string, this.eosMode, this.eosCharCode);
    }

    @Override
    protected void updateWriteTransferStatus(boolean bl) {
        this.transferStatus = bl ? 2 : 0;
    }

    @Override
    protected int writeAsciiToHardware(String string) {
        return this.visaobj.Write(this.handle, string, string.length());
    }

    @Override
    protected int writeBinaryToHardware(Object object, int n, int n2) {
        if (platformByteOrder != this.byteOrder) {
            Object object2 = null;
            try {
                object2 = BinarySwapBytes.swap(object, n2, n);
            }
            catch (Exception exception) {
                return -1;
            }
            object = object2;
        }
        return this.visaobj.writeBytes(this.handle, object, n, n2);
    }

    @Override
    public int writeBinaryToHardwareAsync(byte[] byArray) {
        int n = this.visaobj.WriteBinaryByteAsync(this.handle, byArray, byArray.length);
        if (n >= 0) {
            this.writeId = n;
        }
        return n;
    }

    @Override
    protected String removeTerminator(String string) {
        return this.removeTerminator(string, this.eosMode, this.eosCharCode);
    }

    @Override
    protected Object[] readAsciiFromHardware(int n, double d) {
        return this.visaobj.Read(this.handle, n);
    }

    @Override
    protected Object[] readBinaryFromHardware(int n, double d) {
        return this.visaobj.ReadBinary(this.handle, n, 0);
    }

    @Override
    public byte[] readAsynchronousDataFromHardware(int n) {
        return this.visaobj.GetAsyncReadData(this.handle, n);
    }

    @Override
    public int readBinaryFromHardwareAsync(int n) {
        int n2 = this.visaobj.ReadBinaryByteAsync(this.handle, n);
        if (n2 >= 0) {
            this.readId = n2;
        }
        return n2;
    }

    @Override
    protected int okToGenerateTerminatorBytesAvailableEvent(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return 0;
        }
        if (byArray[byArray.length - 1] == this.eosCharCode) {
            return 1;
        }
        return 0;
    }

    @Override
    protected String getErrorMessageFromHardware(int n) {
        return "VISA: " + this.visaobj.TranslateErrorCode(this.handle, n);
    }

    @Override
    protected int getSuccessValue() {
        return 0;
    }

    @Override
    protected String wasAsciiReadSuccessful(String string, int n, int n2) {
        String string2 = "";
        switch (n) {
            case 0: {
                if (n2 != 0 || string.length() != this.inputBufferSize) break;
                if (this.eosMode == 1 || this.eosMode == 3) {
                    string2 = "The input buffer was filled before the EOI line was asserted or the EOSCharCode was detected.";
                    break;
                }
                string2 = "The input buffer was filled before the EOI line was asserted.";
                break;
            }
            default: {
                if (string.length() == n) break;
                String string3 = new Character((char)this.eosCharCode).toString();
                if (string.endsWith(string3)) {
                    if (this.eosMode == 1 || this.eosMode == 3) {
                        string2 = "The EOSCharCode was detected before SIZE values were available.";
                        break;
                    }
                    string2 = "The EOI line was asserted before SIZE values were available.";
                    break;
                }
                string2 = "The EOI line was asserted before SIZE values were available.";
            }
        }
        return string2;
    }

    @Override
    protected String wasBinaryReadSuccessful(int n, int n2, String string, int n3) {
        if (!string.equals("")) {
            return string;
        }
        if (n < n2) {
            if (this.eosMode == 1 || this.eosMode == 3) {
                return "The EOI line was asserted or the EOSCharCode was detected before SIZE values were available.";
            }
            return "The EOI line was asserted before SIZE values were available.";
        }
        return "";
    }

    @Override
    protected String getTimeoutMessage(int n, int n2) {
        if (n == 0) {
            return "A timeout occurred before the EOI line was asserted.";
        }
        if (this.eosMode == 1 || this.eosMode == 3) {
            return "A timeout occurred before the EOI line was asserted, EOSCharCode was read" + LINESEP + " or SIZE values were available.";
        }
        return "A timeout occurred before the EOI line was asserted or SIZE values were available.";
    }

    protected String constrctUpdatePropsOnOpenWarning(String[] stringArray) {
        String string = "An error occurred while configuring the following properties: " + stringArray[0];
        for (int i = 1; i < stringArray.length; ++i) {
            string = string + ", " + stringArray[i];
        }
        string = string + "." + LINESEP + "The instrument may not support these properties or the values they " + "were configured to.";
        return string;
    }

    @Override
    protected void verifyObjectState() throws TMException {
        if (!this.isvalid()) {
            throw new TMException("Instrument object OBJ is an invalid object.");
        }
        if (this.status == 0) {
            throw new TMException("OBJ must be connected to the hardware with FOPEN.");
        }
    }

    private void verifyObjectStateForLowLevel() throws TMException {
        if (!this.isvalid()) {
            Vxi.displayError("Instrument object OBJ is an invalid object.");
        }
        if (this.status == 0) {
            Vxi.displayError("OBJ must be connected to the hardware with FOPEN.");
        }
        if (this.mappedMemorySize == 0) {
            Vxi.displayError("Memory must be mapped with the MEMMAP function.");
        }
    }

    public void clrdevice() throws TMException {
        this.verifyObjectState();
        int n = this.visaobj.Clear(this.handle);
        if (n < 0) {
            Vxi.displayError("VISA: " + this.visaobj.TranslateErrorCode(this.handle, n));
        }
    }

    public void memunmap() throws TMException {
        if (!this.isvalid()) {
            Vxi.displayError("Instrument object OBJ is an invalid object.");
        }
        if (this.status == 0 || this.mappedMemorySize == 0) {
            return;
        }
        int n = this.visaobj.UnMapAddress(this.handle);
        if (n < 0) {
            Vxi.displayError("VISA: " + this.visaobj.TranslateErrorCode(this.handle, n));
        }
        this.mappedMemorySize = 0;
        this.mappedMemoryBase = "0H";
    }

    public void memmap(int n, int n2, int n3) throws TMException {
        long l;
        this.verifyObjectState();
        if (this.mappedMemorySize != 0) {
            Vxi.displayError("Memory has been mapped. Type 'instrhelp memmap' for more information.");
        }
        if ((l = this.visaobj.MapAddress(this.handle, n, n2, n3)) == -1L) {
            Vxi.displayError("VISA: Unable to map the specified address space.");
        }
        this.address = l;
        this.mappedMemorySpace = n - 1;
        this.mappedMemorySize = n3;
        this.mappedMemoryBase = this.isX86Arch() ? Integer.toHexString((int)this.address) + "H" : Long.toHexString(this.address) + "H";
    }

    public Object mempeek(int n, int n2) throws TMException {
        Object object;
        this.verifyObjectStateForLowLevel();
        ++this.valuesReceived;
        Object object2 = null;
        switch (n2) {
            case 3: {
                object = new byte[4];
                for (int i = 0; i < ((byte[])object).length; ++i) {
                    byte[] byArray = (byte[])this.visaobj.MemoryPeek(this.handle, 0, this.address, n + i);
                    object[i] = byArray[0];
                }
                try {
                    object2 = BinarySwapBytes.convertToLittlePrecision(object, 3, 4);
                    break;
                }
                catch (Exception exception) {
                    throw new TMException("An error occurred while reading.");
                }
            }
            default: {
                object2 = this.visaobj.MemoryPeek(this.handle, n2, this.address, n);
            }
        }
        if (this.recordStatus) {
            try {
                object = ", " + ADDRESS_SPACE_DESC[this.mappedMemorySpace] + " space, " + n + " offset";
                this.writeRawDataToFile(object2, 1, n2, "<", (String)object, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return object2;
    }

    public void mempoke(Object object, int n, int n2) throws TMException {
        Object object2;
        this.verifyObjectStateForLowLevel();
        switch (n) {
            case 0: {
                object2 = (Byte)object;
                this.visaobj.MemoryPokeByte(this.handle, this.address, n2, (Byte)object2);
                break;
            }
            case 1: {
                Short s = (Short)object;
                this.visaobj.MemoryPokeShort(this.handle, this.address, n2, s);
                break;
            }
            case 2: {
                Integer n3 = (Integer)object;
                this.visaobj.MemoryPokeInt(this.handle, this.address, n2, n3);
                break;
            }
            case 3: {
                try {
                    byte[] byArray = BinarySwapBytes.breakdownToBytes(object, 3);
                    for (int i = 0; i < byArray.length; ++i) {
                        this.visaobj.MemoryPokeByte(this.handle, this.address, n2 + i, byArray[i]);
                    }
                    break;
                }
                catch (Exception exception) {
                    throw new TMException("An error occurred while writing the data.");
                }
            }
        }
        if (this.recordStatus) {
            try {
                object2 = ", " + ADDRESS_SPACE_DESC[this.mappedMemorySpace] + " space, " + n2 + " offset";
                this.writeRawDataToFile(object, 1, n, ">", (String)object2, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ++this.valuesSent;
    }

    public Object memread(int n, int n2, int n3, int n4) throws TMException {
        Object[] objectArray;
        this.verifyObjectState();
        if (n4 * DATASIZE[n3] > this.inputBufferSize) {
            Vxi.displayError("SIZE*PRECISION must be less than or equal to InputBufferSize.");
        }
        int n5 = n4;
        int n6 = n3;
        if (n3 == 3) {
            n5 = n4 * 4;
            n6 = 0;
        }
        if ((objectArray = this.visaobj.MemRead(this.handle, n, n2, n5, n6))[0] instanceof String) {
            Integer n7 = (Integer)objectArray[1];
            String string = this.visaobj.TranslateErrorCode(this.handle, n7);
            if (string.indexOf("timeout") != -1) {
                string = "The specified data could not be read most likely due to a bus error.";
            }
            throw new TMException("VISA: " + string);
        }
        this.valuesReceived += (long)n4;
        if (n3 == 3) {
            try {
                objectArray[0] = BinarySwapBytes.convertToLittlePrecision((byte[])objectArray[0], 3, n5);
            }
            catch (Exception exception) {
                throw new TMException("An error occurred while reading.");
            }
        }
        if (this.recordStatus) {
            try {
                String string = ", " + ADDRESS_SPACE_DESC[n - 1] + " space, " + n2 + " offset";
                this.writeRawDataToFile(objectArray[0], n4, n3, "<", string, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return objectArray[0];
    }

    public void memwrite(int n, Object object, int n2, int n3, int n4) throws TMException {
        Object object2;
        this.verifyObjectState();
        if (n4 * DATASIZE[n3] > this.outputBufferSize) {
            Vxi.displayError("The length(DATA)*PRECISION must be less than or equal to OutputBufferSize.");
        }
        int n5 = 0;
        switch (n3) {
            case 0: {
                if (object instanceof Byte) {
                    n5 = this.visaobj.MemWriteByte(this.handle, n, Vxi.object2byteArray(object), n2);
                    break;
                }
                n5 = this.visaobj.MemWriteByte(this.handle, n, (byte[])object, n2);
                break;
            }
            case 1: {
                if (object instanceof Short) {
                    n5 = this.visaobj.MemWriteShort(this.handle, n, Vxi.object2shortArray(object), n2);
                    break;
                }
                n5 = this.visaobj.MemWriteShort(this.handle, n, (short[])object, n2);
                break;
            }
            case 2: {
                if (object instanceof Integer) {
                    n5 = this.visaobj.MemWriteInt(this.handle, n, Vxi.object2intArray(object), n2);
                    break;
                }
                n5 = this.visaobj.MemWriteInt(this.handle, n, (int[])object, n2);
                break;
            }
            case 3: {
                try {
                    object2 = BinarySwapBytes.breakdownToBytes(object, 3);
                    n5 = this.visaobj.MemWriteByte(this.handle, n, (byte[])object2, n2);
                    break;
                }
                catch (Exception exception) {
                    throw new TMException("An error occurred while writing.");
                }
            }
        }
        if (n5 < 0) {
            Vxi.displayError("VISA: " + this.visaobj.TranslateErrorCode(this.handle, n5));
        }
        if (this.recordStatus) {
            try {
                object2 = ", " + ADDRESS_SPACE_DESC[n - 1] + " space, " + n2 + " offset";
                this.writeRawDataToFile(object, n4, n3, ">", (String)object2, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.valuesSent += (long)n4;
    }

    protected boolean isX86Arch() {
        String string = System.getProperty("os.arch");
        int n = string.indexOf("64");
        return n == -1;
    }

    public Object ObjectHardwareInfo() {
        return this.visaobj.ObjectHardwareInfo(this.info, this.handle);
    }

    @Override
    protected Object[] getHwInfoStruct() {
        this.ObjectHardwareInfo();
        return this.info;
    }

    @Override
    protected String[] getHwInfoFields() {
        return HWINFO_FIELDS;
    }

    abstract void updateNameProperties();

    abstract char spoll(int var1) throws TMException;
}

