/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument;

import com.mathworks.toolbox.instrument.AdaptorInfo;
import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.toolbox.instrument.SerialVisa;
import com.mathworks.toolbox.instrument.VisaAGILENT;
import com.mathworks.toolbox.instrument.VisaNI;
import com.mathworks.toolbox.instrument.VisaTEK;
import com.mathworks.toolbox.instrument.VisaTEST;
import com.mathworks.toolbox.testmeas.util.TMException;
import java.io.File;

public abstract class VISA {
    private static final String[] visaAdaptors = AdaptorInfo.VISA_ADAPTORS;
    private static final String[] visaName = AdaptorInfo.VISA_VENDORS;
    protected static final int SUCCESS = 0;

    public static VISA createVisaObject(String string, String string2) throws Exception {
        if ((string = string.toLowerCase()).equals("ni")) {
            return new VisaNI(string2, 4086);
        }
        if (string.equals("rs")) {
            return new VisaNI(string2, 4015);
        }
        if (string.equals("agilent")) {
            return new VisaAGILENT(string2);
        }
        if (string.equals("tek")) {
            return new VisaTEK(string2);
        }
        return new VisaTEST(string2);
    }

    protected void setHardwareEOSChar(int n, int n2, int n3, int n4) throws TMException {
        int n5 = 0;
        switch (n4) {
            case 0: {
                n5 = this.Set(n, n2, -1);
                break;
            }
            case 1: 
            case 3: {
                n5 = this.Set(n, n2, n3);
                break;
            }
            case 2: {
                n5 = 0;
            }
        }
        if (n5 < 0) {
            throw new TMException("VISA: " + this.TranslateErrorCode(n, n5));
        }
    }

    protected void setHardwareEOSMode(int n, int n2, int n3, int n4) throws TMException {
        int n5 = 0;
        switch (n3) {
            case 0: {
                n5 = this.Set(n, n2, -1);
                break;
            }
            case 1: 
            case 3: {
                n5 = this.Set(n, n2, n4);
                break;
            }
            case 2: {
                n5 = 0;
            }
        }
        if (n5 < 0) {
            throw new TMException("VISA: " + this.TranslateErrorCode(n, n5));
        }
    }

    protected void setHardwareTimeout(int n, double d, int n2) throws TMException {
        if (d < 0.001) {
            throw new TMException("Timeout must be greater than or equal to 1ms.");
        }
        if (d > 1000.0) {
            throw new TMException("Timeout must be less than or equal to 1000s.");
        }
        int n3 = this.Set(n, n2, (int)(d * 1000.0));
        if (n3 < 0) {
            throw new TMException("VISA: " + this.TranslateErrorCode(n, n3));
        }
    }

    protected int getProperty(int n, int n2) throws TMException {
        int n3 = this.Get(n, n2);
        if (n3 < 0) {
            throw new TMException("VISA: " + this.TranslateErrorCode(n, n3));
        }
        return n3;
    }

    protected String getStringProperty(int n, int n2) throws TMException {
        String string = this.GetStringProp(n, n2);
        return string;
    }

    protected void setProperty(int n, int n2, int n3) throws TMException {
        int n4 = this.Set(n, n2, n3);
        if (n4 < 0) {
            throw new TMException("VISA: " + this.TranslateErrorCode(n, n4));
        }
    }

    protected int writeBytes(int n, Object object, int n2, int n3) {
        if (object instanceof byte[]) {
            return this.WriteBinaryByte(n, (byte[])object, n2);
        }
        if (object instanceof Byte) {
            return this.WriteBinaryByte(n, Instrument.object2byteArray(object), n2);
        }
        if (object instanceof short[]) {
            return this.WriteBinaryShort(n, (short[])object, n2);
        }
        if (object instanceof Short) {
            return this.WriteBinaryShort(n, Instrument.object2shortArray(object), n2);
        }
        if (object instanceof int[]) {
            return this.WriteBinaryInt(n, (int[])object, n2);
        }
        if (object instanceof Integer) {
            return this.WriteBinaryInt(n, Instrument.object2intArray(object), n2);
        }
        if (object instanceof float[]) {
            return this.WriteBinaryFloat(n, (float[])object, n2);
        }
        if (object instanceof Float) {
            return this.WriteBinaryFloat(n, Instrument.object2floatArray(object), n2);
        }
        if (object instanceof double[]) {
            return this.WriteBinaryDouble(n, (double[])object, n2);
        }
        if (object instanceof Double) {
            return this.WriteBinaryDouble(n, Instrument.object2doubleArray(object), n2);
        }
        return -1;
    }

    protected void verifyWriteOperation(int n, String string, String string2, int n2) throws TMException {
        if (n == 1 && !this.VerifyAsyncVISAWrite()) {
            if (Instrument.platform != 0) {
                throw new TMException("Asynchronous operation is not supported for " + string + " " + string2.toUpperCase() + " objects on the UNIX platform.");
            }
            throw new TMException("Asynchronous operation is not supported for " + string + " " + string2.toUpperCase() + " objects.");
        }
        if (n2 == 2) {
            throw new TMException("An asynchronous write is already in progress.");
        }
        if (n2 == 1) {
            throw new TMException("An asynchronous read is already in progress.");
        }
    }

    protected void verifyReadOperation(String string, String string2, int n) throws TMException {
        if (!this.VerifyAsyncVISARead()) {
            if (Instrument.platform != 0) {
                throw new TMException("Asynchronous operation is not supported for " + string + " " + string2.toUpperCase() + " objects on the UNIX platform.");
            }
            throw new TMException("Asynchronous operation is not supported for " + string + " " + string2.toUpperCase() + " objects.");
        }
        if (n == 2) {
            throw new TMException("An asynchronous write is already in progress.");
        }
        if (n == 1) {
            throw new TMException("An asynchronous read is already in progress.");
        }
    }

    public Object ObjectHardwareInfo(Object[] objectArray, int n) {
        objectArray[3] = this.HardwareInfo(n, 3);
        objectArray[4] = this.HardwareInfo(n, 4);
        Integer n2 = (Integer)this.HardwareInfo(0, 5);
        objectArray[5] = VISA.constructVersionString(n2);
        return objectArray;
    }

    public static Double constructVersionString(int n) {
        double d = ((long)n & 0xFFF00000L) >> 20;
        double d2 = ((long)n & 0xFFF00L) >> 8;
        double d3 = (long)n & 0xFFL;
        return new Double(d + 0.1 * d2 + 0.01 * d3);
    }

    public static String[] findValidAdaptors(String string) throws Exception {
        String[] stringArray = new String[3];
        int n = 0;
        File file = new File(string);
        if (!file.exists()) {
            return null;
        }
        String string2 = Instrument.extension();
        try {
            new VisaAGILENT(string + Instrument.FILESEP + visaAdaptors[0] + string2);
            stringArray[n++] = visaName[0];
        }
        catch (Exception exception) {
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
        try {
            new VisaNI(string + Instrument.FILESEP + visaAdaptors[1] + string2);
            stringArray[n++] = visaName[1];
        }
        catch (Exception exception) {
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
        try {
            new VisaTEK(string + Instrument.FILESEP + visaAdaptors[2] + string2);
            stringArray[n++] = visaName[2];
        }
        catch (Exception exception) {
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
        String[] stringArray2 = new String[n];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        return stringArray2;
    }

    public char spoll(int n, int n2, double d) throws TMException {
        char c = '\u0000';
        if (n2 == 0) {
            c = this.SPoll(n);
            if (c < '\u0000') {
                Instrument.displayError("GPIB: " + this.TranslateErrorCode(n, c));
            }
            return c;
        }
        long l = Instrument.currentNanoTicTime();
        while (!Instrument.nanoTicTimeout(l, d)) {
            c = this.SPoll(n);
            if (c < '\u0000') {
                Instrument.displayError("GPIB: " + this.TranslateErrorCode(n, c));
            }
            if (((byte)c & 0x20) != 32) continue;
            break;
        }
        return c;
    }

    public Object[] hardwareInfo(String string, String string2) {
        Object[] objectArray = this.hardwareInfoOnAdaptorAndVendor(string, string2);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        Object[] objectArray2 = null;
        Object[] objectArray3 = null;
        Object[] objectArray4 = null;
        Object[] objectArray5 = null;
        Object[] objectArray6 = null;
        Object[] objectArray7 = this.Find("?*INSTR");
        if (objectArray7 != null) {
            String string3;
            int n6;
            int n7 = objectArray7.length;
            objectArray2 = new Object[n7];
            for (n6 = 0; n6 < n7; ++n6) {
                if (!((String)objectArray7[n6]).startsWith("ASRL")) continue;
                objectArray2[n++] = objectArray7[n6];
            }
            objectArray3 = new Object[n7];
            for (n6 = 0; n6 < n7; ++n6) {
                string3 = (String)objectArray7[n6];
                if (!string3.startsWith("GPIB") || string3.startsWith("GPIB-")) continue;
                objectArray3[n2++] = objectArray7[n6];
            }
            objectArray4 = new Object[n7];
            for (n6 = 0; n6 < n7; ++n6) {
                string3 = (String)objectArray7[n6];
                if (!string3.startsWith("PXI")) continue;
                objectArray4[n3++] = objectArray7[n6];
            }
            objectArray5 = new Object[n7];
            for (n6 = 0; n6 < n7; ++n6) {
                string3 = (String)objectArray7[n6];
                if (!string3.startsWith("VXI")) continue;
                objectArray5[n4++] = objectArray7[n6];
            }
            objectArray6 = new Object[n7];
            for (n6 = 0; n6 < n7; ++n6) {
                string3 = (String)objectArray7[n6];
                if (!string3.startsWith("GPIB-VXI")) continue;
                objectArray6[n5++] = objectArray7[n6];
            }
        }
        objectArray[3] = this.parseAvailableVXIHardware(objectArray5, n4, objectArray6, n5);
        objectArray[5] = this.parseAvailableGPIBHardware(objectArray3, n2);
        if (n == 0) {
            objectArray[4] = "";
            objectArray[7] = "";
        } else {
            objectArray[7] = this.parseAvailableSerialHardware(objectArray2, n);
            objectArray[4] = this.findSerialNotInUse((String[])objectArray[7]);
        }
        objectArray[6] = this.createConstructorCommand(string2, objectArray7);
        objectArray7 = null;
        objectArray2 = null;
        objectArray3 = null;
        objectArray4 = null;
        objectArray5 = null;
        objectArray6 = null;
        return objectArray;
    }

    public Object[] hardwareInfoOnAdaptorAndVendor(String string, String string2) {
        Object[] objectArray = new Object[11];
        objectArray[0] = string;
        objectArray[1] = Instrument.jarVersion();
        objectArray[2] = string2.toUpperCase();
        objectArray[8] = this.HardwareInfo(0, 3);
        objectArray[9] = this.HardwareInfo(0, 4);
        Integer n = (Integer)this.HardwareInfo(0, 5);
        objectArray[10] = VISA.constructVersionString(n);
        return objectArray;
    }

    private double[] parseAvailableGPIBHardware(Object[] objectArray, int n) {
        if (n == 0) {
            return null;
        }
        int[] nArray = new int[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            String string = (String)objectArray[i];
            n2 = string.indexOf("::");
            nArray[i] = Integer.valueOf(string.substring(4, n2));
        }
        return VISA.unique(nArray);
    }

    private double[] parseAvailableVXIHardware(Object[] objectArray, int n, Object[] objectArray2, int n2) {
        String string;
        int n3;
        if (n + n2 == 0) {
            return null;
        }
        int[] nArray = new int[n + n2];
        int n4 = 0;
        int n5 = 0;
        for (n3 = 0; n3 < n; ++n3) {
            string = (String)objectArray[n3];
            n4 = string.indexOf("::");
            nArray[n5++] = Integer.valueOf(string.substring(3, n4));
        }
        for (n3 = 0; n3 < n2; ++n3) {
            string = (String)objectArray2[n3];
            n4 = string.indexOf("::");
            nArray[n5++] = Integer.valueOf(string.substring(8, n4));
        }
        return VISA.unique(nArray);
    }

    private double[] parseAvailablePXIHardware(Object[] objectArray, int n) {
        if (n == 0) {
            return null;
        }
        int[] nArray = new int[n];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            String string = (String)objectArray[i];
            n2 = string.indexOf("::");
            n3 = string.lastIndexOf("::");
            nArray[n4++] = Integer.valueOf(string.substring(n2 + 2, n3));
        }
        return VISA.unique(nArray);
    }

    private String[] parseAvailableSerialHardware(Object[] objectArray, int n) {
        String[] stringArray = new String[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            String string = (String)objectArray[i];
            n2 = string.indexOf("::");
            stringArray[i] = string.substring(0, n2);
        }
        return stringArray;
    }

    private String[] parseAvailableGenericHardware(Object[] objectArray, int n) {
        String[] stringArray = new String[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            String string = (String)objectArray[i];
            n2 = string.indexOf("::");
            stringArray[i] = string.substring(0, n2);
        }
        return stringArray;
    }

    private String[] findSerialNotInUse(String[] stringArray) {
        int n = 0;
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            if (SerialVisa.isInUse(stringArray[i])) continue;
            stringArray2[n++] = stringArray[i];
        }
        String[] stringArray3 = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray3[i] = stringArray2[i];
        }
        stringArray2 = null;
        return stringArray3;
    }

    private String[] createConstructorCommand(String string, Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = "visa('" + string + "', '" + objectArray[i] + "');";
        }
        return stringArray;
    }

    private static double[] unique(int[] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= n) continue;
            n = nArray[i];
        }
        int[] nArray2 = new int[n + 1];
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray2[nArray[i]] != 0) continue;
            nArray2[nArray[i]] = 1;
            ++n2;
        }
        double[] dArray = new double[n2];
        n2 = 0;
        for (int i = 0; i < nArray2.length; ++i) {
            if (nArray2[i] == 0) continue;
            dArray[n2++] = i;
        }
        return dArray;
    }

    public Object[] hardwareInfoOnGeneric(String string, String string2) {
        Object[] objectArray = this.hardwareInfoOnAdaptorAndVendor(string, string2);
        Object[] objectArray2 = this.FindGeneric();
        int n = 0;
        if (objectArray2 != null) {
            n = objectArray2.length;
        }
        objectArray[5] = this.parseAvailableGenericHardware(objectArray2, n);
        objectArray[6] = this.createConstructorCommand(string2, objectArray2);
        objectArray2 = null;
        return objectArray;
    }

    public Object[] hardwareInfoOnGPIB(String string, String string2) {
        Object[] objectArray = this.hardwareInfoOnAdaptorAndVendor(string, string2);
        Object[] objectArray2 = this.FindGPIB();
        int n = 0;
        if (objectArray2 != null) {
            n = objectArray2.length;
        }
        objectArray[5] = this.parseAvailableGPIBHardware(objectArray2, n);
        objectArray[6] = this.createConstructorCommand(string2, objectArray2);
        objectArray2 = null;
        return objectArray;
    }

    public Object[] hardwareInfoOnPXI(String string, String string2) {
        Object[] objectArray = this.hardwareInfoOnAdaptorAndVendor(string, string2);
        Object[] objectArray2 = this.FindPXI();
        Object[] objectArray3 = this.FindPXIBackplane();
        int n = 0;
        if (objectArray3 != null) {
            n = objectArray3.length;
        }
        objectArray[3] = this.parseAvailablePXIHardware(objectArray3, n);
        objectArray[6] = this.createConstructorCommand(string2, objectArray2);
        objectArray2 = null;
        objectArray3 = null;
        return objectArray;
    }

    public Object[] hardwareInfoOnVXI(String string, String string2) {
        Object[] objectArray = this.hardwareInfoOnAdaptorAndVendor(string, string2);
        Object[] objectArray2 = this.FindVXI();
        int n = 0;
        if (objectArray2 != null) {
            n = objectArray2.length;
        }
        objectArray[3] = this.parseAvailableVXIHardware(objectArray2, n, null, 0);
        objectArray[6] = this.createConstructorCommand(string2, objectArray2);
        objectArray2 = null;
        return objectArray;
    }

    public Object[] hardwareInfoOnGPIBVXI(String string, String string2) {
        Object[] objectArray = this.hardwareInfoOnAdaptorAndVendor(string, string2);
        Object[] objectArray2 = this.FindGPIBVXI();
        int n = 0;
        if (objectArray2 != null) {
            n = objectArray2.length;
        }
        objectArray[3] = this.parseAvailableVXIHardware(null, 0, objectArray2, n);
        objectArray[6] = this.createConstructorCommand(string2, objectArray2);
        objectArray2 = null;
        return objectArray;
    }

    public Object[] hardwareInfoOnSerial(String string, String string2) {
        Object[] objectArray = this.hardwareInfoOnAdaptorAndVendor(string, string2);
        Object[] objectArray2 = this.FindSerial();
        if (objectArray2 == null) {
            objectArray[4] = "";
            objectArray[7] = "";
        } else {
            objectArray[7] = this.parseAvailableSerialHardware(objectArray2, objectArray2.length);
            objectArray[4] = this.findSerialNotInUse((String[])objectArray[7]);
        }
        objectArray[6] = this.createConstructorCommand(string2, objectArray2);
        objectArray2 = null;
        return objectArray;
    }

    public Object[] hardwareInfoOn(String string, String string2, String string3) {
        Object[] objectArray = this.hardwareInfoOnAdaptorAndVendor(string, string2);
        Object[] objectArray2 = this.Find(string3 + "::?*INSTR");
        objectArray[6] = this.createConstructorCommand(string2, objectArray2);
        if (string3.equals("RSIB")) {
            objectArray[9] = (String)objectArray[9] + " with " + string3 + " passport";
        }
        objectArray2 = null;
        return objectArray;
    }

    public abstract int[] Create(Instrument var1, String var2);

    public abstract int Close(int var1, int var2);

    public abstract int Clear(int var1);

    public abstract int Set(int var1, int var2, int var3);

    public abstract int EnableAction(Instrument var1, int var2, int var3, int var4);

    public abstract int Get(int var1, int var2);

    public abstract String GetStringProp(int var1, int var2);

    public abstract int GetVendor();

    public abstract int Write(int var1, String var2, int var3);

    public abstract int WriteBinaryByte(int var1, byte[] var2, int var3);

    public abstract int WriteBinaryShort(int var1, short[] var2, int var3);

    public abstract int WriteBinaryInt(int var1, int[] var2, int var3);

    public abstract int WriteBinaryFloat(int var1, float[] var2, int var3);

    public abstract int WriteBinaryDouble(int var1, double[] var2, int var3);

    public abstract int WriteBinaryChar(int var1, char[] var2, int var3);

    public abstract Object[] Read(int var1, int var2);

    public abstract Object[] ReadBinary(int var1, int var2, int var3);

    public abstract int WriteBinaryByteAsync(int var1, byte[] var2, int var3);

    public abstract int ReadBinaryByteAsync(int var1, int var2);

    public abstract byte[] GetAsyncReadData(int var1, int var2);

    public abstract void StopAsync(int var1, int var2);

    public abstract int Trigger(int var1);

    public abstract Object[] Find(String var1);

    public abstract Object[] FindGeneric();

    public abstract Object[] FindSerial();

    public abstract Object[] FindGPIB();

    public abstract Object[] FindPXI();

    public abstract Object[] FindPXIBackplane();

    public abstract Object[] FindVXI();

    public abstract Object[] FindGPIBVXI();

    public abstract Object HardwareInfo(int var1, int var2);

    public abstract Object[] GetAliasInfo(String var1);

    public abstract String TranslateErrorCode(int var1, int var2);

    public abstract int MemWriteByte(int var1, int var2, byte[] var3, long var4);

    public abstract int MemWriteShort(int var1, int var2, short[] var3, long var4);

    public abstract int MemWriteInt(int var1, int var2, int[] var3, long var4);

    public abstract Object[] MemRead(int var1, int var2, long var3, int var5, int var6);

    public abstract long MapAddress(int var1, int var2, long var3, int var5);

    public abstract int UnMapAddress(int var1);

    public abstract void MemoryPokeByte(int var1, long var2, long var4, byte var6);

    public abstract void MemoryPokeShort(int var1, long var2, long var4, short var6);

    public abstract void MemoryPokeInt(int var1, long var2, long var4, int var6);

    public abstract Object MemoryPeek(int var1, int var2, long var3, long var5);

    public abstract boolean VerifyAsyncVISAWrite();

    public abstract boolean VerifyAsyncVISARead();

    public abstract char SPoll(int var1);
}

