/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument;

import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.util.Timer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

public class Poller
implements ActionListener {
    private static Poller poller = null;
    private static Vector<Instrument> children = null;
    private static Timer timer;
    private static int maxNumFailed;
    private static int TIME;
    private static int MINTIME;
    private static int numFailed;
    private boolean completedAction = false;
    private static boolean running;

    private Poller() {
        children = new Vector();
        timer = new Timer(TIME, (ActionListener)this, 2, 5, "InstrumentReadWritePoll");
    }

    public static final void addInstrument(Instrument instrument) {
        int n;
        boolean bl = false;
        if (poller == null) {
            poller = new Poller();
            timer.start();
            bl = true;
        }
        if ((n = children.indexOf(instrument)) == -1) {
            children.addElement(instrument);
        }
        if (children.size() == 1 && !bl) {
            timer.reset();
        }
    }

    public static final void setDelay() {
        timer.setDelay(TIME);
    }

    public static final int getDelay() {
        if (timer != null) {
            return timer.getDelay();
        }
        return TIME;
    }

    public static final void removeInstrument(Instrument instrument) {
        if (poller == null) {
            return;
        }
        int n = children.indexOf(instrument);
        if (n != -1) {
            children.removeElementAt(n);
        }
        if (children.isEmpty()) {
            timer.hold();
        }
    }

    public static void wakeUpTimer() {
        if (running) {
            numFailed = 0;
            return;
        }
        numFailed = 0;
        timer.hold();
        timer.setDelay(0);
        timer.reset();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        running = true;
        this.completedAction = false;
        for (int i = 0; i < children.size(); ++i) {
            try {
                Instrument instrument = children.elementAt(i);
                boolean bl = instrument.poll();
                this.completedAction = this.completedAction || bl;
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        if (this.completedAction) {
            numFailed = 0;
        }
        if (this.completedAction || numFailed < maxNumFailed) {
            timer.setDelay(MINTIME);
            ++numFailed;
        } else {
            timer.setDelay(TIME);
        }
        timer.reset();
        running = false;
    }

    public static void dispose() {
        if (timer != null) {
            timer.stop();
        }
    }

    static {
        maxNumFailed = 5;
        TIME = 20;
        MINTIME = 2;
        numFailed = 0;
        running = false;
    }
}

