/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.inspector.celleditors.color;

import com.jidesoft.combobox.AbstractComboBox;
import com.jidesoft.combobox.ColorComboBox;
import com.jidesoft.combobox.PopupPanel;
import com.mathworks.mlwidgets.inspector.celleditors.color.MLColorChooserPanel;
import com.mathworks.mlwidgets.inspector.guiutils.InvalidInput;
import com.mathworks.util.StyledColor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.SwingUtilities;

class MLColorComboBox
extends ColorComboBox {
    MLColorComboBox() {
    }

    public PopupPanel createPopupComponent() {
        Color color = this.getSelectedColor();
        Object object = null;
        object = color instanceof StyledColor ? MLColorChooserPanel.newInstance(this.getColorMode(), this.isAllowMoreColors(), ((StyledColor)color).getAllowedStyles()) : new MLColorChooserPanel(this.getColorMode(), this.isAllowMoreColors(), this.isAllowDefaultColor());
        return object;
    }

    public AbstractComboBox.EditorComponent createEditorComponent() {
        StyledColorEditorComponent styledColorEditorComponent = new StyledColorEditorComponent(Color.class);
        styledColorEditorComponent.setColorValueVisible(this.isColorValueVisible());
        return styledColorEditorComponent;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent != null) {
            return;
        }
        assert (this.getEditor() != null);
        Object object = this.getEditor().getItem();
        assert (object != null);
        if (object instanceof InvalidInput) {
            this.revertTextFieldEdit();
        }
        super.actionPerformed(actionEvent);
    }

    private void revertTextFieldEdit() {
        Object object = null;
        Object object2 = null;
        try {
            object2 = this.getSelectedItem();
            object = this.getEditor().getItem();
        }
        catch (Exception exception) {
            this.getEditor().setItem(object2);
        }
        if (object != object2) {
            this.getEditor().setItem(object2);
        }
    }

    private final class StyledColorEditorComponent
    extends ColorComboBox.ColorEditorComponent {
        private final ColorComboBox.ColorLabel colorLabel;

        public StyledColorEditorComponent(Class<?> clazz) {
            super((ColorComboBox)MLColorComboBox.this, clazz);
            this.colorLabel = new ColorComboBox.ColorLabel(){
                private static final int MARGIN = 2;
                private static final double RATIO = 1.618;

                protected void paintComponent(Graphics graphics) {
                    StyledColor styledColor;
                    Color color = this.getColor();
                    if (color instanceof StyledColor && (styledColor = (StyledColor)color).isStyle()) {
                        int n = this.getHeight();
                        int n2 = MLColorComboBox.this.isColorValueVisible() ? (int)((double)n * 1.618) : this.getWidth();
                        graphics.setColor(Color.gray);
                        graphics.drawRect(2, 2, n2 - 4, n - 4 - 1);
                        graphics.drawLine(2, 2, n2 - 2, n - 2 - 1);
                        graphics.drawLine(2, n - 2 - 1, n2 - 2, 2);
                        return;
                    }
                    super.paintComponent(graphics);
                }
            };
            MouseAdapter mouseAdapter = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() != 2 && SwingUtilities.isLeftMouseButton(mouseEvent) && MLColorComboBox.this.isEnabled()) {
                        if (StyledColorEditorComponent.this._textField.isShowing()) {
                            StyledColorEditorComponent.this._textField.requestFocus();
                        } else {
                            MLColorComboBox.this.requestFocus();
                        }
                        if (!MLColorComboBox.this.isEditable() || !MLColorComboBox.this.isColorValueVisible()) {
                            MLColorComboBox.this.actionPerformed(null);
                        }
                    }
                }
            };
            this.colorLabel.addMouseListener((MouseListener)mouseAdapter);
            this._textField.addMouseListener(mouseAdapter);
            this.colorLabel.setOpaque(false);
            this.add((Component)this.colorLabel, "Before");
        }

        public void updateVisible() {
            if (MLColorComboBox.this.isColorIconVisible() && MLColorComboBox.this.isColorValueVisible()) {
                this.add((Component)this.colorLabel, "Before");
                this.add(this._textField, "Center");
            } else if (MLColorComboBox.this.isColorIconVisible() && !MLColorComboBox.this.isColorValueVisible()) {
                this.add((Component)this.colorLabel, "Center");
                this.remove(this._textField);
            } else if (!MLColorComboBox.this.isColorIconVisible() && MLColorComboBox.this.isColorValueVisible()) {
                this.add(this._textField, "Center");
                this.remove((Component)this.colorLabel);
            } else {
                this.add((Component)this.colorLabel, "Before");
                this.add(this._textField, "Center");
            }
            this.revalidate();
        }

        public void setColorValueVisible(boolean bl) {
            this.updateVisible();
        }

        public void setColorIconVisible(boolean bl) {
            this.updateVisible();
        }

        public void setItem(Object object) {
            super.setItem(object);
            if (object instanceof Color) {
                this.colorLabel.setColor((Color)object);
                this.colorLabel.repaint();
            } else if (object == null) {
                this.colorLabel.setColor(null);
                this.colorLabel.repaint();
            }
        }
    }
}

