/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.mlwidgets.importtool.ImportToolUtils;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

class WorksheetRulePanelComboBox
extends MJComboBox {
    private boolean fPrompting = false;
    private Object fLastSelectedItem;
    private static Color sForeground = Color.black;
    private static Color sPromptForeground = Color.lightGray;

    WorksheetRulePanelComboBox() {
        this.setEditor(new RuleTargetComboBoxEditor());
        this.setRenderer(new RuleTargetComboBoxRenderer());
        this.addItem(new Prompt());
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!WorksheetRulePanelComboBox.this.fPrompting) {
                    WorksheetRulePanelComboBox.this.editingStopped();
                }
            }
        });
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (WorksheetRulePanelComboBox.this.fPrompting) {
                    ((JTextField)WorksheetRulePanelComboBox.this.getEditor().getEditorComponent()).setText("");
                    WorksheetRulePanelComboBox.this.getEditor().getEditorComponent().setForeground(sForeground);
                    WorksheetRulePanelComboBox.this.fPrompting = false;
                }
            }
        };
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() != 1 || WorksheetRulePanelComboBox.this.getSelectedIndex() < 0) {
                    return;
                }
                WorksheetRulePanelComboBox.this.fLastSelectedItem = itemEvent.getItem();
                if (WorksheetRulePanelComboBox.this.getItemCount() > 1 && WorksheetRulePanelComboBox.this.getSelectedItem() instanceof Prompt) {
                    WorksheetRulePanelComboBox.this.setEditable(true);
                    WorksheetRulePanelComboBox.this.fPrompting = true;
                } else {
                    WorksheetRulePanelComboBox.this.setEditable(WorksheetRulePanelComboBox.this.getSelectedItem() instanceof EditableTarget);
                }
            }
        };
        this.addItemListener(itemListener);
        this.getEditor().getEditorComponent().addKeyListener(keyAdapter);
    }

    void addAndSelectEditableItem(String string) {
        EditableTarget editableTarget = new EditableTarget(string);
        this.addItem(editableTarget);
        this.setSelectedItem(editableTarget);
    }

    void editingStopped() {
        if (!this.isEditable()) {
            return;
        }
        if (this.fPrompting) {
            this.fPrompting = false;
            this.setSelectedIndex(0);
            this.setEditable(false);
            return;
        }
        String string = this.getEditor().getItem().toString();
        for (int i = 0; i < this.getItemCount(); ++i) {
            if (!this.getItemAt(i).toString().equals(string)) continue;
            this.setSelectedIndex(i);
            this.setEditable(this.getItemAt(i) instanceof EditableTarget);
            return;
        }
        if (string.trim().length() == 0) {
            this.setSelectedIndex(0);
            this.setEditable(this.getItemAt(0) instanceof EditableTarget);
            return;
        }
        try {
            Double.parseDouble(string);
            JOptionPane.showMessageDialog((Component)((Object)this), String.format(ImportToolUtils.getResourceString("WorksheetRulePanelComboBox.numberEntered"), string));
        }
        catch (Exception exception) {
            // empty catch block
        }
        EditableTarget editableTarget = new EditableTarget(string);
        if (this.fLastSelectedItem instanceof Prompt) {
            this.insertItemAt(editableTarget, this.getItemCount() - 1);
        } else {
            for (int i = 0; i < this.getItemCount(); ++i) {
                if (!this.getItemAt(i).equals(this.fLastSelectedItem)) continue;
                this.insertItemAt(editableTarget, i);
                break;
            }
            this.removeItem(this.fLastSelectedItem);
        }
        this.setSelectedItem(editableTarget);
        this.setEditable(true);
    }

    public void addItem(Object object) {
        if (object instanceof Prompt || !(this.getItemAt(this.getItemCount() - 1) instanceof Prompt)) {
            super.addItem(object);
        } else {
            this.insertItemAt(object, this.getItemCount() - 1);
        }
        if (this.getSelectedItem() instanceof Prompt) {
            this.setSelectedIndex(0);
        } else {
            this.setForeground(sForeground);
        }
    }

    public void removeAllItems() {
        super.removeAllItems();
        this.addItem(new Prompt());
        this.setForeground(sPromptForeground);
    }

    static {
        if (MJUtilities.isHighContrast()) {
            sForeground = Color.white;
            sPromptForeground = Color.white;
        }
    }

    static class EditableTarget {
        String iString;

        EditableTarget(String string) {
            this.iString = string;
        }

        public String toString() {
            return this.iString;
        }
    }

    private static class RuleTargetComboBoxEditor
    extends BasicComboBoxEditor {
        private RuleTargetComboBoxEditor() {
        }

        @Override
        public void setItem(Object object) {
            super.setItem(object);
            if (object instanceof Prompt) {
                this.getEditorComponent().setForeground(sPromptForeground);
                ((JTextField)this.getEditorComponent()).moveCaretPosition(0);
                ((JTextField)this.getEditorComponent()).setCaretPosition(0);
            } else {
                this.getEditorComponent().setForeground(sForeground);
            }
        }
    }

    private class RuleTargetComboBoxRenderer
    extends BasicComboBoxRenderer {
        private RuleTargetComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object instanceof Prompt) {
                component.setForeground(sPromptForeground);
            } else {
                component.setForeground(sForeground);
            }
            return component;
        }
    }

    static class Prompt {
        Prompt() {
        }

        public String toString() {
            return ImportToolUtils.getResourceString("WorksheetRulePanelComboBox.prompt");
        }
    }
}

