/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.desktop.attr.Attribute;
import com.mathworks.desktop.client.Client;
import com.mathworks.jmi.Matlab;
import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mlwidgets.importtool.AbstractFileTableModel;
import com.mathworks.mlwidgets.importtool.BlankColumnExcludeRule;
import com.mathworks.mlwidgets.importtool.BlankReplacementRule;
import com.mathworks.mlwidgets.importtool.BlankRowExcludeRule;
import com.mathworks.mlwidgets.importtool.HeaderRowListenerInterface;
import com.mathworks.mlwidgets.importtool.ImportClient;
import com.mathworks.mlwidgets.importtool.ImportToolUtils;
import com.mathworks.mlwidgets.importtool.MoreOptionsDropDownButton;
import com.mathworks.mlwidgets.importtool.NonNumericColumnExcludeRule;
import com.mathworks.mlwidgets.importtool.NonNumericReplacementRule;
import com.mathworks.mlwidgets.importtool.NonNumericRowExcludeRule;
import com.mathworks.mlwidgets.importtool.SpreadsheetImportToolGroup;
import com.mathworks.mlwidgets.importtool.StringReplacementRule;
import com.mathworks.mlwidgets.importtool.TextFilePane;
import com.mathworks.mlwidgets.importtool.TextFileTableModel;
import com.mathworks.mlwidgets.importtool.TextTable;
import com.mathworks.mlwidgets.importtool.TextToolstripTab;
import com.mathworks.mlwidgets.importtool.WorksheetRule;
import com.mathworks.mlwidgets.importtool.WorksheetRuleList;
import com.mathworks.mlwidgets.importtool.WorksheetSelectionListener;
import com.mathworks.mlwidgets.importtool.popuplist.EditablePopupButton;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJProgressBar;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.toolstrip.DefaultToolstrip;
import com.mathworks.toolstrip.Toolstrip;
import com.mathworks.toolstrip.ToolstripTab;
import com.mathworks.toolstrip.factory.TSFactory;
import com.mathworks.toolstrip.plaf.TSLookAndFeel;
import com.mathworks.util.Log;
import com.mathworks.widgets.desk.Desktop;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JSpinner;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TextImportClient
extends ImportClient {
    protected boolean fTemporaryFile = false;

    protected TextImportClient(File file) {
        this(file, false);
    }

    protected TextImportClient(File file, boolean bl) {
        super(file);
        this.setName("TextImportClient");
        this.fTemporaryFile = bl;
    }

    public static void open() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                        if (!clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) {
                            JOptionPane.showMessageDialog(null, ImportToolUtils.getResourceString("error.pastenotsupported"), ImportToolUtils.getResourceString("error.title"), 0);
                            return;
                        }
                        File file = File.createTempFile("MatlabImportTool_paste_", "tmp.txt");
                        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file, false));
                        bufferedWriter.write((String)clipboard.getData(DataFlavor.stringFlavor));
                        bufferedWriter.close();
                        file.deleteOnExit();
                        TextImportClient.utOpen(file.getAbsolutePath(), null, true);
                    }
                    catch (UnsupportedFlavorException unsupportedFlavorException) {
                        JOptionPane.showMessageDialog(null, ImportToolUtils.getResourceString("error.pastenotsupported"), ImportToolUtils.getResourceString("error.title"), 0);
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        JOptionPane.showMessageDialog(null, ImportToolUtils.getResourceString("error.pastetoobig"), ImportToolUtils.getResourceString("error.title"), 0);
                    }
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, exception, ImportToolUtils.getResourceString("error.title"), 0);
                }
            }
        });
    }

    public static void open(final String string) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                TextImportClient.utOpen(string, null, false);
            }
        });
    }

    public static void open(final String string, final MJFrame mJFrame) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                TextImportClient.utOpen(string, mJFrame, false);
            }
        });
    }

    @Override
    protected void reOpen(String string) {
        TextImportClient.utOpen(string, null, false);
    }

    private static void utOpen(String string, final MJFrame mJFrame, boolean bl) {
        TextImportClient textImportClient;
        Desktop desktop = MatlabDesktopServices.getDesktop();
        File file = new File(string);
        if (!file.canRead()) {
            JOptionPane.showMessageDialog(null, ImportToolUtils.getResourceString("error.cantread"), ImportToolUtils.getResourceString("error.title"), 0);
            return;
        }
        boolean bl2 = desktop.hadGroup(SpreadsheetImportToolGroup.SPREADSHEETIMPORTTOOLGROUPNAME);
        if (!bl2) {
            desktop.setGroupDocked(SpreadsheetImportToolGroup.SPREADSHEETIMPORTTOOLGROUPNAME, false);
        }
        if (desktop.hasClient(string, SpreadsheetImportToolGroup.SPREADSHEETIMPORTTOOLGROUPNAME)) {
            textImportClient = (TextImportClient)((Object)desktop.getClient(string, SpreadsheetImportToolGroup.SPREADSHEETIMPORTTOOLGROUPNAME));
            if (!textImportClient.getFile().isFile() || !textImportClient.getFile().exists()) {
                MJOptionPane.showMessageDialog((Component)((Object)textImportClient), (Object)ImportToolUtils.getResourceString("messages.deletedworkbook"), (String)file.getName(), (int)1);
                desktop.closeClient(string);
                return;
            }
            if (!textImportClient.isLastLoadedFileContentDifferentThanOnDiskFileContent()) {
                try {
                    TextImportClient.hideWaitProgressWindow(mJFrame);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                desktop.showClient(string);
                return;
            }
            desktop.closeClient((Component)((Object)textImportClient));
        }
        textImportClient = new TextImportClient(file, bl);
        textImportClient.build(new Object(), string, desktop);
        textImportClient.setShortTitle(file.getName());
        textImportClient.addClient(desktop, string);
        ((TextFilePane)textImportClient.getImportComponent()).getWorksheetTableModel().addWorksheetCachedDataListener(new AbstractFileTableModel.WorksheetCachedDataListener(){

            @Override
            public void worksheetCachedDataChanged(EventObject eventObject) {
                try {
                    TextImportClient.hideWaitProgressWindow(mJFrame);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public static MJFrame showWaitProgressWindow() throws InvocationTargetException, InterruptedException {
        final MJFrame mJFrame = new MJFrame();
        mJFrame.setUndecorated(true);
        mJFrame.setAlwaysOnTop(true);
        Desktop desktop = MatlabDesktopServices.getDesktop();
        Rectangle rectangle = desktop.getMainFrame().getBounds();
        mJFrame.setBounds(new Rectangle(rectangle.x + rectangle.width / 2 - 100, rectangle.y + rectangle.height / 2 - 25, 200, 50));
        MJProgressBar mJProgressBar = new MJProgressBar(0, 100);
        if (MJUtilities.isHighContrast()) {
            mJProgressBar.setBorder(BorderFactory.createLineBorder(Color.white, 3));
        } else {
            mJProgressBar.setBorder(BorderFactory.createLineBorder(Color.black, 3));
        }
        mJProgressBar.setStringPainted(true);
        mJProgressBar.setString(ImportToolUtils.getResourceString("textimport.wait"));
        mJProgressBar.setIndeterminate(true);
        mJFrame.getContentPane().add((Component)mJProgressBar);
        if (SwingUtilities.isEventDispatchThread()) {
            mJFrame.show();
        } else {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    mJFrame.show();
                }
            });
        }
        return mJFrame;
    }

    public static void hideWaitProgressWindow(final MJFrame mJFrame) throws InvocationTargetException, InterruptedException {
        if (mJFrame == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            mJFrame.hide();
            mJFrame.dispose();
        } else {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    mJFrame.hide();
                    mJFrame.dispose();
                }
            });
        }
    }

    @Override
    protected void cleanup(boolean bl) {
        if (this.fImportToolstripTab != null) {
            TSFactory.disposeTab((ToolstripTab)this.fImportToolstripTab);
        }
        if (this.fImportComponent != null) {
            ((TextFilePane)this.fImportComponent).cleanup();
            this.fImportComponent = null;
            this.fImportToolstripTab = null;
        }
        if (this.fTemporaryFile) {
            Matlab.whenMatlabIdle((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        File file = TextImportClient.this.getFile();
                        file.delete();
                    }
                    catch (Exception exception) {
                        Log.logException((Exception)exception);
                    }
                }
            });
        }
    }

    private void build(Object object, String string, Desktop desktop) {
        Object object2;
        Object object3;
        Object object4;
        TSLookAndFeel.install();
        this.fImportToolstripTab = new TextToolstripTab(string);
        ((TextToolstripTab)this.fImportToolstripTab).addTextFileTypeListener(new TextToolstripTab.TextFileTypeListener(){

            @Override
            public void textFileTypeChanged(TextToolstripTab.TextFileType textFileType) {
                ((TextFilePane)TextImportClient.this.fImportComponent).setFixedWidth(textFileType == TextToolstripTab.TextFileType.FIXEDWIDTH);
                if (textFileType == TextToolstripTab.TextFileType.FIXEDWIDTH) {
                    ((TextToolstripTab)TextImportClient.this.fImportToolstripTab).setTextFileTypeEnabled(TextToolstripTab.TextFileType.DELIMITED, false);
                } else {
                    ((TextToolstripTab)TextImportClient.this.fImportToolstripTab).setTextFileTypeEnabled(TextToolstripTab.TextFileType.FIXEDWIDTH, false);
                }
                TextImportClient.this.fImportToolstripTab.getComponent().setCursor(new Cursor(3));
                ((TextFilePane)TextImportClient.this.fImportComponent).getWorksheetTableModel().addWorksheetCachedDataListener(new AbstractFileTableModel.WorksheetCachedDataListener(){

                    @Override
                    public void worksheetCachedDataChanged(EventObject eventObject) {
                        if (TextImportClient.this.fImportComponent == null || TextImportClient.this.fImportToolstripTab == null) {
                            return;
                        }
                        ((TextFilePane)TextImportClient.this.fImportComponent).getWorksheetTableModel().removeWorksheetCachedDataListener(this);
                        ((TextToolstripTab)TextImportClient.this.fImportToolstripTab).setTextFileTypeEnabled(TextToolstripTab.TextFileType.DELIMITED, true);
                        ((TextToolstripTab)TextImportClient.this.fImportToolstripTab).setTextFileTypeEnabled(TextToolstripTab.TextFileType.FIXEDWIDTH, true);
                        TextImportClient.this.fImportToolstripTab.getComponent().setCursor(null);
                    }
                });
                TextImportClient.this.fImportComponent.repaint();
            }
        });
        if (desktop != null && desktop.useToolstrip()) {
            this.setToolstripTabs(new ToolstripTab[]{this.fImportToolstripTab});
        } else {
            object4 = new MJPanel((LayoutManager)new BorderLayout());
            object4.setFocusCycleRoot(false);
            object3 = new DefaultToolstrip();
            object2 = object3.getModel();
            object2.add((Client)this.fImportToolstripTab);
            object4.add((Component)object3.getComponent(), (Object)"North");
            object3.setCurrentTab("importData");
            object3.setAttribute((Attribute)Toolstrip.COLLAPSABLE, (Object)false);
            object3.setAttribute((Attribute)Toolstrip.NO_TABS, (Object)true);
            this.add((Component)object4, "North");
        }
        object4 = new ImportClient.Target(ImportClient.TargetType.MATRIX);
        object3 = new ImportClient.Target(ImportClient.TargetType.COLUMNVECTORS);
        object2 = new ImportClient.Target(ImportClient.TargetType.CELLARRAY);
        ImportClient.Target target = new ImportClient.Target(ImportClient.TargetType.DATASET);
        JList jList = this.fImportToolstripTab.getTargetList();
        jList.setCellRenderer(new ImportClient.TargetRenderer());
        ((DefaultListModel)jList.getModel()).add(0, object3);
        ((DefaultListModel)jList.getModel()).add(1, object4);
        ((DefaultListModel)jList.getModel()).add(2, object2);
        if (sHasStats.booleanValue()) {
            ((DefaultListModel)jList.getModel()).add(3, target);
        }
        ArrayList<WorksheetRule> arrayList = new ArrayList<WorksheetRule>();
        arrayList.add(new NonNumericReplacementRule());
        arrayList.add(new NonNumericRowExcludeRule());
        arrayList.add(new NonNumericColumnExcludeRule());
        arrayList.add(new BlankReplacementRule());
        arrayList.add(new BlankRowExcludeRule());
        arrayList.add(new BlankColumnExcludeRule());
        arrayList.add(new StringReplacementRule());
        final WorksheetRuleList worksheetRuleList = this.fImportToolstripTab.getWorksheetRuleList();
        ArrayList<WorksheetRule> arrayList2 = new ArrayList<WorksheetRule>();
        arrayList2.add(new NonNumericReplacementRule());
        ArrayList<WorksheetRule> arrayList3 = new ArrayList<WorksheetRule>();
        arrayList3.add(new NonNumericReplacementRule());
        ((ImportClient.Target)object4).setWorksheetRules(arrayList3);
        ((ImportClient.Target)object3).setWorksheetRules(arrayList2);
        target.setWorksheetRules(arrayList2);
        ((ImportClient.Target)object2).setWorksheetRules(arrayList3);
        worksheetRuleList.setWorksheetRuleList(arrayList2, arrayList);
        worksheetRuleList.fireWorksheetRuleChanged();
        final TextFilePane textFilePane = new TextFilePane(this.fFileLocation, ((ImportClient.Target)object3).getWorksheetRules(), ImportClient.TargetType.COLUMNVECTORS);
        this.fImportToolstripTab.setImporter(textFilePane);
        textFilePane.addWorksheetSelectionListener(this.fImportToolstripTab.getRangeEditBox());
        this.fImportToolstripTab.getRangeEditBox().addWorksheetSelectionListener(textFilePane);
        this.addDelimiterListeners();
        this.fImportToolstripTab.getTargetList().addListSelectionListener(new ListSelectionListener((ImportClient.Target)object4, (ImportClient.Target)object3, (ImportClient.Target)object2, target, jList, arrayList, textFilePane){
            private int iLastSelection = -1;
            final /* synthetic */ ImportClient.Target val$matrixTarget;
            final /* synthetic */ ImportClient.Target val$columnVectorTarget;
            final /* synthetic */ ImportClient.Target val$cellArrayTarget;
            final /* synthetic */ ImportClient.Target val$datasetTarget;
            final /* synthetic */ JList val$targetList;
            final /* synthetic */ List val$rulePrototypes;
            final /* synthetic */ TextFilePane val$tabbedPane;
            {
                this.val$matrixTarget = target;
                this.val$columnVectorTarget = target2;
                this.val$cellArrayTarget = target3;
                this.val$datasetTarget = target4;
                this.val$targetList = jList;
                this.val$rulePrototypes = list;
                this.val$tabbedPane = textFilePane;
            }

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ImportClient.Target target;
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                if (this.iLastSelection >= 0) {
                    target = (ImportClient.Target)((DefaultListModel)TextImportClient.this.fImportToolstripTab.getTargetList().getModel()).get(this.iLastSelection);
                    target.setWorksheetRules(worksheetRuleList.getRules());
                    if (target == this.val$matrixTarget) {
                        this.val$matrixTarget.setWorksheetRules(worksheetRuleList.getRules());
                    } else if (target == this.val$columnVectorTarget) {
                        this.val$columnVectorTarget.setWorksheetRules(worksheetRuleList.getRules());
                    } else if (target == this.val$cellArrayTarget) {
                        this.val$cellArrayTarget.setWorksheetRules(worksheetRuleList.getRules());
                    } else if (target == this.val$datasetTarget) {
                        this.val$datasetTarget.setWorksheetRules(worksheetRuleList.getRules());
                    }
                    worksheetRuleList.removeAllWorksheetRulePanels();
                }
                this.iLastSelection = this.val$targetList.getSelectedIndex();
                target = (ImportClient.Target)((DefaultListModel)TextImportClient.this.fImportToolstripTab.getTargetList().getModel()).get(this.iLastSelection);
                worksheetRuleList.setWorksheetRuleList(target.getWorksheetRules(), this.val$rulePrototypes);
                this.val$tabbedPane.setTargetType(target.getTargetType());
                TextImportClient.this.fImportToolstripTab.getHeaderSpinner().setEnabled(target.getTargetType() == ImportClient.TargetType.COLUMNVECTORS || target.getTargetType() == ImportClient.TargetType.DATASET);
                worksheetRuleList.fireWorksheetRuleChanged();
            }
        });
        this.fImportToolstripTab.getTargetList().setSelectedIndex(0);
        final MoreOptionsDropDownButton moreOptionsDropDownButton = ((TextToolstripTab)this.fImportToolstripTab).getMoreOptionsComboBox();
        moreOptionsDropDownButton.addSelectionListener(new EditablePopupButton.EditablePopupListSelectionListener(){

            @Override
            public void selectionChanged(EditablePopupButton.EditablePopupEvent editablePopupEvent) {
                if (editablePopupEvent.getItem().equals((Object)moreOptionsDropDownButton.getDecimalSeparatorPeriodItem()) && editablePopupEvent.getItem().isSelected()) {
                    ((TextFilePane)TextImportClient.this.fImportComponent).setDecimalSeparator(".");
                } else if (editablePopupEvent.getItem().equals((Object)moreOptionsDropDownButton.getDecimalSeparatorCommaItem()) && editablePopupEvent.getItem().isSelected()) {
                    if (((TextToolstripTab)TextImportClient.this.fImportToolstripTab).getDelimiterComboBox().isCommaDelimiterSelected()) {
                        int n = MJOptionPane.showConfirmDialog((Component)((Object)TextImportClient.this), (Object)ImportToolUtils.getResourceString("messages.commaseparatorconflict"), (String)TextImportClient.this.getFile().getName(), (int)2, (int)2);
                        if (n == 2) {
                            moreOptionsDropDownButton.getDecimalSeparatorPeriodItem().setSelected(true);
                            return;
                        }
                        ((TextToolstripTab)TextImportClient.this.fImportToolstripTab).getDelimiterComboBox().clearCommaDelimiter();
                    }
                    ((TextFilePane)TextImportClient.this.fImportComponent).setDecimalSeparator(",");
                } else if (editablePopupEvent.getItem().equals((Object)moreOptionsDropDownButton.getCoalesceDelimitersItem())) {
                    ((TextFilePane)TextImportClient.this.fImportComponent).setCoalesceDelimiters(editablePopupEvent.getItem().isSelected());
                }
                TextImportClient.this.updateSuggestedDelimiters();
            }

            @Override
            public void temporarySelectionChanged(EditablePopupButton.EditablePopupEvent editablePopupEvent) {
            }
        });
        this.fImportComponent = textFilePane;
        this.add(this.fImportComponent, "Center");
        this.addWorksheetSelectionListener();
        this.addHeaderRowListener((JSpinner)this.fImportToolstripTab.getHeaderSpinner(), (HeaderRowListenerInterface)((Object)this.fImportComponent));
        this.fImportToolstripTab.getWorksheetRuleList().addWorksheetRuleListener(textFilePane);
        ((TextFilePane)this.fImportComponent).getWorksheetTableModel().addWorksheetCachedDataListener(new AbstractFileTableModel.WorksheetCachedDataListener(){

            @Override
            public void worksheetCachedDataChanged(EventObject eventObject) {
                if (!((TextFileTableModel)textFilePane.getTextTable().getWorksheetTableModel()).canRead()) {
                    TextImportClient.this.cantRead();
                    return;
                }
                if (TextImportClient.this.fImportComponent == null) {
                    return;
                }
                ((TextFilePane)TextImportClient.this.fImportComponent).getWorksheetTableModel().removeWorksheetCachedDataListener(this);
                TextImportClient.this.setupDefaultView();
            }
        });
        this.setContextActions(new Action[]{((TextFilePane)this.fImportComponent).getTextTable().getUndoAction(), ((TextFilePane)this.fImportComponent).getTextTable().getRedoAction()});
    }

    private void addWorksheetSelectionListener() {
        ((TextFilePane)this.fImportComponent).addWorksheetSelectionListener(new WorksheetSelectionListener(){

            @Override
            public void selectedDataChanged(String string) {
                if (TextImportClient.this.fImportComponent == null || TextImportClient.this.fImportToolstripTab == null) {
                    return;
                }
                TextImportClient.this.fImportToolstripTab.setImportButtonEnabled(((TextFilePane)TextImportClient.this.fImportComponent).isImportableData());
                TextTable textTable = ((TextFilePane)TextImportClient.this.fImportComponent).getTextTable();
                textTable.setImportContextMenuEnabled(((TextFilePane)TextImportClient.this.fImportComponent).isImportableData());
                TextImportClient.this.fImportToolstripTab.getWorksheetRuleList().setColumnExcludeRulesTransparent(!textTable.allowColumnExcludeRuleEvaluation());
            }

            @Override
            public void selectedDataChanged(String string, boolean bl) {
                this.selectedDataChanged(string);
            }

            @Override
            public void temporarySelectionDataChanged(String string) {
            }
        });
    }

    private void setupDefaultView() {
        try {
            int n;
            String string = ((TextFilePane)this.fImportComponent).getWorksheetTableModel().getTextParser().getDefaultDelimiter();
            String string2 = ((TextFilePane)this.fImportComponent).getWorksheetTableModel().getTextParser().getDefaultDecimalSeparator();
            boolean bl = ((TextFilePane)this.fImportComponent).getWorksheetTableModel().getTextParser().isDefaultFixedWidth();
            ((TextFilePane)this.fImportComponent).setFixedWidthView(bl);
            ((TextToolstripTab)this.fImportToolstripTab).setFixedWidth(bl);
            MoreOptionsDropDownButton moreOptionsDropDownButton = ((TextToolstripTab)this.fImportToolstripTab).getMoreOptionsComboBox();
            moreOptionsDropDownButton.setDecimalSeparator(".".equals(string2) ? MoreOptionsDropDownButton.DECIMAL_SEPARATOR.PERIOD : MoreOptionsDropDownButton.DECIMAL_SEPARATOR.COMMA);
            ((TextToolstripTab)this.fImportToolstripTab).getDelimiterComboBox().setSelectedDelimiter(string);
            if (!bl) {
                this.updateSuggestedDelimiters();
                if (" ".equals(string)) {
                    moreOptionsDropDownButton.setCoalesceDelimiters(true);
                }
            } else {
                ((TextToolstripTab)this.fImportToolstripTab).getDelimiterComboBox().setEnabled(false);
                moreOptionsDropDownButton.getCoalesceDelimitersItem().setEnabled(false);
            }
            if ((n = ((TextFilePane)this.fImportComponent).getWorksheetTableModel().getTextParser().getDefaultHeaderRow()) >= 0) {
                ((TextFilePane)this.fImportComponent).setHeaderRow(n);
                this.setHeaderRowSpinnerDefaultValue((JSpinner)this.fImportToolstripTab.getHeaderSpinner(), n, ((TextFilePane)this.fImportComponent).getWorksheetTableModel().getRowCount());
            }
            ((TextFilePane)this.fImportComponent).getTextTable().setInitialSelection();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog((Component)((Object)this), exception, ImportToolUtils.getResourceString("error.title"), 0);
            Desktop desktop = MatlabDesktopServices.getDesktop();
            desktop.closeClient((Component)((Object)this));
        }
    }

    private void cantRead() {
        JOptionPane.showMessageDialog(null, ImportToolUtils.getResourceString("error.cantread"), ImportToolUtils.getResourceString("error.title"), 0);
        Desktop desktop = MatlabDesktopServices.getDesktop();
        desktop.closeClient((Component)((Object)this));
    }

    private void updateSuggestedDelimiters() {
        MoreOptionsDropDownButton moreOptionsDropDownButton = ((TextToolstripTab)this.fImportToolstripTab).getMoreOptionsComboBox();
        String string = moreOptionsDropDownButton.getDecimalSeparatorPeriodItem().isSelected() ? "." : ",";
        HashMap<String, Integer> hashMap = ((TextFilePane)this.fImportComponent).getWorksheetTableModel().getTextParser().getDefaultDelimitersMap();
        HashMap hashMap2 = (HashMap)hashMap.clone();
        if (hashMap2 != null) {
            hashMap2.remove(string);
            ((TextToolstripTab)this.fImportToolstripTab).getDelimiterComboBox().setSuggestedDelimiters(hashMap2);
        }
    }

    private void addDelimiterListeners() {
        ((TextToolstripTab)this.fImportToolstripTab).getDelimiterComboBox().addItemListener(new EditablePopupButton.EditablePopupListItemListener(){

            @Override
            public void itemAdded(EditablePopupButton.EditablePopupEvent editablePopupEvent) {
            }

            @Override
            public void itemRemoved(EditablePopupButton.EditablePopupEvent editablePopupEvent) {
            }

            @Override
            public void itemNameModified(EditablePopupButton.EditablePopupEvent editablePopupEvent) {
                if (!((TextToolstripTab)TextImportClient.this.fImportToolstripTab).getDelimiterComboBox().getSelectionAdjusting()) {
                    ((TextFilePane)TextImportClient.this.fImportComponent).setDelimiters(((TextToolstripTab)TextImportClient.this.fImportToolstripTab).getDelimiterComboBox().getSelectedFormat(), TextImportClient.this);
                }
            }

            @Override
            public void itemDescriptionModified(EditablePopupButton.EditablePopupEvent editablePopupEvent) {
            }
        });
        ((TextToolstripTab)this.fImportToolstripTab).getDelimiterComboBox().addSelectionListener(new EditablePopupButton.EditablePopupListSelectionListener(){

            @Override
            public void selectionChanged(EditablePopupButton.EditablePopupEvent editablePopupEvent) {
                if (TextImportClient.this.fImportComponent == null || TextImportClient.this.fImportToolstripTab == null) {
                    return;
                }
                if (!((TextToolstripTab)TextImportClient.this.fImportToolstripTab).getDelimiterComboBox().getSelectionAdjusting()) {
                    MoreOptionsDropDownButton moreOptionsDropDownButton = ((TextToolstripTab)TextImportClient.this.fImportToolstripTab).getMoreOptionsComboBox();
                    if (moreOptionsDropDownButton.getDecimalSeparatorCommaItem().isSelected() && ((TextToolstripTab)TextImportClient.this.fImportToolstripTab).getDelimiterComboBox().isCommaDelimiterSelected()) {
                        int n = MJOptionPane.showConfirmDialog((Component)((Object)TextImportClient.this), (Object)ImportToolUtils.getResourceString("messages.separatorcommaconflict"), (String)TextImportClient.this.getFile().getName(), (int)2, (int)2);
                        if (n == 2) {
                            ((TextToolstripTab)TextImportClient.this.fImportToolstripTab).getDelimiterComboBox().clearCommaDelimiter();
                            return;
                        }
                        moreOptionsDropDownButton.getDecimalSeparatorPeriodItem().setSelected(true);
                    }
                    ((TextFilePane)TextImportClient.this.fImportComponent).setDelimiters(((TextToolstripTab)TextImportClient.this.fImportToolstripTab).getDelimiterComboBox().getSelectedFormat(), TextImportClient.this);
                }
            }

            @Override
            public void temporarySelectionChanged(EditablePopupButton.EditablePopupEvent editablePopupEvent) {
            }
        });
    }
}

