/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.desktop.attr.Attribute;
import com.mathworks.desktop.client.Client;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabException;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.jmi.mdt.MatlabCallable;
import com.mathworks.jmi.mdt.MatlabEventQueue;
import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mlwidgets.importtool.AbstractFileTableModel;
import com.mathworks.mlwidgets.importtool.BlankColumnExcludeRule;
import com.mathworks.mlwidgets.importtool.BlankReplacementRule;
import com.mathworks.mlwidgets.importtool.BlankRowExcludeRule;
import com.mathworks.mlwidgets.importtool.DateConversionRule;
import com.mathworks.mlwidgets.importtool.ImportClient;
import com.mathworks.mlwidgets.importtool.ImportToolUtils;
import com.mathworks.mlwidgets.importtool.NonNumericColumnExcludeRule;
import com.mathworks.mlwidgets.importtool.NonNumericReplacementRule;
import com.mathworks.mlwidgets.importtool.NonNumericRowExcludeRule;
import com.mathworks.mlwidgets.importtool.SpreadsheetImportToolGroup;
import com.mathworks.mlwidgets.importtool.SpreadsheetTabbedPane;
import com.mathworks.mlwidgets.importtool.StringReplacementRule;
import com.mathworks.mlwidgets.importtool.WorksheetRule;
import com.mathworks.mlwidgets.importtool.WorksheetRuleList;
import com.mathworks.mlwidgets.importtool.WorksheetRulePanel;
import com.mathworks.mlwidgets.importtool.WorksheetSelectionListener;
import com.mathworks.mlwidgets.importtool.WorksheetTable;
import com.mathworks.mlwidgets.importtool.WorksheetTableModel;
import com.mathworks.mlwidgets.importtool.WorksheetToolstripTab;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJProgressBar;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.toolstrip.DefaultToolstrip;
import com.mathworks.toolstrip.Toolstrip;
import com.mathworks.toolstrip.ToolstripTab;
import com.mathworks.toolstrip.plaf.TSLookAndFeel;
import com.mathworks.util.Log;
import com.mathworks.widgets.desk.Desktop;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.io.File;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JMenuBar;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class SpreadsheetImportClient
extends ImportClient {
    private static int WAITBAR_SIZE_THRESHOLD = 1000000;
    private volatile Object fSpreadsheet;
    private MJPanel fTabbedPanePanel;
    private int fMaxRows = 65569;
    static Boolean sBasicMode = null;

    void setSpreadsheetMCOSObject(Object object) {
        this.fSpreadsheet = object;
    }

    Object getSpreadsheetMCOSObject() {
        return this.fSpreadsheet;
    }

    private SpreadsheetImportClient(File file) {
        super(file);
        this.setName("SpreadsheetImportClient");
    }

    public static void open(final String string) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                SpreadsheetImportClient.utOpen(string);
            }
        });
    }

    @Override
    protected void reOpen(String string) {
        SpreadsheetImportClient.utOpen(string);
    }

    private static void utOpen(final String string) {
        MatlabWorker matlabWorker;
        Object object;
        SpreadsheetImportClient spreadsheetImportClient;
        Desktop desktop = MatlabDesktopServices.getDesktop();
        File file = new File(string);
        boolean bl = desktop.hadGroup(SpreadsheetImportToolGroup.SPREADSHEETIMPORTTOOLGROUPNAME);
        if (!bl) {
            desktop.setGroupDocked(SpreadsheetImportToolGroup.SPREADSHEETIMPORTTOOLGROUPNAME, false);
        }
        if (desktop.hasClient(string, SpreadsheetImportToolGroup.SPREADSHEETIMPORTTOOLGROUPNAME)) {
            spreadsheetImportClient = (SpreadsheetImportClient)((Object)desktop.getClient(string, SpreadsheetImportToolGroup.SPREADSHEETIMPORTTOOLGROUPNAME));
            if (!spreadsheetImportClient.getFile().isFile() || !spreadsheetImportClient.getFile().exists()) {
                MJOptionPane.showMessageDialog((Component)((Object)spreadsheetImportClient), (Object)ImportToolUtils.getResourceString("messages.deletedworkbook"), (String)file.getName(), (int)1);
                desktop.closeClient(string);
                return;
            }
            if (!spreadsheetImportClient.isLastLoadedFileContentDifferentThanOnDiskFileContent()) {
                desktop.showClient(string);
                return;
            }
            spreadsheetImportClient.setFileHash();
        } else {
            spreadsheetImportClient = null;
        }
        MJFrame mJFrame = null;
        if (file.length() > (long)WAITBAR_SIZE_THRESHOLD) {
            mJFrame = new MJFrame();
            mJFrame.setUndecorated(true);
            mJFrame.setAlwaysOnTop(true);
            object = desktop.getMainFrame().getBounds();
            mJFrame.setBounds(new Rectangle(object.x + object.width / 2 - 100, object.y + object.height / 2 - 25, 200, 50));
            matlabWorker = new MJProgressBar(0, 100);
            if (MJUtilities.isHighContrast()) {
                matlabWorker.setBorder(BorderFactory.createLineBorder(Color.white, 3));
            } else {
                matlabWorker.setBorder(BorderFactory.createLineBorder(Color.black, 3));
            }
            matlabWorker.setStringPainted(true);
            matlabWorker.setString(ImportToolUtils.getResourceString("spreadsheetimport.wait"));
            matlabWorker.setIndeterminate(true);
            mJFrame.getContentPane().add((Component)matlabWorker);
            mJFrame.show();
        }
        object = mJFrame;
        matlabWorker = new MatlabWorker((MJFrame)object, file, desktop){
            final /* synthetic */ MJFrame val$finalWaitFrame;
            final /* synthetic */ File val$workbookFile;
            final /* synthetic */ Desktop val$dt;
            {
                this.val$finalWaitFrame = mJFrame;
                this.val$workbookFile = file;
                this.val$dt = desktop;
            }

            public Object runOnMatlabThread() {
                Object[] objectArray;
                try {
                    Object object = spreadsheetImportClient == null ? Matlab.mtEval((String)"internal.matlab.importtool.AbstractSpreadsheet.createSpreadsheet", (int)1) : spreadsheetImportClient.getSpreadsheetMCOSObject();
                    if (sBasicMode == null) {
                        boolean[] blArray = (boolean[])Matlab.mtFeval((String)"isa", (Object[])new Object[]{object, "internal.matlab.importtool.InMemSpreadsheet"}, (int)1);
                        sBasicMode = blArray.length >= 1 && blArray[0];
                    }
                    Matlab.mtFeval((String)"Open", (Object[])new Object[]{object, string}, (int)0);
                    objectArray = (Object[])Matlab.mtFeval((String)"GetInfo", (Object[])new Object[]{object}, (int)3);
                    objectArray[0] = object;
                }
                catch (MatlabException matlabException) {
                    return matlabException;
                }
                catch (Exception exception) {
                    return exception;
                }
                return objectArray;
            }

            public void runOnAWTEventDispatchThread(Object object) {
                Object object2;
                Object[] objectArray = null;
                if (object instanceof MatlabException) {
                    object2 = ImportToolUtils.getResourceString("error.openfailed") + ((MatlabException)((Object)object)).getLocalizedMessage();
                    MJOptionPane.showMessageDialog((Component)MatlabDesktopServices.getDesktop().getMainFrame(), (Object)object2, (String)ImportToolUtils.getResourceString("error.title"), (int)0);
                    object = null;
                } else {
                    if (object instanceof Object[]) {
                        objectArray = (Object[])object;
                    }
                    if (objectArray == null || objectArray.length < 2 || !(objectArray[1] instanceof String[]) || ((String[])objectArray[1]).length == 0) {
                        MJOptionPane.showMessageDialog((Component)MatlabDesktopServices.getDesktop().getMainFrame(), (Object)ImportToolUtils.getResourceString("error.opennonspreadsheet"), (String)ImportToolUtils.getResourceString("error.title"), (int)0);
                        object = null;
                    }
                }
                if (object == null) {
                    if (this.val$finalWaitFrame != null) {
                        this.val$finalWaitFrame.hide();
                    }
                    return;
                }
                if (spreadsheetImportClient == null) {
                    object2 = new SpreadsheetImportClient(this.val$workbookFile);
                    ((SpreadsheetImportClient)((Object)object2)).setSpreadsheetMCOSObject(objectArray[0]);
                    ((SpreadsheetImportClient)((Object)object2)).build(objectArray[0], string, (String[])objectArray[1], this.val$dt);
                    ((SpreadsheetImportClient)((Object)object2)).setShortTitle(this.val$workbookFile.getName());
                    ((ImportClient)((Object)object2)).addClient(this.val$dt, string);
                } else {
                    spreadsheetImportClient.rebuild((String[])objectArray[1]);
                }
                if (this.val$finalWaitFrame != null) {
                    this.val$finalWaitFrame.hide();
                }
            }
        };
        matlabWorker.start();
    }

    public static boolean isBasicMode() {
        return sBasicMode == null ? true : sBasicMode;
    }

    static void setBasicMode(boolean bl) {
        sBasicMode = bl;
    }

    private int getMaxRowCount() {
        return this.fMaxRows;
    }

    public void rebuild(String[] stringArray) {
        if (this.fImportComponent != null) {
            ((SpreadsheetTabbedPane)((Object)this.fImportComponent)).rebuild(stringArray);
        }
    }

    private void build(Object object, String string, String[] stringArray, Desktop desktop) {
        Object object3;
        Object object4;
        Object object5;
        TSLookAndFeel.install();
        this.fImportToolstripTab = new WorksheetToolstripTab(string);
        this.fImportToolstripTab.getFunctionGenerationAction().setEnabled(!SpreadsheetImportClient.isBasicMode());
        if (desktop != null && desktop.useToolstrip()) {
            this.setToolstripTabs(new ToolstripTab[]{this.fImportToolstripTab});
        } else {
            object5 = new MJPanel((LayoutManager)new BorderLayout());
            object5.setFocusCycleRoot(false);
            object4 = new DefaultToolstrip();
            object3 = object4.getModel();
            object3.add((Client)this.fImportToolstripTab);
            object5.add((Component)object4.getComponent(), (Object)"North");
            object4.setCurrentTab("importData");
            object4.setAttribute((Attribute)Toolstrip.COLLAPSABLE, (Object)false);
            object4.setAttribute((Attribute)Toolstrip.NO_TABS, (Object)true);
            this.add((Component)object5, "North");
        }
        object5 = new ImportClient.Target(ImportClient.TargetType.MATRIX);
        object4 = new ImportClient.Target(ImportClient.TargetType.COLUMNVECTORS);
        object3 = new ImportClient.Target(ImportClient.TargetType.CELLARRAY);
        ImportClient.Target target = new ImportClient.Target(ImportClient.TargetType.DATASET);
        final JList jList = this.fImportToolstripTab.getTargetList();
        jList.setCellRenderer(new ImportClient.TargetRenderer());
        ((DefaultListModel)jList.getModel()).add(0, object4);
        ((DefaultListModel)jList.getModel()).add(1, object5);
        ((DefaultListModel)jList.getModel()).add(2, object3);
        if (sHasStats.booleanValue()) {
            ((DefaultListModel)jList.getModel()).add(3, target);
        }
        final WorksheetRuleList worksheetRuleList = this.fImportToolstripTab.getWorksheetRuleList();
        for (WorksheetRule object22 : ((ImportClient.Target)object4).getWorksheetRules()) {
            worksheetRuleList.addWorksheetRulePanel(new WorksheetRulePanel(worksheetRuleList, object22, SpreadsheetImportClient.getRulePrototypes()));
        }
        final SpreadsheetTabbedPane spreadsheetTabbedPane = new SpreadsheetTabbedPane(object, string, stringArray, worksheetRuleList.getRules(), ImportClient.TargetType.COLUMNVECTORS);
        this.fImportToolstripTab.setImporter(spreadsheetTabbedPane);
        spreadsheetTabbedPane.addWorksheetSelectionListener(this.fImportToolstripTab.getRangeEditBox());
        this.fImportToolstripTab.getRangeEditBox().addWorksheetSelectionListener(spreadsheetTabbedPane);
        spreadsheetTabbedPane.addWorksheetSelectionListener(new WorksheetSelectionListener(){

            @Override
            public void selectedDataChanged(String string) {
                boolean bl = spreadsheetTabbedPane.isImportableData();
                SpreadsheetImportClient.this.fImportToolstripTab.setImportButtonEnabled(bl);
                WorksheetTable worksheetTable = ((SpreadsheetTabbedPane)((Object)SpreadsheetImportClient.this.fImportComponent)).getCurrentTabContentPanel().getWorksheetTable();
                worksheetTable.setImportContextMenuEnabled(bl);
                if (jList.getSelectedValue() instanceof ImportClient.Target && !((ImportClient.Target)jList.getSelectedValue()).getTargetType().isCellArray()) {
                    SpreadsheetImportClient.this.fImportToolstripTab.setPromptLabelText(ImportToolUtils.getResourceString("ruletooltip.addruleunimportable"));
                } else {
                    SpreadsheetImportClient.this.fImportToolstripTab.setPromptLabelText(ImportToolUtils.getResourceString("ruletooltip.addruleempty"));
                }
                SpreadsheetImportClient.this.fImportToolstripTab.getWorksheetRuleList().setColumnExcludeRulesTransparent(!worksheetTable.allowColumnExcludeRuleEvaluation());
            }

            @Override
            public void selectedDataChanged(String string, boolean bl) {
                this.selectedDataChanged(string);
            }

            @Override
            public void temporarySelectionDataChanged(String string) {
            }
        });
        this.fImportToolstripTab.getTargetList().setSelectedIndex(0);
        this.fImportToolstripTab.getTargetList().addListSelectionListener(new ListSelectionListener((ImportClient.Target)object5, (ImportClient.Target)object4, target, jList, spreadsheetTabbedPane){
            private int iLastSelection = -1;
            final /* synthetic */ ImportClient.Target val$matrixTarget;
            final /* synthetic */ ImportClient.Target val$columnVectorTarget;
            final /* synthetic */ ImportClient.Target val$datasetTarget;
            final /* synthetic */ JList val$targetList;
            final /* synthetic */ SpreadsheetTabbedPane val$tabbedPane;
            {
                this.val$matrixTarget = target;
                this.val$columnVectorTarget = target2;
                this.val$datasetTarget = target3;
                this.val$targetList = jList;
                this.val$tabbedPane = spreadsheetTabbedPane;
            }

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ImportClient.Target target;
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                if (this.iLastSelection >= 0) {
                    target = (ImportClient.Target)((DefaultListModel)SpreadsheetImportClient.this.fImportToolstripTab.getTargetList().getModel()).get(this.iLastSelection);
                    target.setWorksheetRules(worksheetRuleList.getRules());
                    if (target == this.val$matrixTarget) {
                        this.val$matrixTarget.setWorksheetRules(worksheetRuleList.getRules());
                    } else if (target == this.val$columnVectorTarget) {
                        this.val$columnVectorTarget.setWorksheetRules(worksheetRuleList.getRules());
                    } else if (target == this.val$datasetTarget) {
                        this.val$datasetTarget.setWorksheetRules(worksheetRuleList.getRules());
                    }
                    worksheetRuleList.removeAllWorksheetRulePanels();
                }
                this.iLastSelection = this.val$targetList.getSelectedIndex();
                target = (ImportClient.Target)((DefaultListModel)SpreadsheetImportClient.this.fImportToolstripTab.getTargetList().getModel()).get(this.iLastSelection);
                worksheetRuleList.setWorksheetRuleList(target.getWorksheetRules(), SpreadsheetImportClient.getRulePrototypes());
                this.val$tabbedPane.setTargetType(target.getTargetType());
                SpreadsheetImportClient.this.fImportToolstripTab.getHeaderSpinner().setEnabled(target.getTargetType() == ImportClient.TargetType.COLUMNVECTORS || target.getTargetType() == ImportClient.TargetType.DATASET);
                worksheetRuleList.fireWorksheetRuleChanged();
            }
        });
        this.fImportComponent = spreadsheetTabbedPane;
        this.fTabbedPanePanel = new MJPanel((LayoutManager)new BorderLayout());
        this.fTabbedPanePanel.add((Component)this.fImportComponent, (Object)"Center");
        this.add((Component)this.fTabbedPanePanel, "Center");
        this.fImportToolstripTab.getWorksheetRuleList().addWorksheetRuleListener(spreadsheetTabbedPane);
        this.addHeaderRowListener((JSpinner)this.fImportToolstripTab.getHeaderSpinner(), (SpreadsheetTabbedPane)((Object)this.fImportComponent));
        WorksheetTable worksheetTable = ((SpreadsheetTabbedPane)((Object)this.fImportComponent)).getWorksheetTableAtIndex(0);
        if (worksheetTable != null) {
            worksheetTable.getWorksheetTableModel().addWorksheetCachedDataListener(new AbstractFileTableModel.WorksheetCachedDataListener((ImportClient.Target)object5, (ImportClient.Target)object4, target, worksheetRuleList, worksheetTable){
                final /* synthetic */ ImportClient.Target val$matrixTarget;
                final /* synthetic */ ImportClient.Target val$columnVectorTarget;
                final /* synthetic */ ImportClient.Target val$datasetTarget;
                final /* synthetic */ WorksheetRuleList val$worksheetRuleList;
                final /* synthetic */ WorksheetTable val$worksheetTableInFirstTab;
                {
                    this.val$matrixTarget = target;
                    this.val$columnVectorTarget = target2;
                    this.val$datasetTarget = target3;
                    this.val$worksheetRuleList = worksheetRuleList;
                    this.val$worksheetTableInFirstTab = worksheetTable;
                }

                @Override
                public void worksheetCachedDataChanged(EventObject eventObject) {
                    final WorksheetTableModel worksheetTableModel = (WorksheetTableModel)eventObject.getSource();
                    List<WorksheetRule> list = worksheetTableModel.getDefaultWorksheetRuleList();
                    List<WorksheetRule> list2 = worksheetTableModel.getDefaultWorksheetRuleList();
                    this.val$matrixTarget.setWorksheetRules(list);
                    this.val$columnVectorTarget.setWorksheetRules(list2);
                    this.val$datasetTarget.setWorksheetRules(list2);
                    this.val$worksheetRuleList.setWorksheetRuleList(list2, SpreadsheetImportClient.getRulePrototypes());
                    this.val$worksheetRuleList.fireWorksheetRuleChanged();
                    worksheetTableModel.removeWorksheetCachedDataListener(this);
                    this.val$worksheetTableInFirstTab.getWorksheetTableModel().addWorksheetCachedDataListener(new AbstractFileTableModel.WorksheetCachedDataListener(){

                        @Override
                        public void worksheetCachedDataChanged(EventObject eventObject) {
                            val$worksheetTableInFirstTab.setInitialSelection();
                            worksheetTableModel.removeWorksheetCachedDataListener(this);
                        }
                    });
                }
            });
        }
        if (desktop != null) {
            ((SpreadsheetTabbedPane)((Object)this.fImportComponent)).addSpreadsheetTabSelectionListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    SpreadsheetImportClient.this.setMenuBar((JMenuBar)((Object)new ImportClient.ImportToolMenuBar(((SpreadsheetTabbedPane)((Object)SpreadsheetImportClient.this.fImportComponent)).getCurrentTabContentPanel().getWorksheetTable())));
                    SpreadsheetImportClient.this.resetRowheaderSpinnerForCurrentTab();
                }
            });
            this.setMenuBar((JMenuBar)((Object)new ImportClient.ImportToolMenuBar(worksheetTable)));
        }
        this.resetRowheaderSpinnerForCurrentTab();
    }

    private void resetRowheaderSpinnerForCurrentTab() {
        final WorksheetTableModel worksheetTableModel = (WorksheetTableModel)((SpreadsheetTabbedPane)((Object)this.fImportComponent)).getCurrentTabContentPanel().getWorksheetTable().getWorksheetTableModel();
        if (worksheetTableModel.getRowCount() > 0) {
            this.setHeaderRowSpinnerDefaultValue((JSpinner)this.fImportToolstripTab.getHeaderSpinner(), worksheetTableModel.getTopHeaderRow(), worksheetTableModel.getRowCount());
        } else {
            worksheetTableModel.addWorksheetCachedDataListener(new AbstractFileTableModel.WorksheetCachedDataListener(){

                @Override
                public void worksheetCachedDataChanged(EventObject eventObject) {
                    if (SpreadsheetImportClient.this.fImportToolstripTab != null) {
                        SpreadsheetImportClient.this.setHeaderRowSpinnerDefaultValue((JSpinner)SpreadsheetImportClient.this.fImportToolstripTab.getHeaderSpinner(), worksheetTableModel.getTopHeaderRow(), worksheetTableModel.getRowCount());
                    }
                    worksheetTableModel.removeWorksheetCachedDataListener(this);
                }
            });
        }
    }

    static List<WorksheetRule> getRulePrototypes() {
        ArrayList<WorksheetRule> arrayList = new ArrayList<WorksheetRule>();
        arrayList.add(new NonNumericColumnExcludeRule());
        arrayList.add(new NonNumericReplacementRule());
        arrayList.add(new NonNumericRowExcludeRule());
        arrayList.add(new BlankRowExcludeRule());
        arrayList.add(new BlankColumnExcludeRule());
        arrayList.add(new BlankReplacementRule());
        if (!SpreadsheetImportClient.isBasicMode()) {
            arrayList.add(new DateConversionRule());
        }
        arrayList.add(new StringReplacementRule());
        return arrayList;
    }

    @Override
    public void cleanup(boolean bl) {
        if (Matlab.isMatlabAvailable()) {
            if (bl) {
                Future future = MatlabEventQueue.invoke((MatlabCallable)new MatlabCallable<Object>(){

                    public void callOnEdt(Object object, boolean bl) {
                    }

                    public Object call() {
                        try {
                            boolean[] blArray = (boolean[])Matlab.mtFeval((String)"isvalid", (Object[])new Object[]{SpreadsheetImportClient.this.fSpreadsheet}, (int)1);
                            if (blArray != null && blArray.length >= 1 && blArray[0]) {
                                Matlab.mtFeval((String)"delete", (Object[])new Object[]{SpreadsheetImportClient.this.fSpreadsheet}, (int)0);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return null;
                    }
                });
                try {
                    future.get(500L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException timeoutException) {
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.fSpreadsheet = null;
            } else {
                MatlabWorker matlabWorker = new MatlabWorker(){

                    public Object runOnMatlabThread() {
                        try {
                            boolean[] blArray = (boolean[])Matlab.mtFeval((String)"isvalid", (Object[])new Object[]{SpreadsheetImportClient.this.fSpreadsheet}, (int)1);
                            if (blArray != null && blArray.length >= 1 && blArray[0]) {
                                Matlab.mtFeval((String)"delete", (Object[])new Object[]{SpreadsheetImportClient.this.fSpreadsheet}, (int)0);
                            }
                        }
                        catch (Exception exception) {
                            Log.log((String)exception.toString());
                        }
                        SpreadsheetImportClient.this.fSpreadsheet = null;
                        return null;
                    }

                    public void runOnAWTEventDispatchThread(Object object) {
                    }
                };
                matlabWorker.start();
            }
        }
        if (this.fImportComponent != null) {
            ((SpreadsheetTabbedPane)((Object)this.fImportComponent)).cleanup();
            this.fImportComponent = null;
            this.fImportToolstripTab = null;
        }
    }
}

