/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.mlwidgets.importtool.ImportToolUtils;
import com.mathworks.mwswing.MJFormattedTextField;
import com.mathworks.mwswing.MJSpinner;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;

public class ReverseSpinner
extends MJSpinner {
    private ReverseSpinnerNumberModel fModel;
    private boolean fShowMinimumValue = false;

    public ReverseSpinner(int n, int n2, int n3, int n4, boolean bl) {
        this.fShowMinimumValue = bl;
        this.fModel = new ReverseSpinnerNumberModel(n, n2, n3, n4);
        this.setModel(this.fModel);
        this.setEditor(new ReverseSpinnerEditor(this));
    }

    public boolean getShowMinimumValue() {
        return this.fShowMinimumValue;
    }

    public void setShowMinimumValue(boolean bl) {
        this.fShowMinimumValue = bl;
    }

    private static class DisabledAction
    implements Action {
        private DisabledAction() {
        }

        @Override
        public Object getValue(String string) {
            return null;
        }

        @Override
        public void putValue(String string, Object object) {
        }

        @Override
        public void setEnabled(boolean bl) {
        }

        @Override
        public boolean isEnabled() {
            return false;
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    public class ReverseSpinnerNumberModel
    extends SpinnerNumberModel {
        public ReverseSpinnerNumberModel(int n, int n2, int n3, int n4) {
            super(n, n2, n3, n4);
        }

        private Number incrValue(int n) {
            Number number;
            Number number2 = (Number)this.getValue();
            Number number3 = this.getStepSize();
            Comparable<?> comparable = this.getMaximum();
            Comparable<?> comparable2 = this.getMinimum();
            if (number2 instanceof Float || number2 instanceof Double) {
                double d = number2.doubleValue() + number3.doubleValue() * (double)n;
                number = number2 instanceof Double ? (Number)new Double(d) : (Number)new Float(d);
            } else {
                long l = number2.longValue() + number3.longValue() * (long)n;
                number = number2 instanceof Long ? (Number)new Long(l) : (Number)(number2 instanceof Integer ? (Number)new Integer((int)l) : (Number)(number2 instanceof Short ? (Number)new Short((short)l) : (Number)new Byte((byte)l)));
            }
            if (comparable != null && comparable.compareTo(number) < 0) {
                return null;
            }
            if (comparable2 != null && comparable2.compareTo(number) > 0) {
                return null;
            }
            return number;
        }

        @Override
        public Object getNextValue() {
            return this.incrValue(-1);
        }

        @Override
        public Object getPreviousValue() {
            return this.incrValue(1);
        }
    }

    public class ReverseSpinnerTextField
    extends MJFormattedTextField {
        ReverseSpinner fSpinner;

        public ReverseSpinnerTextField(ReverseSpinner reverseSpinner2) {
            this.fSpinner = reverseSpinner2;
            this.setEditable(true);
        }

        public void setValue(Object object) {
            ReverseSpinnerNumberModel reverseSpinnerNumberModel = (ReverseSpinnerNumberModel)this.fSpinner.getModel();
            if (object != null && object.equals(reverseSpinnerNumberModel.getMinimum()) && !ReverseSpinner.this.fShowMinimumValue) {
                super.setValue((Object)ImportToolUtils.getResourceString("toolstrip.variablenamesnone"));
            } else {
                super.setValue(object);
            }
        }
    }

    public class ReverseSpinnerEditor
    extends JSpinner.DefaultEditor {
        ReverseSpinner fSpinner;
        private final Action DISABLED_ACTION;
        private ReverseSpinnerTextField fReverseSpinnerTextField;

        public ReverseSpinnerEditor(ReverseSpinner reverseSpinner2) {
            super((JSpinner)((Object)reverseSpinner2));
            this.DISABLED_ACTION = new DisabledAction();
            this.fSpinner = reverseSpinner2;
            JFormattedTextField jFormattedTextField = this.getTextField();
            this.remove(jFormattedTextField);
            this.fReverseSpinnerTextField = new ReverseSpinnerTextField(reverseSpinner2);
            this.fReverseSpinnerTextField.setName("Spinner.formattedTextField");
            this.fReverseSpinnerTextField.setValue(reverseSpinner2.getValue());
            this.fReverseSpinnerTextField.addPropertyChangeListener(this);
            this.fReverseSpinnerTextField.setEditable(true);
            this.fReverseSpinnerTextField.setInheritsPopupMenu(true);
            String string = reverseSpinner2.getToolTipText();
            if (string != null) {
                this.fReverseSpinnerTextField.setToolTipText(string);
            }
            this.add((Component)((Object)this.fReverseSpinnerTextField));
            this.setLayout(this);
            ActionMap actionMap = this.fReverseSpinnerTextField.getActionMap();
            if (actionMap != null) {
                actionMap.put("increment", this.DISABLED_ACTION);
                actionMap.put("decrement", this.DISABLED_ACTION);
            }
            this.fReverseSpinnerTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    super.keyPressed(keyEvent);
                    if (keyEvent.getKeyCode() == 10) {
                        ReverseSpinnerEditor.this.validateSpinnerData(ReverseSpinnerEditor.this.fSpinner, (JTextField)((Object)ReverseSpinnerEditor.this.fReverseSpinnerTextField));
                    }
                }
            });
            this.fReverseSpinnerTextField.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    super.mouseClicked(mouseEvent);
                    SpinnerMouseFocusLostListener spinnerMouseFocusLostListener = new SpinnerMouseFocusLostListener(ReverseSpinnerEditor.this.fSpinner);
                    long l = 16L;
                    Toolkit.getDefaultToolkit().addAWTEventListener(spinnerMouseFocusLostListener, l);
                }
            });
        }

        private void validateSpinnerData(ReverseSpinner reverseSpinner, JTextField jTextField) {
            ReverseSpinnerNumberModel reverseSpinnerNumberModel = (ReverseSpinnerNumberModel)reverseSpinner.getModel();
            try {
                String string = jTextField.getText();
                int n = string.toLowerCase().equals(ImportToolUtils.getResourceString("toolstrip.variablenamesnone").toLowerCase()) ? ((Integer)reverseSpinnerNumberModel.getMinimum()).intValue() : Integer.valueOf(string).intValue();
                if (n > (Integer)reverseSpinnerNumberModel.getMaximum()) {
                    reverseSpinner.setValue(reverseSpinnerNumberModel.getMaximum());
                    jTextField.setText(reverseSpinner.getValue().toString());
                } else if (n <= (Integer)reverseSpinnerNumberModel.getMinimum()) {
                    reverseSpinner.setValue((Integer)reverseSpinnerNumberModel.getMinimum());
                    if (!this.fSpinner.getShowMinimumValue()) {
                        jTextField.setText(ImportToolUtils.getResourceString("toolstrip.variablenamesnone"));
                    } else {
                        jTextField.setText(reverseSpinnerNumberModel.getMinimum().toString());
                    }
                } else {
                    reverseSpinner.setValue(n);
                    jTextField.setText(reverseSpinner.getValue().toString());
                }
            }
            catch (Exception exception) {
                jTextField.setText(reverseSpinner.getValue().toString());
            }
        }

        public class SpinnerMouseFocusLostListener
        implements AWTEventListener {
            ReverseSpinner fSpinner;

            public SpinnerMouseFocusLostListener(ReverseSpinner reverseSpinner) {
                this.fSpinner = reverseSpinner;
            }

            @Override
            public void eventDispatched(AWTEvent aWTEvent) {
                try {
                    MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                    if (this.fSpinner.isVisible() && mouseEvent.getClickCount() > 0 && mouseEvent.getID() == 501) {
                        Point point = mouseEvent.getLocationOnScreen();
                        Rectangle rectangle = this.fSpinner.getBounds();
                        Point point2 = this.fSpinner.getLocationOnScreen();
                        rectangle.x = point2.x;
                        rectangle.y = point2.y;
                        if (!rectangle.contains(point)) {
                            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
                            ReverseSpinnerEditor.this.validateSpinnerData(this.fSpinner, ((ReverseSpinnerEditor)this.fSpinner.getEditor()).getTextField());
                            this.fSpinner.repaint();
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

