/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.html;

import com.mathworks.mlwidgets.html.HTMLRenderer;
import com.mathworks.mlwidgets.html.HTMLRendererActions;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJToolBar;
import javax.swing.Action;
import javax.swing.JButton;

public class HTMLBrowserToolbar
extends MJToolBar {
    private HTMLRenderer fHtmlRenderer;
    private boolean fWantHomeButton;
    private String fHomeButtonTooltip;

    public HTMLBrowserToolbar(HTMLRenderer hTMLRenderer) {
        this(hTMLRenderer, false, null);
    }

    public HTMLBrowserToolbar(HTMLRenderer hTMLRenderer, boolean bl) {
        this(hTMLRenderer, bl, null);
    }

    public HTMLBrowserToolbar(HTMLRenderer hTMLRenderer, boolean bl, String string) {
        this.setFloatable(false);
        this.fWantHomeButton = bl;
        this.fHomeButtonTooltip = string;
        this.fHtmlRenderer = hTMLRenderer;
        this.addDefaultItems();
    }

    public JButton add(Action action) {
        JButton jButton = super.add(action);
        if (this.fHtmlRenderer != null) {
            this.fHtmlRenderer.getAcceleratorHelper().addAction(action);
        }
        return jButton;
    }

    protected void addDefaultItems() {
        HTMLRendererActions hTMLRendererActions = this.fHtmlRenderer != null ? this.fHtmlRenderer.getActions() : new HTMLRendererActions(null, true);
        this.add((Action)((Object)hTMLRendererActions.fGoBackAction));
        this.add((Action)((Object)hTMLRendererActions.fGoForwardAction));
        this.add((Action)((Object)hTMLRendererActions.fReloadAction));
        if (this.fWantHomeButton) {
            this.add((Action)((Object)hTMLRendererActions.fHomeAction));
            if (this.fHomeButtonTooltip != null) {
                hTMLRendererActions.fHomeAction.setTip(this.fHomeButtonTooltip);
            }
        }
        this.addSeparator();
        this.add((Action)((Object)hTMLRendererActions.fPrintAction));
        this.addSeparator();
        this.add((Action)((Object)hTMLRendererActions.fFindAction));
    }

    public void addCustomButton(MJAbstractAction mJAbstractAction) {
        this.removeAll();
        this.add((Action)mJAbstractAction);
        this.addSeparator();
        this.addDefaultItems();
    }

    public void removeCustomButton(MJAbstractAction mJAbstractAction) {
        this.removeAll();
        this.addDefaultItems();
    }
}

