/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.html;

import com.mathworks.mlwidgets.html.AddressObject;
import com.mathworks.mlwidgets.html.HTMLUtils;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJToolBar;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class HTMLBrowserAddressBox
extends MJToolBar {
    private MJComboBox fAddressBox;
    private DefaultComboBoxModel fComboModel;
    private AddressActionListener fAddressActionListener;
    private MJLabel fAddressLabel;
    private ActionListener fAddressBoxListener;

    public HTMLBrowserAddressBox(ActionListener actionListener) {
        this.setFloatable(false);
        this.fAddressBoxListener = actionListener;
        this.fAddressBox = new MJComboBox(new Vector());
        this.fAddressBox.setEditable(true);
        this.fAddressActionListener = new AddressActionListener();
        this.fAddressBox.addActionListener((ActionListener)this.fAddressActionListener);
        this.fAddressBox.setName("Title ComboBox");
        this.fComboModel = new DefaultComboBoxModel();
        this.fAddressBox.setModel((ComboBoxModel)this.fComboModel);
        this.fAddressLabel = new MJLabel();
        this.setAddressLabelText();
        this.fAddressLabel.setBorder((Border)new EmptyBorder(0, 3, 0, 3));
        this.add((Component)this.fAddressLabel);
        this.add((Component)this.fAddressBox);
    }

    public void removeAllItems() {
        this.fAddressBox.removeAllItems();
    }

    private void setAddressLabelText() {
        this.fAddressLabel.setText(HTMLUtils.sRes.getString("icecontainer.address_label_location"));
        this.fAddressBox.getAccessibleContext().setAccessibleName(HTMLUtils.sRes.getString("icecontainer.acc.address_label_location"));
    }

    private void processComboboxActionEvent() {
        String string;
        Object object = this.fAddressBox.getSelectedItem();
        if (object instanceof AddressObject) {
            AddressObject addressObject = (AddressObject)object;
            string = addressObject.getUrl();
            this.addUrlToCombobox(addressObject.getTitle(), string);
        } else {
            string = (String)object;
        }
        if (string == null) {
            return;
        }
        this.fAddressBoxListener.actionPerformed(new ActionEvent((Object)this, 0, string));
    }

    public void addUrlToCombobox(String string, String string2) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.addUrlToComboboxMethod(string, string2);
        } else {
            SwingUtilities.invokeLater(new AddUrlToComboboxThread(string, string2));
        }
    }

    private void addUrlToComboboxMethod(String string, String string2) {
        AddressObject addressObject = new AddressObject(string, string2);
        if (this.fAddressActionListener != null) {
            this.fAddressBox.removeActionListener((ActionListener)this.fAddressActionListener);
        }
        this.fComboModel.removeElement(addressObject);
        this.fComboModel.insertElementAt(addressObject, 0);
        this.fAddressBox.getEditor().setItem(addressObject);
        this.fAddressBox.setSelectedItem((Object)addressObject);
        if (this.fAddressActionListener != null) {
            this.fAddressBox.addActionListener((ActionListener)this.fAddressActionListener);
        }
    }

    public Dimension getMaximumSize() {
        Dimension dimension = super.getMaximumSize();
        dimension.height = this.getPreferredSize().height;
        return dimension;
    }

    private class AddUrlToComboboxThread
    implements Runnable {
        private String fTitle;
        private String fUrl;

        AddUrlToComboboxThread(String string, String string2) {
            this.fTitle = string;
            this.fUrl = string2;
        }

        @Override
        public void run() {
            HTMLBrowserAddressBox.this.addUrlToComboboxMethod(this.fTitle, this.fUrl);
        }
    }

    private class ComboboxActionPerformedThread
    implements Runnable {
        private ComboboxActionPerformedThread() {
        }

        @Override
        public void run() {
            if (!HTMLBrowserAddressBox.this.fAddressBox.isPopupVisible()) {
                HTMLBrowserAddressBox.this.processComboboxActionEvent();
            }
        }
    }

    private class AddressActionListener
    implements ActionListener {
        private AddressActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand().equals("comboBoxChanged")) {
                SwingUtilities.invokeLater(new ComboboxActionPerformedThread());
            }
        }
    }
}

