/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.graphics;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabEvent;
import com.mathworks.jmi.MatlabListener;
import com.mathworks.mlwidgets.graphics.PlotAction;
import com.mathworks.mlwidgets.graphics.PlotCatalogPanel;
import com.mathworks.mlwidgets.graphics.PlotWidgetsResources;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PlotCatalog
extends MJFrame
implements MatlabListener,
ListSelectionListener {
    protected static Dimension DEFAULT_SIZE = new Dimension(750, 650);
    protected static Dimension MINIMUM_SIZE = new Dimension(440, 250);
    protected static PlotCatalog SINGLETON = null;
    protected PlotCatalogPanel fPlotCatalogPanel = PlotCatalogPanel.createPlotCatalogPanel();
    private MJButton fPlotButton;
    private MJButton fPlotNewFigureButton;
    CompletionObserver plotCmdObserver = new CompletionObserver(){

        public void completed(int n, Object object) {
            if (object != null && object instanceof String && !((String)object).equals("") && ((String)object).indexOf("Warning") == -1) {
                JOptionPane.showMessageDialog((Component)((Object)PlotCatalog.this), (String)object, PlotWidgetsResources.getBundle().getString("PlotCatalog.error"), 0);
            }
        }
    };

    public static PlotCatalog getInstance() {
        if (SINGLETON == null) {
            SINGLETON = new PlotCatalog();
        }
        return SINGLETON;
    }

    private PlotCatalog() {
        super(PlotWidgetsResources.getBundle().getString("PlotCatalog.title"));
        this.setName("Plot Catalog");
        this.fPlotButton = new MJButton(PlotWidgetsResources.getBundle().getString("PlotCatalog.button.plot"));
        this.getRootPane().setDefaultButton((JButton)this.fPlotButton);
        this.fPlotButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PlotCatalog.this.doPlotCommand(false);
            }
        });
        this.fPlotButton.setName("Plot.Button");
        this.fPlotNewFigureButton = new MJButton(PlotWidgetsResources.getBundle().getString("PlotCatalog.button.plotnew"));
        this.fPlotNewFigureButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PlotCatalog.this.doPlotCommand(true);
            }
        });
        this.fPlotNewFigureButton.setName("PlotNew.Button");
        MJButton mJButton = new MJButton(PlotWidgetsResources.getBundle().getString("PlotCatalog.button.close"));
        mJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PlotCatalog.this.setVisible(false);
            }
        });
        mJButton.setName("Close.Button");
        this.fPlotCatalogPanel.fPlotTypeList.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    PlotCatalog.this.doPlotCommand(false);
                }
            }
        });
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout());
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new GridLayout(1, 3, 5, 5));
        mJPanel2.add((Component)this.fPlotButton);
        mJPanel2.add((Component)this.fPlotNewFigureButton);
        mJPanel2.add((Component)mJButton);
        mJPanel.add((Component)mJPanel2, (Object)"East");
        MJPanel mJPanel3 = new MJPanel();
        mJPanel3.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
        mJPanel3.setLayout((LayoutManager)new BorderLayout(10, 10));
        mJPanel3.add((Component)((Object)this.fPlotCatalogPanel), (Object)"Center");
        mJPanel3.add((Component)mJPanel, (Object)"South");
        this.getContentPane().add((Component)mJPanel3);
        this.pack();
        this.setSize(DEFAULT_SIZE);
        this.setMinimumSize(MINIMUM_SIZE);
        this.fPlotCatalogPanel.addListSelectionListener(this);
        this.fPlotCatalogPanel.setDefaultSliderLocation(DEFAULT_SIZE);
        Matlab.addListener((MatlabListener)this);
    }

    public void setPlottedVars(String[] stringArray) {
        this.fPlotCatalogPanel.setPlottedVars(stringArray);
    }

    protected void doPlotCommand(boolean bl) {
        PlotAction plotAction = this.fPlotCatalogPanel.getCurrentPlotAction();
        if (plotAction != null) {
            if (bl && !plotAction.isGUI()) {
                plotAction.executeInNewFigure(this.fPlotCatalogPanel.fPlottedVars, this);
            } else {
                plotAction.execute(this.fPlotCatalogPanel.fPlottedVars, this);
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            this.fPlotNewFigureButton.setEnabled(this.fPlotCatalogPanel.isCurrentPlotEnabled());
            this.fPlotButton.setEnabled(this.fPlotCatalogPanel.isCurrentPlotEnabled());
        }
    }

    public void dispose() {
        this.fPlotCatalogPanel.cleanup();
        SINGLETON = null;
        super.dispose();
    }

    public void matlabEvent(MatlabEvent matlabEvent) {
        if (1 == matlabEvent.getEventType() && this.fPlotCatalogPanel != null) {
            this.fPlotCatalogPanel.cleanup();
        }
    }
}

