/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.model.realfs;

import com.mathworks.jmi.Matlab;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystem;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.FileSystemTransaction;
import com.mathworks.mlwidgets.explorer.model.realfs.RealFileSystem;
import com.mathworks.mlwidgets.explorer.model.realfs.WindowsNativeRecycle;
import com.mathworks.mlwidgets.explorer.util.MatlabUtils;
import com.mathworks.util.AsyncReceiver;
import com.mathworks.util.FileSystemUtils;
import com.mathworks.util.Holder;
import com.mathworks.util.NativeJava;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.Predicate;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;

final class RealFileSystemTransaction
implements FileSystemTransaction {
    private static FileLocation sUnixTempLocation;
    private static final Matlab sMatlab;

    RealFileSystemTransaction() {
    }

    public FileSystem getSystem() {
        return RealFileSystem.getInstance();
    }

    public OutputStream getOutputStream(FileLocation fileLocation) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(fileLocation.toFile());
        FileSystemUtils.getFileSystemNotifier().created(fileLocation.toFile());
        FileSystemUtils.getFileSystemNotifier().changed(fileLocation.toFile());
        return fileOutputStream;
    }

    public void setPermissions(FileLocation fileLocation, long l) throws IOException {
    }

    public void createDirectory(FileLocation fileLocation) throws IOException {
        File file = fileLocation.toFile();
        file.mkdirs();
        if (!this.getSystem().exists(fileLocation)) {
            throw new IOException("Could not create " + fileLocation);
        }
        FileSystemUtils.getFileSystemNotifier().created(fileLocation.toFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void delete(FileLocation fileLocation, boolean bl) throws IOException {
        if (bl && PlatformInfo.isLinux()) {
            if (sUnixTempLocation == null) {
                Class<RealFileSystemTransaction> clazz = RealFileSystemTransaction.class;
                // MONITORENTER : com.mathworks.mlwidgets.explorer.model.realfs.RealFileSystemTransaction.class
                try {
                    sUnixTempLocation = new FileLocation((String)MatlabUtils.evalAndWait("tempdir", 1));
                }
                catch (Exception exception) {
                    sUnixTempLocation = new FileLocation("/tmp/");
                }
            }
            this.move(fileLocation, new FileLocation(sUnixTempLocation, fileLocation.getName()));
            return;
        }
        File file = fileLocation.toFile();
        if (PlatformInfo.isMacintosh() && !bl && file.isDirectory()) {
            RealFileSystemTransaction.deleteMacDirectory(file);
        } else {
            try {
                if (file.isDirectory() && Matlab.isMatlabAvailable()) {
                    sMatlab.evalNoOutput("rmdir('" + file.getAbsolutePath() + "','s')");
                } else {
                    FileUtils.forceDelete((File)file);
                }
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
        }
        FileSystemUtils.getFileSystemNotifier().deleted(file);
    }

    private static void deleteMacDirectory(final File file) throws IOException {
        final Holder holder = new Holder();
        NativeJava.listFiles((String)file.getAbsolutePath(), (AsyncReceiver)new AsyncReceiver<NativeJava.StatEntry>(){

            public boolean receive(NativeJava.StatEntry statEntry) {
                File file2 = new File(file, statEntry.getName());
                if (statEntry.s_isdir) {
                    try {
                        RealFileSystemTransaction.deleteMacDirectory(file2);
                    }
                    catch (IOException iOException) {
                        holder.set((Object)iOException);
                    }
                } else {
                    if (!file2.delete()) {
                        holder.set((Object)new IOException("Could not delete " + file2.getAbsolutePath()));
                    }
                    FileSystemUtils.getFileSystemNotifier().deleted(file2);
                }
                return holder.get() == null;
            }
        });
        if (holder.get() != null) {
            throw (IOException)holder.get();
        }
        if (!file.delete()) {
            throw new IOException("Could not delete " + file.getAbsolutePath());
        }
        FileSystemUtils.getFileSystemNotifier().deleted(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Component component, List<FileLocation> list, boolean bl, Predicate<FileSystemEntry> predicate, final AsyncReceiver<FileLocation> asyncReceiver) throws IOException {
        File[] fileArray = new File[list.size()];
        Iterator<FileLocation> iterator = list.iterator();
        for (int i = 0; i < fileArray.length; ++i) {
            fileArray[i] = iterator.next().toFile();
        }
        if (bl && PlatformInfo.isWindows()) {
            WindowsNativeRecycle.windowsNativeDelete(component, fileArray, new AsyncReceiver<File>(){

                public boolean receive(File file) {
                    FileSystemUtils.getFileSystemNotifier().deleted(file);
                    return asyncReceiver.receive((Object)new FileLocation(file));
                }

                public void finished() {
                    asyncReceiver.finished();
                }
            });
        } else if (bl && PlatformInfo.isMacintosh()) {
            try {
                for (FileLocation fileLocation : list) {
                    boolean bl2;
                    boolean bl3 = bl2 = NativeJava.trashFile((String)fileLocation.toString()) && !fileLocation.toFile().exists();
                    if (!bl2 && predicate.accept((Object)RealFileSystem.getInstance().getEntry(fileLocation))) {
                        this.delete(fileLocation, false);
                        FileSystemUtils.getFileSystemNotifier().deleted(fileLocation.toFile());
                        if (asyncReceiver.receive((Object)fileLocation)) continue;
                    }
                    if (!bl2) continue;
                    FileSystemUtils.getFileSystemNotifier().deleted(fileLocation.toFile());
                }
            }
            finally {
                asyncReceiver.finished();
            }
        } else {
            try {
                for (FileLocation fileLocation : list) {
                    if (!predicate.accept((Object)RealFileSystem.getInstance().getEntry(fileLocation))) continue;
                    this.delete(fileLocation, bl);
                    if (asyncReceiver.receive((Object)fileLocation)) continue;
                    break;
                }
            }
            finally {
                asyncReceiver.finished();
            }
        }
    }

    public void move(FileLocation fileLocation, FileLocation fileLocation2) throws IOException {
        if (fileLocation.getParent().equals((Object)fileLocation2.getParent())) {
            File file;
            File file2 = fileLocation.toFile();
            if (!file2.renameTo(file = fileLocation2.toFile())) {
                throw new IOException("Could not move " + file2 + " to " + file);
            }
            FileSystemUtils.getFileSystemNotifier().moved(fileLocation.toFile(), fileLocation2.toFile());
        } else {
            this.copy(fileLocation, fileLocation2);
            FileSystemUtils.getFileSystemNotifier().moved(fileLocation.toFile(), fileLocation2.toFile());
            this.delete(fileLocation, false);
        }
    }

    public void copy(FileLocation fileLocation, FileLocation fileLocation2) throws IOException {
        NativeJava.StatEntry statEntry;
        File file = new File(fileLocation.toString());
        File file2 = new File(fileLocation2.toString());
        if (file.isDirectory()) {
            FileUtils.copyDirectory((File)file, (File)file2);
        } else {
            FileUtils.copyFile((File)file, (File)file2);
        }
        if (PlatformInfo.isUnix() && (statEntry = NativeJava.getStat((String)fileLocation.toString())) != null) {
            NativeJava.setPermissions((String)fileLocation2.toString(), (long)statEntry.st_mode);
        }
        FileSystemUtils.getFileSystemNotifier().created(file2);
    }

    public void close() {
    }

    static {
        sMatlab = new Matlab();
    }
}

