/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.extensions.archive;

import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystem;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.FileSystemTransaction;
import com.mathworks.mlwidgets.explorer.extensions.archive.ZipFileSystem;
import com.mathworks.mlwidgets.explorer.util.FileSystemUtils;
import com.mathworks.mlwidgets.explorer.util.MLFileSystemUtils;
import com.mathworks.mlwidgets.explorer.util.TransactionLogic;
import com.mathworks.util.AsyncReceiver;
import com.mathworks.util.Holder;
import com.mathworks.util.Predicate;
import com.mathworks.util.ThrowableClosure;
import java.awt.Component;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;

final class ZipFileTransaction
implements FileSystemTransaction {
    private final ZipFileSystem fSystem;
    private final FileSystemEntry fZipFile;
    private final FileSystemEntry fTempRoot;
    private final FileSystemTransaction fTempTransaction;
    private final List<Runnable> fOutputRunnables;

    ZipFileTransaction(ZipFileSystem zipFileSystem, FileSystemEntry fileSystemEntry) throws IOException {
        this.fSystem = zipFileSystem;
        this.fZipFile = fileSystemEntry;
        this.fTempRoot = MLFileSystemUtils.getMatlabAccessibleEntry(this.fSystem.getEntry(FileLocation.ROOT), false);
        this.fTempTransaction = this.fTempRoot.getSystem().createTransaction();
        this.fOutputRunnables = new LinkedList<Runnable>();
    }

    public FileSystem getSystem() {
        return this.fSystem;
    }

    public OutputStream getOutputStream(FileLocation fileLocation) throws IOException {
        FileLocation fileLocation2 = new FileLocation(this.fTempRoot.getLocation(), fileLocation.toString());
        return this.fTempTransaction.getOutputStream(fileLocation2);
    }

    public void setPermissions(FileLocation fileLocation, long l) throws IOException {
        FileLocation fileLocation2 = new FileLocation(this.fTempRoot.getLocation(), fileLocation.toString());
        this.fTempTransaction.setPermissions(fileLocation2, l);
    }

    public void createDirectory(FileLocation fileLocation) throws IOException {
        FileLocation fileLocation2 = new FileLocation(this.fTempRoot.getLocation(), fileLocation.toString());
        this.fTempTransaction.createDirectory(fileLocation2);
    }

    public void delete(FileLocation fileLocation, boolean bl) throws IOException {
        FileLocation fileLocation2 = new FileLocation(this.fTempRoot.getLocation(), fileLocation.toString());
        this.fTempTransaction.delete(fileLocation2, bl);
    }

    public void delete(Component component, List<FileLocation> list, boolean bl, Predicate<FileSystemEntry> predicate, final AsyncReceiver<FileLocation> asyncReceiver) throws IOException {
        ArrayList<FileLocation> arrayList = new ArrayList<FileLocation>();
        for (FileLocation fileLocation : list) {
            arrayList.add(new FileLocation(this.fTempRoot.getLocation(), fileLocation.toString()));
        }
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        this.fTempTransaction.delete(component, arrayList, bl, predicate, (AsyncReceiver)new AsyncReceiver<FileLocation>(){

            public boolean receive(FileLocation fileLocation) {
                return asyncReceiver.receive((Object)fileLocation);
            }

            public void finished() {
                ZipFileTransaction.this.fSystem.flushEntries();
                ZipFileTransaction.this.fOutputRunnables.add(new Runnable(){

                    @Override
                    public void run() {
                        asyncReceiver.finished();
                    }
                });
                countDownLatch.countDown();
            }
        });
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            throw new IllegalStateException(interruptedException);
        }
    }

    public void move(FileLocation fileLocation, FileLocation fileLocation2) throws IOException {
        FileLocation fileLocation3 = new FileLocation(this.fTempRoot.getLocation(), fileLocation2.toString());
        FileLocation fileLocation4 = new FileLocation(this.fTempRoot.getLocation(), fileLocation.toString());
        this.fTempTransaction.move(fileLocation4, fileLocation3);
    }

    public void copy(FileLocation fileLocation, FileLocation fileLocation2) throws IOException {
        FileLocation fileLocation3 = new FileLocation(this.fTempRoot.getLocation(), fileLocation.toString());
        FileLocation fileLocation4 = new FileLocation(this.fTempRoot.getLocation(), fileLocation2.toString());
        this.fTempTransaction.copy(fileLocation3, fileLocation4);
    }

    public void close() throws IOException {
        ZipFileTransaction.compressFromTemp(this.fTempRoot, this.fZipFile);
        this.fSystem.flushEntries();
        for (Runnable runnable : this.fOutputRunnables) {
            runnable.run();
        }
        this.fOutputRunnables.clear();
    }

    private static void compressFromTemp(final FileSystemEntry fileSystemEntry, final FileSystemEntry fileSystemEntry2) throws IOException {
        FileSystemUtils.withTransaction(fileSystemEntry2.getSystem(), new TransactionLogic(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(FileSystemTransaction fileSystemTransaction) throws IOException {
                final Holder holder = new Holder();
                final Holder holder2 = new Holder();
                holder2.set((Object)true);
                try {
                    ZipOutputStream zipOutputStream = new ZipOutputStream(fileSystemTransaction.getOutputStream(fileSystemEntry2.getLocation()));
                    zipOutputStream.setEncoding("UTF-8");
                    holder.set((Object)zipOutputStream);
                    FileSystemUtils.traverse(fileSystemEntry, FileSystemUtils.TraversalMode.ITERATIVE, new ThrowableClosure<Void, FileSystemEntry, IOException>(){

                        public Void run(FileSystemEntry fileSystemEntry) throws IOException {
                            FileLocation fileLocation = fileSystemEntry.getLocation().stripPrefix(fileSystemEntry.getLocation());
                            String string = fileLocation.toString().replace('\\', '/');
                            if (fileSystemEntry.isFolder()) {
                                string = string + "/";
                            }
                            if (!string.equals("/")) {
                                holder2.set((Object)false);
                                ZipEntry zipEntry = new ZipEntry(string);
                                zipEntry.setSize(fileSystemEntry.getSize());
                                zipEntry.setTime(fileSystemEntry.getDateModified().getTime());
                                ((ZipOutputStream)holder.get()).putNextEntry(zipEntry);
                                if (!fileSystemEntry.isFolder()) {
                                    FileSystemUtils.copy(fileSystemEntry, (OutputStream)holder.get());
                                }
                                ((ZipOutputStream)holder.get()).closeEntry();
                            }
                            return null;
                        }
                    });
                }
                finally {
                    if (holder.get() != null) {
                        try {
                            ((ZipOutputStream)holder.get()).close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        });
    }
}

