/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array.editors;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.mlservices.WorkspaceVariable;
import com.mathworks.mlwidgets.array.UpdatableData;
import com.mathworks.mlwidgets.workspace.FetchedValueBuffer;
import com.mathworks.mlwidgets.workspace.StatisticalFunction;
import com.mathworks.mlwidgets.workspace.ValueLookup;
import com.mathworks.mlwidgets.workspace.WhosInformation;
import com.mathworks.mlwidgets.workspace.WhosRecordlistModel;
import com.mathworks.mlwidgets.workspace.WorkspaceCommands;
import com.mathworks.mlwidgets.workspace.WorkspaceResources;
import com.mathworks.widgets.recordlist.ICopyingObserver;
import com.mathworks.widgets.recordlist.IEditingObserver;
import com.mathworks.widgets.recordlist.IOpeningObserver;
import com.mathworks.widgets.recordlist.IRecordEditor;
import com.mathworks.widgets.recordlist.IRecordFieldCopier;
import com.mathworks.widgets.recordlist.IRecordOpener;
import com.mathworks.widgets.recordlist.IRecordQueryInformant;
import com.mathworks.widgets.recordlist.IRestrictedSortRecordlist;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public abstract class MatlabWorkspaceLikeModel
extends WhosRecordlistModel
implements UpdatableData,
ValueLookup,
IRecordOpener,
IRecordEditor,
IRecordFieldCopier,
IRestrictedSortRecordlist {
    private ActionListener fOpenActionListener;
    protected int fLastColumnIndex = this.STD();
    protected FetchedValueBuffer[] fBufferedValueLists;
    private IRecordQueryInformant fQueryInformant = null;
    protected WorkspaceVariable fVariable;

    public int VALUE() {
        return 1;
    }

    @Override
    public int SIZE() {
        return super.SIZE() + 1;
    }

    @Override
    public int CLASS() {
        return super.CLASS();
    }

    public int MIN() {
        return this.CLASS() + 1;
    }

    public int MAX() {
        return this.CLASS() + 2;
    }

    public int RANGE() {
        return this.CLASS() + 3;
    }

    public int MEAN() {
        return this.CLASS() + 4;
    }

    public int MEDIAN() {
        return this.CLASS() + 5;
    }

    public int MODE() {
        return this.CLASS() + 6;
    }

    public int VAR() {
        return this.CLASS() + 7;
    }

    public int STD() {
        return this.CLASS() + 8;
    }

    public MatlabWorkspaceLikeModel(WorkspaceVariable workspaceVariable) {
        this.fVariable = workspaceVariable;
        this.fQueryInformant = new RecordQuery();
        this.initializeBufferedValueLists();
        this.updateData();
    }

    void rename(String string) {
        this.fVariable.setVariableName(string);
    }

    @Override
    public synchronized Object getValueAt(int n, int n2) {
        Object object = !this.isCalculatedField(n2) ? super.getValueAt(n, n2) : this.fBufferedValueLists[this.calculatedFieldToHashIndex(n2)].getValueAt(this.getValueAt(n, this.NAME()).toString(), this.fVariable.getWorkspaceID(), this.getValueAt(n, this.CLASS()).toString(), n2, this.fQueryInformant.getForthcomingRequestRegion(n));
        return object;
    }

    @Override
    public Class<?> getFieldClass(int n) {
        Class clazz = String.class;
        if (n != this.VALUE()) {
            clazz = super.getFieldClass(n);
        }
        return clazz;
    }

    @Override
    public int getFieldCount() {
        return this.fLastColumnIndex + 1;
    }

    @Override
    public String getFieldName(int n) {
        if (n == this.VALUE()) {
            return WorkspaceResources.getBundle().getString("fieldname.value");
        }
        if (this.isStatisticalField(n)) {
            return this.getStatFunctionFromField(n).getDescription();
        }
        return super.getFieldName(n);
    }

    @Override
    public void lookupValue(String[] stringArray, int n, StatisticalFunction statisticalFunction, CompletionObserver completionObserver) {
        if (statisticalFunction == null) {
            this.lookupValueInMatlab(stringArray, n, completionObserver);
        } else {
            this.lookupStatInMatlab(stringArray, n, statisticalFunction, completionObserver);
        }
    }

    private void lookupValueInMatlab(String[] stringArray, int n, CompletionObserver completionObserver) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = this.fVariable.getWorkspaceVariableNameTemp() + '.' + stringArray[i];
        }
        WorkspaceCommands.getVariableShortObjects(stringArray2, n, completionObserver);
    }

    private void lookupStatInMatlab(String[] stringArray, int n, StatisticalFunction statisticalFunction, CompletionObserver completionObserver) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = this.fVariable.getWorkspaceVariableNameTemp() + '.' + stringArray[i];
        }
        WorkspaceCommands.getVariableStatObjects(stringArray2, n, statisticalFunction, completionObserver);
    }

    private void initializeBufferedValueLists() {
        this.fBufferedValueLists = new FetchedValueBuffer[this.fLastColumnIndex + 1];
        for (int i = 0; i <= this.fLastColumnIndex; ++i) {
            if (!this.isCalculatedField(i)) continue;
            StatisticalFunction statisticalFunction = this.getStatFunctionFromField(i);
            this.fBufferedValueLists[this.calculatedFieldToHashIndex((int)i)] = new FetchedValueBuffer(this, this, statisticalFunction);
        }
    }

    private boolean isCalculatedField(int n) {
        return n == this.VALUE() || this.isStatisticalField(n);
    }

    private boolean isStatisticalField(int n) {
        return n == this.MIN() || n == this.MAX() || n == this.RANGE() || n == this.MEAN() || n == this.MEDIAN() || n == this.MODE() || n == this.VAR() || n == this.STD();
    }

    protected int calculatedFieldToHashIndex(int n) {
        if (n == this.VALUE()) {
            return 0;
        }
        if (this.isStatisticalField(n)) {
            return n - this.CLASS();
        }
        return -1;
    }

    public boolean areRecordsOpenable(int[] nArray) {
        return nArray.length > 0;
    }

    public void openRecords(int[] nArray, IOpeningObserver iOpeningObserver) {
        String[] stringArray = this.getFullNamesFromIDs(nArray);
        if (stringArray.length == 0) {
            return;
        }
        if (this.fOpenActionListener == null) {
            int n = iOpeningObserver.openingStarted(nArray);
            WorkspaceVariable[] workspaceVariableArray = new WorkspaceVariable[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                workspaceVariableArray[i] = new WorkspaceVariable(stringArray[i], this.fVariable.getWorkspaceID());
            }
            WorkspaceCommands.openVariables(workspaceVariableArray);
            iOpeningObserver.openingCompleted(n, WorkspaceResources.getBundle().getString("error.open"));
        } else {
            assert (stringArray.length == 1);
            this.fOpenActionListener.actionPerformed(new ActionEvent(this, 1001, stringArray[0]));
        }
    }

    public void setOpenActionListener(ActionListener actionListener) {
        this.fOpenActionListener = actionListener;
    }

    public int[] getUnsortableFields() {
        int[] nArray = new int[]{this.VALUE(), this.MIN(), this.MAX(), this.RANGE(), this.MEAN(), this.MEDIAN(), this.MODE(), this.VAR(), this.STD()};
        return nArray;
    }

    @Override
    public void copyRecords(int[] nArray, int n, ICopyingObserver iCopyingObserver) {
        int n2;
        int n3 = iCopyingObserver.copyingStarted(nArray);
        StringBuilder stringBuilder = new StringBuilder();
        String string = n == this.NAME() ? this.fVariable.getVariableName() + "." : "";
        String[] stringArray = new String[nArray.length];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            String string2 = sEditingFormatter.format(this.getValueAt(nArray[n2], n));
            stringArray[n2] = string2 != null ? string + string2.toString() : string;
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            stringBuilder.append(stringArray[n2]);
            if (n2 + 1 >= stringArray.length) continue;
            stringBuilder.append(", ");
        }
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(stringBuilder.toString()), null);
        iCopyingObserver.copyingCompleted(n3, WorkspaceResources.getBundle().getString("error.copy"));
    }

    @Override
    protected void setWhosInformation(WhosInformation whosInformation) {
        super.setWhosInformation(whosInformation);
        if (this.getRecordCount() == 0) {
            for (int i = 0; i <= this.fLastColumnIndex; ++i) {
                if (!this.isCalculatedField(i)) continue;
                this.fBufferedValueLists[this.calculatedFieldToHashIndex(i)].cleanAllValues();
            }
        } else {
            for (int i = 0; i <= this.fLastColumnIndex; ++i) {
                if (!this.isCalculatedField(i)) continue;
                this.fBufferedValueLists[this.calculatedFieldToHashIndex(i)].prepareForNewValues();
            }
        }
    }

    protected String[] getFullNamesFromIDs(int[] nArray) {
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            stringArray[i] = this.fVariable.getVariableName() + '.' + this.getValueAt(nArray[i], this.NAME());
        }
        return stringArray;
    }

    private StatisticalFunction getStatFunctionFromField(int n) {
        if (n == this.MIN()) {
            return StatisticalFunction.MIN;
        }
        if (n == this.MAX()) {
            return StatisticalFunction.MAX;
        }
        if (n == this.RANGE()) {
            return StatisticalFunction.RANGE;
        }
        if (n == this.MEAN()) {
            return StatisticalFunction.MEAN;
        }
        if (n == this.MEDIAN()) {
            return StatisticalFunction.MEDIAN;
        }
        if (n == this.MODE()) {
            return StatisticalFunction.MODE;
        }
        if (n == this.VAR()) {
            return StatisticalFunction.VAR;
        }
        if (n == this.STD()) {
            return StatisticalFunction.STD;
        }
        return null;
    }

    private static class RecordQuery
    implements IRecordQueryInformant {
        private static final int BUFFER_SIZE = 32;

        private RecordQuery() {
        }

        public int[] getForthcomingRequestRegion(int n) {
            int[] nArray;
            nArray = new int[]{n / 32 * 32, nArray[0] + 32 - 1};
            return nArray;
        }
    }

    protected class ValueObserver
    implements CompletionObserver {
        private IEditingObserver fObserver;
        private String fVarName;

        ValueObserver(IEditingObserver iEditingObserver, String string) {
            this.fObserver = iEditingObserver;
            this.fVarName = string;
        }

        public void completed(int n, Object object) {
            int n2 = Matlab.getExecutionStatus((int)n);
            int n3 = 0;
            String string = null;
            switch (n2) {
                case 0: {
                    n3 = 0;
                    break;
                }
                case 1: {
                    string = WorkspaceResources.getBundle().getString("error.reassign.syntax");
                    break;
                }
                case 2: {
                    string = WorkspaceResources.getBundle().getString("error.reassign.evaluation");
                    break;
                }
                default: {
                    string = WorkspaceResources.getBundle().getString("error.reassign.unknown");
                }
            }
            if (string != null) {
                n3 = 2;
                MatlabWorkspaceLikeModel.this.fBufferedValueLists[MatlabWorkspaceLikeModel.this.calculatedFieldToHashIndex(MatlabWorkspaceLikeModel.this.VALUE())].backOutValue(this.fVarName);
            }
            this.fObserver.editingCompleted(n3, string);
        }
    }
}

