/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array;

import com.mathworks.jmi.Matlab;
import com.mathworks.mlservices.WorkspaceVariable;
import com.mathworks.mlwidgets.array.ArrayUtils;
import com.mathworks.mlwidgets.array.ValueTableModel;
import com.mathworks.widgets.datatransfer.SimpleVariableDefinition;
import com.mathworks.widgets.datatransfer.VariableIdentifier;
import com.mathworks.widgets.datatransfer.VariableLiteral;
import com.mathworks.widgets.spreadsheet.AbstractSpreadsheetTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class RefreshableVariableLiteral
implements VariableLiteral {
    private VariableIdentifier fIdentifier;
    private String fMatlabLiteral = "";
    private String fExternalLiteral = "";

    protected RefreshableVariableLiteral(VariableIdentifier variableIdentifier) {
        this.fIdentifier = variableIdentifier;
    }

    public static void createFromIdentifier(VariableIdentifier variableIdentifier, ChangeListener changeListener) {
        RefreshableVariableLiteral refreshableVariableLiteral = new RefreshableVariableLiteral(variableIdentifier);
        refreshableVariableLiteral.refresh(changeListener);
    }

    public void refresh(ChangeListener changeListener) {
        if (!Matlab.isMatlabAvailable()) {
            changeListener.stateChanged(new ChangeEvent(this));
            return;
        }
        ValueTableModel valueTableModel = new ValueTableModel(new WorkspaceVariable(this.fIdentifier.getExpression(), this.fIdentifier.getWorkspaceID()), false);
        TableModelListenerImple tableModelListenerImple = new TableModelListenerImple(changeListener);
        valueTableModel.addTableModelListener(tableModelListenerImple);
    }

    public String getMatlabLiteral() {
        return this.fMatlabLiteral;
    }

    public String getExternalLiteral() {
        return this.fExternalLiteral;
    }

    public static void populateClipboardFromIdentifier(VariableIdentifier variableIdentifier, ChangeListener changeListener) {
        RefreshableVariableLiteral.createFromIdentifier(variableIdentifier, new CopyChangeListener(variableIdentifier, changeListener));
    }

    private static class CopyChangeListener
    implements ChangeListener {
        private VariableIdentifier fIdentifier;
        private ChangeListener fChangeListener;

        CopyChangeListener(VariableIdentifier variableIdentifier, ChangeListener changeListener) {
            this.fIdentifier = variableIdentifier;
            this.fChangeListener = changeListener;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            RefreshableVariableLiteral refreshableVariableLiteral = (RefreshableVariableLiteral)changeEvent.getSource();
            new SimpleVariableDefinition(this.fIdentifier, (VariableLiteral)refreshableVariableLiteral).populateClipboards();
            if (this.fChangeListener != null) {
                this.fChangeListener.stateChanged(changeEvent);
            }
        }
    }

    private class TableModelListenerImple
    implements TableModelListener {
        private ChangeListener fChangeListener;

        TableModelListenerImple(ChangeListener changeListener) {
            this.fChangeListener = changeListener;
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            block4: {
                ValueTableModel valueTableModel = (ValueTableModel)tableModelEvent.getSource();
                int n = valueTableModel.getType();
                if (n != -1) {
                    try {
                        RefreshableVariableLiteral.this.fMatlabLiteral = ArrayUtils.arrayToMatlabConstructor(valueTableModel, n, n == 1 || n == 4 || n == 0);
                        RefreshableVariableLiteral.this.fExternalLiteral = ArrayUtils.arrayToTabbedConstructor(valueTableModel, n, n == 1 || n == 4 || n == 0);
                        if (this.fChangeListener != null) {
                            this.fChangeListener.stateChanged((ChangeEvent)new AbstractSpreadsheetTable.TableModelChangeEvent((Object)RefreshableVariableLiteral.this));
                        }
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        RefreshableVariableLiteral.this.fMatlabLiteral = (RefreshableVariableLiteral.this.fExternalLiteral = null);
                        if (this.fChangeListener == null) break block4;
                        this.fChangeListener.stateChanged((ChangeEvent)new AbstractSpreadsheetTable.TableModelChangeEvent((Object)RefreshableVariableLiteral.this, (Throwable)outOfMemoryError));
                    }
                }
            }
            this.fChangeListener = null;
        }
    }
}

