/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.actionbrowser;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mlwidgets.actionbrowser.AbstractActionTable;
import com.mathworks.mlwidgets.actionbrowser.ActionToolTip;
import com.mathworks.mlwidgets.actionbrowser.DragableGripper;
import com.mathworks.mlwidgets.actionbrowser.HelpOnSelectionProvider;
import com.mathworks.mlwidgets.actionbrowser.LightScrollBarUI;
import com.mathworks.mlwidgets.actionbrowser.MACCornerGrip;
import com.mathworks.mlwidgets.actionbrowser.TearOffAble;
import com.mathworks.mlwidgets.actionbrowser.TransparentDialog;
import com.mathworks.mlwidgets.help.HelpUtils;
import com.mathworks.mwswing.ComponentMover;
import com.mathworks.mwswing.MJCornerGrip;
import com.mathworks.mwswing.MJGrip;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollBar;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.HyperlinkLabel;
import com.mathworks.widgets.desk.DTTitleButton;
import com.mathworks.widgets.tooltip.TooltipUtils;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public final class ActionToolTipPanel
extends MJPanel
implements TearOffAble {
    static Dimension DEFAULT_SIZE = new Dimension(410, 240);
    private static String[] sFontsWithNoSpecialRenderering = new String[]{"MS UI Gothic"};
    private static int INSET_GAP = 10;
    private static Color BANNER_COLOR = new Color(217, 218, 188);
    private TextPanel fhtmlPane;
    private MJLabel fTitleLabel;
    private String fFuncName;
    private DragableGripper fGripper;
    private static final String resStr = "com.mathworks.mlwidgets.actionbrowser.resources.RES_ActionBrowser";
    private static final String key = "ActionToolTip.";
    private static ResourceBundle resources = ResourceBundle.getBundle("com.mathworks.mlwidgets.actionbrowser.resources.RES_ActionBrowser");
    private MJPanel fGripperPanel;
    private ActionToolTip fActionToolTip;
    private ComponentMover fMover;
    private MJScrollPane fLightScrollPane;
    private static int TITLEBAR_HEIGHT = 16;
    private DTTitleButton fCloseButton;
    private WindowListener fWindowListener;
    private URL fURL;
    private WheelFocusMouseListener fWheelFocusMouseListener;
    private HelpOnSelectionProvider fHelpOnSelectionProvider;
    private boolean fUseAntiAliasing = true;
    private MJPanel fHelpLinkPanel;

    public ActionToolTipPanel(HelpOnSelectionProvider helpOnSelectionProvider) {
        this(helpOnSelectionProvider, true);
    }

    public ActionToolTipPanel(HelpOnSelectionProvider helpOnSelectionProvider, boolean bl) {
        super((LayoutManager)new BorderLayout(0, 0));
        this.fHelpOnSelectionProvider = helpOnSelectionProvider;
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.setBackground(BANNER_COLOR);
        this.setPreferredSize(new Dimension(ActionToolTipPanel.DEFAULT_SIZE.width + INSET_GAP, ActionToolTipPanel.DEFAULT_SIZE.height + INSET_GAP));
        this.setOpaque(true);
        this.setBackground(UIManager.getColor("ToolTip.background"));
        this.fhtmlPane = new TextPanel();
        this.fhtmlPane.setName("ActionToolTipPanel:fhtmlPane");
        this.applyMatlabFonts();
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout(0, 0));
        mJPanel.setBackground(BANNER_COLOR);
        mJPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 0));
        this.fTitleLabel = new MJLabel(this.fFuncName, 2);
        this.fTitleLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        Font font = this.fhtmlPane.getFont().deriveFont(1, 20.0f);
        this.fTitleLabel.setFont(font);
        HyperlinkLabel hyperlinkLabel = new HyperlinkLabel("{0}", new HyperlinkLabel.HyperlinkItem[]{new HyperlinkLabel.HyperlinkItem(resources.getString("ActionToolTip.HOSLink"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Rectangle rectangle = ActionToolTipPanel.this.getBounds();
                rectangle.x = ActionToolTipPanel.this.getLocationOnScreen().x;
                rectangle.y = ActionToolTipPanel.this.getLocationOnScreen().y;
                if (ActionToolTipPanel.this.fURL != null) {
                    ActionToolTipPanel.this.fHelpOnSelectionProvider.showHelpOnSelection(ActionToolTipPanel.this.fURL, rectangle);
                } else {
                    ActionToolTipPanel.this.fHelpOnSelectionProvider.showHelpOnSelection(ActionToolTipPanel.this.fFuncName, rectangle);
                }
                if (ActionToolTipPanel.this.fActionToolTip != null) {
                    ActionToolTipPanel.this.fActionToolTip.hide();
                }
            }
        }, "FunctionHints:HelpHyperlink", "")});
        hyperlinkLabel.setBackground(BANNER_COLOR);
        this.fHelpLinkPanel = new MJPanel((LayoutManager)new GridLayout(1, 1));
        this.fHelpLinkPanel.setBackground(BANNER_COLOR);
        MJPanel mJPanel2 = new MJPanel();
        mJPanel2.setBackground(BANNER_COLOR);
        mJPanel2.add((Component)hyperlinkLabel);
        this.fHelpLinkPanel.add((Component)mJPanel2);
        mJPanel.add((Component)this.fTitleLabel, (Object)"Center");
        mJPanel.add((Component)this.fHelpLinkPanel, (Object)"East");
        this.fGripper = new DragableGripper(this, resources.getString("ActionToolTip.TearOffTip"));
        this.fGripper.setName("FunctionBrowser:fGripper");
        this.fGripperPanel = new MJPanel((LayoutManager)new BorderLayout());
        this.fGripperPanel.add((Component)((Object)this.fGripper), (Object)"North");
        this.fGripperPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        mJPanel.add((Component)this.fGripperPanel, (Object)"North");
        this.fGripperPanel.setBackground(mJPanel.getBackground());
        this.fGripperPanel.setVisible(bl);
        this.fLightScrollPane = new MJScrollPane((Component)this.fhtmlPane, 20, 30);
        this.fLightScrollPane.setWheelScrollingEnabled(true);
        this.fLightScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.fLightScrollPane.setOpaque(true);
        LightScrollBar lightScrollBar = new LightScrollBar();
        lightScrollBar.setUnitIncrement(5);
        Dimension dimension = this.getPreferredSize();
        Dimension dimension2 = mJPanel.getPreferredSize();
        if (dimension != null && dimension2 != null) {
            lightScrollBar.setBlockIncrement(dimension.height - dimension2.height);
        }
        this.fLightScrollPane.setVerticalScrollBar((JScrollBar)((Object)lightScrollBar));
        this.add((Component)this.fLightScrollPane, "Center");
        this.add((Component)mJPanel, "North");
    }

    @Override
    public void makeFloating() {
        TransparentDialog transparentDialog = (TransparentDialog)((Object)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        int n = this.fGripper.getHeight();
        Dimension dimension = this.getSize();
        int n2 = TITLEBAR_HEIGHT - n;
        dimension.height += n2;
        this.addWindowListener((Dialog)((Object)transparentDialog));
        this.fhtmlPane.removeMouseListener(this.fWheelFocusMouseListener);
        MJGrip mJGrip = new MJGrip();
        mJGrip.setName("FunctionBrowser:fFrameMover");
        mJGrip.setBorder(BorderFactory.createEmptyBorder(TITLEBAR_HEIGHT / 2, 2, TITLEBAR_HEIGHT / 2, 2));
        mJGrip.setPreferredSize(new Dimension(8, TITLEBAR_HEIGHT));
        mJGrip.setComponentToMove((Component)((Object)transparentDialog));
        mJGrip.setShouldDrawGripper(false);
        mJGrip.setShouldDrawGradient(true);
        if (PlatformInfo.isIntelMac()) {
            mJGrip.setShouldDrawGradient(true);
        }
        mJGrip.setCursor(new Cursor(13));
        this.fGripperPanel.add((Component)mJGrip, (Object)"Center");
        this.fCloseButton = new DTTitleButton(5);
        FormLayout formLayout = new FormLayout("d:grow", "d");
        CellConstraints cellConstraints = new CellConstraints();
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, (JPanel)this.fGripperPanel);
        String string = PlatformInfo.isMacintosh() ? "left" : "right";
        panelBuilder.add((Component)this.fCloseButton, cellConstraints.xy(1, 1, string + ", center"));
        panelBuilder.add((Component)mJGrip, cellConstraints.xy(1, 1, "fill, fill"));
        this.fGripper.setVisible(false);
        this.fGripperPanel.revalidate();
        this.fGripperPanel.setBackground((Color)SystemColor.activeCaption);
        this.parentPanelToContainer((Window)((Object)transparentDialog));
        this.fActionToolTip.detach();
        this.fActionToolTip = null;
        MACCornerGrip mACCornerGrip = PlatformInfo.isMacintosh() ? MACCornerGrip.createAlwaysVisibleCornerGrip() : MJCornerGrip.createAlwaysVisibleCornerGrip();
        mACCornerGrip.setBackground(UIManager.getColor("ToolTip.background"));
        mACCornerGrip.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        mJPanel.add((Component)mACCornerGrip, (Object)"East");
        mJPanel.setBackground(UIManager.getColor("ToolTip.background"));
        this.add((Component)mJPanel, "South");
        transparentDialog.setFocusableWindowState(true);
        transparentDialog.requestFocus();
        transparentDialog.setSize(this.getSize());
        this.revalidate();
        this.repaint();
    }

    @Override
    public void floatingComplete() {
        this.fGripper.removeMouseListener((MouseListener)this.fMover);
        this.fGripper.removeMouseMotionListener((MouseMotionListener)this.fMover);
    }

    private void parentPanelToContainer(final Window window) {
        for (ActionListener actionListener : this.fCloseButton.getActionListeners()) {
            this.fCloseButton.removeActionListener(actionListener);
        }
        this.fCloseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                window.dispose();
            }
        });
    }

    void setHelpLinkVisible(boolean bl) {
        this.fHelpLinkPanel.setVisible(bl);
    }

    void setToolTipManager(ActionToolTip actionToolTip) {
        this.fActionToolTip = actionToolTip;
        this.fWheelFocusMouseListener = new WheelFocusMouseListener(this.fActionToolTip);
        this.fhtmlPane.addMouseListener(this.fWheelFocusMouseListener);
        this.fMover = new ComponentMover((Component)((Object)this.fActionToolTip.getDialog()));
        this.fGripper.addMouseListener((MouseListener)this.fMover);
        this.fGripper.addMouseMotionListener((MouseMotionListener)this.fMover);
    }

    void setFunctionName(String string, URL uRL) {
        this.fTitleLabel.setText(string);
        this.fURL = uRL;
        this.fFuncName = string;
    }

    void setShortDescription(String string) {
        this.fTitleLabel.setText(string);
    }

    void setHtmlText(String string) {
        this.fhtmlPane.setText(string);
        this.fhtmlPane.setCaretPosition(0);
        this.applyMatlabFonts();
        this.fLightScrollPane.revalidate();
        this.fLightScrollPane.repaint();
    }

    int getDialogY(Point point, Insets insets) {
        double d = 0.6666666666666666;
        Rectangle rectangle = PlatformInfo.isLinux() ? GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds() : WindowUtils.getVirtualScreenBounds();
        int n = point.y - (int)(d * (double)this.getPreferredSize().height) - insets.top;
        int n2 = point.y + (int)((1.0 - d) * (double)this.getPreferredSize().height) + insets.bottom;
        if (n < rectangle.y) {
            n = rectangle.y;
        } else if (n2 > rectangle.y + rectangle.height) {
            n = rectangle.y + rectangle.height - this.getPreferredSize().height - insets.bottom - insets.top - 1;
        }
        return n;
    }

    void dispatchScrollEvent(AWTEvent aWTEvent) {
        this.fLightScrollPane.dispatchEvent(aWTEvent);
    }

    private void addWindowListener(Dialog dialog) {
        if (this.fWindowListener != null) {
            return;
        }
        this.fWindowListener = new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                ActionToolTipPanel.this.setActive(true);
            }

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
                ActionToolTipPanel.this.setActive(false);
            }
        };
        dialog.addWindowListener(this.fWindowListener);
    }

    private void setActive(boolean bl) {
        if (bl) {
            this.fGripperPanel.setBackground(ActionToolTipPanel.getPopupSelectionColor());
            this.fCloseButton.setActive(true);
            this.setBorder(BorderFactory.createLineBorder(AbstractActionTable.getPopupSelectionColor(), 1));
        } else {
            this.fGripperPanel.setBackground(ActionToolTipPanel.getPopupNonselectionColor());
            this.fCloseButton.setActive(false);
            this.setBorder(BorderFactory.createLineBorder(AbstractActionTable.getPopupNonselectionColor(), 1));
        }
    }

    private static Color getPopupSelectionColor() {
        return PlatformInfo.isMacintosh() ? UIManager.getColor("TextField.selectionBackground") : UIManager.getColor("InternalFrame.activeTitleBackground");
    }

    private static Color getPopupNonselectionColor() {
        return UIManager.getColor("InternalFrame.inactiveTitleBackground");
    }

    private void applyMatlabFonts() {
        this.fhtmlPane.setForeground(TooltipUtils.getTooltipFontColor());
        Font font = TooltipUtils.getTooltipHtmlFont();
        this.fhtmlPane.setFont(font);
        switch (HelpUtils.getLanguageLocale()) {
            case ENGLISH: {
                this.fUseAntiAliasing = true;
                break;
            }
            default: {
                this.fUseAntiAliasing = false;
            }
        }
        if (this.fUseAntiAliasing) {
            for (String string : sFontsWithNoSpecialRenderering) {
                if (!string.equals(font.getName())) continue;
                this.fUseAntiAliasing = false;
                return;
            }
        }
    }

    private boolean useAntiAliasing() {
        return this.fUseAntiAliasing;
    }

    class LightScrollBar
    extends MJScrollBar {
        LightScrollBar() {
        }

        public void updateUI() {
            this.setUI(LightScrollBarUI.createUI((JComponent)((Object)this)));
        }
    }

    private static class WheelFocusMouseListener
    extends MouseAdapter {
        ActionToolTip iActionToolTip;

        public WheelFocusMouseListener(ActionToolTip actionToolTip) {
            this.iActionToolTip = actionToolTip;
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (!this.iActionToolTip.isMouseWheelFocusManual()) {
                this.iActionToolTip.setMouseWheelFocus(true);
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (!this.iActionToolTip.isMouseWheelFocusManual()) {
                this.iActionToolTip.setMouseWheelFocus(false);
            }
        }
    }

    class TextPanel
    extends JEditorPane {
        public TextPanel() {
            this.setContentType("text/html");
            this.setEditable(false);
            this.setFocusable(true);
            this.setBackground(UIManager.getColor("ToolTip.background"));
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.putClientProperty("JEditorPane.honorDisplayProperties", true);
        }

        @Override
        public void paint(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (ActionToolTipPanel.this.useAntiAliasing()) {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            }
            super.paint(graphics2D);
        }
    }
}

