/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.util;

import com.mathworks.jmi.AutoConvertStringToMatlabChar;
import com.mathworks.toolbox.instrument.ICProp;
import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.toolbox.testmeas.util.TMException;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;

public class PropertyUtil
implements AutoConvertStringToMatlabChar {
    private PropertyUtil() {
    }

    public static final int getNumberOfValidProps(ICProp[] iCPropArray) {
        int n;
        int n2 = n = iCPropArray.length;
        for (int i = 0; i < n; ++i) {
            if (iCPropArray[i].hidden != 1 && iCPropArray[i].hidden != 2) continue;
            --n2;
        }
        return n2;
    }

    public static final String[] getNonSettable(Instrument instrument) {
        ICProp[] iCPropArray = instrument.getProps();
        int n = iCPropArray.length;
        int n2 = 0;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            if (iCPropArray[i].hidden != 0 || !iCPropArray[i].readOnly.equals("always")) continue;
            stringArray[n2++] = iCPropArray[i].name;
        }
        String[] stringArray2 = new String[n2];
        for (int i = 0; i < n2; ++i) {
            stringArray2[i] = stringArray[i];
        }
        return stringArray2;
    }

    public static final Object createPropSetArray(Instrument instrument, String string) throws TMException {
        int n;
        ICProp[] iCPropArray = instrument.getProps();
        int n2 = iCPropArray.length;
        String[] stringArray = new String[n2];
        for (n = 0; n < n2; ++n) {
            stringArray[n] = iCPropArray[n].name.toLowerCase();
        }
        n = TMStringUtil.findPropertyCompleteName((String)string, (String[])stringArray);
        if (iCPropArray[n].readOnly.equals("always")) {
            TMStringUtil.error((String)("Attempt to modify read-only " + instrument.getDisplayName() + " property: '" + iCPropArray[n].name + "'."));
        }
        if (iCPropArray[n].type.equals("double") || iCPropArray[n].type.equals("any")) {
            return "";
        }
        return iCPropArray[n].constraintValue;
    }

    public static final String createPropSetDisplay(Instrument instrument, String[] stringArray) throws TMException {
        int n;
        ICProp[] iCPropArray = instrument.getProps();
        int n2 = iCPropArray.length;
        String[] stringArray2 = new String[n2];
        for (n = 0; n < n2; ++n) {
            stringArray2[n] = iCPropArray[n].name.toLowerCase();
        }
        n = TMStringUtil.findPropertyCompleteName((String)stringArray[0], (String[])stringArray2);
        if (iCPropArray[n].readOnly.equals("always")) {
            Instrument.displayError("Attempt to modify read-only " + instrument.getDisplayName() + " property: '" + iCPropArray[n].name + "'.");
        }
        if (iCPropArray[n].constraint.equals("enum")) {
            try {
                String[] stringArray3 = (String[])iCPropArray[n].constraintValue;
                String string = (String)iCPropArray[n].defaultValue;
                String string2 = "[ ";
                for (int i = 0; i < stringArray3.length; ++i) {
                    string2 = stringArray3[i].equals(string) ? string2 + "{" + stringArray3[i] + "}" : string2 + stringArray3[i];
                    string2 = i == stringArray3.length - 1 ? string2 + " ]" : string2 + " | ";
                }
                return string2;
            }
            catch (ClassCastException classCastException) {
                return "A " + instrument.getDisplayName() + " object's '" + iCPropArray[n].name + "' property does not have a fixed set of property values.";
            }
        }
        if (iCPropArray[n].type.equals("callback")) {
            return "string -or- function handle -or- cell array";
        }
        return "A " + instrument.getDisplayName() + " object's '" + iCPropArray[n].name + "' property does not have a fixed set of property values.";
    }

    private static String extractClassProperty(String string) {
        return string.charAt(0) == 'f' ? string.substring(1) : string;
    }

    public static final String[] getPropertyNames(Instrument instrument) {
        ICProp[] iCPropArray = instrument.getProps();
        int n = iCPropArray.length;
        int n2 = PropertyUtil.getNumberOfValidProps(iCPropArray);
        int n3 = 0;
        String[] stringArray = new String[n2];
        for (int i = 0; i < n; ++i) {
            if (iCPropArray[i].hidden != 0) continue;
            stringArray[n3++] = PropertyUtil.extractClassProperty(iCPropArray[i].name);
        }
        return stringArray;
    }

    public static final int[] isInterfaceSpecific(Instrument instrument) {
        ICProp[] iCPropArray = instrument.getProps();
        int n = iCPropArray.length;
        int n2 = 0;
        int[] nArray = new int[PropertyUtil.getNumberOfValidProps(iCPropArray)];
        for (int i = 0; i < n; ++i) {
            if (iCPropArray[i].hidden != 0) continue;
            nArray[n2++] = iCPropArray[i].interfaceSpecific;
        }
        return nArray;
    }

    public static final String[] findStructProps() {
        String[] stringArray = new String[]{"BusManagementStatus", "HandshakeStatus", "PinStatus"};
        return stringArray;
    }
}

