/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.util;

import com.mathworks.jmi.AutoConvertStringToMatlabChar;
import com.mathworks.toolbox.instrument.Bluetooth;
import com.mathworks.toolbox.instrument.GpibNI;
import com.mathworks.toolbox.instrument.GpibVisa;
import com.mathworks.toolbox.instrument.I2C;
import com.mathworks.toolbox.instrument.ICProp;
import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.toolbox.instrument.PxiVisa;
import com.mathworks.toolbox.instrument.RsibVisa;
import com.mathworks.toolbox.instrument.SerialComm;
import com.mathworks.toolbox.instrument.SerialVisa;
import com.mathworks.toolbox.instrument.TCPIP;
import com.mathworks.toolbox.instrument.TcpipVisa;
import com.mathworks.toolbox.instrument.UDP;
import com.mathworks.toolbox.instrument.UsbVisa;
import com.mathworks.toolbox.instrument.VxiGpibVisa;
import com.mathworks.toolbox.instrument.VxiVisa;
import com.mathworks.toolbox.testmeas.util.TMException;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;

public class PropertyHelp
implements AutoConvertStringToMatlabChar {
    private static String[] visaTypes = new String[]{"visa-serial", "visa-gpib", "visa-gpib-vxi", "visa-vxi", "visa-pxi", "visa-rsib", "visa-tcpip", "visa-generic", "visa-usb"};
    private static String[] allTypes = new String[]{"serial", "Bluetooth", "i2c", "gpib", "tcpip", "udp", "visa-serial", "visa-gpib", "visa-gpib-vxi", "visa-pxi", "visa-vxi", "visa-rsib", "visa-generic", "visa-tcpip", "visa-usb"};

    public static String getHelp(String string) throws TMException {
        return PropertyHelp.getPropertyHelp(string);
    }

    public static String getHelp(String string, String string2) throws TMException {
        if (string.equals("")) {
            return PropertyHelp.getPropertyHelp(string2);
        }
        if (string.toLowerCase().equals("visa")) {
            PropertyHelp.isValidVISAProperty(string2);
        } else {
            PropertyHelp.isValidProperty(string, string2);
        }
        return PropertyHelp.getPropertyHelp(string2);
    }

    private static boolean isValidProperty(String string, String string2) throws TMException {
        string2 = string2.toLowerCase();
        ICProp[] iCPropArray = PropertyHelp.getProperties(string);
        for (int i = 0; i < iCPropArray.length; ++i) {
            if (!iCPropArray[i].name.toLowerCase().equals(string2)) continue;
            return true;
        }
        Instrument.displayError("Invalid property for an object of type: " + string);
        return false;
    }

    public static String isValidPropertyName(String string) {
        for (int i = 0; i < allTypes.length; ++i) {
            String string2 = PropertyHelp.isValidPropertyName(allTypes[i], string);
            if (string2.equals("")) continue;
            return string2;
        }
        return "";
    }

    public static String isValidPropertyName(String string, String string2) {
        try {
            int n;
            ICProp[] iCPropArray = PropertyHelp.getProperties(string);
            String[] stringArray = new String[iCPropArray.length];
            for (n = 0; n < stringArray.length; ++n) {
                stringArray[n] = iCPropArray[n].name;
            }
            n = TMStringUtil.findPropertyCompleteName((String)string2, (String[])stringArray);
            return stringArray[n];
        }
        catch (TMException tMException) {
            return "";
        }
    }

    private static boolean isValidVISAProperty(String string) throws TMException {
        for (int i = 0; i < visaTypes.length; ++i) {
            try {
                if (!PropertyHelp.isValidProperty(visaTypes[i], string)) continue;
                return true;
            }
            catch (TMException tMException) {
                // empty catch block
            }
        }
        Instrument.displayError("Invalid property for an object of type: visa.");
        return false;
    }

    private static ICProp[] getProperties(String string) {
        if (string.equals("serial")) {
            return SerialComm.getProperties();
        }
        if (string.equals("Bluetooth")) {
            return Bluetooth.getProperties();
        }
        if (string.equals("i2c")) {
            return I2C.getProperties();
        }
        if (string.equals("gpib")) {
            return GpibNI.getProperties();
        }
        if (string.equals("visa-vxi")) {
            return VxiVisa.getProperties();
        }
        if (string.equals("visa-pxi")) {
            return PxiVisa.getProperties();
        }
        if (string.equals("visa-serial")) {
            return SerialVisa.getProperties();
        }
        if (string.equals("visa-gpib")) {
            return GpibVisa.getProperties();
        }
        if (string.equals("visa-gpib-vxi")) {
            return VxiGpibVisa.getProperties();
        }
        if (string.equals("tcpip")) {
            return TCPIP.getProperties();
        }
        if (string.equals("udp")) {
            return UDP.getProperties();
        }
        if (string.equals("visa-rsib")) {
            return RsibVisa.getProperties();
        }
        if (string.equals("visa-tcpip")) {
            return TcpipVisa.getProperties();
        }
        if (string.equals("visa-generic")) {
            return TcpipVisa.getProperties();
        }
        if (string.equals("visa-usb")) {
            return UsbVisa.getProperties();
        }
        return null;
    }

    private static String getPropertyHelp(String string) throws TMException {
        if ((string = string.toLowerCase()).equals("alias")) {
            return PropertyHelp.getAliasHelp();
        }
        if (string.equals("baudrate")) {
            return PropertyHelp.getBaudRateHelp();
        }
        if (string.equals("bitrate")) {
            return PropertyHelp.getBitRateHelp();
        }
        if (string.equals("boardindex")) {
            return PropertyHelp.getBoardIndexHelp();
        }
        if (string.equals("boardserial")) {
            return PropertyHelp.getBoardSerialHelp();
        }
        if (string.equals("breakinterruptfcn")) {
            return PropertyHelp.getBreakInterruptFcnHelp();
        }
        if (string.equals("busmanagementstatus")) {
            return PropertyHelp.getBusManagementStatusHelp();
        }
        if (string.equals("busnumber")) {
            return PropertyHelp.getBusNumberHelp();
        }
        if (string.equals("byteorder")) {
            return PropertyHelp.getByteOrderHelp();
        }
        if (string.equals("bytesavailable")) {
            return PropertyHelp.getBytesAvailableHelp();
        }
        if (string.equals("bytesavailablefcn")) {
            return PropertyHelp.getBytesAvailableFcnHelp();
        }
        if (string.equals("bytesavailablefcncount")) {
            return PropertyHelp.getBytesAvailableFcnCountHelp();
        }
        if (string.equals("bytesavailablefcnmode")) {
            return PropertyHelp.getBytesAvailableFcnModeHelp();
        }
        if (string.equals("bytestooutput")) {
            return PropertyHelp.getBytesToOutputHelp();
        }
        if (string.equals("chassisindex")) {
            return PropertyHelp.getChassisIndexHelp();
        }
        if (string.equals("channel")) {
            return PropertyHelp.getChannelHelp();
        }
        if (string.equals("profile")) {
            return PropertyHelp.getProfileHelp();
        }
        if (string.equals("chassisnumber")) {
            return PropertyHelp.getChassisNumberHelp();
        }
        if (string.equals("comparebits")) {
            return PropertyHelp.getCompareBitsHelp();
        }
        if (string.equals("databits")) {
            return PropertyHelp.getDataBitsHelp();
        }
        if (string.equals("datagramaddress")) {
            return PropertyHelp.getDatagramAddressHelp();
        }
        if (string.equals("datagramport")) {
            return PropertyHelp.getDatagramPortHelp();
        }
        if (string.equals("datagramreceivedfcn")) {
            return PropertyHelp.getDatagramReceivedFcnHelp();
        }
        if (string.equals("datagramterminatemode")) {
            return PropertyHelp.getDatagramTerminateModeHelp();
        }
        if (string.equals("dataterminalready")) {
            return PropertyHelp.getDataTerminalReadyHelp();
        }
        if (string.equals("devicenumber")) {
            return PropertyHelp.getDeviceNumberHelp();
        }
        if (string.equals("eoimode")) {
            return PropertyHelp.getEOIModeHelp();
        }
        if (string.equals("eoscharcode")) {
            return PropertyHelp.getEOSCharCodeHelp();
        }
        if (string.equals("eosmode")) {
            return PropertyHelp.getEOSModeHelp();
        }
        if (string.equals("errorfcn")) {
            return PropertyHelp.getErrorFcnHelp();
        }
        if (string.equals("flowcontrol")) {
            return PropertyHelp.getFlowControlHelp();
        }
        if (string.equals("functionnumber")) {
            return PropertyHelp.getFunctionNumberHelp();
        }
        if (string.equals("handshakestatus")) {
            return PropertyHelp.getHandShakeStatusHelp();
        }
        if (string.equals("inputbuffersize")) {
            return PropertyHelp.getInputBufferSizeHelp();
        }
        if (string.equals("interfaceindex")) {
            return PropertyHelp.getInterfaceIndexHelp();
        }
        if (string.equals("interruptfcn")) {
            return PropertyHelp.getInterruptFcnHelp();
        }
        if (string.equals("lanname")) {
            return PropertyHelp.getLanNameHelp();
        }
        if (string.equals("localhost")) {
            return PropertyHelp.getLocalHostHelp();
        }
        if (string.equals("localport")) {
            return PropertyHelp.getLocalPortHelp();
        }
        if (string.equals("localportmode")) {
            return PropertyHelp.getLocalPortModeHelp();
        }
        if (string.equals("logicaladdress")) {
            return PropertyHelp.getLogicalAddressHelp();
        }
        if (string.equals("mappedmemorybase")) {
            return PropertyHelp.getMappedMemoryBaseHelp();
        }
        if (string.equals("mappedmemorysize")) {
            return PropertyHelp.getMappedMemorySizeHelp();
        }
        if (string.equals("manufacturerid")) {
            return PropertyHelp.getManufacturerIDHelp();
        }
        if (string.equals("memorybase")) {
            return PropertyHelp.getMemoryBaseHelp();
        }
        if (string.equals("memoryincrement")) {
            return PropertyHelp.getMemoryIncrementHelp();
        }
        if (string.equals("memorysize")) {
            return PropertyHelp.getMemorySizeHelp();
        }
        if (string.equals("memoryspace")) {
            return PropertyHelp.getMemorySpaceHelp();
        }
        if (string.equals("modelcode")) {
            return PropertyHelp.getModelCodeHelp();
        }
        if (string.equals("name")) {
            return PropertyHelp.getNameHelp();
        }
        if (string.equals("networkrole")) {
            return PropertyHelp.getNetworkRoleHelp();
        }
        if (string.equals("objectvisibility")) {
            return PropertyHelp.getObjectVisibilityHelp();
        }
        if (string.equals("outputbuffersize")) {
            return PropertyHelp.getOutputBufferSizeHelp();
        }
        if (string.equals("outputemptyfcn")) {
            return PropertyHelp.getOutputEmptyFcnHelp();
        }
        if (string.equals("parity")) {
            return PropertyHelp.getParityHelp();
        }
        if (string.equals("pinstatus")) {
            return PropertyHelp.getPinStatusHelp();
        }
        if (string.equals("pinstatusfcn")) {
            return PropertyHelp.getPinStatusFcnHelp();
        }
        if (string.equals("port")) {
            return PropertyHelp.getPortHelp();
        }
        if (string.equals("primaryaddress")) {
            return PropertyHelp.getPrimaryAddressHelp();
        }
        if (string.equals("pullupresistors")) {
            return PropertyHelp.getPullupResistorsHelp();
        }
        if (string.equals("readasyncmode")) {
            return PropertyHelp.getReadAsyncModeHelp();
        }
        if (string.equals("recorddetail")) {
            return PropertyHelp.getRecordDetailHelp();
        }
        if (string.equals("recordmode")) {
            return PropertyHelp.getRecordModeHelp();
        }
        if (string.equals("recordname")) {
            return PropertyHelp.getRecordNameHelp();
        }
        if (string.equals("recordstatus")) {
            return PropertyHelp.getRecordStatusHelp();
        }
        if (string.equals("remoteaddress")) {
            return PropertyHelp.getRemoteAddressHelp();
        }
        if (string.equals("remotehost")) {
            return PropertyHelp.getRemoteHostHelp();
        }
        if (string.equals("remotename")) {
            return PropertyHelp.getremoteNameHelp();
        }
        if (string.equals("remoteid")) {
            return PropertyHelp.getremoteIDHelp();
        }
        if (string.equals("remoteport")) {
            return PropertyHelp.getRemotePortHelp();
        }
        if (string.equals("requesttosend")) {
            return PropertyHelp.getRequestToSendHelp();
        }
        if (string.equals("rsrcname")) {
            return PropertyHelp.getRsrcNameHelp();
        }
        if (string.equals("secondaryaddress")) {
            return PropertyHelp.getSecondaryAddressHelp();
        }
        if (string.equals("serialnumber")) {
            return PropertyHelp.getSerialNumberHelp();
        }
        if (string.equals("slot")) {
            return PropertyHelp.getSlotHelp();
        }
        if (string.equals("slotnumber")) {
            return PropertyHelp.getSlotNumberHelp();
        }
        if (string.equals("slotpath")) {
            return PropertyHelp.getSlotPathHelp();
        }
        if (string.equals("status")) {
            return PropertyHelp.getStatusHelp();
        }
        if (string.equals("stopbits")) {
            return PropertyHelp.getStopBitsHelp();
        }
        if (string.equals("tag")) {
            return PropertyHelp.getTagHelp();
        }
        if (string.equals("targetpower")) {
            return PropertyHelp.getTargetPowerHelp();
        }
        if (string.equals("vendor")) {
            return PropertyHelp.getVendorHelp();
        }
        if (string.equals("terminator")) {
            return PropertyHelp.getTerminatorHelp();
        }
        if (string.equals("timeout")) {
            return PropertyHelp.getTimeoutHelp();
        }
        if (string.equals("timerfcn")) {
            return PropertyHelp.getTimerFcnHelp();
        }
        if (string.equals("timerperiod")) {
            return PropertyHelp.getTimerPeriodHelp();
        }
        if (string.equals("transferdelay")) {
            return PropertyHelp.getTransferDelayHelp();
        }
        if (string.equals("transferstatus")) {
            return PropertyHelp.getTransferStatusHelp();
        }
        if (string.equals("triggerbusnumber")) {
            return PropertyHelp.getTriggerBusNumberHelp();
        }
        if (string.equals("triggerfcn")) {
            return PropertyHelp.getTriggerFcnHelp();
        }
        if (string.equals("triggerline")) {
            return PropertyHelp.getTriggerLineHelp();
        }
        if (string.equals("triggertype")) {
            return PropertyHelp.getTriggerTypeHelp();
        }
        if (string.equals("type")) {
            return PropertyHelp.getTypeHelp();
        }
        if (string.equals("userdata")) {
            return PropertyHelp.getUserDataHelp();
        }
        if (string.equals("valuesreceived")) {
            return PropertyHelp.getValuesReceivedHelp();
        }
        if (string.equals("valuessent")) {
            return PropertyHelp.getValuesSentHelp();
        }
        throw new TMException("Invalid instrument control function or property: '" + string + "'.");
    }

    private static String getProfileHelp() {
        return "   PROFILE string (read-only)\n\nIndicates the current Bluetooth Profile of the object.\n   \n   See also Channel, RemoteID, RemoteName, INSTRHWINFO";
    }

    private static String getremoteIDHelp() {
        return "   REMOTEID string\n\nIndicates the Bluetooth address of the remote device as a hexidecimal string.\n   \n   See also Channel, Profile, RemoteName, INSTRHWINFO";
    }

    private static String getremoteNameHelp() {
        return "   REMOTENAME\n\nIndicates the friendly name of the remote device if available.\n   \n   See also Channel, Profile, RemoteID, INSTRHWINFO";
    }

    private static String getChannelHelp() {
        return "   CHANNEL\n\nIndicates the current channel selected on the remote device.\n   \n   See also Profile, RemoteID, RemoteName, INSTRHWINFO";
    }

    private static String getChassisNumberHelp() {
        return "   CHASSISNUMBER  double (read-only) \n\n   Indicate the chassis number of the PXI chassis.\n   \n\tChassisNumber indicates the chassis number of a specific PXI device. The range\n\tof the ChassisNumber attribute is between 0 and 255. A value of -1 means that the\n\tchassis number for the PXI instrument is unknown.\n\t\n\tSee also BusNumber, DeviceNumber, FunctionNumber, SlotNumber";
    }

    private static String getAliasHelp() {
        return "   ALIAS string (read-only)\n\n   Indicate the alias of the resource name for a VISA instrument.\n   \n   Alias indicates the alias for the resource name for a VISA instrument. When\n   you create a VISA object, you can specify either the resource name for a \n   VISA instrument or you can specify an alias for the resource name. If an alias \n   is specified, Alias is automatically assigned the value specified in the VISA \n   function. If a resource name is specified and the resource name has an alias, \n   Alias is updated with the alias value. If the resource name does not have an alias, \n   Alias is an empty string.\n   \n   See also VISA, RsrcName.\n\n";
    }

    private static String getBitRateHelp() {
        return "   BITRATE double\n\n   Specify the bit rate for an I2C communication bus.\n\n   You can configure Bit Rate in bits per second. Only certain discrete bit rates\n   are typically supported.  The actual bitrate will be equal to or less than the requested\n   bit rate.  The actual value set will be indicated in the BitRate property\n\n   See also I2C\n\n";
    }

    private static String getBaudRateHelp() {
        return "   BAUDRATE  double\n\n   Specify the rate at which bits are transmitted.\n   \n   You configure BaudRate as bits per second. The transferred bits \n   include the start bit, the data bits, the parity bit (if used),\n   and the stop bits. However, only the data bits are stored.\n   \n   The baud rate is the rate at which information is transferred in a \n   communication channel. In the serial port context, \"9600 baud\" means \n   that the serial port is capable of transferring a maximum of 9600 bits\n   per second. If the information unit is one baud (one bit), then the\n   bit rate and the baud rate are identical. If one baud is given as 10\n   bits, (for example, eight data bits plus two framing bits), the bit\n   rate is still 9600 but the baud rate is 9600/10, or 960. You always\n   configure BaudRate as bits per second. Therefore, in the above example, \n   set BaudRate to 9600.\n   \n   Note: Both the object and the instrument must be configured to the\n   same baud rate before you can successfully read or write data.\n   \n   Standard baud rates include: 110, 300, 600, 1200, 2400, 4800,\n   9600, 14400, 19200, 38400, 57600, 115200, 128000 and 256000.\n   \n   See also DataBits, Parity, StopBits.\n\n";
    }

    private static String getBoardIndexHelp() {
        return "   BOARDINDEX  double  \n\n   Specify the index number of the board.\n   \n   For GPIB or VISA-GPIB objects, you configure BoardIndex to be the index  \n   number of the GPIB board associated with your instrument. When you \n   create a GPIB or VISA-GPIB object, BoardIndex is automatically assigned \n   the value specified in the GPIB or VISA function.\n   \n   For VISA-TCPIP objects, you configure BoardIndex to be the index number of\n   the network board associated with your instrument. When you create the \n   VISA-TCPIP object, BoardIndex is automatically assigned the value specified \n   in the VISA function.\n   \n   For VISA-USB objects, you configure BoardIndex to be the index number of\n   the USB board associated with your instrument. When you create the \n   VISA-USB object, BoardIndex is automatically assigned the value specified \n   in the VISA function.\n   \n   For GPIB objects, the Name property is automatically updated to reflect\n   the BoardIndex value. For VISA-GPIB and VISA-TCPIP objects, the Name  \n   and RsrcName properties are automatically updated to reflect the BoardIndex\n   value.\n   \n   For I2C objects, the BoardIndex property is automatically updated to reflect\n   the BoardIndex value.\n   \n   You can configure BoardIndex only when the object is disconnected from\n   the instrument. You disconnect a connected object with the FCLOSE function.\n   A disconnected object has a Status property value of closed.\n   \n   See also FCLOSE, GPIB, I2C, VISA, Name, RsrcName, Status.\n\n";
    }

    private static String getBoardSerialHelp() {
        return "   BOARDSERIAL  double (read-only) \n\n   Indicate the vendors serial number for the board assigned by the vendor.\n   \n\tThe board serial number may be used to indentify a specific device when more \n\tthan one is present.  If the serial number is not available BOARDSERIAL will\n\tbe zero.\n\t\n\tSee also I2C";
    }

    private static String getBreakInterruptFcnHelp() {
        return "   BREAKINTERRUPTFCN  callback\n\n   Specify the callback function to execute when a break- \n   interrupt event occurs.\n   \n   You configure BreakInterruptFcn to execute an callback\n   function when a break-interrupt event occurs. A break-interrupt\n   event is generated by the serial port when the received data is\n   in an off (space) state longer than the transmission time for \n   one byte.\n   \n   Note: A break interrupt event can be generated at any time\n   during the instrument control session.\n\n";
    }

    private static String getBusManagementStatusHelp() {
        return "   BUSMANAGEMENTSTATUS  structure  (read only)\n\n   Indicate the state of the GPIB bus management lines.\n   \n   BusManagementStatus is a structure array that contains the fields \n   Attention, InterfaceClear, RemoteEnable, ServiceRequest, and EndOrIdentify.\n   These fields indicate the state of the Attention (ATN), Interface Clear \n   (IFC), Remote Enable (REN), Service Request (SRQ) and End Or Identify (EOI)\n   GPIB lines.\n   \n   BusManagementStatus can be on or off for any of these fields. If\n   BusManagementStatus is on, the associated line is asserted. If\n   BusManagementStatus is off, the associated line is unasserted.\n   \n   When the object is disconnected from the instrument, the last queried\n   BusManagementStatus value is returned.\n\n";
    }

    private static String getBusNumberHelp() {
        return "   BUSNUMBER  double  (read only)\n\n   Indicate the PCI bus number of the PXI instrument.\n   \n   BusNumber indicates the PCI bus number on which a given PXI devicehas been installed.\n   The range of the BusNumber attribute can be between 0 and 255.\n\t\n\tSee also DeviceNumber, SlotNumber, SlotPath.\n\n";
    }

    private static String getByteOrderHelp() {
        return "   BYTEORDER  [ {littleEndian} | bigEndian ] \n\n   Specify the byte order of the instrument.\n   \n   You configure ByteOrder to be littleEndian or bigEndian. If \n   ByteOrder is littleEndian, then the instrument stores the first\n   byte in the first memory address. If ByteOrder is bigEndian, \n   then the instrument stores the last byte in the first memory \n   address.\n   \n   For example, suppose the hexadecimal value 4F52 is to be stored in \n   instrument memory. Since this value consists of two bytes, 4F and 52,\n   two memory locations are used. Using big-endian format, 4F is stored\n   first in the lower storage address. Using little-endian format, 52 is \n   stored first in the lower storage address.\n   ";
    }

    private static String getBytesAvailableHelp() {
        return "   BYTESAVAILABLE  double  (read only)\n\n   Indicate the number of bytes available in the input buffer.\n   \n   BytesAvailable indicates the number of bytes currently available\n   to be read from the input buffer. The property value is \n   continuously updated as the input buffer is filled, and is set\n   to 0 after the FOPEN function is issued.\n   \n   You can make use of BytesAvailable only when reading data \n   asynchronously. This is because when reading data synchronously,\n   control is returned to the MATLAB command line only after the \n   input buffer is empty. Therefore, the BytesAvailable value is\n   always 0. \n   \n   The BytesAvailable value can range from zero to the size of \n   the input buffer. Use the InputBufferSize property to specify\n   the size of the input buffer. Use the ValuesReceived property \n   to return the total number of values read.\n   \n   See also FOPEN, InputBufferSize, ValuesReceived.\n\n";
    }

    private static String getBytesAvailableFcnHelp() {
        return "   BYTESAVAILABLEFCN  callback\n\n   Specify the callback function to execute when a specified \n   number of bytes is available in the input buffer, or a terminator\n   is read.\n   \n   You configure BytesAvailableFcn to execute an callback \n   function when a bytes-available event occurs. A bytes-available\n   event occurs immediately after the number of bytes specified by \n   the BytesAvailableFcnCount property is available in the input\n   buffer or after a terminator is read, as determined by the\n   BytesAvailableFcnMode property.\n   \n   Note: A bytes-available event can be generated only for asynchronous\n   read operations.\n   \n   See also BytesAvailableFcnCount, BytesAvailableFcnMode,\n   EOSCharCode, Terminator, TransferStatus.\n\n";
    }

    private static String getBytesAvailableFcnCountHelp() {
        return "   BYTESAVAILABLEFCNCOUNT  double\n\n   Specify the number of bytes that must be available in the input \n   buffer before a bytes-available event occurs.\n   \n   You configure BytesAvailableFcnCount to the number of bytes\n   that must be available in the input buffer before a bytes- \n   available event is generated.\n   \n   Use the BytesAvailableFcnMode property to specify whether \n   the bytes-available event occurs after a certain number of \n   bytes are available or after a terminator is read.\n   \n   The bytes-available event executes the callback function\n   specified for the BytesAvailableFcn property.\n   \n   You can configure BytesAvailableFcnCount only when the \n   object is disconnected from the instrument. You disconnect \n   a connected object with the FCLOSE function. A disconnected\n   object has a Status property value of closed.\n   \n   See also FCLOSE, BytesAvailableFcn, BytesAvailableFcnMode,\n   Status.\n\n";
    }

    private static String getBytesAvailableFcnModeHelp() {
        return "   BYTESAVAILABLEFCNMODE  [ byte | {eosCharCode} ]\n\n   For serial port, VISA-serial, TCPIP and UDP objects, you can configure \n   BytesAvailableFcnMode to be terminator or byte. For all other\n   instrument objects, you can configure BytesAvailableFcnMode to \n   be eosCharCode or byte.\n   \n   If BytesAvailableFcnMode is terminator, a bytes-available event \n   occurs when the terminator specified by the Terminator property is\n   read. If BytesAvailableFcnMode is eosCharCode, a bytes-available\n   event occurs when the End-Of-String character specified by the \n   EOSCharCode property is read. If BytesAvailableFcnMode is byte, a\n   bytes-available event occurs when the number of bytes specified by\n   the BytesAvailableFcnCount property is available.\n   \n   The bytes-available event executes the callback function specified\n   for the BytesAvailableFcn property.\n   \n   You can configure BytesAvailableFcnMode only when the object is \n   disconnected from the instrument. You disconnect an object with the\n   FCLOSE function. A disconnected object has a Status property value of \n   closed.\n   \n   See also FCLOSE, BytesAvailableFcn, BytesAvailableFcnCount,\n   EOSCharCode, Status, Terminator.\n\n";
    }

    private static String getBytesToOutputHelp() {
        return "   BYTESTOOUTPUT  double  (read only)\n\n   Indicate the number of bytes currently in the output buffer.\n   \n   BytesToOutput indicates the number of bytes currently in the \n   output buffer waiting to be written to the instrument. The property\n   value is continuously updated as the output buffer is filled and\n   emptied, and is set to 0 after the FOPEN function is issued.\n   \n   You can make use of BytesToOutput only when writing data\n   asynchronously. This is because when writing data synchronously,\n   control is returned to the MATLAB command line only after the \n   output buffer is empty. Therefore, the BytesToOutput value is \n   always 0. \n   \n   Use the ValuesSent property to return the total number of values \n   written to the instrument.\n   \n   Note: If you attempt to write out more data than can fit in the\n   output buffer, then an error is returned and BytesToOutput is 0.\n   The size of the output buffer is specified by the OutputBufferSize\n   property.\n   \n   See also FOPEN, OutputBufferSize, ValuesSent.\n\n";
    }

    private static String getChassisIndexHelp() {
        return "   CHASSISINDEX  double \n\n   Specify the index number of the VXI chassis.\n   \n   You configure ChassisIndex to be the index number of the VXI chassis\n   associated with your instrument.\n   \n   When you create a VISA-VXI or VISA-GPIB-VXI object, ChassisIndex is\n   automatically assigned the value specified in the VISA function. For\n   both object types, the Name and RsrcName properties are automatically \n   updated to reflect the ChassisIndex value.\n   \n   You can configure ChassisIndex only when the object is disconnected \n   from the instrument. You disconnect a connected object with the FCLOSE\n   function. A disconnected object has a Status property value of closed.\n   \n   See also FCLOSE, VISA, Name, RsrcName, Status.\n\n";
    }

    private static String getCompareBitsHelp() {
        return "   COMPAREBITS  double\n\n   For GPIB objects, you can configure CompareBits to be 7 or 8. If \n   CompareBits is 7, the read operation completes when a byte that matches\n   the low seven bits of the End-Of-String (EOS) character is received.\n   The End Or Identify (EOI) line is asserted when a byte that matches\n   the low seven bits of the EOS character is written.\n   \n   If CompareBits is 8, the read operation completes when a byte that\n   matches all eight bits of the EOS character is received. The EOI line \n   is asserted when a byte that matches the low seven bits of the EOS\n   character is written.\n   \n   You can specify the EOS character with the EOSCharCode property. You \n   can specify when the EOS character is used (read operation, write\n   operation, or both) with the EOSMode property.\n   \n   See also EOSCharCode, EOSMode.\n\n";
    }

    private static String getDataBitsHelp() {
        return "   DATABITS  double\n\n   Specify the number of data bits to transmit.\n   \n   You can configure DataBits to be 5, 6, 7, or 8. Data is transmitted\n   as a series of five, six, seven, or eight bits with the least\n   significant bit sent first. At least seven data bits are required\n   to transmit ASCII characters. Eight bits are required to transmit\n   binary data. Five and six bit data formats are used for specialized \n   communications equipment.\n   \n   Note: Both the computer and the instrument must agree on the number\n   of data bits.\n   \n   In addition to the data bits, the serial data format consists of\n   a start bit, one or two stop bits, and possibly a parity bit. You\n   specify the number of stop bits with the StopBits property, and\n   the type of parity checking with the Parity property.\n   \n   See also Parity, StopBits.\n\n";
    }

    private static String getDatagramAddressHelp() {
        return "   DATAGRAMADDRESS  string (read only)\n\n   Indicate the IP dotted decimal address of the received datagram sender.\n   \n   DatagramAddress is the datagram sender IP address of the datagram to be\n   read next from the input buffer. An example of an IP dotted decimal address\n   string is '144.212.100.10'.\n   \n   When you read a datagram from the input buffer, DatagramAddress is updated.\n   \n   See also UDP, DatagramPort, RemotePort.\n\n";
    }

    private static String getDatagramPortHelp() {
        return "   DATAGRAMPORT  double (read only)\n\n   Indicate the port number of the datagram sender.\n   \n   DatagramPort is the datagram sender port number of the datagram to be read\n   next from the input buffer.\n   \n   When you read a datagram from the input buffer, DatagramPort is updated.\n   \n   See also UDP, DatagramAddress, RemoteAddress.\n\n";
    }

    private static String getDatagramReceivedFcnHelp() {
        return "   DATAGRAMRECEIVEDFCN  callback\n\n   Specify the M-callback function to execute whenever a datagram has been\n   received.\n   \n   You configure DatagramReceivedFcn to execute an callback function\n   when a datagram has been received. The callback executes when an\n   asynchronous read completes.\n   \n   See also READASYNC, UDP, DatagramAddress, DatagramPort, ReadAsyncMode.\n\n";
    }

    private static String getDatagramTerminateModeHelp() {
        return "   DATAGRAMTERMINATEMODE  [ {on} | off ]\n\n   Configure the terminate read mode for a UDP object.\n   \n   DatagramTerminateMode defines how FREAD and FSCANF read operations\n   terminate. You can configure DatagramTerminateMode to be on or off. When\n   DatagramTerminateMode is on, the read operation terminates when a datagram\n   has been read. When DatagramTerminateMode is off, FREAD and FSCANF read\n   across datagram boundaries.\n   \n   By default, DatagramTerminateMode is on.\n   \n   See also FREAD, FSCANF, UDP.\n\n";
    }

    private static String getDataTerminalReadyHelp() {
        return "   DATATERMINALREADY  [ {on} | off ]\n\n   Specify the state of the DTR pin.\n   \n   You can configure DataTerminalReady to be on or off. If\n   DataTerminalReady is on, the Data Terminal Ready (DTR) pin is \n   asserted. If DataTerminalReady is off, the DTR pin is unasserted.\n   \n   In normal usage, the DTR and Data Set Ready (DSR) pins work \n   together, and are used to signal if instruments are connected and\n   powered. However, there is nothing in the RS-232 standard that \n   states the DTR pin must be used in any specific way. For example,\n   DTR and DSR may be used for handshaking. You should refer to \n   your instrument's documentation to determine its specific pin\n   behavior.\n   \n   You can return the value of the DSR pin with the PinStatus \n   property.\n   \n   See also PinStatus.\n\n";
    }

    private static String getDeviceNumberHelp() {
        return "   DEVICENUMBER  double  (read only)\n\n   Indicate the device number of the PXI instrument.\n   \n   DeviceNumber indicates the device number of a PXI device on a given PCI bus. DeviceNumber\n   can be any value between 0 and 31.\n\t\n\tSee also BusNumber, SlotNumber, SlotPath.\n\n";
    }

    private static String getEOIModeHelp() {
        return "   EOIMODE  [ {on} | off ]\n\n   Specify if the EOI line is asserted at the end of a write operation.\n   \n   You can configure EOIMode to be on or off. If EOIMode is on, the EOI line\n   is asserted at the end of a write operation. If EOIMode is off, the EOI\n   line is not asserted at the end of a write operation. EOIMode applies to\n   both binary and formatted write operations.\n   \n   A write operation completes when:\n   \n   - The specified number of values are written\n   - A timeout occurs\n   \n   See also BusManagementStatus, EOSMode.\n\n";
    }

    private static String getEOSCharCodeHelp() {
        return "   EOSCHARCODE  ASCII Value\n\n   Specify the EOS character.\n   \n   You configure EOSCharCode to be the End-Of-String (EOS) character. The \n   value can be an integer ranging from 0 to 255, which represents the ASCII \n   code for the character, or the value can be the ASCII character. For example,\n   if the EOSCharCode is set to either 'CR' or to 13, then the EOS character \n   is a carriage return.\n   \n   For many practical applications, you will configure both EOSCharCode and \n   the EOSMode property. EOSMode specifies when the EOS character is used.\n   \n   If EOSMode is write or read&write (writing is enabled), the EOSCharCode\n   replaces \\n wherever it appears in the command sent to the instrument\n   and the EOI line is asserted every time the EOSCharCode value is written\n   to the instrument. Note that %s\\n is the default format for the \n   FPRINTF function.\n   \n   If EOSMode is read or read&write (reading is enabled), then the read \n   operation may terminate when the EOSCharCode value is detected. \n   \n   For GPIB objects, the CompareBits property specifies the number of bits\n   that must match the EOS character to complete a read operation or to \n   assert the EOI line. For VISA-GPIB, VISA-VXI, VISA-GPIB-VXI, VISA-TCPIP\n   and VISA-USB objects, all 8 bits must match the EOS character to complete \n   a read operation or to assert the EOI line.\n   \n   See also FPRINTF, CompareBits, EOSMode.\n\n";
    }

    private static String getEOSModeHelp() {
        return "   EOSMODE  [ {none} | read | write | read&write ]\n\n   For GPIB, VISA-GPIB, VISA-VXI, VISA-GPIB-VXI, VISA-TCPIP and \n   VISA-USB objects, you can configure EOSMode to be none, read,\n   write, or read&write.  For VISA-GENERIC objects, EOSMODE defaults\n   to read&write.\n   \n   If EOSMode is none, the End Of String (EOS) character is ignored. \n   If EOSMode is read, the EOS character is used to terminate a read\n   operation. If EOSMode is write, the EOS character is appended to \n   the command being written whenever \\n is encountered. If EOSMode is \n   read&write, the EOS character is used in both read and write operations. \n   If the EOS character is written to the instrument then the End Or \n   Identify (EOI) line is asserted.\n   \n   The EOS character is specified by the EOSCharCode property. For GPIB \n   objects, the CompareBits property specifies the number of bits that must\n   match the EOS character to complete a read operation or to assert the EOI\n   line. For VISA-GPIB, VISA-VXI, VISA-GPIB-VXI, VISA-TCPIP, VISA-USB and \n   VISA-GENERIC objects, all 8 bits must match the EOS character to complete\n   a read operation or to assert the EOI line.\n   \n   See also CompareBits, EOIMode, EOSCharCode.\n\n";
    }

    private static String getErrorFcnHelp() {
        return "   ERRORFCN  callback\n\n   Specify the callback function to execute when an error event\n   occurs.\n   \n   You configure ErrorFcn to execute an callback function when an\n   error event occurs. \n   \n   An error event is generated when a timeout occurs. A timeout occurs  \n   if a read or write operation does not successfully complete within  \n   the time specified by the Timeout property. An error event is not\n   generated for configuration errors such as setting an invalid property\n   value.\n   \n   Note: An error event based on a timeout can be generated only for\n   asynchronous read and write operations.\n   \n   See also Timeout.\n\n";
    }

    private static String getFlowControlHelp() {
        return "   FLOWCONTROL  [ {none} | hardware | software ]\n\n   Specify the data flow control method to use.\n   \n   You can configure FlowControl to be none, hardware, or software.\n   If FlowControl is none, then data flow control (handshaking) is\n   not used. If FlowControl is hardware, then hardware handshaking \n   is used to control data flow. If FlowControl is software, then\n   software handshaking is used to control data flow.\n   \n   Hardware handshaking typically utilizes the Request to Send (RTS)\n   and Clear to Send (CTS) pins to control data flow. Software \n   handshaking uses control characters (Xon and Xoff) to control\n   data flow. \n   \n   You can return the value of the CTS pin with the PinStatus \n   property. You can specify the value of the RTS pin with the \n   RequestToSend property. However, if FlowControl is hardware, and\n   you specify a value for RequestToSend, then that value may not be\n   honored.\n   \n   See also PinStatus, RequestToSend.\n\n";
    }

    private static String getFunctionNumberHelp() {
        return "\tFUNCTIONNUMBER double (read-only)\n\n\tIndicate the PCI function number of the PXI/PCI resource.\n\t\n\tMost devices have a function number of 0. Multi-function devices have\n\tfunction numbers ranging from 0 - 7. Each function on the multi-function\n\tdevice is assigned a unique function number and manifests as a separate\n\tVISA resource string.\n\t\n\tSee also VISA, RsrcName, BusNumber, DeviceNumber, SlotNumber, SlotPath. \n\n";
    }

    private static String getHandShakeStatusHelp() {
        return "   HANDSHAKESTATUS  structure  (read only)\n\n   Indicate the state of the GPIB handshake lines.\n   \n   HandShakeStatus is a structure array that contains the fields DataValid,\n   NotDataAccepted, and NotReadyForData. These fields indicate the state of\n   the Data Valid (DAV), Not Data Accepted (NDAC) and Not Ready For Data (NRFD)\n   GPIB lines, respectively.\n   \n   HandshakeStatus can be on or off for any of these fields. A value of on\n   indicates the associated line is asserted. A value of off indicates the \n   associated line is unasserted.\n   \n   When the object is disconnected from the instrument, the last queried\n   HandshakeStatus value is returned.\n\n";
    }

    private static String getInputBufferSizeHelp() {
        return "   INPUTBUFFERSIZE  double\n\n   Specify the size of the input buffer in bytes.\n   \n   You configure InputBufferSize as the total number of bytes that\n   can be stored in the input buffer during a read operation.\n   \n   A read operation is terminated if the amount of data stored in\n   the input buffer equals the InputBufferSize value. You can read\n   formatted data with the FGETL, FGETS, or FSCANF functions. You \n   can read binary data with the FREAD function.\n   \n   You can configure InputBufferSize only when the interface object\n   is disconnected from the instrument. You disconnect a connected \n   object with the FCLOSE function. A disconnected object has a Status\n   property value of closed.\n   \n   If you configure InputBufferSize while there is data in the input \n   buffer, then that data is flushed.\n   \n   See also FCLOSE, FGETL, FGETS, FOPEN, FREAD, FSCANF, Status.\n\n";
    }

    private static String getInterfaceIndexHelp() {
        return "   INTERFACEINDEX  double\n\n   Specify the USB interface number. \n   \n   You configure InterfaceIndex to be the USB interface number.\n   \n   The Name and RsrcName properties are automatically updated to reflect\n   the InterfaceIndex value.\n   \n   You can configure InterfaceIndex only when the object is disconnected \n   from the instrument. You disconnect a connected object with the FCLOSE \n   function. A disconnected object has a Status property value of closed.\n   \n   See also FCLOSE.\n\n";
    }

    private static String getInterruptFcnHelp() {
        return "   INTERRUPTFCN  callback\n\n   Specify the callback function to execute when an interrupt event\n   occurs.\n   \n   You configure InterruptFcn to execute an callback function when\n   an interrupt event occurs. An interrupt event is generated when a VXI \n   bus signal or a VXI bus interrupt is received from the instrument.\n   \n   Note: An interrupt event can be generated at any time during the \n   instrument control session.\n\n";
    }

    private static String getLanNameHelp() {
        return "   LANNAME  string\n\n   Specify the LAN device name.\n   \n   You configure LANName to be the LAN (Local Area Network) device name.\n   \n   The Name and RsrcName properties are automatically updated to reflect\n   the LANName value.\n   \n   You can configure LANName only when the object is disconnected from the\n   instrument. You disconnect a connected object with the FCLOSE function.\n   A disconnected object has a Status property value of closed.\n   \n   See also FCLOSE.\n\n";
    }

    private static String getLocalHostHelp() {
        return "   LOCALHOST string (read only while open)\n\n   Specify the local host.\n   \n   LocalHost specifies the local host name or IP dotted decimal address. An\n   example dotted decimal address is '144.212.100.10'. If you have only one\n   address or you do not specify this property the object uses the default IP\n   address when you connect to the hardware with FOPEN.\n   \n   You can configure LocalHost only when the object is disconnected from the\n   hardware. You disconnect a connected object with FCLOSE. A disconnected\n   object has a Status property value of closed.\n   \n   See also FCLOSE, FOPEN, TCPIP, UDP, LocalPort, RemoteHost, Status.\n\n";
    }

    private static String getLocalPortHelp() {
        return "   LOCALPORT double (read only while open)\n\n   Specify the local port for the connection.\n   \n   You can configure LocalPort to be the port value of the local host. By\n   default, LocalPort has value [].\n   \n   If LocalPortMode is set to auto or LocalPort is [], LocalPort will be assigned\n   any free port when you FOPEN the TCPIP or UDP object.\n   \n   If LocalPortMode is set to manual, LocalPort value will be used when you FOPEN\n   the object. If you configure LocalPort, LocalPortMode will be set to manual.\n   \n   You can configure LocalPort only when the object is disconnected from the\n   hardware. You disconnect a connected object with FCLOSE. A disconnected\n   object has a Status property value of closed.\n   \n   See also FCLOSE, TCPIP, UDP, LocalHost, LocalPortMode, Status.\n\n";
    }

    private static String getLocalPortModeHelp() {
        return "   LOCALPORTMODE string [ {auto} | manual ]\n\n   Configure the local port selection mode.\n   \n   LocalPortMode configures the selection mode for LocalPort when you FOPEN a\n   TCPIP or UDP object. If LocalPortMode is set to auto, MATLAB will use any\n   free local port. If LocalPortMode is set to manual, LocalPort value will be\n   used when you FOPEN the object. If you change LocalPort, LocalPortMode will be\n   set to manual.\n   \n   See also FCLOSE, FOPEN, TCPIP, UDP, LocalHost, LocalPort, Status.\n\n";
    }

    private static String getLogicalAddressHelp() {
        return "   LOGICALADDRESS  double\n\n   Specify the logical address of the VXI instrument.\n   \n   For VISA-VXI and VISA-GPIB-VXI objects, you configure LogicalAddress to\n   be the logical address of the VXI instrument. You must include the logical\n   address as part of the resource name during object creation using the VISA\n   function.\n   \n   The Name and RsrcName properties are automatically updated to reflect the\n   LogicalAddress value.\n   \n   You can configure LogicalAddress only when the object is disconnected from\n   the instrument. You disconnect a connected object with the FCLOSE function.\n   A disconnected object has a Status property value of closed.\n   \n   See also FCLOSE, VISA, Name, RsrcName, Status.\n\n";
    }

    private static String getMappedMemoryBaseHelp() {
        return "   MAPPEDMEMORYBASE  string  (read only) \n\n   Indicate the base memory address of the mapped memory.\n   \n   MappedMemoryBase is the base address of the mapped memory used for low\n   level read and write operations.\n   \n   The memory address is returned as a string representing a hexadecimal \n   value. For example, if the mapped memory base is 200000, then MappedMemoryBase\n   returns 200000H. If no memory is mapped, MappedMemoryBase is 0H.\n   \n   Use the MEMMAP function to map the specified amount of memory in the\n   specified address space (A16, A24 or A32) with the specified offset. Use the\n   MEMUNMAP function to unmap the memory space.\n   \n   See also MEMMAP, MEMUNMAP, MappedMemorySize.\n\n";
    }

    private static String getMappedMemorySizeHelp() {
        return "   MAPPEDMEMORYSIZE  double  (read only)\n\n   Indicate the size of the mapped memory for low-level read and write\n   operations.\n   \n   MappedMemorySize indicates the amount of memory mapped for low-level\n   read and write operations.\n   \n   Use the MEMMAP function to map the specified amount of memory in the\n   specified address space (A16, A24 or A32) with the specified offset. \n   Use the MEMUNMAP function to unmap the memory space.\n   \n   See also MEMMAP, MEMUNMAP, MappedMemoryBase.\n\n";
    }

    private static String getManufacturerIDHelp() {
        return "   MANUFACTURERID  string\n\n   Specify the manufacturer ID of the USB instrument. \n   \n   You configure ManufacturerID to be the manufacturer ID of the USB \n   instrument.\n   \n   The Name and RsrcName properties are automatically updated to reflect\n   the ManufacturerID value.\n   \n   You can configure ManufacturerID only when the object is disconnected \n   from the instrument. You disconnect a connected object with the FCLOSE \n   function. A disconnected object has a Status property value of closed.\n   \n   See also FCLOSE.\n\n";
    }

    private static String getMemoryBaseHelp() {
        return "   MEMORYBASE  string  (read only)\n\n   Indicate the base address of the A24 or A32 space.\n   \n   MemoryBase indicates the base address of the A24 or A32 space. The value\n   is returned as a string representing a hexadecimal value.\n   \n   All VXI instruments have A16 address space that is 16 bits wide. There\n   are also 24- and 32-bit wide address spaces known as A24 and A32. Some\n   instruments require the additional memory associated with the A24 or\n   A32 address space when the 64 bytes of A16 space are insufficient for \n   performing necessary functions.  \n   \n   An instrument cannot use both the A24 and A32 address space. The address\n   space is given by the MemorySpace property. If MemorySpace is A16, then \n   MemoryBase is 0H. \n   \n   See also MemorySpace.\n\n";
    }

    private static String getMemoryIncrementHelp() {
        return "   MEMORYINCREMENT  string  [ {block} | FIFO ]\n\n   Indicate whether the VXI register offset is incremented after data \n   is transferred.\n   \n   You can configure MemoryIncrement to be block or FIFO. If MemoryIncrement\n   is configured to block, the MEMREAD and MEMWRITE functions increment the \n   offset after every read and write operation, and data is transferred from\n   or to consecutive memory elements. If MemoryIncrement is configured to \n   FIFO, the MEMREAD and MEMWRITE functions do not increment the VXI register\n   offset, and data is always read from or written to the same memory element.\n   \n   By default, MemoryIncrement is configured to block. \n   \n   See also MEMREAD, MEMWRITE.\n\n";
    }

    private static String getMemorySizeHelp() {
        return "   MEMORYSIZE  double  (read only)\n\n   Indicate the size of the memory requested in the A24 or A32 address \n   space.\n   \n   MemorySize indicates the size of the memory requested by the instrument in \n   the A24 or A32 address space.\n   \n   Some instruments use the A24 or A32 address space when the 64 bytes of\n   A16 space are not enough for performing necessary functions. An instrument\n   cannot use both the A24 and A32 address space. The address space is\n   given by the MemorySpace property. If MemorySpace is A16, then MemorySize\n   is 0.\n   \n   See also MemorySpace.\n\n";
    }

    private static String getMemorySpaceHelp() {
        return "   MEMORYSPACE  [ {A16} | A16/A24 | A16/A32 ]  (read only)\n\n   Indicate the address space used by the instrument.\n   \n   MemorySpace indicates the address space requested by the instrument. \n   MemorySpace can be A16, A16/A24,or A16/A32. If MemorySpace is A16, the\n   instrument uses only the A16 address space. If MemorySpace is A16/A24,\n   the instrument uses the A16 and A24 address space. If MemorySpace is \n   A16/A32, the instrument uses the A16 and A32 address space.\n   \n   All VXI instruments have A16 address space that is 16 bits wide. There\n   are also 24- and 32-bit wide address spaces known as A24 and A32, \n   respectively. Some instruments use this memory when the 64 bytes of \n   A16 space are not enough for performing necessary functions. An instrument \n   cannot use both the A24 and A32 address space. The size of the memory\n   is given by the MemorySize property. The base address of the memory is \n   given by the MemoryBase property.\n   \n   See also MemoryBase, MemorySize.\n\n";
    }

    private static String getModelCodeHelp() {
        return "   MODELCODE  string\n\n   Specify the model code of the USB instrument. \n   \n   You configure ModelCode to be the model code of the USB instrument.\n    \n   The Name and RsrcName properties are automatically updated to reflect\n   the ModelCode value.\n   \n   You can configure ModelCode only when the object is disconnected \n   from the instrument. You disconnect a connected object with the FCLOSE \n   function. A disconnected object has a Status property value of closed.\n   \n   See also FCLOSE.\n\n";
    }

    private static String getNameHelp() {
        return "   NAME  string\n\n   Specify a descriptive name for the instrument object.\n   \n   You configure Name to be a descriptive name for the instrument \n   object.\n   \n   When you create an instrument object, a descriptive name is \n   automatically generated and stored in Name. However, you can\n   change the value of Name at any time.\n\n";
    }

    private static String getNetworkRoleHelp() {
        return "   NETWORKROLE  [ {client} | server ] \n\n   Specify ServerSocket Connections.\n   \n   You configure NetworkRole to be client or server. If \n   NetworkRole is server, then tcpip waits for a connection.\n   from a client.  If NetworkRole is client, then tcpip\n   tries to connect to a server.\n   \n   See also TCPIP.\n\n";
    }

    private static String getObjectVisibilityHelp() {
        return "   OBJECTVISIBILITY   [ {on} | off ]\n\n   Control access to an object by command-line users and GUIs.\n   \n   ObjectVisibility determines when an object is visible. ObjectVisibility \n   is useful for preventing command-line users from accidentally deleting \n   or configuring an instrument object that is being used by a GUI. \n   \n   Objects are always visible when ObjectVisibility is set to on. Setting \n   ObjectVisibility to off makes the object invisible. This may be necessary \n   from within a GUI to prevent a command-line user from accidentally deleting \n   or configuring an instrument object. When an object is not visible, it will \n   not be returned by the INSTRFIND function. By default, ObjectVisibility is \n   on. \n   \n   Objects that are hidden are still valid. If you have access to the object, \n   you can set and get its properties, and pass it to any function that operates \n   on instrument objects. \n   \n   See also INSTRFIND.\n\n";
    }

    private static String getOutputBufferSizeHelp() {
        return "   OUTPUTBUFFERSIZE  double\n\n   Specify the size of the output buffer in bytes.\n   \n   You configure OutputBufferSize as the total number of bytes that\n   can be stored in the output buffer during a write operation.\n   \n   An error occurs if the output buffer cannot hold all the data to \n   be written. You can write formatted data with the FPRINTF function.\n   You write binary data with the FWRITE function.\n   \n   You can configure OutputBufferSize only when the interface object\n   is disconnected from the instrument. You disconnect a connected \n   object with the FCLOSE function. A disconnected object has a Status\n   property value of closed.\n   \n   See also FCLOSE, FPRINTF, FWRITE, Status.\n\n";
    }

    private static String getOutputEmptyFcnHelp() {
        return "   OUTPUTEMPTYFCN  callback\n\n   Specify the callback function to execute when the output \n   buffer is empty.\n   \n   You configure OutputEmptyFcn to execute an callback function\n   when an output-empty event occurs. An output-empty event is generated \n   when the last byte is sent from the output buffer to the instrument.\n   \n   Note: An output-empty event can be generated only for asynchronous\n   write operations.\n\n";
    }

    private static String getParityHelp() {
        return "   PARITY  [ {none} | even | mark | odd | space ]\n\n   Specify the type of parity checking.\n   \n   You can configure Parity to be none, odd, even, mark, or space. \n   If Parity is none, parity checking is not performed and the parity \n   bit is not transmitted. If Parity is odd, the number of mark bits\n   (1's) in the data is counted, and the parity bit is asserted or \n   unasserted to obtain an odd number of mark bits. If Parity is even,\n   the number of mark bits in the data is counted, and the parity bit \n   is asserted or unasserted to obtain an even number of mark bits. If \n   Parity is mark, the parity bit is asserted. If Parity is space, \n   the parity bit is unasserted.\n   \n   Parity checking can detect errors of one bit only. An error in two \n   bits may cause the data to have a seemingly valid parity, when in fact\n   it is incorrect.  \n   \n   In addition to the parity bit, the serial data format consists of\n   a start bit, between five and eight data bits, and one or two stop bits.\n   You specify the number of data bits with the DataBits property, and the\n   number of stop bits with the StopBits property.\n   \n   See also DataBits, StopBits.\n\n";
    }

    private static String getPinStatusHelp() {
        return "   PINSTATUS  structure  (read only)\n\n   Indicate the state of the CD, CTS, DSR, and RI pins.\n   \n   PinStatus is a structure array that contains the fields CarrierDetect,\n   ClearToSend, DataSetReady and RingIndicator. These fields indicate the\n   state of the Carrier Detect (CD), Clear to Send (CTS), Data Set Ready (DSR)\n   and Ring Indicator (RI) pins, respectively. \n   \n   PinStatus can be on or off for any of these fields. A value of on \n   indicates the associated pin is asserted. A value of off indicates the\n   associated pin is unasserted. For serial port objects, a pin status \n   event occurs when any of these pins changes its state. A pin status \n   event executes the function specified by PinStatusFcn.\n   \n   In normal usage, the Data Terminal Ready (DTR) and DSR pins work together,\n   while the Request To Send (RTS) and CTS pins work together. You can\n   specify the state of the DTR pin with the DataTerminalReady property. You\n   can specify the state of the RTS pin with the RequestToSend property.\n   \n   When the object is disconnected from the instrument, the last queried\n   PinStatus value is returned.\n   \n   See also DataTerminalReady, PinStatusFcn, RequestToSend.\n\n";
    }

    private static String getPinStatusFcnHelp() {
        return "   PINSTATUSFCN  callback\n\n   Specify the callback function to execute when the CD, CTS, DSR, \n   or RI pins change state.\n   \n   You configure PinStatusFcn to execute an callback function\n   when a pin status event occurs. A pin status event occurs when the \n   Carrier Detect (CD), Clear to Send (CTS), Data Set Ready (DSR) or \n   Ring Indicator (RI) pin changes state. A serial port pin changes\n   state when it is asserted or unasserted. State information for these\n   pins is recorded in the PinStatus property.\n   \n   Note: A pin status event can be generated at any time during the \n   instrument control session.\n   \n   See also PinStatus.\n\n";
    }

    private static String getPortHelp() {
        return "   PORT  string  \n\n   Specify the platform-specific serial port name.\n   \n   You configure Port to be the name of a serial port on your platform.\n   Port specifies the physical port associated with the object and the\n   instrument.\n   \n   When you create a serial port object, Port is automatically assigned\n   the port name specified in the SERIAL or VISA function.\n   \n   You can configure Port only when the object is disconnected from the\n   instrument. You disconnect a connected object with the FCLOSE function. \n   A disconnected object has a Status property value of closed.\n   \n   See also FCLOSE, SERIAL, VISA, Name, Status.\n\n";
    }

    private static String getPrimaryAddressHelp() {
        return "   PRIMARYADDRESS  double  \n\n   Specify the primary address of the GPIB instrument.\n   \n   For GPIB and VISA-GPIB objects, you configure PrimaryAddress to be the\n   GPIB primary address associated with your instrument. The primary address\n   can range from 0 to 30, and you must specify it during object creation \n   using the GPIB or VISA function. For VISA-GPIB-VXI objects, PrimaryAddress is\n   read-only, and the value is returned automatically by the VISA interface after\n   the object is connected to the instrument with the FOPEN function.\n   \n   For GPIB and VISA-GPIB objects, the Name property is automatically updated\n   to reflect the PrimaryAddress value. For VISA-GPIB objects, the RsrcName\n   property is automatically updated to reflect the PrimaryAddress value.\n   \n   You can configure PrimaryAddress only when the GPIB or VISA-GPIB object\n   is disconnected from the instrument. You disconnect a connected object with\n   the FCLOSE function. A disconnected object has a Status property value of\n   closed.\n   \n   See also FCLOSE, FOPEN, GPIB, VISA, Name, RsrcName, Status.\n\n";
    }

    private static String getPullupResistorsHelp() {
        return " PULLUPRESISTORS [ {both} | none ]\n\n   Specify the state of the I2C pullup resistors.\n   \n   You can configure PullupResistors to be both or none. If PullupResistors is set to\n   both, the total pull-up current could be potentially larger.   \n   PullupResistors may not be supported by all devices.  Check the device data sheet\n   to determine if the feature is available. \n   \n   See also TargetPower.\n\n";
    }

    private static String getReadAsyncModeHelp() {
        return "   READASYNCMODE  [ {continuous} | manual ] \n\n   You can configure ReadAsyncMode to be continuous or manual. If \n   ReadAsyncMode is continuous, the object continuously queries the\n   instrument to determine if data is available to be read. If data is\n   available, it is automatically read and stored in the input buffer.\n   If issued, the READASYNC function is ignored.\n   \n   If ReadAsyncMode is manual, the object will not query the instrument \n   to determine if data is available to be read. Instead, you must \n   manually issue the READASYNC function to perform an asynchronous read\n   operation. Since READASYNC checks for the terminator, this function \n   can be slow. To increase speed, you should configure ReadAsyncMode to\n   continuous.\n   \n   Note: If the instrument is ready to transmit data, then it will do \n   so regardless of the ReadAsyncMode value. Therefore, if ReadAsyncMode\n   is manual and a read operation is not in progress, then data may be \n   lost. To guarantee that all transmitted data is stored in the input \n   buffer, you should configure ReadAsyncMode to continuous.\n   \n   You can determine the amount of data available in the input buffer\n   with the BytesAvailable property. You can configure the size of the\n   input buffer with the InputBufferSize property. For either ReadAsyncMode\n   value you can bring data into the MATLAB workspace with one of the \n   synchronous read functions such as FSCANF, FGETL, FGETS, or FREAD.\n   \n   See also FGETL, FGETS, FREAD, FSCANF, READASYNC, BytesAvailable,\n   InputBufferSize.\n\n";
    }

    private static String getRecordDetailHelp() {
        return "   RECORDDETAIL  [ {compact} | verbose ]\n\n   Specify the amount of information recorded. \n   \n   You can configure RecordDetail to be compact or verbose. If RecordDetail\n   is compact, the number of values written to the instrument, the number of\n   values read from the instrument, the data type of the values, and event \n   information are saved to the record file. If RecordDetail is verbose, the \n   data written to the instrument, and the data read from the instrument are\n   also saved to the record file.\n   \n   See also RECORD, RecordMode, RecordName, RecordStatus.\n\n";
    }

    private static String getRecordModeHelp() {
        return "   RECORDMODE  [ append | {overwrite} | index ]\n\n   Specify whether data and event information are saved to one record \n   file or to multiple record files.\n   \n   You can configure RecordMode to be overwrite, append, or index. If\n   RecordMode is overwrite, then the record file is overwritten each time\n   recording is initiated. If RecordMode is append, then data is appended\n   to the record file each time recording is initiated. If RecordMode is\n   index, a different record file is created each time recording is initiated,\n   each with an indexed filename.\n   \n   You can configure RecordMode only when the object is not recording. \n   You terminate recording with the RECORD function. An object that is \n   not recording has a RecordStatus property value of off.\n   \n   You specify the record filename with the RecordName property.\n   \n   See also RECORD, RecordDetail, RecordName, RecordStatus.\n\n";
    }

    private static String getRecordNameHelp() {
        return "   RECORDNAME  string\n\n   Specify the name of the record file.\n   \n   You configure RecordName to be the name of the record file. You can \n   specify any value for RecordName -- including a directory path -- \n   provided the filename is supported by your operating system.\n   \n   MATLAB supports any filename supported by your operating system.\n   However, if you access the file through MATLAB, you may need to specify\n   the filename using quotes. For example, suppose you name the record file\n   My Record.txt. To type this file at the MATLAB command line, you must \n   include the name in quotes.\n   \n   type('My Record.txt')\n   \n   You can specify whether data and event information are saved to one\n   disk file or to multiple disk files with the RecordMode property. \n   \n   You can configure RecordName only when the object is not recording. \n   You terminate recording with the RECORD function. An object that is \n   not recording has a RecordStatus property value of off.\n   \n   See also RECORD, RecordDetail, RecordMode, RecordStatus.\n\n";
    }

    private static String getRecordStatusHelp() {
        return "   RECORDSTATUS   [ {off} | on ]  (read only)\n\n   Indicate if data and event information are saved to a record file.\n   \n   You can configure RecordStatus to be on or off with the RECORD function.\n   If RecordStatus is on, then data and event information are saved to the\n   record file specified by RecordName. If RecordStatus is off, then data \n   and event information are not saved to a record file.\n   \n   Use the RECORD function to initiate or terminate recording. RecordStatus\n   is automatically configured to reflect the recording state.\n   \n   See also RECORD, RecordDetail, RecordMode, RecordName.\n\n";
    }

    private static String getRemoteAddressHelp() {
        return "   REMOTEADDRESS string or double \n\n   Specify the remote I2C address.\n   \n   RemoteAddress specifies the remote chip address as a hex string or double.\n   An example for a chip at address 80 would be '50h' or 80.\n   The maximum value is determined by an I2C adaptor, but is typically 7 or 10 bits.   \n   For I2C objects, you can configure RemoteAddress when the object is open or closed.\n   \n   See also I2C.\n\n";
    }

    private static String getRemoteHostHelp() {
        return "   REMOTEHOST string \n\n   Specify the remote host.\n   \n   RemoteHost specifies the remote host name or IP dotted decimal address. An\n   example dotted decimal address is '144.212.100.10'.\n   \n   For TCPIP, VISA-TCPIP and VISA-RSIB objects, you can configure RemoteHost\n   only when the object is disconnected from the hardware. You disconnect \n   a connected object with FCLOSE. A disconnected object has a Status property\n   value of closed.\n   \n   For UDP objects, you can configure the RemoteHost at any time. If the object\n   is open, the user is warned if the remote address is invalid.\n   \n   See also FCLOSE, FOPEN, TCPIP, UDP, VISA, LocalHost, RemotePort, Status.\n\n";
    }

    private static String getRemotePortHelp() {
        return "   REMOTEPORT double \n\n   Specify the remote host port for the connection.\n   \n   You can configure RemotePort to be any port number between 1 and 65535. By\n   default, RemotePort is configured 80 for TCPIP and 9090 for UDP objects.\n   \n   For TCPIP objects, you can configure RemotePort only when the object is\n   disconnected from the hardware. You disconnect a connected object with\n   FCLOSE. A disconnected object has a Status property value of closed.\n   \n   For UDP objects, you can configure the RemotePort at any time.\n   \n   See also FCLOSE, FOPEN, TCPIP, UDP, RemoteHost, LocalPort, Status.\n\n";
    }

    private static String getRequestToSendHelp() {
        return "   REQUESTTOSEND  [ {on} | off ]\n\n   Specify the state of the RTS pin.\n   \n   You can configure RequestToSend to be on or off. If RequestToSend is on,\n   the Request to Send (RTS) pin is asserted. If RequestToSend is off, the\n   RTS pin is unasserted.\n   \n   In normal usage, the RTS and Clear to Send (CTS) pins work together, and\n   are used as standard handshaking pins for data transfer. In this case,\n   RTS and CTS are automatically managed by the DTE and DCE. However, there\n   is nothing in the RS-232 standard that requires the RTS pin must be\n   used in one specific way. \n   \n   If your instrument does not use hardware handshaking in the standard way,\n   and you need to manually configure RequestToSend, then you should configure\n   the FlowControl property to none. Otherwise, the RequestToSend value that\n   you specify may not be honored. Refer to your instrument's documentation\n   to determine its specific pin behavior.\n   \n   You can return the value of the CTS pin with the PinStatus property.\n   \n   See also FlowControl, PinStatus.\n\n";
    }

    private static String getRsrcNameHelp() {
        return "   RSRCNAME string (read-only)\n\n   Indicate the resource name for a VISA instrument.\n   \n   RsrcName indicates the resource name for a VISA instrument. When you create\n   a VISA object, RsrcName is automatically assigned. \n   \n   The resource name is a symbolic name for the instrument. The value you supply\n   to VISA has the following format, where the components in brackets are optional\n   and have a default value of 0 except for port_number, which has a default\n   value of 1.\n   \n     Interface          Resource Name\n     ---------          -------------\n     VXI                VXI[chassis]::VXI_logical_address::INSTR\n     GPIB-VXI           GPIB-VXI[chassis]::VXI_logical_address::INSTR\n     GPIB               GPIB[board]::primary_address::[secondary_address]::INSTR\n     TCPIP              TCPIP[board]::remote_host::[lan_device_name]::INSTR\n     USB                USB[board]::man_id::model_code::serial_No::[interface_No]::INSTR\n     RSIB               RSIB::remote_host::INSTR\n     Serial             ASRL[port_number]::INSTR\n   \n   If you change the BoardIndex, PrimaryAddress, SecondaryAddress, ChassisIndex, \n   LANName, LogicalAddress, Port, RemoteHost, ManufacturerID, ModelCode, SerialNumber,\n   or InterfaceIndex property values, RsrcName is automatically updated to reflect\n   these changes.\n   \n   For device objects with a DriverType property value of MATLAB interface object, the \n   RsrcName property specifies the type of interface used to communicate with the \n   instrument. For example, a RsrcName of GPIB0-2 indicates that communication is \n   through a GPIB board at index 0 with an instrument at primary address 2.\n   \n   For all other device objects, RsrcName is any valid VISA resource name. Communication\n   to the instrument is done through the resource specified by RSRCNAME. \n   \n   For device objects, the RsrcName value is defined at device object creation.\n   \n   See also VISA, BoardIndex, ChassisIndex, InterfaceIndex, LANName, LogicalAddress,\n   ManufacturerID, ModelCode, Port, PrimaryAddress, RemoteHost, SecondaryAddress, \n   SerialNumber.\n\n";
    }

    private static String getSecondaryAddressHelp() {
        return "   SECONDARYADDRESS  double\n\n   Specify the secondary address of the GPIB instrument.\n   \n   For GPIB and VISA-GPIB objects, you configure SecondaryAddress to be the\n   GPIB secondary address associated with your instrument. You can initially\n   specify the secondary address during object creation using the GPIB or VISA\n   function. For VISA-GPIB-VXI objects, SecondaryAddress is read-only, and the\n   value is returned automatically by the VISA interface after the object is\n   connected to the instrument with the FOPEN function.\n   \n   For GPIB objects, SecondaryAddress can range from 96 and 126, or it can be 0\n   indicating that no secondary address is used. For VISA-GPIB objects,\n   SecondaryAddress can range from 0 and 30. If your instrument does not have\n   a secondary address, then SecondaryAddress is 0.\n   \n   For GPIB and VISA-GPIB objects, the Name property is automatically\n   updated to reflect the SecondaryAddress value. For VISA-GPIB objects,\n   the RsrcName property is automatically updated to reflect the\n   SecondaryAddress value.\n    \n   You can configure SecondaryAddress only when the GPIB or VISA-GPIB\n   object is disconnected from the instrument. You disconnect a connected \n   object with the FCLOSE function. A disconnected object has a Status \n   property value of closed.\n   \n   See also FCLOSE, FOPEN, GPIB, VISA, Name, RsrcName, Status.\n\n";
    }

    private static String getStatusHelp() {
        return "   STATUS  [ {closed} | open ]  (read only)\n\n   Indicate if the instrument object is connected to the instrument.\n   \n   Status can be open or closed. If Status is open, the instrument object is\n   connected to the instrument. If Status is closed, the instrument object is \n   not connected to the instrument.\n   \n   Before you can write or read data, you must connect the instrument object\n   to the instrument. Interface objects are connected to the instrument with \n   the FOPEN function. Device objects are connected to the instrument with the\n   CONNECT function. You use the FCLOSE function to disconnect an interface \n   object from the instrument. You use the DISCONNECT function to disconnect\n   a device object from the instrument.\n   \n   See also CONNECT, DISCONNECT, FCLOSE, FOPEN.\n\n";
    }

    private static String getSerialNumberHelp() {
        return "   SERIALNUMBER  string\n\n   Specify the index of the USB instrument on the USB hub. \n   \n   You configure SerialNumber to be the index of the USB instrument on\n   the USB hub.\n   \n   The Name and RsrcName properties are automatically updated to reflect\n   the SerialNumber value.\n   \n   You can configure SerialNumber only when the object is disconnected \n   from the instrument. You disconnect a connected object with the FCLOSE \n   function. A disconnected object has a Status property value of closed.\n   \n   See also FCLOSE.\n\n";
    }

    private static String getSlotHelp() {
        return "   SLOT  double  (read only)\n\n   Indicate the slot location of the VXI instrument.\n   \n   Slot indicates the physical slot of the VXI instrument. Slot can be any\n   value between 0 and 12.\n\n";
    }

    private static String getSlotNumberHelp() {
        return "   SLOT  double  (read only)\n\n   Indicate the slot location of the PXI instrument.\n   \n   Slot indicates the physical slot of the PXI instrument. Slot can be any\n   value between 1 and 18.\n\n";
    }

    private static String getSlotPathHelp() {
        return "   SLOTPATH  string  (read-only)\n\n   Indicate the slot path of the PXI instrument.\n   \n\tThe PXI slot path describes the PCI bus hierarchy in a manner independent of the\n\tPCI bus number. PXI slot paths consist of a sequence of numbers that represent\n\tthe device number and function number of a PCI module and each parent PCI bridge\n\tthat routes the module to the host PCI bridge (bus 0). Each value is represented as,\n\tdeviceNumber.[FunctionNumber] where the function number is listed only if it is\n\tnon-zero. When a PXI slot path includes multiple values, the values are\n\tcomma-separated.\n\t\n\tSee Also BusNumber, DeviceNumber, FunctionNumber, SlotNumber.\n\n";
    }

    private static String getStopBitsHelp() {
        return "   STOPBITS  double\n\n   Specify the number of bits used to indicate the end of a byte.\n   \n   For serial port objects, you can configure StopBits to be 1, 1.5, or 2.\n   For VISA-serial objects, you can configure StopBits to be 1 or 2.\n   If StopBits is 1, one stop bit is used to indicate the end of data \n   transmission. If StopBits is 2, two stop bits are used to indicate the\n   end of data transmission. If StopBits is 1.5, the stop bit is transferred\n   for 150 percent of the normal time used to transfer one bit.\n   \n   Note: Both the computer and the instrument must agree on the number\n   of stop bits. \n   \n   In addition to the stop bits, the serial data format consists of a \n   start bit, between five and eight data bits, and possibly a parity bit.\n   You specify the number of data bits with the DataBits property, and the \n   type of parity checking with the Parity property.\n   \n   See also DataBits, Parity.\n\n";
    }

    private static String getTagHelp() {
        return "   TAG  string\n\n   Specify a label to associate with an instrument object.\n   \n   You configure Tag to be a string value that uniquely identifies an instrument\n   object.\n   \n   Tag is particularly useful when constructing programs that would otherwise\n   need to define the instrument object as a global variable, or pass the object\n   as an argument between callback routines.\n   \n   You can return an instrument object with the INSTRFIND function by specifying\n   the Tag property value.\n   \n   See also INSTRFIND.\n\n";
    }

    private static String getTargetPowerHelp() {
        return " TARGETPOWER [ {both} | none ]\n\n   Specify the state of the I2C board power pins.\n   \n   You can configure TARGETPOWER to be both or none.\n   If TargetPower is set to both, the target power is enabled.\n   If TargetPower is set to none, the target power is disabled.\n   \n   TargetPower may not be supported by all devices.  Check the device data sheet\n   to determine if the feature is available. \n   \n   See also PullupResistors.\n\n";
    }

    private static String getVendorHelp() {
        return " Vendor string  (read only)\n\n   Specify the manufacturer's name of the I2C adapter.\n   \n   \n   See also I2C.\n\n";
    }

    private static String getTerminatorHelp() {
        return "   TERMINATOR  ASCII Value\n\n   Specify the character used to terminate commands written to the instrument.\n   \n   For serial port, VISA-serial, TCPIP and UDP objects, you can configure Terminator\n   to an integer value ranging from 0 to 127, which represents the ASCII code\n   for the character, the ASCII character or an empty string. For example, if the\n   the Terminator is set to either 'CR' or to 13, the terminator character is\n   a carriage return.\n   \n   Additionally, the serial port object's Terminator value can be set to \n   CR/LF or LF/CR. If Terminator is CR/LF, the terminator is a carriage return\n   followed by a line feed. If Terminator is LF/CR, the terminator is a line\n   feed followed by a carriage return.\n   \n   You can set Terminator to a 1-by-2 cell array. The first element of the cell\n   is the read terminator and the second element of the cell array is the write\n   terminator.\n   \n   When performing a formatted write operation using the FPRINTF function, all\n   occurrences of \\n are replaced with the Terminator property value. Note that\n   %s\\n is the default format for FPRINTF. The terminator is ignored for binary\n   write operations.\n   \n   You can also use the terminator to generate a bytes available event when\n   the BytesAvailableFcnMode is set to terminator.\n   \n   See also FPRINTF, BytesAvailableFcnMode.\n\n";
    }

    private static String getTimeoutHelp() {
        return "   TIMEOUT  double\n\n   Specify the waiting time to complete a read or write operation.\n   \n   You configure Timeout to be the maximum time (in seconds) to wait to\n   complete a read or write operation.\n   \n   If a timeout occurs, then the read or write operation aborts. Additionally,\n   if a timeout occurs during an asynchronous read or write operation, then:\n   \n   - An error event is generated.\n   - The callback function specified for ErrorFcn is executed.\n   \n   See also ErrorFcn.\n\n";
    }

    private static String getTimerFcnHelp() {
        return "   TIMERFCN  callback\n\n   Specify the callback function to execute whenever a predefined period\n   of time passes.\n   \n   You configure TimerFcn to execute an callback function when a timer\n   event occurs. A timer event occurs when the time specified by the TimerPeriod\n   property passes. Time is measured relative to when the object is connected to \n   the instrument with the FOPEN function. Timer events will stop being generated \n   when the interface object is closed with the FCLOSE function.\n   \n   Some timer events may not be processed if your system is significantly slowed\n   or if the TimerPeriod value is too small.\n   \n   See also FCLOSE, FOPEN, TimerPeriod.\n\n";
    }

    private static String getTimerPeriodHelp() {
        return "   TIMERPERIOD  double\n\n   Specify the period of time between timer events.\n   \n   TimerPeriod specifies the time, in seconds, that must pass before the callback\n   function specified for TimerFcn is called. Time is measured relative to when\n   the interface object is connected to the instrument with the FOPEN function. \n   Timer events will stop being generated when the interface object is closed \n   with the FCLOSE function.\n   \n   Some timer events may not be processed if your system is significantly slowed\n   or if the TimerPeriod value is too small.\n   \n   The default value is 1 second. The minimum value is 0.01 second.\n   \n   See also FCLOSE, FOPEN, TimerFcn.\n\n";
    }

    private static String getTransferDelayHelp() {
        return "   TRANSFERDELAY [ {on} | off ]\n\n   Specify the use of the TCP segment transfer algorithm.\n   \n   TransferDelay can be configured to either on or off. When TransferDelay is on,\n   small segments of outstanding data are collected and sent in a single packet\n   when acknowledgement (ACK) arrives from the server. When off, data is sent\n   immediately to the network. By default, TransferDelay is on.\n   \n   On a slow network, network performance can be improved by configuring\n   TransferDelay to on. However, on a fast network, since ACKs arrive quickly, there\n   is negligible difference between configuring TransferDelay to on or off.\n   \n   The segment transfer algorithm used by TransferDelay is Nagle's algorithm.\n   \n   See also TCPIP.\n\n";
    }

    private static String getTransferStatusHelp() {
        return "   TRANSFERSTATUS  [ {idle} | read | write | read&write ]  (read only)\n\n   Indicate the asynchronous read or write operations that are in progress.\n   \n   TransferStatus can be idle, read, write, or read&write. If TransferStatus\n   is idle, then no asynchronous read or write operations are in progress. If\n   TransferStatus is read, then an asynchronous read operation is in progress.\n   If TransferStatus is write, then an asynchronous write operation is in\n   progress. If TransferStatus is read&write, then both an asynchronous read\n   and an asynchronous write operation are in progress.\n   \n   You can write data asynchronously using the FPRINTF or FWRITE function.\n   You can read data asynchronously using the READASYNC function, or by\n   configuring the ReadAsyncMode property (supported on serial port,\n   VISA-serial, TCPIP and UDP objects only) to continuous. \n   \n   While READASYNC is executing for any instrument object, TransferStatus \n   may indicate that data is being read even though data is not filling the\n   input buffer. However, if ReadAsyncMode is continuous, TransferStatus \n   indicates that data is being read only when data is actually filling the\n   input buffer.\n   \n   See also FPRINTF, FWRITE, READASYNC, ReadAsyncMode.\n\n";
    }

    private static String getTriggerBusNumberHelp() {
        return "   TRIGGERBUSNUMBER double (read-only)\n\n\tIndicate the trigger bus number of the PXI instrument.\n\t\n\tA trigger bus consisting of 8 trigger lines (TTL0-TTL7) is available within a\n\tPXI chassis. In the case of a PXI chassis or system with multiple trigger buses,\n\tthe TriggerBusNumber indicates the trigger bus number for a specific PXI instrument.\n\t\n\tSee also TriggerLine, TriggerType, ChassisNumber.\n\n";
    }

    private static String getTriggerFcnHelp() {
        return "   TRIGGERFCN  callback \n\n   Specify the callback function to execute when a trigger event occurs.\n   \n   You configure TriggerFcn to execute an callback function when a\n   trigger event occurs. A trigger event is generated when a trigger occurs in\n   software, or on one of the VXI hardware trigger lines. You configure the \n   trigger type with the TriggerType property.\n   \n   Note: A trigger event can be generated at any time during an instrument\n   control session.\n   \n   See also TriggerLine, TriggerType.\n\n";
    }

    private static String getTriggerLineHelp() {
        return "   TRIGGERLINE  [ {TTL0} | TTL1 | TTL2 | TTL3 | TTL4 | TTL5 | TTL6 | TTL7 | ECL0 | ECL1 ]\n\n   Specify the trigger lines on the VXI instrument.\n   \n   You can configure TriggerLine to be TTL0 through TTL7, ECL0,or ECL1. You can\n   use only one trigger line at a time.\n   \n   You can specify the trigger type with the TriggerType property. When\n   TriggerType is hardware, the line triggered is given by the TriggerLine\n   value. When the TriggerType is software, the TriggerLine value is ignored.\n   \n   You execute a trigger for a VISA-VXI object with the TRIGGER function.\n   \n   See also TRIGGER, TriggerType.\n\n";
    }

    private static String getTriggerTypeHelp() {
        return "   TRIGGERTYPE  [ {hardware} | software ] \n\n   Specify the trigger type.\n   \n   You can configure TriggerType to be software or hardware. If TriggerType is\n   software, then a software trigger is used. If TriggerType is hardware, then \n   the trigger line specified by the TriggerLine property is used.\n   \n   You execute a trigger for a VISA-VXI object with the TRIGGER function.\n   \n   See also TRIGGER, TriggerLine.\n\n";
    }

    private static String getTypeHelp() {
        return "   TYPE  string  (read only)\n\n   Indicate the instrument object type.\n\n   Type indicates the type of the object. Once the instrument object is created,\n   the value of Type is automatically defined.\n   \n   Using the INSTRFIND function and the Type value, you can quickly identify \n   instrument objects of a given type.\n   \n   See also INSTRFIND.\n\n";
    }

    private static String getUserDataHelp() {
        return "   USERDATA  any\n\n   Specify data that you want to associate with an instrument object.\n   \n   You configure UserData to store data that you want to associate with\n   an instrument object. The object does not use this data directly, but\n   you can access it using the GET function or the dot notation.\n   \n   See also GET.\n\n";
    }

    private static String getValuesReceivedHelp() {
        return "   VALUESRECEIVED double (read only)\n\n   Indicate the total number of values read from the instrument.\n   \n   ValuesReceived indicates the total number of values read from the\n   instrument. The property value is updated after each successful read\n   operation, and is set to 0 after the FOPEN function is issued. \n   \n   If you are reading data asynchronously, use the BytesAvailable property\n   to return the number of bytes currently available in the input buffer.\n   \n   Note: when performing a read operation, the received data is represented \n   by values rather than bytes. A value consists of one or more bytes. For \n   example, one uint32 value consists of four bytes. \n   \n   See also FOPEN, BytesAvailable.\n\n";
    }

    private static String getValuesSentHelp() {
        return "   VALUESSENT double (read only)\n\n   Indicate the total number of values written to the instrument.\n   \n   ValuesSent indicates the total number of values written to the instrument.\n   The property value is updated after each successful write operation, and is\n   set to 0 after the FOPEN function is issued. \n   \n   If you are writing data asynchronously, use the BytesToOutput property to\n   return the number of bytes currently in the output buffer waiting to be written\n   to the instrument.\n   \n   Note: when performing a write operation, the transmitted data is represented \n   by values rather than bytes. A value consists of one or more bytes. For \n   example, one uint32 value consists of four bytes.\n   \n   See also FOPEN, BytesToOutput.\n\n";
    }
}

