/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.instrcomm;

import com.mathworks.jmi.AWTUtilities;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.toolbox.instrument.InstrumentObjectListener;
import com.mathworks.toolbox.instrument.PropertyChangedListener;
import com.mathworks.toolbox.instrument.guiutil.DataExporter;
import com.mathworks.toolbox.instrument.guiutil.FillPanel;
import com.mathworks.toolbox.instrument.instrcomm.EmptyQueryRow;
import com.mathworks.toolbox.instrument.instrcomm.FlushRow;
import com.mathworks.toolbox.instrument.instrcomm.HistoryTable;
import com.mathworks.toolbox.instrument.instrcomm.MatlabActionListener;
import com.mathworks.toolbox.instrument.instrcomm.MatlabCaller;
import com.mathworks.toolbox.instrument.instrcomm.QueryRow;
import com.mathworks.toolbox.instrument.instrcomm.ReadRow;
import com.mathworks.toolbox.instrument.instrcomm.WarningRow;
import com.mathworks.toolbox.instrument.instrcomm.WriteRow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class CommunicationPanel
extends JPanel
implements PropertyChangedListener,
KeyListener,
MatlabActionListener,
ActionListener,
FocusListener,
InstrumentObjectListener {
    private static final long serialVersionUID = 1L;
    private static final int WRITE_TYPE = 0;
    private static final int RESPONSE_TYPE = 1;
    private static final int WRITE_BUTTON = 2;
    private static final int FLUSH_BUTTON = 3;
    private static final int QUERY_BUTTON = 4;
    private static final int READ_BUTTON = 5;
    private static final int EXPORT_BUTTON = 6;
    private static final int READ_SIZE_TEXT = 7;
    private static final String ACTION = "ACTION";
    private static final String[] ASCIIFormats = new String[]{"%s", "%c", "%s\\n", "%c\\n"};
    private static final String[] BinaryFormats = new String[]{"signed character (schar)", "signed integer 8 bits (int8)", "signed integer 16 bits (int16)", "signed integer 32 bits (int32)", "unsigned character (uchar)", "unsigned integer 8 bits (uint8)", "unsigned integer 16 bits (uint16)", "unsigned integer 32 bits (uint32)", "float", "double"};
    private static final String[] binaryFormatStr = new String[]{"schar", "int8", "int16", "int32", "uchar", "uint8", "uint16", "uint32", "float", "double"};
    private static final String[] writeCommands = new String[]{"fprintf", "fwrite", "binblockwrite"};
    private static final String[] readCommands = new String[]{"fscanf", "fread", "binblockread"};
    private static final String[] commandTypes = new String[]{"ASCII", "Binary", "Binblock"};
    private static final int ASCII = 0;
    private static final int BINARY = 1;
    private static final int BINBLOCK = 2;
    private MJLabel writeCommandTypeLabel;
    private MJLabel writeFormatLabel;
    private MJLabel dataToWriteLabel;
    private MJComboBox writeCommandComboBox;
    private MJComboBox writeFormatComboBox;
    private MJComboBox dataToWriteComboBox;
    private MJCheckBox writeEvaluateCommand;
    private int maxCommandsWrittenStored = 10;
    private MJButton writeButton;
    private MJButton queryButton;
    private MJLabel readCommandTypeLabel;
    private MJLabel readFormatLabel;
    private MJLabel readSizeLabel;
    private MJLabel dataReadLabel;
    private MJComboBox readCommandComboBox;
    private MJComboBox readFormatComboBox;
    private MJTextField readSizeTextField;
    private MJTextField responseTextField;
    private String readSizeValue = "";
    private MJButton exportButton;
    private MJButton readButton;
    private MJButton flushButton;
    private HistoryTable historyTable;
    private int numOfObjects = 0;
    private int numOfReads = 0;
    private Instrument currentObject;
    private MatlabCaller matlabCaller;

    public CommunicationPanel(HistoryTable historyTable) {
        this(historyTable, 0, null);
    }

    public CommunicationPanel(HistoryTable historyTable, int n, Instrument instrument) {
        this.historyTable = historyTable;
        this.numOfObjects = n;
        this.currentObject = instrument;
        this.matlabCaller = new MatlabCaller();
        this.matlabCaller.addMatlabActionListener(this);
        this.setLayout(new BorderLayout(0, 0));
        this.layoutPanel();
        if (this.numOfObjects == 0) {
            this.setComponentsEnabled(false);
        }
        Instrument.addInstrumentObjectListener(this);
        Instrument.addPropertyChangedListener(this);
        this.updateComponentsBasedOnStatus();
    }

    public void setObject(Instrument instrument) {
        this.numOfObjects = 1;
        this.currentObject = instrument;
        this.selectedObjectUpdated(this.currentObject);
    }

    public void dispose() {
        Instrument.removeInstrumentObjectListener(this);
        Instrument.removePropertyChangedListener(this);
        this.matlabCaller.removeMatlabActionListener(this);
        this.matlabCaller.dispose();
        this.cleanup();
    }

    public void cleanup() {
    }

    public void setup() {
    }

    private void layoutPanel() {
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 4, 0));
        jPanel.add(this.createWritePanel());
        jPanel.add(this.createReadPanel());
        this.add((Component)jPanel, "North");
        this.setComponentsEnabled(false);
    }

    private JPanel createWritePanel() {
        MJPanel mJPanel = new MJPanel((LayoutManager)new GridBagLayout());
        mJPanel.setBorder((Border)BorderFactory.createTitledBorder("Sending data"));
        this.writeCommandTypeLabel = new MJLabel("Data type:");
        this.writeFormatLabel = new MJLabel("Data format:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 0, 0), 0, 0);
        mJPanel.add((Component)this.writeCommandTypeLabel, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 0, 0), 0, 0);
        mJPanel.add((Component)this.writeFormatLabel, (Object)gridBagConstraints);
        this.writeCommandComboBox = new MJComboBox((Object[])commandTypes);
        this.writeCommandComboBox.setName("Write CommandType ComboBox");
        this.writeCommandComboBox.putClientProperty((Object)ACTION, (Object)new Integer(0));
        this.writeCommandComboBox.addActionListener((ActionListener)this);
        gridBagConstraints = new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 0, 2), 0, 0);
        mJPanel.add((Component)this.writeCommandComboBox, (Object)gridBagConstraints);
        this.writeFormatComboBox = new MJComboBox((Object[])ASCIIFormats);
        this.writeFormatComboBox.setSelectedItem((Object)"%s\\n");
        this.writeFormatComboBox.setEditable(true);
        this.writeFormatComboBox.setName("Write Format ComboBox");
        gridBagConstraints = new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 0, 2), 0, 0);
        mJPanel.add((Component)this.writeFormatComboBox, (Object)gridBagConstraints);
        this.dataToWriteLabel = new MJLabel("Data to write:");
        gridBagConstraints = new GridBagConstraints(0, 2, 0, 1, 1.0, 0.0, 17, 2, new Insets(6, 2, 0, 2), 0, 0);
        mJPanel.add((Component)this.dataToWriteLabel, (Object)gridBagConstraints);
        this.dataToWriteComboBox = new MJComboBox();
        this.dataToWriteComboBox.setEditable(true);
        this.dataToWriteComboBox.setName("Data To Write Combobox");
        this.dataToWriteComboBox.getEditor().getEditorComponent().addKeyListener(this);
        gridBagConstraints = new GridBagConstraints(0, 3, 0, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 0, 2), 0, 0);
        mJPanel.add((Component)this.dataToWriteComboBox, (Object)gridBagConstraints);
        this.writeEvaluateCommand = new MJCheckBox("Evaluate in workspace before write");
        this.writeEvaluateCommand.setName("Evaluate Command CheckBox");
        gridBagConstraints = new GridBagConstraints(0, 4, 0, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 2, 2), 0, 0);
        mJPanel.add((Component)this.writeEvaluateCommand, (Object)gridBagConstraints);
        this.queryButton = this.createButton("Query");
        this.writeButton = this.createButton("Write");
        this.queryButton.setName("Query Button");
        this.writeButton.setName("Write Button");
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new FlowLayout(2));
        mJPanel2.add((Component)this.queryButton);
        mJPanel2.add((Component)this.writeButton);
        this.writeButton.putClientProperty((Object)ACTION, (Object)new Integer(2));
        this.writeButton.addActionListener((ActionListener)this);
        this.queryButton.putClientProperty((Object)ACTION, (Object)new Integer(4));
        this.queryButton.addActionListener((ActionListener)this);
        gridBagConstraints = new GridBagConstraints(0, 5, 0, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0);
        mJPanel.add((Component)((Object)new FillPanel()), (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 6, 0, 1, 1.0, 0.0, 16, 2, new Insets(0, 0, 0, 0), 0, 0);
        mJPanel.add((Component)mJPanel2, (Object)gridBagConstraints);
        return mJPanel;
    }

    public int getWritePanelCommandIndex() {
        return this.writeCommandComboBox.getSelectedIndex();
    }

    public void setWritePanelCommandIndex(int n) {
        this.writeCommandComboBox.setSelectedIndex(n);
    }

    public int getWritePanelFormatIndex() {
        return this.writeFormatComboBox.getSelectedIndex();
    }

    public void setWritePanelFormatIndex(int n) {
        this.writeFormatComboBox.setSelectedIndex(n);
    }

    public boolean getWritePanelEvaluateCommand() {
        return this.writeEvaluateCommand.isSelected();
    }

    public void setWritePanelEvaluateCommand(boolean bl) {
        this.writeEvaluateCommand.setSelected(bl);
    }

    public String[] getWritePanelCommands() {
        int n = this.dataToWriteComboBox.getItemCount();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)this.dataToWriteComboBox.getItemAt(i);
        }
        return stringArray;
    }

    public void setWritePanelCommands(String[] stringArray) {
        this.dataToWriteComboBox.removeAllItems();
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.dataToWriteComboBox.addItem((Object)stringArray[i]);
        }
    }

    public JPanel createReadPanel() {
        MJPanel mJPanel = new MJPanel((LayoutManager)new GridBagLayout());
        mJPanel.setBorder((Border)BorderFactory.createTitledBorder("Receiving data"));
        this.readCommandTypeLabel = new MJLabel("Data type:");
        this.readFormatLabel = new MJLabel("Data format:");
        this.readSizeLabel = new MJLabel("Size (optional):");
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 0, 0), 0, 0);
        mJPanel.add((Component)this.readCommandTypeLabel, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 0, 0), 0, 0);
        mJPanel.add((Component)this.readFormatLabel, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 0, 0), 0, 0);
        mJPanel.add((Component)this.readSizeLabel, (Object)gridBagConstraints);
        this.readCommandComboBox = new MJComboBox((Object[])commandTypes);
        this.readCommandComboBox.setName("Read CommandType ComboBox");
        this.readCommandComboBox.putClientProperty((Object)ACTION, (Object)new Integer(1));
        this.readCommandComboBox.addActionListener((ActionListener)this);
        gridBagConstraints = new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 0, 2), 0, 0);
        mJPanel.add((Component)this.readCommandComboBox, (Object)gridBagConstraints);
        this.readFormatComboBox = new MJComboBox((Object[])ASCIIFormats);
        this.readFormatComboBox.setSelectedItem((Object)"%c");
        this.readFormatComboBox.setEditable(true);
        this.readFormatComboBox.setName("Read Format ComboBox");
        gridBagConstraints = new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 0, 2), 0, 0);
        mJPanel.add((Component)this.readFormatComboBox, (Object)gridBagConstraints);
        this.readSizeTextField = new MJTextField();
        this.readSizeTextField.setName("Read Size TextField");
        this.readSizeTextField.putClientProperty((Object)ACTION, (Object)new Integer(7));
        this.readSizeTextField.addActionListener((ActionListener)this);
        this.readSizeTextField.addFocusListener((FocusListener)this);
        gridBagConstraints = new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 0, 2), 0, 0);
        mJPanel.add((Component)this.readSizeTextField, (Object)gridBagConstraints);
        this.dataReadLabel = new MJLabel("Response:");
        gridBagConstraints = new GridBagConstraints(0, 3, 0, 1, 1.0, 0.0, 17, 2, new Insets(6, 2, 0, 2), 0, 0);
        mJPanel.add((Component)this.dataReadLabel, (Object)gridBagConstraints);
        this.responseTextField = new MJTextField();
        this.responseTextField.setEditable(false);
        this.responseTextField.setBackground(this.getBackground());
        this.responseTextField.setName("Response TextField");
        gridBagConstraints = new GridBagConstraints(0, 4, 0, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 0, 2), 0, 0);
        mJPanel.add((Component)this.responseTextField, (Object)gridBagConstraints);
        this.exportButton = this.createButton("Export");
        this.readButton = this.createButton("Read");
        this.flushButton = this.createButton("Flush");
        this.exportButton.setName("Export Button");
        this.readButton.setName("Read Button");
        this.flushButton.setName("Flush Button");
        this.exportButton.putClientProperty((Object)ACTION, (Object)new Integer(6));
        this.exportButton.addActionListener((ActionListener)this);
        this.readButton.putClientProperty((Object)ACTION, (Object)new Integer(5));
        this.readButton.addActionListener((ActionListener)this);
        this.flushButton.putClientProperty((Object)ACTION, (Object)new Integer(3));
        this.flushButton.addActionListener((ActionListener)this);
        JPanel jPanel = new JPanel(new FlowLayout(2));
        jPanel.add((Component)this.flushButton);
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add((Component)this.readButton);
        jPanel2.add((Component)this.exportButton);
        JPanel jPanel3 = new JPanel(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, "West");
        jPanel3.add((Component)jPanel, "Center");
        gridBagConstraints = new GridBagConstraints(0, 5, 0, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0);
        mJPanel.add((Component)((Object)new FillPanel()), (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 6, 0, 1, 1.0, 0.0, 16, 2, new Insets(0, 0, 0, 0), 0, 0);
        mJPanel.add((Component)jPanel3, (Object)gridBagConstraints);
        return mJPanel;
    }

    public int getReadPanelCommandIndex() {
        return this.readCommandComboBox.getSelectedIndex();
    }

    public void setReadPanelCommandIndex(int n) {
        this.readCommandComboBox.setSelectedIndex(n);
    }

    public int getReadPanelFormatIndex() {
        return this.readFormatComboBox.getSelectedIndex();
    }

    public void setReadPanelFormatIndex(int n) {
        this.readFormatComboBox.setSelectedIndex(n);
    }

    public String getReadSize() {
        return this.readSizeTextField.getText();
    }

    public void setReadSize(String string) {
        this.readSizeTextField.setText(string);
    }

    public String getResponseText() {
        return this.responseTextField.getText();
    }

    public void setResponseText(String string) {
        this.responseTextField.setText(string);
    }

    private MJButton createButton(String string) {
        MJButton mJButton = new MJButton(string);
        return mJButton;
    }

    private void write() {
        String string = (String)this.dataToWriteComboBox.getSelectedItem();
        String string2 = writeCommands[this.writeCommandComboBox.getSelectedIndex()];
        String string3 = this.getFormat(string2, (JComboBox)this.writeFormatComboBox);
        String string4 = "Literal";
        if (string == null) {
            this.setButtonsEnabled(true);
            return;
        }
        if (this.writeEvaluateCommand.isSelected()) {
            string4 = "Evaluate";
        }
        Object[] objectArray = new Object[]{"privateInstrcommHelper", string2, this.currentObject, string3, string, string4};
        this.matlabCaller.runAction(2, objectArray);
    }

    private void read() {
        String string = readCommands[this.readCommandComboBox.getSelectedIndex()];
        String string2 = this.getFormat(string, (JComboBox)this.readFormatComboBox);
        String string3 = this.readSizeTextField.getText();
        Object[] objectArray = new Object[]{"privateInstrcommHelper", string, this.currentObject, string2, string3, new Integer(this.numOfReads++)};
        this.matlabCaller.runAction(3, objectArray);
    }

    private void query() {
        String string = writeCommands[this.writeCommandComboBox.getSelectedIndex()];
        String string2 = readCommands[this.readCommandComboBox.getSelectedIndex()];
        if (!string.equals("fprintf") && !string2.equals("fscanf")) {
            this.setButtonsEnabled(true);
            return;
        }
        String string3 = (String)this.dataToWriteComboBox.getSelectedItem();
        String string4 = (String)this.writeFormatComboBox.getSelectedItem();
        String string5 = (String)this.readFormatComboBox.getSelectedItem();
        Object[] objectArray = new Object[]{"privateInstrcommHelper", "query", this.currentObject, string3, string4, string5, new Integer(this.numOfReads++)};
        this.matlabCaller.runAction(5, objectArray);
    }

    private String getFormat(String string, JComboBox jComboBox) {
        String string2 = (String)jComboBox.getSelectedItem();
        if (string.equals("fwrite") || string.equals("binblockwrite")) {
            string2 = binaryFormatStr[jComboBox.getSelectedIndex()];
        } else if (string.equals("fread") || string.equals("binblockread")) {
            string2 = binaryFormatStr[jComboBox.getSelectedIndex()];
        }
        return string2;
    }

    private void updateFormat(int n, JComboBox jComboBox, int n2) {
        String[] stringArray = ASCIIFormats;
        String string = "unsigned character (uchar)";
        boolean bl = false;
        switch (n) {
            case 0: {
                stringArray = ASCIIFormats;
                switch (n2) {
                    case 1: {
                        string = "%c";
                        break;
                    }
                    case 0: {
                        string = "%s\\n";
                    }
                }
                bl = true;
                if (jComboBox != this.readFormatComboBox) break;
                this.readSizeTextField.setEnabled(true);
                break;
            }
            case 1: {
                stringArray = BinaryFormats;
                string = "unsigned character (uchar)";
                if (jComboBox != this.readFormatComboBox) break;
                this.readSizeTextField.setEnabled(true);
                break;
            }
            case 2: {
                stringArray = BinaryFormats;
                string = "unsigned character (uchar)";
                if (jComboBox != this.readFormatComboBox) break;
                this.readSizeTextField.setEnabled(false);
                this.readSizeTextField.setBackground(this.getBackground());
            }
        }
        jComboBox.removeAllItems();
        for (int i = 0; i < stringArray.length; ++i) {
            jComboBox.addItem(stringArray[i]);
        }
        jComboBox.setSelectedItem(string);
        jComboBox.setEditable(bl);
        this.enableQueryButton();
    }

    private void enableQueryButton() {
        if (this.writeCommandComboBox.getSelectedIndex() == 0 && this.readCommandComboBox.getSelectedIndex() == 0) {
            this.queryButton.setEnabled(true);
        } else {
            this.queryButton.setEnabled(false);
        }
    }

    private void verifyEnteredValue(int n) {
        try {
            String string = this.readSizeTextField.getText();
            if (string.equals("")) {
                this.readSizeValue = "";
                return;
            }
            int n2 = new Integer(string);
            if (n2 < 1) {
                this.readSizeTextField.setText(this.readSizeValue);
            } else if (n2 > this.currentObject.getInputBufferSize()) {
                n2 = this.currentObject.getInputBufferSize();
                this.readSizeTextField.setText(String.valueOf(n2));
                this.readSizeValue = this.readSizeTextField.getText();
            } else {
                this.readSizeValue = string;
            }
        }
        catch (Exception exception) {
            this.readSizeTextField.setText(this.readSizeValue);
        }
    }

    private void updateWriteCommandComboBox() {
        String string = (String)this.dataToWriteComboBox.getSelectedItem();
        if (string == null || string.equals("")) {
            return;
        }
        int n = this.indexOf(string);
        if (n != -1) {
            this.dataToWriteComboBox.removeItemAt(n);
        }
        this.dataToWriteComboBox.insertItemAt((Object)string, 0);
        if (this.dataToWriteComboBox.getItemCount() > this.maxCommandsWrittenStored) {
            this.dataToWriteComboBox.removeItemAt(this.maxCommandsWrittenStored);
        }
        this.dataToWriteComboBox.setSelectedItem((Object)string);
    }

    private int indexOf(String string) {
        for (int i = 0; i < this.dataToWriteComboBox.getItemCount(); ++i) {
            String string2 = (String)this.dataToWriteComboBox.getItemAt(i);
            if (!string2.equals(string)) continue;
            return i;
        }
        return -1;
    }

    public void blockEvents(boolean bl) {
        try {
            this.getRootPane().getGlassPane().setVisible(bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setComponentsEnabled(final boolean bl) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        CommunicationPanel.this.setComponentsEnabled(bl);
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return;
        }
        this.writeCommandTypeLabel.setEnabled(bl);
        this.writeFormatLabel.setEnabled(bl);
        this.dataToWriteLabel.setEnabled(bl);
        this.writeEvaluateCommand.setEnabled(bl);
        this.writeCommandComboBox.setEnabled(bl);
        this.writeFormatComboBox.setEnabled(bl);
        this.dataToWriteComboBox.setEnabled(bl);
        this.writeFormatComboBox.setEditable(bl);
        this.dataToWriteComboBox.setEditable(bl);
        if (bl && this.writeCommandComboBox.getSelectedIndex() != 0) {
            this.writeFormatComboBox.setEditable(false);
        }
        this.writeButton.setEnabled(bl);
        this.readCommandTypeLabel.setEnabled(bl);
        this.readFormatLabel.setEnabled(bl);
        this.readSizeLabel.setEnabled(bl);
        this.dataReadLabel.setEnabled(bl);
        this.readCommandComboBox.setEnabled(bl);
        this.readFormatComboBox.setEnabled(bl);
        this.readFormatComboBox.setEditable(bl);
        if (bl && this.readFormatComboBox.getSelectedIndex() != 0) {
            this.readFormatComboBox.setEditable(false);
        }
        if (bl) {
            if (this.readCommandComboBox.getSelectedIndex() != 2) {
                this.readSizeTextField.setEnabled(true);
            } else {
                this.readSizeTextField.setEnabled(false);
                this.readSizeTextField.setBackground(this.getBackground());
            }
        } else {
            this.readSizeTextField.setEnabled(false);
            this.readSizeTextField.setBackground(this.getBackground());
        }
        this.responseTextField.setEnabled(bl);
        this.responseTextField.setBackground(this.getBackground());
        this.readButton.setEnabled(bl);
        this.flushButton.setEnabled(bl);
        if (!bl) {
            this.exportButton.setEnabled(bl);
        } else {
            this.enableExportButton();
        }
        if (!bl) {
            this.queryButton.setEnabled(bl);
        } else {
            this.enableQueryButton();
        }
        this.repaint();
    }

    private void enableExportButton() {
        if (this.historyTable.containsReadRow()) {
            this.exportButton.setEnabled(true);
        } else {
            this.exportButton.setEnabled(false);
        }
    }

    public void updateComponentsBasedOnStatus() {
        if (this.currentObject == null) {
            this.setComponentsEnabled(false);
            return;
        }
        if (this.currentObject.getStatus() == 0) {
            this.setComponentsEnabled(false);
        } else {
            this.setComponentsEnabled(true);
        }
    }

    private void setButtonsEnabled(boolean bl) {
        this.queryButton.setEnabled(bl);
        this.writeButton.setEnabled(bl);
        this.readButton.setEnabled(bl);
        this.flushButton.setEnabled(bl);
        this.blockEvents(!bl);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JComponent jComponent = (JComponent)actionEvent.getSource();
        int n = (Integer)jComponent.getClientProperty(ACTION);
        switch (n) {
            case 7: {
                this.verifyEnteredValue(7);
                break;
            }
            case 0: {
                this.updateFormat(this.writeCommandComboBox.getSelectedIndex(), (JComboBox)this.writeFormatComboBox, 0);
                break;
            }
            case 1: {
                this.updateFormat(this.readCommandComboBox.getSelectedIndex(), (JComboBox)this.readFormatComboBox, 1);
                if (this.readCommandComboBox.getSelectedIndex() == 2) {
                    this.readSizeTextField.setEnabled(false);
                    break;
                }
                this.readSizeTextField.setEnabled(true);
                break;
            }
            case 2: {
                this.setButtonsEnabled(false);
                this.responseTextField.setText("");
                this.write();
                break;
            }
            case 4: {
                this.responseTextField.setText("");
                this.setButtonsEnabled(false);
                this.query();
                break;
            }
            case 5: {
                this.setButtonsEnabled(false);
                this.read();
                break;
            }
            case 6: {
                MJFrame mJFrame;
                try {
                    mJFrame = (MJFrame)this.getRootPane().getParent();
                }
                catch (Exception exception) {
                    mJFrame = new MJFrame();
                }
                new DataExporter(this.historyTable).showAsDialog(mJFrame);
                break;
            }
            case 3: {
                this.setButtonsEnabled(false);
                Object[] objectArray = new Object[]{"privateInstrcommHelper", "flushinput", this.currentObject};
                this.matlabCaller.runAction(4, objectArray);
            }
        }
    }

    @Override
    public void matlabActionComplete(int n, Object object, Object[] objectArray) {
        switch (n) {
            case 2: {
                String string = (String)this.dataToWriteComboBox.getSelectedItem();
                String string2 = writeCommands[this.writeCommandComboBox.getSelectedIndex()];
                String string3 = this.getFormat(string2, (JComboBox)this.writeFormatComboBox);
                double[] dArray = new double[]{0.0};
                try {
                    dArray = (double[])object;
                }
                catch (Exception exception) {
                    this.setButtonsEnabled(true);
                }
                this.historyTable.addRow("Write", string, "1x" + (int)dArray[0], string3);
                this.historyTable.addMCode(new WriteRow(objectArray));
                this.updateWriteCommandComboBox();
                this.setButtonsEnabled(true);
                break;
            }
            case 3: {
                String string;
                Object[] objectArray2 = (Object[])object;
                double[] dArray = (double[])objectArray2[1];
                String string4 = (String)objectArray2[2];
                String string5 = (String)objectArray2[3];
                Object object2 = objectArray2[0];
                if (object2 instanceof String) {
                    string = (String)object2;
                    string5 = string.length() <= 40 ? string : string5 + " (" + string.substring(0, 20) + "...)";
                }
                string = readCommands[this.readCommandComboBox.getSelectedIndex()];
                String string6 = this.getFormat(string, (JComboBox)this.readFormatComboBox);
                if ((int)dArray[0] > 0) {
                    this.historyTable.addRow("Read", string5, "1x" + (int)dArray[0], string6);
                    this.historyTable.addMCode(new ReadRow(objectArray, (int)dArray[0]));
                    this.historyTable.addVariable((String)objectArray2[3], object2);
                }
                this.responseTextField.setText(string5);
                this.responseTextField.setToolTipText(null);
                if (object2 instanceof String && ((String)object2).length() > 40) {
                    this.responseTextField.setToolTipText((String)object2);
                }
                if (!string4.equals("")) {
                    this.historyTable.addRow("Read (warning)", string4, "", "");
                    this.historyTable.addMCode(new WarningRow());
                }
                this.enableExportButton();
                this.setButtonsEnabled(true);
                break;
            }
            case 5: {
                Object[] objectArray3 = (Object[])object;
                String string = (String)objectArray3[0];
                double[] dArray = (double[])objectArray3[1];
                String string7 = (String)objectArray3[2];
                double[] dArray2 = (double[])objectArray3[3];
                String string8 = (String)objectArray3[4];
                String string9 = (String)this.dataToWriteComboBox.getSelectedItem();
                String string10 = (String)this.writeFormatComboBox.getSelectedItem();
                String string11 = (String)this.readFormatComboBox.getSelectedItem();
                this.historyTable.addRow("Write (Query)", string9, "1x" + (int)dArray2[0], string10);
                this.historyTable.addMCode(new QueryRow(objectArray));
                this.historyTable.addMCode(new EmptyQueryRow(this.numOfReads - 1));
                this.responseTextField.setToolTipText(null);
                if (string.length() <= 40) {
                    this.historyTable.addRow("Read (Query)", string, "1x" + (int)dArray[0], string11);
                    this.responseTextField.setText(string);
                } else {
                    this.historyTable.addRow("Read (Query)", string8 + " (" + string.substring(0, 20) + "...)", "1x" + (int)dArray[0], string11);
                    this.responseTextField.setText(string8 + " (" + string.substring(0, 20) + "...)");
                    this.responseTextField.setToolTipText(string);
                }
                this.historyTable.addVariable(string8, string);
                if (!string7.equals("")) {
                    this.historyTable.addRow("Read (warning)", string7, "", "");
                    this.historyTable.addMCode(new WarningRow());
                }
                this.updateWriteCommandComboBox();
                this.enableExportButton();
                this.setButtonsEnabled(true);
                break;
            }
            case 4: {
                this.historyTable.addRow("Flush", "", "", "");
                this.historyTable.addMCode(new FlushRow((Instrument)objectArray[2]));
                this.setButtonsEnabled(true);
            }
        }
    }

    @Override
    public void matlabActionErrored(int n) {
        this.setButtonsEnabled(true);
    }

    public void selectedObjectUpdated(Instrument instrument) {
        this.currentObject = instrument;
        this.updateComponentsBasedOnStatus();
    }

    public void objectVisibilityUpdated(Instrument instrument) {
        ++this.numOfObjects;
    }

    @Override
    public void instrumentObjectAdded(Instrument instrument, String string, String string2) {
        ++this.numOfObjects;
    }

    @Override
    public void instrumentObjectDeleted(Instrument instrument, String string, String string2) {
        --this.numOfObjects;
        if (this.numOfObjects == 0) {
            this.setComponentsEnabled(false);
        }
    }

    @Override
    public void propertyChanged(Instrument instrument, String string, Object object) {
        if (instrument != this.currentObject) {
            return;
        }
        if (string.equals("Status")) {
            if (object.equals("closed")) {
                this.setComponentsEnabled(false);
            } else {
                this.responseTextField.setText("");
                this.setComponentsEnabled(true);
            }
        } else if (string.equals("InputBufferSize")) {
            this.verifyReadSizeValue();
        }
    }

    private void verifyReadSizeValue() {
        String string = this.readSizeTextField.getText();
        if (string.equals("")) {
            this.readSizeValue = "";
            return;
        }
        int n = new Integer(string);
        if (n > this.currentObject.getInputBufferSize()) {
            n = this.currentObject.getInputBufferSize();
            this.readSizeTextField.setText(String.valueOf(n));
            this.readSizeValue = this.readSizeTextField.getText();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        JComponent jComponent = (JComponent)focusEvent.getSource();
        int n = (Integer)jComponent.getClientProperty(ACTION);
        switch (n) {
            case 7: {
                this.verifyEnteredValue(7);
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            int n = this.dataToWriteComboBox.getSelectedIndex();
            String string = (String)this.dataToWriteComboBox.getEditor().getItem();
            if (n == -1) {
                this.dataToWriteComboBox.addItem((Object)string);
            } else if (!this.dataToWriteComboBox.getSelectedItem().equals(string)) {
                this.dataToWriteComboBox.insertItemAt((Object)string, 0);
                this.dataToWriteComboBox.setSelectedIndex(0);
            }
            this.writeButton.doClick();
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }
}

