/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.guiutil.midtool;

import com.mathworks.toolbox.instrument.device.drivers.xml.PropertyGroupDefinition;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverFunction;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverModel;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverProperty;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.event.DriverModelEvent;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.event.DriverModelListener;
import com.mathworks.toolbox.instrument.device.icdevice.ICDevice;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class DriverGroup
implements DriverModelListener,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String sDeviceGroupName = "parent";
    private String name = "";
    private String command = "";
    private String helpText = "";
    private Hashtable<Integer, String> idMappings = new Hashtable();
    private Vector<Object> properties = new Vector();
    private Vector<DriverFunction> functions = new Vector();
    private Vector<Object> fChangeListeners = new Vector();
    private DriverModel fModel;

    public DriverGroup(String string) {
        this.name = string;
        this.addMapping(string + "1");
    }

    public DriverGroup(PropertyGroupDefinition propertyGroupDefinition) {
        this.name = propertyGroupDefinition.getName();
        this.idMappings = propertyGroupDefinition.getMappings();
        if (this.idMappings.isEmpty()) {
            this.addMapping(this.name + 1);
        }
    }

    public static DriverGroup createFromIviInfo(String string, String string2) {
        DriverGroup driverGroup = null;
        String string3 = string;
        String[] stringArray = ICDevice.BASE_PROPS;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase(string3)) continue;
            string3 = "Instrument" + string3;
            break;
        }
        driverGroup = new DriverGroup(string3);
        driverGroup.setHelpText(string2);
        return driverGroup;
    }

    public void setName(String string) {
        if (string.equals(this.name)) {
            return;
        }
        String string2 = this.name;
        this.name = string;
        this.fireGroupNameChangedEvent(string2);
    }

    public String getName() {
        return this.name;
    }

    public DriverModel getDriverModel() {
        return this.fModel;
    }

    public void setDriverModel(DriverModel driverModel) {
        this.fModel = driverModel;
    }

    public String getDisplayName() {
        if (this.name.length() > 0) {
            return this.name.substring(0, 1).toUpperCase() + this.name.substring(1);
        }
        return this.name;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public String getHelpText() {
        return this.helpText;
    }

    public void setHelpText(String string) {
        if (!this.helpText.equals(string)) {
            this.helpText = string;
            this.fireGroupChangedEvent();
        }
    }

    public int getSize() {
        return Math.max(1, this.idMappings.size());
    }

    public void setCommand(String string) {
        if (!this.command.equals(string)) {
            this.command = string;
            this.fireGroupChangedEvent();
        }
    }

    public String getCommand() {
        return this.command;
    }

    public void setIdMappings(Hashtable<Integer, String> hashtable) {
        if (hashtable == null) {
            if (!this.idMappings.isEmpty()) {
                this.idMappings.clear();
                this.fireGroupChangedEvent();
            }
            return;
        }
        if (hashtable.size() != this.idMappings.size()) {
            this.idMappings = hashtable;
            this.fireGroupChangedEvent();
            return;
        }
        if (!this.idMappings.keySet().containsAll(hashtable.keySet()) || !hashtable.keySet().containsAll(this.idMappings.keySet())) {
            this.idMappings = hashtable;
            this.fireGroupChangedEvent();
            return;
        }
        Enumeration<Integer> enumeration = this.idMappings.keys();
        while (enumeration.hasMoreElements()) {
            Integer n = enumeration.nextElement();
            if (this.idMappings.get(n).equals(hashtable.get(n))) continue;
            this.idMappings = hashtable;
            this.fireGroupChangedEvent();
            return;
        }
    }

    public Hashtable<Integer, String> getIdMappings() {
        return this.idMappings;
    }

    public String getMapping(int n) {
        return this.idMappings.get(new Integer(n));
    }

    public void setMapping(int n, String string) {
        if (this.idMappings.containsKey(new Integer(n))) {
            if (string != null && string.length() != 0) {
                if (!string.equals(this.idMappings.get(new Integer(n)))) {
                    this.idMappings.put(new Integer(n), string);
                    this.fireGroupChangedEvent();
                }
            } else {
                this.removeMapping(n);
                this.fireGroupChangedEvent();
            }
        }
    }

    public void addMapping(String string) {
        if (string != null && string.length() != 0) {
            this.idMappings.put(new Integer(this.idMappings.size() + 1), string);
            this.fireGroupChangedEvent();
        }
    }

    public void removeMapping(int n) {
        for (int i = n; i < this.idMappings.size(); ++i) {
            this.setMapping(i, this.getMapping(i + 1));
        }
        this.idMappings.remove(new Integer(this.idMappings.size()));
        this.fireGroupChangedEvent();
    }

    public boolean isParentGroup() {
        return this.name.equals(sDeviceGroupName);
    }

    public Vector<Object> getProperties() {
        return this.properties;
    }

    public Vector<String> getPropertyNames() {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.properties.size(); ++i) {
            vector.add(((DriverProperty)this.properties.get(i)).getName());
        }
        return vector;
    }

    public int add(DriverProperty driverProperty) {
        int n = this.properties.size();
        for (int i = 0; i < this.properties.size(); ++i) {
            DriverProperty driverProperty2 = (DriverProperty)this.properties.get(i);
            if (driverProperty.getName().compareToIgnoreCase(driverProperty2.getName()) >= 0) continue;
            n = i;
            break;
        }
        this.properties.insertElementAt(driverProperty, n);
        driverProperty.setGroup(this);
        driverProperty.addDriverModelListener(this);
        return n;
    }

    public int isValidPropertyName(String string) {
        for (int i = 0; i < this.properties.size(); ++i) {
            String string2 = ((DriverProperty)this.properties.get(i)).getName();
            if (string.compareToIgnoreCase(string2) != 0) continue;
            return 1;
        }
        return 0;
    }

    public void remove(DriverProperty driverProperty) {
        this.properties.remove(driverProperty);
    }

    public Vector<DriverFunction> getFunctions() {
        return this.functions;
    }

    public Vector<String> getFunctionNames() {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.functions.size(); ++i) {
            vector.add(this.functions.get(i).getName());
        }
        return vector;
    }

    public int add(DriverFunction driverFunction) {
        int n = this.functions.size();
        for (int i = 0; i < this.functions.size(); ++i) {
            DriverFunction driverFunction2 = this.functions.get(i);
            if (driverFunction.getName().compareToIgnoreCase(driverFunction2.getName()) >= 0) continue;
            n = i;
            break;
        }
        this.functions.insertElementAt(driverFunction, n);
        driverFunction.setGroup(this);
        driverFunction.addDriverModelListener(this);
        return n;
    }

    public int isValidFunctionName(String string) {
        for (int i = 0; i < this.functions.size(); ++i) {
            String string2 = this.functions.get(i).getName();
            if (string.compareToIgnoreCase(string2) != 0) continue;
            return 1;
        }
        return 0;
    }

    public void remove(DriverFunction driverFunction) {
        this.functions.remove(driverFunction);
    }

    public void merge(DriverGroup driverGroup, boolean bl) {
        int n;
        Vector<Object> vector = driverGroup.getProperties();
        for (n = 0; n < vector.size(); ++n) {
            this.add((DriverProperty)vector.get(n));
        }
        vector = driverGroup.getFunctions();
        for (n = 0; n < vector.size(); ++n) {
            this.add((DriverFunction)vector.get(n));
        }
        if (bl) {
            this.setCommand(driverGroup.getCommand());
            this.setIdMappings(driverGroup.getIdMappings());
        }
    }

    @Override
    public void driverStateChanged(DriverModelEvent driverModelEvent) {
        switch (driverModelEvent.getType()) {
            case 9: 
            case 13: {
                this.refireDriverModelEvent(driverModelEvent);
                break;
            }
            case 10: {
                DriverProperty driverProperty = (DriverProperty)driverModelEvent.getSource();
                this.properties.remove(driverProperty);
                int n = this.properties.size();
                for (int i = 0; i < this.properties.size(); ++i) {
                    DriverProperty driverProperty2 = (DriverProperty)this.properties.get(i);
                    if (driverProperty.getName().compareToIgnoreCase(driverProperty2.getName()) >= 0) continue;
                    n = i;
                    break;
                }
                this.properties.insertElementAt(driverProperty, n);
                this.refireDriverModelEvent(driverModelEvent);
                break;
            }
            case 14: {
                DriverFunction driverFunction = (DriverFunction)driverModelEvent.getSource();
                this.functions.remove(driverFunction);
                int n = this.functions.size();
                for (int i = 0; i < this.functions.size(); ++i) {
                    DriverFunction driverFunction2 = this.functions.get(i);
                    if (driverFunction.getName().compareToIgnoreCase(driverFunction2.getName()) >= 0) continue;
                    n = i;
                    break;
                }
                this.functions.insertElementAt(driverFunction, n);
                this.refireDriverModelEvent(driverModelEvent);
            }
        }
    }

    public void addDriverModelListener(DriverModelListener driverModelListener) {
        if (!this.fChangeListeners.contains(driverModelListener)) {
            this.fChangeListeners.add(driverModelListener);
        }
    }

    public void removeDriverModelListener(DriverModelListener driverModelListener) {
        this.fChangeListeners.remove(driverModelListener);
    }

    private void refireDriverModelEvent(DriverModelEvent driverModelEvent) {
        for (int i = 0; i < this.fChangeListeners.size(); ++i) {
            ((DriverModelListener)this.fChangeListeners.get(i)).driverStateChanged(driverModelEvent);
        }
    }

    private void fireGroupChangedEvent() {
        DriverModelEvent driverModelEvent = new DriverModelEvent(this, 5, null, 0);
        for (int i = 0; i < this.fChangeListeners.size(); ++i) {
            ((DriverModelListener)this.fChangeListeners.get(i)).driverStateChanged(driverModelEvent);
        }
    }

    private void fireGroupNameChangedEvent(String string) {
        DriverModelEvent driverModelEvent = new DriverModelEvent(this, 6, string, 0);
        for (int i = 0; i < this.fChangeListeners.size(); ++i) {
            ((DriverModelListener)this.fChangeListeners.get(i)).driverStateChanged(driverModelEvent);
        }
    }
}

