/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.drivers.xml.property;

import com.mathworks.beans.EnumPair;
import com.mathworks.toolbox.instrument.device.drivers.xml.property.PropertyConstraint;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class BooleanProperty
extends PropertyConstraint {
    public static final EnumPair[] BOOLEAN_TAGS = new EnumPair[]{new EnumPair("off", (Object)"off"), new EnumPair("on", (Object)"on")};
    private String[] constraintValues = new String[]{"on", "off"};
    private JComboBox valueComboBox = null;

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public int getConstraint() {
        return 1;
    }

    @Override
    public Object getDefaultValue() {
        return "off";
    }

    @Override
    public boolean isValidValue(Object object) {
        if (object instanceof String) {
            String string = ((String)object).toLowerCase();
            return string.equals("on") || string.equals("off");
        }
        return false;
    }

    @Override
    public Object[] getConstraintValues() {
        return this.constraintValues;
    }

    @Override
    public EnumPair[] getEnumPair() {
        return BOOLEAN_TAGS;
    }

    @Override
    public String getEnum(String string) {
        return string;
    }

    @Override
    public Object getValidValue(Object object) {
        return object;
    }

    @Override
    public String getSetList() {
        return "[ on | off ]";
    }

    @Override
    public String getSetError() {
        return "on, off";
    }

    @Override
    public JPanel getPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
        this.valueComboBox = new JComboBox();
        this.valueComboBox.addItem("on");
        this.valueComboBox.addItem("off");
        jPanel.add(this.valueComboBox);
        Dimension dimension = this.valueComboBox.getPreferredSize();
        if (dimension.width < 93) {
            dimension.width = 93;
        }
        this.valueComboBox.setPreferredSize(dimension);
        return jPanel;
    }

    @Override
    public Object getPanelValue() {
        return this.valueComboBox.getSelectedItem();
    }

    @Override
    public void setPanelValue(Object object) {
        this.valueComboBox.setSelectedItem(object);
    }

    @Override
    public String getCellArrayOfValues() {
        return "{'on', 'off'}";
    }
}

